/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockContext;
import com.jidesoft.docking.DockableFrameMouseInputAdapter;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.DragableDockable;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.NotificationFlasher;
import com.jidesoft.docking.PreviousState;
import com.jidesoft.docking.Refocusable;
import com.jidesoft.docking.Resource;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.plaf.DockableFrameUI;
import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.TabColorProvider;
import com.jidesoft.utils.JideFocusTracker;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.event.MouseInputListener;

public class DockableFrame
extends JComponent
implements Accessible,
WindowConstants,
DragableDockable,
Refocusable,
DockableHolder,
TabColorProvider {
    private static final Logger LOGGER_EVENT;
    private static final Logger LOGGER_FOCUS;
    private DockingManager _dockingManager;
    private DockContext _context;
    private DockContext _previousContext;
    private static final String uiClassID = "DockableFrameUI";
    private JRootPane rootPane;
    private boolean rootPaneCheckingEnabled = false;
    private Icon _frameIcon;
    private String _key;
    private String _tabTitle;
    private String _sideTitle;
    private String _title;
    public static final String PROPERTY_CONTENT_PANE = "contentPane";
    public static final String PROPERTY_MENU_BAR = "JMenuBar";
    public static final String PROPERTY_TAB_TITLE = "tabTitle";
    public static final String PROPERTY_SIDE_TITLE = "sideTitle";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_LAYERED_PANE = "layeredPane";
    public static final String PROPERTY_ROOT_PANE = "rootPane";
    public static final String PROPERTY_GLASS_PANE = "glassPane";
    public static final String PROPERTY_FRAME_ICON = "frameIcon";
    public static final String PROPERTY_AVAILABLE_BUTTONS = "availableButtons";
    public static final String PROPERTY_BUTTONS_ORDER = "buttonsOrder";
    public static final String PROPERTY_TITLE_BAR_COMPONENT = "titleBarComponent";
    public static final String PROPERTY_TITLE_LABEL_COMPONENT = "titleLabelComponent";
    public static final String PROPERTY_VISIBLE = "visible";
    public static final String PROPERTY_AVAILABLE = "available";
    public static final String PROPERTY_SLIDING_AUTOHIDE = "slidingAutohide";
    public static final String PROPERTY_TRANSIENT = "transient";
    public static final String PROPERTY_FLOATABLE = "floatable";
    public static final String PROPERTY_HIDABLE = "hidable";
    public static final String PROPERTY_DOCKABLE = "dockable";
    public static final String PROPERTY_AUTOHIDABLE = "autohidable";
    public static final String PROPERTY_MAXIMIZABLE = "maximizable";
    public static final String PROPERTY_REARRANGABLE = "rearrangable";
    public static final String PROPERTY_ACTIVE = "active";
    public static final String PROPERTY_MAXIMIZED = "maximized";
    public static final String PROPERTY_HIDDEN = "hidden";
    public static final String PROPERTY_DOCKED = "docked";
    public static final String PROPERTY_FLOATED = "floated";
    public static final String PROPERTY_AUTOHIDE = "autohide";
    public static final String PROPERTY_AUTOHIDE_SHOWING = "autohideShowing";
    public static final String PROPERTY_TAB_DOCK_ALLOWED = "tabDockAllowed";
    public static final String PROPERTY_SIDE_DOCK_ALLOWED = "sideDockAllowed";
    public static final String PROPERTY_STAY_IN_GROUP = "stayInGroup";
    public static final String PROPERTY_SHOW_GRIPPER = "showGripper";
    public static final String PROPERTY_SHOW_TITLE_BAR = "showTitleBar";
    public static final String PROPERTY_SHOW_CONTENT_PANE = "showContentPane";
    public static final String PROPERTY_SHOW_CONTEXT_MENU = "showContextMenu";
    public static final String PROPERTY_INIT_SIDE = "initSide";
    public static final String PROPERTY_INIT_MODE = "initMode";
    public static final String PROPERTY_INIT_INDEX = "initIndex";
    public static final String PROPERTY_DOCKED_WIDTH = "dockedWidth";
    public static final String PROPERTY_DOCKED_HEIGHT = "dockedHeight";
    public static final String PROPERTY_AUTOHIDE_WIDTH = "autohideWidth";
    public static final String PROPERTY_AUTOHIDE_HEIGHT = "autohideHeight";
    public static final String PROPERTY_UNDOCKED_BOUNDS = "undockedBounds";
    public static final String PROPERTY_PREFERRED_AUTOHIDE_SIDE = "preferredAutohideSide";
    public static final String PROPERTY_CLOSE_ACTION = "closeAction";
    public static final String PROPERTY_AUTOHIDE_ACTION = "autohideAction";
    public static final String PROPERTY_HIDE_AUTOHIDE_ACTION = "hideAutohideAction";
    public static final String PROPERTY_FLOATING_ACTION = "floatingAction";
    public static final String PROPERTY_MAXIMIZE_ACTION = "maximizeAction";
    public static final String PROPERTY_DOCKABLE_ACTION = "dockableAction";
    public static final String PROPERTY_DOUBLE_CLICK_ACTION = "doubleClickAction";
    public static final String PROPERTY_DEFAULT_CLOSE_ACTION = "defaultCloseAction";
    public static final String PROPERTY_DEFAULT_AUTOHIDE_ACTION = "defaultAutohideAction";
    public static final String PROPERTY_DEFAULT_ESCAPE_ACTION = "defaultEscapeAction";
    public static final String PROPERTY_AUTOHIDE_WHEN_ACTIVE = "autohideWhenActive";
    @Deprecated
    public static final String PROPERTY_ADDITONAL_BUTTON_ACTIONS = "additionalButtonActions";
    public static final String PROPERTY_ADDITIONAL_BUTTON_ACTIONS = "additionalButtonActions";
    private final LinkedList<Action> _additionalButtonActions = new LinkedList();
    private boolean _showGripper = false;
    private boolean _showTitleBarConfigured = false;
    private boolean _showTitleBar = true;
    private boolean _showContentPane = true;
    private boolean _rearrangable = true;
    private boolean _active;
    private boolean _maximized;
    private MouseInputListener _mouseListener;
    private boolean _notified;
    public static final int BUTTON_CLOSE = 1;
    public static final int BUTTON_HIDE_AUTOHIDE = 2;
    public static final int BUTTON_AUTOHIDE = 4;
    public static final int BUTTON_FLOATING = 8;
    public static final int BUTTON_MAXIMIZE = 16;
    public static final int BUTTON_ALL = -1;
    private int _availableButtons = 15;
    private JComponent _titleBarComponent;
    private JComponent _titleLabelComponent;
    private boolean _maximizable = true;
    private boolean _slidingAutohide = true;
    private NotificationFlasher _animator;
    private boolean _transient;
    private JideFocusTracker _currentFocusOwnerTracker;
    private FocusListener _focusListenerInternalTracking;
    private Component _defaultFocusComponent;
    private Component _internalFocusedComponent;
    protected PropertyChangeListener _focusChangeListener;
    private int _preferredAutohideSide = -1;
    private boolean _tabDockAllowed = true;
    private boolean _sideDockAllowed = true;
    private boolean _alwaysStayInGroup = false;
    protected Action _closeAction;
    protected Action _hideAutohideAction;
    protected Action _floatingAction;
    protected Action _autohideAction;
    protected Action _maximizeAction;
    protected Action _dockableAction;
    protected Action _customDoubleClickAction;
    private Action _closeActionByDefault;
    private Action _hideAutohideActionByDefault;
    private Action _floatingActionByDefault;
    private Action _autohideActionByDefault;
    private Action _maximizeActionByDefault;
    private Action _dockableActionByDefault;
    protected boolean _showContextMenu = true;
    private boolean _realized = false;
    private Color _tabBackground;
    private Color _tabForeground;
    public static final int CLOSE_ACTION_TO_HIDE = 0;
    public static final int CLOSE_ACTION_TO_REMOVE = 1;
    public static final int CLOSE_ACTION_TO_REMOVE_AND_DISPOSE = 2;
    private int _defaultCloseAction = 0;
    public static final int AUTOHIDE_ACTION_TO_REMAIN_ACTIVE = 0;
    public static final int ESCAPE_ACTION_TO_YIELD_FOCUS = 0;
    public static final int ESCAPE_ACTION_DO_NOTING = 1;
    public static final int ESCAPE_ACTION_TO_HIDE = 2;
    public static final int ESCAPE_ACTION_TO_REMOVE = 3;
    private int _defaultEscapeAction = 0;
    private boolean _autohideWhenActive = false;
    private int[] _buttonsOrder = new int[]{1, 4, 2, 8, 16};
    private boolean _settingSize = false;
    private Dimension _savedPreferredSize = null;

    protected String getResourceString(String string) {
        return this.getDockingManager() != null ? this.getDockingManager().getResourceString(string) : Resource.getResourceBundle(Locale.getDefault()).getString(string);
    }

    public DockableFrame() {
        this("");
    }

    public DockableFrame(String string) {
        this(string, UIDefaultsLookup.getIcon("DockableFrame.defaultIcon"));
    }

    public DockableFrame(Icon icon) {
        this("", icon);
    }

    public DockableFrame(String string, Icon icon) {
        if (string == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.setRootPane(this.createRootPane());
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.setLayout(new BorderLayout());
        this._key = string;
        this.setName(this._key);
        this.setFrameIcon(icon);
        this._context = new DockContext();
        this.setRootPaneCheckingEnabled(true);
        this._mouseListener = this.createDockableFrameMouseInputListener();
        this.addMouseListener(this._mouseListener);
        this.addMouseMotionListener(this._mouseListener);
        this.putClientProperty("DraggingListener", this._mouseListener);
        this.updateUI();
        this.addFocusTracker();
    }

    protected void addFocusTracker() {
        this._currentFocusOwnerTracker = this.createFocusTracker(this.getContentPane());
        this._focusListenerInternalTracking = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    DockableFrame.this.setLastFocusedComponent(focusEvent.getComponent());
                }
            }
        };
    }

    protected JideFocusTracker createFocusTracker(Container container) {
        return new JideFocusTracker(container);
    }

    @Override
    public boolean isOpaque() {
        return this.getDockingManager() != null && this.getDockingManager().isHeavyweightComponentEnabled() || super.isOpaque();
    }

    public MouseInputListener createDockableFrameMouseInputListener() {
        return new DockableFrameMouseInputAdapter(this);
    }

    void updateDockedWidthOrHeight(int n) {
        Container container = this.getParent();
        if (container instanceof FrameContainer) {
            try {
                this.setSettingSize(true);
                if (n == 1) {
                    this.setDockedWidth(this.getWidth());
                } else if (n == 0) {
                    this.setDockedHeight(this.getHeight());
                }
            }
            finally {
                this.setSettingSize(false);
            }
        }
    }

    protected void deinstallMouseHandlers() {
        Component component;
        DockableFrameUI dockableFrameUI = this.getUI();
        if (dockableFrameUI != null && (component = dockableFrameUI.getTitlePane()) != null) {
            component.removeMouseListener(this._mouseListener);
            component.removeMouseMotionListener(this._mouseListener);
        }
    }

    protected void installMouseHandlers() {
        Component component;
        DockableFrameUI dockableFrameUI = this.getUI();
        if (dockableFrameUI != null && (component = dockableFrameUI.getTitlePane()) != null) {
            component.addMouseListener(this._mouseListener);
            component.addMouseMotionListener(this._mouseListener);
        }
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    @Override
    public DockableFrameUI getUI() {
        return (DockableFrameUI)this.ui;
    }

    public void setUI(DockableFrameUI dockableFrameUI) {
        boolean bl = this.isRootPaneCheckingEnabled();
        try {
            this.setRootPaneCheckingEnabled(false);
            super.setUI(dockableFrameUI);
        }
        finally {
            this.setRootPaneCheckingEnabled(bl);
        }
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.deinstallMouseHandlers();
        this.setUI((DockableFrameUI)UIManager.getUI(this));
        this.installMouseHandlers();
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    @Override
    public void remove(Component component) {
        int n = this.getComponentCount();
        super.remove(component);
        if (n == this.getComponentCount()) {
            this.getContentPane().remove(component);
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.getJMenuBar();
        this.getRootPane().setJMenuBar(jMenuBar);
        this.firePropertyChange(PROPERTY_MENU_BAR, jMenuBar2, jMenuBar);
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        Container container2 = this.getContentPane();
        this.getRootPane().setContentPane(container);
        if (container instanceof JComponent) {
            ((JComponent)container).setOpaque(false);
        }
        if (container2 != container) {
            if (this._focusListenerInternalTracking != null && this._currentFocusOwnerTracker != null) {
                this._currentFocusOwnerTracker.removeFocusListener(this._focusListenerInternalTracking);
                this._currentFocusOwnerTracker = null;
            }
            this._internalFocusedComponent = null;
            this.addFocusTracker();
        }
        this.firePropertyChange(PROPERTY_CONTENT_PANE, container2, container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        JLayeredPane jLayeredPane2 = this.getLayeredPane();
        this.getRootPane().setLayeredPane(jLayeredPane);
        this.firePropertyChange(PROPERTY_LAYERED_PANE, jLayeredPane2, jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        Component component2 = this.getGlassPane();
        this.getRootPane().setGlassPane(component);
        this.firePropertyChange(PROPERTY_GLASS_PANE, component2, component);
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        JRootPane jRootPane2 = this.getRootPane();
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(bl);
            }
        }
        this.firePropertyChange(PROPERTY_ROOT_PANE, jRootPane2, jRootPane);
    }

    public int getAvailableButtons() {
        return this._availableButtons;
    }

    public void setAvailableButtons(int n) {
        if (this.getAvailableButtons() == n) {
            return;
        }
        int n2 = this.getAvailableButtons();
        this._availableButtons = n;
        this.firePropertyChange(PROPERTY_AVAILABLE_BUTTONS, n2, n);
    }

    public void setHidable(boolean bl) {
        if (bl != this.isHidable()) {
            boolean bl2 = this.isHidable();
            this.getContext().setHidable(bl);
            this.firePropertyChange(PROPERTY_HIDABLE, bl2, bl);
        }
    }

    public boolean isHidable() {
        return this.getContext().isHidable();
    }

    public boolean isHidden() {
        return this.getContext().isHidden();
    }

    public void setHidden(boolean bl) throws PropertyVetoException {
        if (this.getContext().isHidden() == bl) {
            return;
        }
        boolean bl2 = this.getContext().isHidden();
        this.fireVetoableChange(PROPERTY_HIDDEN, bl2, bl);
        if (bl) {
            this.changeMode(0);
        }
        this.firePropertyChange(PROPERTY_HIDDEN, bl2, bl);
        this.setVisible(!bl);
    }

    public void setDockable(boolean bl) {
        if (bl != this.isDockable()) {
            boolean bl2 = this.isDockable();
            this.getContext().setDockable(bl);
            this.firePropertyChange(PROPERTY_DOCKABLE, bl2, bl);
        }
    }

    public boolean isDockable() {
        return this.getContext().isDockable();
    }

    public void setAutohidable(boolean bl) {
        if (bl != this.isAutohidable()) {
            boolean bl2 = this.isAutohidable();
            this.getContext().setAutohidable(bl);
            this.firePropertyChange(PROPERTY_AUTOHIDABLE, bl2, bl);
        }
    }

    public boolean isAutohidable() {
        return this.getContext().isAutohidable();
    }

    public void setFloatable(boolean bl) {
        if (bl != this.isFloatable()) {
            boolean bl2 = this.isFloatable();
            this.getContext().setFloatable(bl);
            this.firePropertyChange(PROPERTY_FLOATABLE, bl2, bl);
        }
    }

    public boolean isFloatable() {
        return this.getContext().isFloatable();
    }

    public void setRearrangable(boolean bl) {
        if (bl != this.isRearrangable()) {
            boolean bl2 = this.isRearrangable();
            this._rearrangable = bl;
            this.firePropertyChange(PROPERTY_REARRANGABLE, bl2, bl);
        }
    }

    public boolean isRearrangable() {
        return this._rearrangable;
    }

    public boolean isFloated() {
        return this.getContext().isFloated();
    }

    public boolean isDocked() {
        return this.getContext().isDocked();
    }

    protected void setDocked(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.getContext().isDocked();
        if (bl != bl2) {
            this.fireVetoableChange(PROPERTY_DOCKED, bl2, bl);
            if (bl) {
                boolean bl3 = this.getContext().isHidden();
                this.changeMode(4);
                if (bl3) {
                    this.fireDockableFrameEvent(4001);
                }
                this.fireDockableFrameEvent(4003);
            }
            this.firePropertyChange(PROPERTY_DOCKED, bl2, bl);
            this.recordPreviousContext();
        } else if (this._previousContext == null) {
            this.recordPreviousContext();
        } else if (this._previousContext.getCurrentDockSide() != this.getContext().getCurrentDockSide()) {
            this.fireDockableFrameEvent(4014);
            this.recordPreviousContext();
        }
    }

    protected void setFloated(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.getContext().isFloated();
        if (bl != bl2) {
            this.fireVetoableChange(PROPERTY_FLOATED, bl2, bl);
            if (bl) {
                boolean bl3 = this.getContext().isHidden();
                this.changeMode(1);
                if (bl3) {
                    this.fireDockableFrameEvent(4001);
                }
                this.fireDockableFrameEvent(4004);
            }
            this.firePropertyChange(PROPERTY_FLOATED, bl2, bl);
            this.recordPreviousContext();
        } else if (this._previousContext == null) {
            this.recordPreviousContext();
        } else if (!JideSwingUtilities.equals(this._previousContext.getUndockedBounds(), this.getContext().getUndockedBounds())) {
            this.fireDockableFrameEvent(4014);
            this.recordPreviousContext();
        }
    }

    protected void setAutohide(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.getContext().isAutohide();
        if (bl != bl2) {
            this.fireVetoableChange(PROPERTY_AUTOHIDE, bl2, bl);
            if (bl) {
                this.changeMode(2);
                this.fireDockableFrameEvent(4005);
            }
            this.firePropertyChange(PROPERTY_AUTOHIDE, bl2, bl);
            this.updateUI();
            this.recordPreviousContext();
        } else if (this._previousContext == null) {
            this.recordPreviousContext();
        } else if (this._previousContext.getCurrentDockSide() != this.getContext().getCurrentDockSide()) {
            this.fireDockableFrameEvent(4014);
            this.recordPreviousContext();
        }
    }

    protected void setAutohideShowing(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.getContext().isAutohideShowing();
        if (bl2 != bl) {
            this.fireVetoableChange(PROPERTY_AUTOHIDE_SHOWING, bl2, bl);
            if (bl) {
                boolean bl3 = this.getContext().isHidden();
                this.changeMode(3);
                this.firePropertyChange(PROPERTY_AUTOHIDE_SHOWING, bl2, bl);
                if (bl3) {
                    this.fireDockableFrameEvent(4001);
                }
                this.fireDockableFrameEvent(4006);
            } else {
                this.firePropertyChange(PROPERTY_AUTOHIDE_SHOWING, bl2, bl);
            }
            this.setNotified(false);
            this.recordPreviousContext();
        } else if (this._previousContext == null) {
            this.recordPreviousContext();
        } else if (this._previousContext.getCurrentDockSide() != this.getContext().getCurrentDockSide()) {
            this.fireDockableFrameEvent(4014);
            this.recordPreviousContext();
        }
    }

    public void setKey(String string) {
        if (this._key.equals(string)) {
            return;
        }
        if (this.getDockingManager() != null && this.getDockingManager().getFrame(string) != null) {
            throw new IllegalArgumentException("The DockableFrame exists with name \"" + string + "\". Please specify a new name for the frame.");
        }
        String string2 = this._key;
        this._key = string;
        this.setName(this._key);
        this.firePropertyChange(PROPERTY_KEY, string2, this._key);
        if (this._tabTitle == null) {
            this.firePropertyChange(PROPERTY_TAB_TITLE, string2, string);
            if (this._sideTitle == null) {
                this.firePropertyChange(PROPERTY_SIDE_TITLE, string2, string);
            }
            if (this._title == null) {
                this.firePropertyChange(PROPERTY_TITLE, string2, string);
            }
        }
    }

    public String getKey() {
        return this._key;
    }

    public String getTabTitle() {
        if (this._tabTitle != null) {
            return this._tabTitle;
        }
        return this.getKey();
    }

    public void setTabTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Title cannot be null or empty");
        }
        String string2 = this._tabTitle;
        if (!string.equals(string2)) {
            FrameContainer frameContainer;
            int n;
            this._tabTitle = string;
            this.firePropertyChange(PROPERTY_TAB_TITLE, string2, string);
            if (this._title == null) {
                this.firePropertyChange(PROPERTY_TITLE, string2, string);
            }
            if (this._sideTitle == null) {
                this.firePropertyChange(PROPERTY_SIDE_TITLE, string2, string);
            }
            if (this.getParent() instanceof FrameContainer && (n = (frameContainer = (FrameContainer)this.getParent()).indexOfComponent(this)) != -1) {
                frameContainer.setTitleAt(n, this._tabTitle);
            }
        }
    }

    public String getSideTitle() {
        if (this._sideTitle != null) {
            return this._sideTitle;
        }
        return this.getTabTitle();
    }

    public void setSideTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Title cannot be null or empty");
        }
        String string2 = this._sideTitle;
        if (!string.equals(string2)) {
            this._sideTitle = string;
            this.firePropertyChange(PROPERTY_SIDE_TITLE, string2, string);
        }
    }

    public String getTitle() {
        if (this._title != null) {
            return this._title;
        }
        return this.getTabTitle();
    }

    public void setTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Title cannot be null or empty");
        }
        String string2 = this._title;
        if (!string.equals(string2)) {
            this._title = string;
            this.firePropertyChange(PROPERTY_TITLE, string2, string);
        }
    }

    public boolean isAutohide() {
        return this.getContext().isAutohide();
    }

    public boolean isAutohideShowing() {
        return this.getContext().isAutohideShowing();
    }

    public void setFrameIcon(Icon icon) {
        FrameContainer frameContainer;
        int n;
        Icon icon2 = this._frameIcon;
        this._frameIcon = icon;
        this.firePropertyChange(PROPERTY_FRAME_ICON, icon2, icon);
        if (this.getParent() instanceof FrameContainer && (n = (frameContainer = (FrameContainer)this.getParent()).indexOfComponent(this)) != -1) {
            frameContainer.setIconAt(n, this.getFrameIcon());
        }
    }

    public Icon getFrameIcon() {
        return this._frameIcon;
    }

    protected Component getFocusOwner() {
        if (this.isActive()) {
            Component component = PortingUtils.getCurrentFocusComponent(null);
            if (component != null && !SwingUtilities.isDescendingFrom(component, this)) {
                component = null;
            }
            return component;
        }
        return null;
    }

    public void addDockableFrameListener(DockableFrameListener dockableFrameListener) {
        DockableFrameListener[] dockableFrameListenerArray;
        for (DockableFrameListener dockableFrameListener2 : dockableFrameListenerArray = (DockableFrameListener[])this.listenerList.getListeners(DockableFrameListener.class)) {
            if (dockableFrameListener2 != dockableFrameListener) continue;
            return;
        }
        this.listenerList.add(DockableFrameListener.class, dockableFrameListener);
        this.enableEvents(0L);
    }

    public void removeDockableFrameListener(DockableFrameListener dockableFrameListener) {
        this.listenerList.remove(DockableFrameListener.class, dockableFrameListener);
    }

    public DockableFrameListener[] getDockableFrameListeners() {
        return (DockableFrameListener[])this.listenerList.getListeners(DockableFrameListener.class);
    }

    protected void fireDockableFrameEvent(int n, DockingManager dockingManager) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 4013: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is transferred, oppositeDockingManager is " + (dockingManager == null ? "null" : dockingManager));
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        AWTEvent aWTEvent = null;
        block6: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DockableFrameListener.class) continue;
            if (aWTEvent == null) {
                aWTEvent = new DockableFrameEvent(this, n, dockingManager);
            }
            switch (aWTEvent.getID()) {
                case 4013: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameTransferred((DockableFrameEvent)aWTEvent);
                    continue block6;
                }
            }
        }
    }

    protected void fireDockableFrameEvent(int n, DockableFrame dockableFrame) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 4007: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is activated, oppositeDockableFrame is " + (dockableFrame == null ? "null" : dockableFrame.getKey()));
                    break;
                }
                case 4008: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is deactivated, oppositeDockableFrame is " + (dockableFrame == null ? "null" : dockableFrame.getKey()));
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        AWTEvent aWTEvent = null;
        block8: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DockableFrameListener.class) continue;
            if (aWTEvent == null) {
                aWTEvent = new DockableFrameEvent(this, n, dockableFrame);
            }
            switch (aWTEvent.getID()) {
                case 4007: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameActivated((DockableFrameEvent)aWTEvent);
                    continue block8;
                }
                case 4008: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameDeactivated((DockableFrameEvent)aWTEvent);
                    continue block8;
                }
            }
        }
    }

    protected void fireDockableFrameEvent(int n) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 3999: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is added");
                    break;
                }
                case 4000: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is removed");
                    break;
                }
                case 4003: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is docked " + DockContext.getStateName(this.getContext().getCurrentMode()) + " " + DockContext.getDockSideName(this.getContext().getCurrentDockSide()));
                    break;
                }
                case 4004: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is floating " + DockContext.getStateName(this.getContext().getCurrentMode()));
                    break;
                }
                case 4005: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is autohidden " + DockContext.getStateName(this.getContext().getCurrentMode()) + " " + DockContext.getDockSideName(this.getContext().getCurrentDockSide()));
                    break;
                }
                case 4006: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is autohide showing " + DockContext.getStateName(this.getContext().getCurrentMode()));
                    break;
                }
                case 4001: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is shown " + this.isVisible());
                    break;
                }
                case 4002: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is hidden " + this.isVisible());
                    break;
                }
                case 4007: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is activated");
                    break;
                }
                case 4008: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is deactivated");
                    break;
                }
                case 4009: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is tab shown " + this.isVisible());
                    break;
                }
                case 4010: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is tab hidden " + this.isVisible());
                    break;
                }
                case 4011: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is maximized");
                    break;
                }
                case 4012: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is restored");
                    break;
                }
                case 4014: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is moved");
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        AWTEvent aWTEvent = null;
        block34: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DockableFrameListener.class) continue;
            if (aWTEvent == null) {
                aWTEvent = new DockableFrameEvent(this, n);
            }
            switch (aWTEvent.getID()) {
                case 3999: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameAdded((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4000: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameRemoved((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4003: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameDocked((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4004: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameFloating((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4005: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameAutohidden((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4006: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameAutohideShowing((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4001: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameShown((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4002: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameHidden((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4007: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameActivated((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4008: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameDeactivated((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4009: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameTabShown((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4010: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameTabHidden((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4011: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameMaximized((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4012: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameRestored((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
                case 4014: {
                    ((DockableFrameListener)objectArray[i + 1]).dockableFrameMoved((DockableFrameEvent)aWTEvent);
                    continue block34;
                }
            }
        }
    }

    public DockContext getContext() {
        return this._context;
    }

    public void setContext(DockContext dockContext) {
        int n = this.getContext().getCurrentMode();
        boolean bl = this.getContext().isHidable();
        boolean bl2 = this.getContext().isAvailable();
        this._context = dockContext;
        boolean bl3 = this.isDocked();
        boolean bl4 = this.isFloated();
        boolean bl5 = this.isAutohide();
        boolean bl6 = this.isAutohideShowing();
        boolean bl7 = this.isHidden();
        this._context.setCurrentMode(n);
        this._context.setHidable(bl);
        if (bl2 != this.isAvailable()) {
            this._context.setAvailable(bl2);
            this.setAvailable(!bl2);
        }
        try {
            if (bl3) {
                this.setDocked(true);
            } else if (bl4) {
                this.setFloated(true);
            } else if (bl5) {
                this.setAutohide(true);
            } else if (bl6) {
                this.setAutohideShowing(true);
            } else if (bl7) {
                this.setHidden(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setHiddenPreviousState(PreviousState previousState) {
        this.getContext().setHiddenPreviousState(previousState);
    }

    @Override
    public PreviousState getHiddenPreviousState() {
        return this.getContext().getHiddenPreviousState();
    }

    public void saveHiddenPreviousState() {
        DockingUtils.saveHiddenPreviousState(this);
    }

    public void setAvailablePreviousState(PreviousState previousState) {
        this.getContext().setAvailablePreviousState(previousState);
    }

    public PreviousState getAvailablePreviousState() {
        return this.getContext().getAvailablePreviousState();
    }

    public void saveAvailablePreviousState() {
        DockingUtils.saveAvailablePreviousState(this);
    }

    public void setMaximizedPreviousState(PreviousState previousState) {
        this.getContext().setMaximizedPreviousState(previousState);
    }

    public PreviousState getMaximizedPreviousState() {
        return this.getContext().getMaximizedPreviousState();
    }

    public void saveMaximizedPreviousState() {
        DockingUtils.saveMaximizedPreviousState(this);
    }

    public void setClosePreviousState(PreviousState previousState) {
        if (!this.isTransient()) {
            this.getContext().setClosePreviousState(previousState);
        }
    }

    public PreviousState getClosePreviousState() {
        return this.getContext().getClosePreviousState();
    }

    public void saveClosePreviousState() {
        DockingUtils.saveClosePreviousState(this);
    }

    @Override
    public void setDockPreviousState(PreviousState previousState) {
        this.getContext().setDockPreviousState(previousState);
    }

    @Override
    public PreviousState getDockPreviousState() {
        return this.getContext().getDockPreviousState();
    }

    public void saveDockPreviousState() {
        DockingUtils.saveDockPreviousState(this, true);
    }

    @Override
    public void setFloatPreviousState(PreviousState previousState) {
        this.getContext().setFloatPreviousState(previousState);
    }

    @Override
    public PreviousState getFloatPreviousState() {
        return this.getContext().getFloatPreviousState();
    }

    public void saveFloatPreviousState() {
        DockingUtils.saveFloatPreviousState(this, true);
    }

    @Override
    public void setAutohidePreviousState(PreviousState previousState) {
        this.getContext().setAutohidePreviousState(previousState);
    }

    @Override
    public PreviousState getAutohidePreviousState() {
        return this.getContext().getAutohidePreviousState();
    }

    public void saveAutohidePreviousState() {
        DockingUtils.saveAutohidePreviousState(this);
    }

    public boolean isActive() {
        boolean bl = this._active;
        if (!bl && this.getParent() instanceof FrameContainer) {
            bl = ((FrameContainer)this.getParent()).isTabEditing();
        }
        return bl;
    }

    void setActive(boolean bl, DockableFrame dockableFrame) throws PropertyVetoException {
        this.setActive(bl, dockableFrame, true);
    }

    void setActive(boolean bl, DockableFrame dockableFrame, boolean bl2) throws PropertyVetoException {
        Container container;
        if (bl != this._active) {
            boolean bl3 = this._active;
            this.fireVetoableChange(PROPERTY_ACTIVE, bl3, bl);
            this._active = bl;
            if (this._active) {
                if (this._currentFocusOwnerTracker != null) {
                    this._currentFocusOwnerTracker.addFocusListener(this._focusListenerInternalTracking);
                }
                this.fireDockableFrameEvent(4007, dockableFrame);
            } else {
                if (this._currentFocusOwnerTracker != null) {
                    this._currentFocusOwnerTracker.removeFocusListener(this._focusListenerInternalTracking);
                }
                this.fireDockableFrameEvent(4008, dockableFrame);
            }
            this.firePropertyChange(PROPERTY_ACTIVE, bl3, bl);
        }
        if ((container = this.getParent()) instanceof FrameContainer) {
            ((FrameContainer)container).repaintTabAreaAndContentBorder();
        } else if (this.getUI() != null) {
            this.getUI().getTitlePane().repaint();
        }
        this.setNotified(false);
    }

    public void setActive(boolean bl) throws PropertyVetoException {
        this.setActive(bl, null);
    }

    public boolean isMaximized() {
        return this._maximized;
    }

    public void setMaximized(boolean bl) throws PropertyVetoException {
        if (bl != this._maximized) {
            boolean bl2 = this._maximized;
            this.fireVetoableChange(PROPERTY_MAXIMIZED, bl2, bl);
            this._maximized = bl;
            if (this._maximized) {
                this.fireDockableFrameEvent(4011);
            } else {
                this.fireDockableFrameEvent(4012);
            }
            this.firePropertyChange(PROPERTY_MAXIMIZED, bl2, bl);
        }
    }

    @Override
    public boolean requestFocusInInternalWindow() {
        if (this.getDockingManager() == null) {
            LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: returning false DockingManager == null.");
            return false;
        }
        final Component component = this.getFocusedComponent();
        LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: focusComponent=" + component);
        boolean bl = this.isAncestorOf(component) && JideSwingUtilities.passesFocusabilityTest(component);
        LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: isAncestor && passesFocusability=" + bl);
        if (bl) {
            bl = component.requestFocusInWindow();
            if (bl) {
                return true;
            }
        } else {
            bl = JideSwingUtilities.compositeRequestFocus(this.getContentPane());
            LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: compositeRequestFocus(getContentPane()) return " + bl);
        }
        if (!bl) {
            if (!JideSwingUtilities.passesFocusabilityTest(this)) {
                LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: this does not passFocusabilityTest.");
            }
            LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: requestFocus on DockableFrame.");
            if (component != null) {
                this.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
                            LOGGER_FOCUS.fine("DockableFrame(" + DockableFrame.this.getTitle() + "):focusGained");
                        }
                        if (component != null) {
                            component.requestFocusInWindow();
                        }
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        if (LOGGER_FOCUS.isLoggable(Level.FINE)) {
                            LOGGER_FOCUS.fine("DockableFrame(" + DockableFrame.this.getTitle() + "):focusLost");
                        }
                    }
                });
            }
            this.requestFocus();
            return true;
        }
        LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: return " + bl);
        return bl;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this._defaultFocusComponent;
    }

    @Override
    public void setDefaultFocusComponent(Component component) {
        this._defaultFocusComponent = component;
    }

    @Override
    public Component getFocusedComponent() {
        if (this._internalFocusedComponent == null) {
            return this.getDefaultFocusComponent();
        }
        return this._internalFocusedComponent;
    }

    public void setLastFocusedComponent(Component component) {
        this._internalFocusedComponent = component;
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        if (bl != bl2) {
            super.setVisible(bl);
            this.firePropertyChange(PROPERTY_VISIBLE, bl2, bl);
        }
    }

    @Override
    public void setDockingManager(DockingManager dockingManager) {
        DockingManager dockingManager2 = this._dockingManager;
        this._dockingManager = dockingManager;
        if (this._dockingManager != null) {
            this.setShowGripper(this._dockingManager.isShowGripper());
            if (!this._showTitleBarConfigured) {
                this.internalSetShowTitleBar(this._dockingManager.isShowTitleBar());
            }
            this.updateUI();
            this.resetDockID();
            if (dockingManager2 != dockingManager) {
                this.fireDockableFrameEvent(3999);
            }
        } else if (dockingManager2 instanceof DefaultDockingManager) {
            ((DefaultDockingManager)dockingManager2).discardAllUndoEdits(this.getKey());
        }
    }

    @Override
    public void setDockedWidth(int n) {
        int n2 = this.getContext().getDockedWidth();
        if (n2 != n) {
            this.getContext().setDockedWidth(n);
            this.firePropertyChange(PROPERTY_DOCKED_WIDTH, n2, n);
            if (this.getDockingManager() != null && this.getDockingManager().getDockedFrameContainer() != null && this.getDockingManager().getDockedFrameContainer().isShowing()) {
                this.setPreferredSizeWithDockedWidthAndHeight();
            }
        }
    }

    @Override
    public void setDockedHeight(int n) {
        int n2 = this.getContext().getDockedHeight();
        if (n2 != n) {
            this.getContext().setDockedHeight(n);
            this.firePropertyChange(PROPERTY_DOCKED_HEIGHT, n2, n);
            if (this.getDockingManager() != null && this.getDockingManager().getDockedFrameContainer() != null && this.getDockingManager().getDockedFrameContainer().isShowing()) {
                this.setPreferredSizeWithDockedWidthAndHeight();
            }
        }
    }

    @Override
    public int getDockedWidth() {
        if (this.getContext().getDockedWidth() <= 0) {
            Dimension dimension = super.getPreferredSize();
            int n = dimension.width < 200 ? 200 : dimension.width;
            this.getContext().setDockedWidth(n);
            return n;
        }
        return this.getContext().getDockedWidth();
    }

    @Override
    public int getDockedHeight() {
        if (this.getContext().getDockedHeight() <= 0) {
            Dimension dimension = super.getPreferredSize();
            int n = dimension.height < 200 ? 200 : dimension.height;
            this.getContext().setDockedHeight(n);
            return n;
        }
        return this.getContext().getDockedHeight();
    }

    @Override
    public void setAutohideWidth(int n) {
        int n2 = this.getContext().getAutohideWidth();
        if (n2 != n) {
            this.getContext().setAutohideWidth(n);
            this.firePropertyChange(PROPERTY_AUTOHIDE_WIDTH, n2, n);
            if (!this._settingSize) {
                this.getContext().setInitAutohideWidth(n);
            }
        }
    }

    @Override
    public void setAutohideHeight(int n) {
        int n2 = this.getContext().getAutohideHeight();
        if (n2 != n) {
            this.getContext().setAutohideHeight(n);
            this.firePropertyChange(PROPERTY_AUTOHIDE_HEIGHT, n2, n);
            if (!this._settingSize) {
                this.getContext().setInitAutohideHeight(n);
            }
        }
    }

    @Override
    public int getAutohideWidth() {
        if (this.getContext().getAutohideWidth() <= 0) {
            if (this.getContext().getInitAutohideWidth() <= 0) {
                return Math.max(this.getMinimumSize().width, this.getPreferredSize().width);
            }
            return Math.max(this.getMinimumSize().width, this.getContext().getInitAutohideWidth());
        }
        return Math.max(this.getMinimumSize().width, this.getContext().getAutohideWidth());
    }

    @Override
    public int getAutohideHeight() {
        if (this.getContext().getAutohideHeight() <= 0) {
            if (this.getContext().getInitAutohideHeight() <= 0) {
                return Math.max(this.getMinimumSize().height, this.getPreferredSize().height);
            }
            return Math.max(this.getMinimumSize().height, this.getContext().getInitAutohideHeight());
        }
        return Math.max(this.getMinimumSize().height, this.getContext().getAutohideHeight());
    }

    @Override
    public Rectangle getUndockedBounds() {
        Rectangle rectangle = this._context.getUndockedBounds();
        if (rectangle == null && (rectangle = this._context.getInitUndockedBounds()) == null) {
            Point point = new Point(0, 0);
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this.isDocked()) {
                n = this.getDockedWidth();
                n2 = this.getDockedHeight();
            }
            if (this.isShowing()) {
                try {
                    point = this.getLocationOnScreen();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    JideSwingUtilities.ignoreException(illegalComponentStateException);
                }
            }
            if (this.isShowTitleBar() && this.getUI().getTitlePane() != null) {
                Component component = this.getUI().getTitlePane();
                point.x += component.getHeight();
                point.y += component.getHeight();
            } else {
                point.x += 20;
                point.y += 20;
            }
            rectangle = new Rectangle(point.x, point.y, n, n2);
        }
        return rectangle;
    }

    @Override
    public void setUndockedBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getContext().getUndockedBounds();
        if (rectangle != null && !rectangle.equals(rectangle2) || rectangle == null && rectangle2 != null) {
            this.getContext().setUndockedBounds(rectangle);
            this.firePropertyChange(PROPERTY_UNDOCKED_BOUNDS, rectangle2, rectangle);
            if (!this._settingSize) {
                this.getContext().setInitUndockedBounds(rectangle);
            }
        }
    }

    @Override
    public int getDockID() {
        return this.getContext().getDockID();
    }

    @Override
    public void setDockID(int n) {
        this.getContext().setDockID(this._dockingManager, n);
    }

    @Override
    public void resetDockID() {
        this.getContext().resetDockID(this._dockingManager);
        this.getContext().setInitPosition(false);
    }

    public boolean isAvailable() {
        return this.getContext().isAvailable();
    }

    public void setAvailable(boolean bl) {
        if (bl != this.isAvailable()) {
            boolean bl2 = this.isAvailable();
            this.getContext().setAvailable(bl);
            this.firePropertyChange(PROPERTY_AVAILABLE, bl2, bl);
            if (!bl) {
                this.setVisible(bl);
            }
        }
    }

    public void setTitleBarComponent(JComponent jComponent) {
        JComponent jComponent2 = this._titleBarComponent;
        if (jComponent2 != jComponent) {
            this._titleBarComponent = jComponent;
            this.firePropertyChange(PROPERTY_TITLE_BAR_COMPONENT, jComponent2, this._titleBarComponent);
        }
    }

    public JComponent getTitleBarComponent() {
        return this._titleBarComponent;
    }

    public void setTitleLabelComponent(JComponent jComponent) {
        JComponent jComponent2 = this._titleLabelComponent;
        if (jComponent2 != jComponent) {
            if (jComponent2 != null) {
                jComponent2.removeMouseListener(this._mouseListener);
                jComponent2.removeMouseMotionListener(this._mouseListener);
            }
            this._titleLabelComponent = jComponent;
            if (this._titleLabelComponent != null) {
                this._titleLabelComponent.addMouseListener(this._mouseListener);
                this._titleLabelComponent.addMouseMotionListener(this._mouseListener);
            }
            this.firePropertyChange(PROPERTY_TITLE_LABEL_COMPONENT, jComponent2, this._titleLabelComponent);
        }
    }

    public JComponent getTitleLabelComponent() {
        return this._titleLabelComponent;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDockableFrame();
        }
        return this.accessibleContext;
    }

    public boolean isShowGripper() {
        return !(!this._showGripper || this.isAutohide() || this.isAutohideShowing() || !this.isRearrangable() || this._dockingManager != null && !this._dockingManager.isShowGripper() || this._dockingManager != null && !this._dockingManager.isRearrangable());
    }

    public void setShowGripper(boolean bl) {
        if (this._showGripper != bl) {
            boolean bl2 = this._showGripper;
            this._showGripper = bl;
            this.firePropertyChange(PROPERTY_SHOW_GRIPPER, bl2, this._showGripper);
        }
    }

    public boolean isShowTitleBar() {
        return this._showTitleBar && (this._dockingManager == null || this._dockingManager.isShowTitleBar());
    }

    boolean isShowTitleBarConfigured() {
        return this._showTitleBarConfigured;
    }

    void setShowTitleBarConfigured(boolean bl) {
        this._showTitleBarConfigured = bl;
    }

    public void setShowTitleBar(boolean bl) {
        this._showTitleBarConfigured = true;
        this.internalSetShowTitleBar(bl);
    }

    void internalSetShowTitleBar(boolean bl) {
        if (this._showTitleBar != bl) {
            boolean bl2 = this._showTitleBar;
            this._showTitleBar = bl;
            this.firePropertyChange(PROPERTY_SHOW_TITLE_BAR, bl2, this._showTitleBar);
        }
    }

    public boolean isShowContentPane() {
        return this._showContentPane;
    }

    public void setShowContentPane(boolean bl) {
        if (this._showContentPane != bl) {
            boolean bl2 = this._showContentPane;
            this._showContentPane = bl;
            this.firePropertyChange(PROPERTY_SHOW_CONTENT_PANE, bl2, this._showContentPane);
        }
    }

    public boolean isMaximizable() {
        return this._maximizable;
    }

    public void setMaximizable(boolean bl) {
        if (bl != this._maximizable) {
            boolean bl2 = this._maximizable;
            this._maximizable = bl;
            this.firePropertyChange(PROPERTY_MAXIMIZABLE, bl2, this._maximizable);
        }
    }

    private void changeMode(int n) {
        if (this.isNotified()) {
            this.setNotified(false);
        }
        this.getContext().setCurrentMode(n);
    }

    public boolean isNotified() {
        return this._notified;
    }

    public void setNotified(boolean bl) {
        if (this._notified && bl) {
            return;
        }
        if (bl) {
            if (this.getParent() instanceof FrameContainer) {
                FrameContainer frameContainer = (FrameContainer)this.getParent();
                if (this.shouldNotify(frameContainer)) {
                    this._animator = this.createNotificationFlasher(frameContainer);
                    this._animator.start();
                    this._notified = true;
                }
            } else if (this.isAutohide()) {
                int n = this.getContext().getCurrentDockSide();
                AutoHideContainer autoHideContainer = this.getDockingManager().getAutoHideContainer(n);
                this._animator = this.createNotificationFlasher(autoHideContainer);
                this._animator.start();
                this._notified = true;
            }
        } else {
            this._notified = false;
            if (this._animator != null) {
                this._animator.stop();
            }
        }
    }

    protected boolean shouldNotify(FrameContainer frameContainer) {
        return frameContainer != null && frameContainer.getSelectedFrame() != null && !this.equals(frameContainer.getSelectedFrame());
    }

    protected NotificationFlasher createNotificationFlasher(AutoHideContainer autoHideContainer) {
        return new NotificationFlasher(autoHideContainer, this, 0, this.getDockingManager().getNotificationDelay(), this.getDockingManager().getNotificationSteps());
    }

    protected NotificationFlasher createNotificationFlasher(FrameContainer frameContainer) {
        return new NotificationFlasher(frameContainer, this, 0, this.getDockingManager().getNotificationDelay(), this.getDockingManager().getNotificationSteps());
    }

    public boolean shouldVetoShowing() {
        return false;
    }

    public boolean shouldVetoHiding() {
        return false;
    }

    public boolean shouldVetoRemoving() {
        return false;
    }

    public boolean isSlidingAutohide() {
        return this._slidingAutohide;
    }

    public void setSlidingAutohide(boolean bl) {
        if (this._slidingAutohide != bl) {
            boolean bl2 = this._slidingAutohide;
            this._slidingAutohide = bl;
            this.firePropertyChange(PROPERTY_SLIDING_AUTOHIDE, bl2, this._slidingAutohide);
        }
    }

    public void dispose() {
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this._dockingManager = null;
        this._defaultFocusComponent = null;
        this._internalFocusedComponent = null;
        this.removeMouseListener(this._mouseListener);
        this.removeMouseMotionListener(this._mouseListener);
        this.putClientProperty("DraggingListener", null);
        this._mouseListener = null;
        this.putClientProperty("DraggingListener", null);
        if (this._currentFocusOwnerTracker != null) {
            this._currentFocusOwnerTracker.removeFocusListener(this._focusListenerInternalTracking);
            this._currentFocusOwnerTracker = null;
        }
        this._focusListenerInternalTracking = null;
        this.setRootPaneCheckingEnabled(false);
        this.getUI().uninstallUI(this);
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean bl) {
        if (bl != this._transient) {
            boolean bl2 = this._transient;
            this._transient = bl;
            this.firePropertyChange(PROPERTY_TRANSIENT, bl2, this._transient);
        }
    }

    public int getInitMode() {
        return this.getContext().getInitMode();
    }

    public void setInitMode(int n) {
        int n2 = this.getContext().getInitMode();
        if (n2 != n) {
            this.getContext().setInitMode(n);
            this.firePropertyChange(PROPERTY_INIT_MODE, n2, n);
        }
    }

    public int getInitSide() {
        return this.getContext().getInitSide();
    }

    public void setInitSide(int n) {
        int n2 = this.getContext().getInitSide();
        if (n2 != n) {
            this.getContext().setInitSide(n);
            this.firePropertyChange(PROPERTY_INIT_SIDE, n2, n);
        }
    }

    public int getInitIndex() {
        return this.getContext().getInitIndex();
    }

    public void setInitIndex(int n) {
        int n2 = this.getContext().getInitIndex();
        if (n2 != n) {
            this.getContext().setInitIndex(n);
        }
    }

    protected PropertyChangeListener createFocusChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl;
                boolean bl2 = DockableFrame.this.isAncestorOf((Component)propertyChangeEvent.getOldValue()) || DockableFrame.this == propertyChangeEvent.getOldValue() || DockableFrame.this.hasFocus();
                boolean bl3 = bl = DockableFrame.this.isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) || DockableFrame.this == KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() || DockableFrame.this.hasFocus();
                if (bl != bl2) {
                    DockableFrame.this.getUI().getTitlePane().repaint();
                }
            }
        };
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._focusChangeListener == null) {
            this._focusChangeListener = this.createFocusChangeListener();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this._focusChangeListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._focusChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this._focusChangeListener);
            this._focusChangeListener = null;
        }
    }

    public int getPreferredAutohideSide() {
        return this._preferredAutohideSide;
    }

    public void setPreferredAutohideSide(int n) {
        if (this._preferredAutohideSide != n) {
            int n2 = this._preferredAutohideSide;
            this._preferredAutohideSide = n;
            this.firePropertyChange(PROPERTY_PREFERRED_AUTOHIDE_SIDE, n2, this._preferredAutohideSide);
        }
    }

    public boolean isTabDockAllowed() {
        return this._tabDockAllowed;
    }

    public void setTabDockAllowed(boolean bl) {
        if (this._tabDockAllowed != bl) {
            boolean bl2 = this._tabDockAllowed;
            this._tabDockAllowed = bl;
            this.firePropertyChange(PROPERTY_TAB_DOCK_ALLOWED, bl2, this._tabDockAllowed);
        }
    }

    public boolean isAlwaysStayInGroup() {
        return this._alwaysStayInGroup;
    }

    public void setAlwaysStayInGroup(boolean bl) {
        if (this._alwaysStayInGroup != bl) {
            boolean bl2 = this._alwaysStayInGroup;
            this._alwaysStayInGroup = bl;
            this.firePropertyChange(PROPERTY_STAY_IN_GROUP, bl2, this._alwaysStayInGroup);
        }
    }

    public boolean isSideDockAllowed() {
        return this._sideDockAllowed;
    }

    public void setSideDockAllowed(boolean bl) {
        if (this._sideDockAllowed != bl) {
            boolean bl2 = this._sideDockAllowed;
            this._sideDockAllowed = bl;
            this.firePropertyChange(PROPERTY_SIDE_DOCK_ALLOWED, bl2, this._sideDockAllowed);
        }
    }

    @Override
    protected String paramString() {
        return "key=" + this.getKey() + ",title=" + this.getTitle() + ",mode=" + (this.getContext() == null ? "unknown" : DockContext.getStateName(this.getContext().getCurrentMode())) + ",side=" + (this.getContext() == null ? "unknown" : DockContext.getDockSideName(this.getContext().getCurrentDockSide()));
    }

    public Action getCloseAction() {
        if (this._closeAction == null) {
            if (this._closeActionByDefault == null) {
                this._closeActionByDefault = new CloseAction();
            }
            return this._closeActionByDefault;
        }
        return this._closeAction;
    }

    public void setCloseAction(Action action) {
        Action action2 = this._closeAction;
        if (action2 != action) {
            this._closeAction = action;
            this.firePropertyChange(PROPERTY_CLOSE_ACTION, action2, this._closeAction);
        }
    }

    public Action getHideAutohideAction() {
        if (this._hideAutohideAction == null) {
            if (this._hideAutohideActionByDefault == null) {
                this._hideAutohideActionByDefault = new HideAutohideAction();
            }
            return this._hideAutohideActionByDefault;
        }
        return this._hideAutohideAction;
    }

    public void setHideAutohideAction(Action action) {
        Action action2 = this._hideAutohideAction;
        if (action2 != action) {
            this._hideAutohideAction = action;
            this.firePropertyChange(PROPERTY_HIDE_AUTOHIDE_ACTION, action2, this._hideAutohideAction);
        }
    }

    public Action getFloatingAction() {
        return this.getFloatingAction(false);
    }

    public Action getFloatingAction(boolean bl) {
        if (this._floatingAction == null) {
            if (this._floatingActionByDefault == null) {
                this._floatingActionByDefault = new FloatingAction(bl);
            } else {
                ((FloatingAction)this._floatingActionByDefault).setSingle(bl);
            }
            return this._floatingActionByDefault;
        }
        return this._floatingAction;
    }

    public void setFloatingAction(Action action) {
        Action action2 = this._floatingAction;
        if (action2 != action) {
            this._floatingAction = action;
            this.firePropertyChange(PROPERTY_FLOATING_ACTION, action2, this._floatingAction);
        }
    }

    public Action getAutohideAction() {
        if (this._autohideAction == null) {
            if (this._autohideActionByDefault == null) {
                this._autohideActionByDefault = new AutohideAction();
            }
            return this._autohideActionByDefault;
        }
        return this._autohideAction;
    }

    public void setAutohideAction(Action action) {
        Action action2 = this._autohideAction;
        if (action2 != action) {
            this._autohideAction = action;
            this.firePropertyChange(PROPERTY_AUTOHIDE_ACTION, action2, this._autohideAction);
        }
    }

    public Action getMaximizeAction() {
        if (this._maximizeAction == null) {
            if (this._maximizeActionByDefault == null) {
                this._maximizeActionByDefault = new MaximizeAction();
            }
            return this._maximizeActionByDefault;
        }
        return this._maximizeAction;
    }

    public void setMaximizeAction(Action action) {
        Action action2 = this._maximizeAction;
        if (action2 != action) {
            this._maximizeAction = action;
            this.firePropertyChange(PROPERTY_MAXIMIZE_ACTION, action2, this._maximizeAction);
        }
    }

    public Action getDockableAction() {
        if (this._dockableAction == null) {
            if (this._dockableActionByDefault == null) {
                this._dockableActionByDefault = new DockableAction();
            }
            return this._dockableActionByDefault;
        }
        return this._dockableAction;
    }

    public void setDockableAction(Action action) {
        Action action2 = this._dockableAction;
        if (action2 != action) {
            this._dockableAction = action;
            this.firePropertyChange(PROPERTY_DOCKABLE_ACTION, action2, this._dockableAction);
        }
    }

    public Action getCustomDoubleClickAction() {
        return this._customDoubleClickAction;
    }

    public void setCustomDoubleClickAction(Action action) {
        Action action2 = this._customDoubleClickAction;
        if (action2 != action) {
            this._customDoubleClickAction = action;
            this.firePropertyChange(PROPERTY_DOUBLE_CLICK_ACTION, action2, this._customDoubleClickAction);
        }
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        if (!this._settingSize) {
            this._savedPreferredSize = dimension;
        }
        super.setPreferredSize(dimension);
    }

    void setSettingSize(boolean bl) {
        this._settingSize = bl;
    }

    void resetPreferredSize() {
        this.setPreferredSize(this._savedPreferredSize);
    }

    void internalSetPreferredSize() {
        try {
            this.setSettingSize(true);
            this.setPreferredSizeWithDockedWidthAndHeight();
        }
        finally {
            this.setSettingSize(false);
        }
    }

    void setPreferredSizeWithDockedWidthAndHeight() {
        int n;
        Dimension dimension = this.getPreferredSize();
        int n2 = this.getDockedWidth();
        if (n2 <= 0) {
            n2 = dimension.width;
        }
        if ((n = this.getDockedHeight()) <= 0) {
            n = dimension.height;
        }
        this.setPreferredSize(new Dimension(n2, n));
    }

    public boolean isShowContextMenu() {
        return this._showContextMenu;
    }

    public void setShowContextMenu(boolean bl) {
        boolean bl2 = this._showContextMenu;
        if (bl2 != bl) {
            this._showContextMenu = bl;
            this.firePropertyChange(PROPERTY_SHOW_CONTEXT_MENU, bl2, this._showContextMenu);
        }
    }

    protected boolean isDraggingTarget(MouseEvent mouseEvent) {
        if (this.getDockingManager() == null) {
            return false;
        }
        Object object = mouseEvent.getSource();
        return (!this.isShowGripper() || this._dockingManager != null && !this._dockingManager.isDragGripperOnly()) && this.isConsideredAsTitleBar(object) || object instanceof Gripper;
    }

    protected boolean isConsideredAsTitleBar(Object object) {
        return object == this.getUI().getTitlePane() || object == this.getTitleLabelComponent() || object == this.getTitleBarComponent() || this.getTitleBarComponent() != null && this.getTitleBarComponent().isAncestorOf((Component)object) || this.getTitleLabelComponent() != null && this.getTitleLabelComponent().isAncestorOf((Component)object);
    }

    protected Component getDraggingTarget(MouseEvent mouseEvent) {
        if (!this.isDraggingTarget(mouseEvent)) {
            return null;
        }
        Object object = mouseEvent.getSource();
        if (object == this.getParent() && this.getParent() instanceof JideTabbedPane) {
            Point point;
            Point point2 = mouseEvent.getPoint();
            Component component = ((JideTabbedPaneUI)((JideTabbedPane)this.getParent()).getUI()).getTabPanel();
            if (component.contains(point = SwingUtilities.convertPoint((Component)object, point2, component))) {
                return this.getParent();
            }
        } else if (!this.getDockingManager().isDragAllTabs() && this.isConsideredAsTitleBar(object)) {
            Point point;
            Point point3 = mouseEvent.getPoint();
            Component component = this.getUI().getTitlePane();
            if (component.contains(point = SwingUtilities.convertPoint((Component)object, point3, component))) {
                return this.getParent();
            }
        }
        return this;
    }

    public int getDefaultEscapeAction() {
        return this._defaultEscapeAction;
    }

    public void setDefaultEscapeAction(int n) {
        int n2 = this._defaultEscapeAction;
        if (this._defaultEscapeAction != n) {
            this._defaultEscapeAction = n;
            this.firePropertyChange(PROPERTY_DEFAULT_ESCAPE_ACTION, n2, this._defaultEscapeAction);
        }
    }

    public int getDefaultCloseAction() {
        return this._defaultCloseAction;
    }

    public void setDefaultCloseAction(int n) {
        int n2 = this._defaultCloseAction;
        if (this._defaultCloseAction != n) {
            this._defaultCloseAction = n;
            this.firePropertyChange(PROPERTY_DEFAULT_CLOSE_ACTION, n2, this._defaultCloseAction);
        }
    }

    public boolean isAutohideWhenActive() {
        return this._autohideWhenActive;
    }

    public void setAutohideWhenActive(boolean bl) {
        boolean bl2 = this._autohideWhenActive;
        if (bl2 != bl) {
            this._autohideWhenActive = bl;
            this.firePropertyChange(PROPERTY_AUTOHIDE_WHEN_ACTIVE, bl2, bl);
        }
    }

    public int[] getButtonsOrder() {
        return this._buttonsOrder;
    }

    public void setButtonsOrder(int[] nArray) {
        int[] nArray2 = this._buttonsOrder;
        if (nArray != this._buttonsOrder) {
            this._buttonsOrder = nArray;
            this.firePropertyChange(PROPERTY_BUTTONS_ORDER, nArray2, this._buttonsOrder);
        }
    }

    @Deprecated
    public boolean isActivateAfterSliding() {
        return false;
    }

    @Deprecated
    public void addAdditionalButtonActions(Action action, Icon icon) {
        this.addAdditionalButtonActions(action);
    }

    public void addAdditionalButtonActions(Action action) {
        if (action == null) {
            return;
        }
        if (this._additionalButtonActions.contains(action)) {
            return;
        }
        Object object = this._additionalButtonActions.clone();
        this._additionalButtonActions.add(action);
        this.firePropertyChange("additionalButtonActions", object, this._additionalButtonActions);
    }

    public void removeAdditionalButtonActions(Action action) {
        if (action == null) {
            return;
        }
        if (!this._additionalButtonActions.contains(action)) {
            return;
        }
        Object object = this._additionalButtonActions.clone();
        this._additionalButtonActions.remove(action);
        this.firePropertyChange("additionalButtonActions", object, this._additionalButtonActions);
    }

    public Icon getActionIcon(Action action) {
        if (action == null) {
            return null;
        }
        return (Icon)action.getValue("SmallIcon");
    }

    public List<Action> getAdditionalButtonActions() {
        return Collections.unmodifiableList(this._additionalButtonActions);
    }

    private void recordPreviousContext() {
        if (this._previousContext == null) {
            this._previousContext = new DockContext();
        }
        this._previousContext.setCurrentMode(-1);
        this._previousContext.setCurrentDockSide(0);
        this._previousContext.setUndockedBounds(null);
    }

    boolean isRealized() {
        return this._realized;
    }

    void setRealized(boolean bl) {
        this._realized = bl;
    }

    public void setTabBackground(Color color) {
        this._tabBackground = color;
    }

    @Override
    public Color getTabBackground() {
        return this._tabBackground;
    }

    public void setTabForeground(Color color) {
        this._tabForeground = color;
    }

    @Override
    public Color getTabForeground() {
        return this._tabForeground;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(1)) {
            Lm.showInvalidProductMessage(DockableFrame.class.getName(), 1);
        }
        LOGGER_EVENT = Logger.getLogger(DockableFrameEvent.class.getName());
        LOGGER_FOCUS = Logger.getLogger(DefaultDockingManager.class.getName() + ".focus");
    }

    protected class AccessibleDockableFrame
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleDockableFrame() {
            super(DockableFrame.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return DockableFrame.this.getTabTitle();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            if (DockableFrame.this.isActive()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                try {
                    if (number.intValue() == 0) {
                        DockableFrame.this.setActive(true);
                    } else {
                        DockableFrame.this.setActive(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return Integer.MAX_VALUE;
        }
    }

    public class DockableAction
    extends AbstractAction {
        public DockableAction() {
            super(DockableFrame.this.getResourceString("DockableFrameTitlePane.dockableText"));
            this.putValue("ShortDescription", DockableFrame.this.getResourceString("DockableFrameTitlePane.dockableTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DockableFrame.this.getDockingManager().toggleDockable(DockableFrame.this.getKey());
        }

        @Override
        public boolean isEnabled() {
            return DockableFrame.this.getDockingManager() != null && !DockableFrame.this.isMaximized() && DockableFrame.this.getDockingManager().isFloatable() && DockableFrame.this.isFloatable() && !DockableFrame.this.isAutohide() && !DockableFrame.this.isAutohideShowing() && super.isEnabled();
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(DockableFrame.this.getResourceString("DockableFrameTitlePane.maximizeText"));
            this.putValue("ShortDescription", DockableFrame.this.getResourceString("DockableFrameTitlePane.maximizeTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DockableFrame.this.getDockingManager().getMaximizedFrameKey() == null) {
                DockableFrame.this.getDockingManager().addUndo(DockableFrame.this.getResourceString("Undo.maximize"));
            } else {
                DockableFrame.this.getDockingManager().addUndo(DockableFrame.this.getResourceString("Undo.restore"));
            }
            DockableFrame.this.getDockingManager().toggleMaximizeState(DockableFrame.this.getKey());
        }

        @Override
        public boolean isEnabled() {
            return DockableFrame.this.isMaximizable() && DockableFrame.this.getDockingManager() != null && DockableFrame.this.isDockable() && super.isEnabled();
        }
    }

    public class HideAutohideAction
    extends AbstractAction {
        public HideAutohideAction() {
            super(DockableFrame.this.getResourceString("DockableFrameTitlePane.hideAutohideText"));
            this.putValue("ShortDescription", DockableFrame.this.getResourceString("DockableFrameTitlePane.hideAutohideTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DockableFrame.this.getDockingManager() != null && DockableFrame.this.isAutohideShowing()) {
                DockableFrame.this.getDockingManager().stopShowingAutohideFrame(0, true);
            }
        }

        @Override
        public boolean isEnabled() {
            return DockableFrame.this.getDockingManager() != null && DockableFrame.this.isAutohideShowing() && super.isEnabled();
        }
    }

    public class FloatingAction
    extends AbstractAction {
        private boolean _single;

        public FloatingAction() {
            this(false);
        }

        public FloatingAction(boolean bl) {
            super(DockableFrame.this.getResourceString("DockableFrameTitlePane.floatingText"));
            this.putValue("ShortDescription", DockableFrame.this.getResourceString("DockableFrameTitlePane.floatingTooltip"));
            this.setSingle(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.isSingle() || !DockableFrame.this.getDockingManager().isFloatAllTabs();
            DockableFrame.this.getDockingManager().addUndo(DockableFrame.this.getResourceString("Undo.toggle"));
            DockableFrame.this.getDockingManager().toggleState(DockableFrame.this.getKey(), bl);
        }

        @Override
        public boolean isEnabled() {
            return DockableFrame.this.isDockable() && DockableFrame.this.isFloatable() && DockableFrame.this.getDockingManager() != null && DockableFrame.this.getDockingManager().isFloatable() && super.isEnabled();
        }

        public boolean isSingle() {
            return this._single;
        }

        public void setSingle(boolean bl) {
            this._single = bl;
        }
    }

    public class AutohideAction
    extends AbstractAction {
        public AutohideAction() {
            super(DockableFrame.this.getResourceString("DockableFrameTitlePane.autohideText"));
            this.putValue("ShortDescription", DockableFrame.this.getResourceString("DockableFrameTitlePane.autohideTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DockableFrame.this.getDockingManager().addUndo(DockableFrame.this.getResourceString("Undo.toggleAutohide"));
            DockableFrame.this.getDockingManager().toggleAutohideState(DockableFrame.this.getKey());
        }

        @Override
        public boolean isEnabled() {
            return !DockableFrame.this.isFloated() && DockableFrame.this.isDockable() && DockableFrame.this.isAutohidable() && DockableFrame.this.getDockingManager() != null && DockableFrame.this.getDockingManager().isAutohidable() && super.isEnabled();
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(DockableFrame.this.getDockingManager() != null ? DockableFrame.this.getDockingManager().getResourceString("DockableFrameTitlePane.closeText") : Resource.getResourceBundle(Locale.getDefault()).getString("DockableFrameTitlePane.closeText"));
            this.putValue("ShortDescription", DockableFrame.this.getDockingManager() != null ? DockableFrame.this.getDockingManager().getResourceString("DockableFrameTitlePane.closeTooltip") : Resource.getResourceBundle(Locale.getDefault()).getString("DockableFrameTitlePane.closeTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch (DockableFrame.this.getDefaultCloseAction()) {
                case 0: {
                    if (DockableFrame.this.isHidden() || DockableFrame.this.shouldVetoHiding()) break;
                    if (actionEvent == null || !"hiddenByParentContainer".equals(actionEvent.getActionCommand())) {
                        DockableFrame.this.getDockingManager().addUndo(DockableFrame.this.getDockingManager().getResourceString("Undo.hide"));
                    }
                    DockableFrame.this.getDockingManager().hideFrame(DockableFrame.this.getKey());
                    break;
                }
                case 1: {
                    if (DockableFrame.this.getDockingManager().getFrame(DockableFrame.this.getKey()) == null || DockableFrame.this.shouldVetoRemoving()) break;
                    DockableFrame.this.getDockingManager().removeFrame(DockableFrame.this.getKey());
                    break;
                }
                case 2: {
                    if (DockableFrame.this.getDockingManager().getFrame(DockableFrame.this.getKey()) == null || DockableFrame.this.shouldVetoRemoving()) break;
                    DockableFrame dockableFrame = DockableFrame.this.getDockingManager().getFrame(DockableFrame.this.getKey());
                    DockableFrame.this.getDockingManager().removeFrame(DockableFrame.this.getKey());
                    dockableFrame.dispose();
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return DockableFrame.this.isHidable() && DockableFrame.this.getDockingManager() != null && DockableFrame.this.getDockingManager().isHidable() && super.isEnabled();
        }
    }
}

