/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.LayoutPersistence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class DefaultWindowDockableHolder
extends JWindow
implements DockableHolder {
    private DockingManager _dockingManager;
    private JPanel _contentContainer;
    protected boolean _autoDispose = true;

    public DefaultWindowDockableHolder() {
        this.initFrame(this.getContentPane());
    }

    public DefaultWindowDockableHolder(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.initFrame(this.getContentPane());
    }

    public DefaultWindowDockableHolder(Frame frame) {
        super(frame);
        this.initFrame(this.getContentPane());
    }

    public DefaultWindowDockableHolder(Window window) {
        super(window);
        this.initFrame(this.getContentPane());
    }

    public DefaultWindowDockableHolder(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.initFrame(this.getContentPane());
    }

    private void initFrame(Container container) {
        this.setRootPaneCheckingEnabled(false);
        try {
            container.setLayout(new BorderLayout());
            this._contentContainer = new JPanel();
            container.add((Component)this._contentContainer, "Center");
            this._dockingManager = this.createDockingManager(this._contentContainer);
        }
        finally {
            this.setRootPaneCheckingEnabled(true);
        }
    }

    protected DockingManager createDockingManager(Container container) {
        return new DefaultDockingManager(this, container);
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    public LayoutPersistence getLayoutPersistence() {
        return this._dockingManager;
    }

    protected boolean isContentPaneCheckingEnabled() {
        return this.isRootPaneCheckingEnabled();
    }

    protected void setContentPaneCheckingEnabled(boolean bl) {
        this.setRootPaneCheckingEnabled(bl);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isAutoDispose()) {
            this._contentContainer = null;
            if (this._dockingManager != null) {
                this._dockingManager.dispose();
                this._dockingManager = null;
            }
        }
    }

    public boolean isAutoDispose() {
        return this._autoDispose;
    }

    public void setAutoDispose(boolean bl) {
        this._autoDispose = bl;
    }
}

