/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainerDivider;
import com.jidesoft.docking.DockID;
import com.jidesoft.docking.Dockable;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.Workspace;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;

public class ContainerContainer
extends JideSplitPane
implements ContainerListener,
Dockable,
PropertyChangeListener {
    private DockingManager _dockingManager;
    private int _dockID = 0;
    private double[] _eventualProportions;

    ContainerContainer() {
        this((DockingManager)null);
    }

    public ContainerContainer(DockingManager dockingManager) {
        this(dockingManager, 1);
    }

    public ContainerContainer(DockingManager dockingManager, int n) {
        super(n);
        this._dockingManager = dockingManager;
        if (this._dockingManager != null) {
            this.setHeavyweightComponentEnabled(this._dockingManager.isHeavyweightComponentEnabled());
            this.setContinuousLayout(this._dockingManager.isContinuousLayout());
            this.setProportionalLayout(this._dockingManager.isProportionalSplits());
            this.setShowGripper(this._dockingManager.isShowDividerGripper());
            this.addPropertyChangeListener(this);
            this.setInitiallyEven(false);
            this.resetDockID();
        }
    }

    @Override
    public void addImpl(Component component, Object object, int n) {
        if (this.getDockingManager() != null) {
            Workspace workspace = this.getDockingManager().getWorkspace();
            if (component instanceof Container && workspace.isVisible() && ((Container)component).isAncestorOf(workspace) || component == workspace) {
                super.addImpl(component, workspace.getLayoutConstraint(), n);
            } else {
                super.addImpl(component, object, n);
            }
        } else {
            super.addImpl(component, object, n);
        }
    }

    @Override
    protected JideSplitPaneDivider createSplitPaneDivider() {
        return new ContainerContainerDivider(this);
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    protected void startDragging(JideSplitPaneDivider jideSplitPaneDivider) {
        this.setContinuousLayout(this._dockingManager.isContinuousLayout());
        super.startDragging(jideSplitPaneDivider);
    }

    @Override
    public void setDockingManager(DockingManager dockingManager) {
        this._dockingManager = dockingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideItselfIfEmpty() {
        Object object;
        Object object2;
        Container container;
        if (this.getComponentCount() == 1 && this.getComponent(0) instanceof ContainerContainer) {
            container = (ContainerContainer)this.getComponent(0);
            object2 = this.getParent();
            object = ((Component)object2).getTreeLock();
            synchronized (object) {
                if (((JideSplitPane)container).getOrientation() == this.getOrientation()) {
                    if (object2 instanceof DockedFrameContainer) {
                        ((Container)object2).add((Component)container, "Center");
                        ((ContainerContainer)container).setDockID(this.getDockID());
                    } else if (object2 instanceof ContainerContainer) {
                        ContainerContainer containerContainer = (ContainerContainer)object2;
                        int n = containerContainer.indexOfPane(this);
                        containerContainer.insertPane(container, n);
                    }
                    ((Container)object2).doLayout();
                }
            }
        }
        if (this.getComponentCount() == 1 && this.getComponent(0) instanceof Workspace && !this.getComponent(0).isVisible()) {
            container = (Workspace)this.getComponent(0);
            object2 = this.getParent();
            if (object2 instanceof DockedFrameContainer) {
                ((Container)object2).add((Component)container, "Center");
            } else if (object2 instanceof ContainerContainer) {
                object = (ContainerContainer)object2;
                int n = ((JideSplitPane)object).indexOfPane(this);
                ((JideSplitPane)object).insertPane(container, n);
            }
            ((Container)object2).doLayout();
        }
        if (this.getComponentCount() == 0 && this.getParent() != null) {
            container = this.getParent();
            object2 = container.getTreeLock();
            synchronized (object2) {
                this.setVisible(false);
                container.remove(this);
                container.doLayout();
                if (container instanceof ContainerContainer) {
                    ((ContainerContainer)container).hideItselfIfEmpty();
                }
            }
        }
    }

    @Override
    public int getDockID() {
        return this._dockID;
    }

    @Override
    public void setDockID(int n) {
        this._dockID = n;
    }

    @Override
    public void resetDockID() {
        this._dockID = DockID.getInstance(this._dockingManager).getID(this.getDockID());
    }

    void setEventualProportions(double[] dArray) {
        this._eventualProportions = dArray;
        this.updateProportions();
    }

    private void updateProportions() {
        if (this._eventualProportions != null && this.getPaneCount() == this._eventualProportions.length + 1) {
            this.setProportions(this._eventualProportions);
            this._eventualProportions = null;
        }
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        super.componentAdded(containerEvent);
        if (!(containerEvent.getChild() instanceof JideSplitPaneDivider)) {
            this.updateProportions();
        }
    }

    boolean isComponentNextToDivider(ContainerContainerDivider containerContainerDivider, Component component) {
        if (containerContainerDivider == null || containerContainerDivider.getParent() != this) {
            return false;
        }
        if (component == null || component.getParent() != this) {
            return false;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component2 = this.getComponent(i);
            if (component2 == containerContainerDivider && i < this.getComponentCount() - 1 && component == this.getComponent(i + 1)) {
                return true;
            }
            if (component2 != component || i >= this.getComponentCount() - 1 || containerContainerDivider != this.getComponent(i + 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        final int n = this.getOrientation();
        if ("dividerLocation".equals(propertyChangeEvent.getPropertyName())) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    JideSwingUtilities.setRecursively(ContainerContainer.this, new JideSwingUtilities.Handler(){

                        @Override
                        public boolean condition(Component component) {
                            return component instanceof DockableFrame;
                        }

                        @Override
                        public void action(Component component) {
                            ((DockableFrame)component).updateDockedWidthOrHeight(n);
                        }

                        @Override
                        public void postAction(Component component) {
                        }
                    });
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    protected void finishDraggingTo(JideSplitPaneDivider jideSplitPaneDivider, int n) {
        this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.resizing"));
        super.finishDraggingTo(jideSplitPaneDivider, n);
    }
}

