/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.swing.SidePane;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import com.jidesoft.swing.SimpleScrollPane;
import java.awt.Container;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class AutoHideContainer
extends SidePane
implements PropertyChangeListener,
DockableFrameListener {
    private final DockingManager _dockingManager;
    private final MouseInputCreator _mouseInputCreator;

    AutoHideContainer(int n) {
        this(n, null, null);
    }

    public AutoHideContainer(int n, DockingManager dockingManager, MouseInputCreator mouseInputCreator) {
        super(n);
        this.setOpaque(false);
        this._dockingManager = dockingManager;
        this._mouseInputCreator = mouseInputCreator;
    }

    public int getGroupIndex(DockableFrame dockableFrame) {
        for (int i = 0; i < this.getGroups().size(); ++i) {
            SidePaneGroup sidePaneGroup = this.getGroups().get(i);
            if (!sidePaneGroup.exists(dockableFrame)) continue;
            return i;
        }
        return -1;
    }

    public SidePaneGroup getSidePaneGroup(DockableFrame dockableFrame) {
        for (int i = 0; i < this.getGroups().size(); ++i) {
            SidePaneGroup sidePaneGroup = this.getGroups().get(i);
            if (!sidePaneGroup.exists(dockableFrame)) continue;
            return sidePaneGroup;
        }
        return null;
    }

    public SidePaneItem getSidePaneItem(DockableFrame dockableFrame) {
        SidePaneGroup sidePaneGroup = this.getSidePaneGroup(dockableFrame);
        if (sidePaneGroup != null) {
            return sidePaneGroup.getSidePaneItem(dockableFrame);
        }
        return null;
    }

    public int getSelectedItemIndex(Point point) {
        return this.getUI().getSelectedItemIndex(point);
    }

    public SidePaneGroup getGroupForIndex(int n) {
        return this.getUI().getGroupForIndex(n);
    }

    public SidePaneItem getItemForIndex(int n) {
        return this.getUI().getItemForIndex(n);
    }

    @Override
    public void addGroup(SidePaneGroup sidePaneGroup) {
        super.addGroup(sidePaneGroup);
        int n = DockingUtils.convertToDockSide(this.getAttachedSide());
        for (SidePaneItem sidePaneItem : sidePaneGroup) {
            if (sidePaneItem.getComponent() instanceof DockableFrame) {
                DockableFrame dockableFrame = (DockableFrame)sidePaneItem.getComponent();
                dockableFrame.getContext().setCurrentDockSide(n);
                dockableFrame.addDockableFrameListener(this);
            }
            sidePaneItem.getComponent().removePropertyChangeListener(this);
            sidePaneItem.getComponent().addPropertyChangeListener(this);
        }
        this.invalidateScrollPane();
    }

    public void addGroup(FrameContainer frameContainer) {
        if (this._dockingManager.isGroupAllowedOnSidePane()) {
            DockableFrame dockableFrame;
            int n;
            SidePaneGroup sidePaneGroup = new SidePaneGroup();
            for (n = 0; n < frameContainer.getTabCount(); ++n) {
                dockableFrame = (DockableFrame)frameContainer.getComponentAt(n);
                int n2 = DockingUtils.convertToDockSide(this.getAttachedSide());
                sidePaneGroup.add(new SidePaneItem(dockableFrame.getSideTitle(), dockableFrame.getFrameIcon(), dockableFrame, this._mouseInputCreator.createAutoHideMouseInputListener(dockableFrame, n2)));
                dockableFrame.getContext().setCurrentDockSide(n2);
                dockableFrame.removeDockableFrameListener(this);
                dockableFrame.addDockableFrameListener(this);
                dockableFrame.removePropertyChangeListener(this);
                dockableFrame.addPropertyChangeListener(this);
            }
            if (sidePaneGroup.size() > 0) {
                n = frameContainer.getSelectedIndex();
                if (n >= 0) {
                    sidePaneGroup.setSelectedIndex(n);
                }
                this.getGroups().add(sidePaneGroup);
            }
            for (n = 0; n < frameContainer.getTabCount(); ++n) {
                try {
                    dockableFrame = (DockableFrame)frameContainer.getComponentAt(n);
                    dockableFrame.setAutohide(true);
                    continue;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        } else {
            for (int i = 0; i < frameContainer.getTabCount(); ++i) {
                SidePaneGroup sidePaneGroup = new SidePaneGroup();
                DockableFrame dockableFrame = (DockableFrame)frameContainer.getComponentAt(i);
                int n = DockingUtils.convertToDockSide(this.getAttachedSide());
                sidePaneGroup.add(new SidePaneItem(dockableFrame.getSideTitle(), dockableFrame.getFrameIcon(), dockableFrame, this._mouseInputCreator.createAutoHideMouseInputListener(dockableFrame, n)));
                dockableFrame.removeDockableFrameListener(this);
                dockableFrame.addDockableFrameListener(this);
                dockableFrame.removePropertyChangeListener(this);
                dockableFrame.addPropertyChangeListener(this);
                this.getGroups().add(sidePaneGroup);
                try {
                    dockableFrame.getContext().setCurrentDockSide(n);
                    dockableFrame.setAutohide(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (sidePaneGroup.size() <= 0) continue;
                sidePaneGroup.setSelectedIndex(0);
            }
        }
        frameContainer.removeAll();
        this.invalidateScrollPane();
    }

    public void addFrame(DockableFrame dockableFrame, int n) {
        if (n >= this.getGroups().size()) {
            super.addGroup(new SidePaneGroup());
            n = this.getGroups().size() - 1;
        }
        SidePaneGroup sidePaneGroup = this.getGroups().get(n);
        this.addFrameToGroup(sidePaneGroup, dockableFrame);
        sidePaneGroup.setSelectedIndex(sidePaneGroup.size() - 1);
        this.invalidateScrollPane();
    }

    public void addFrame(DockableFrame dockableFrame) {
        this.addFrame(dockableFrame, 0);
    }

    private void addFrameToGroup(SidePaneGroup sidePaneGroup, DockableFrame dockableFrame) {
        int n = DockingUtils.convertToDockSide(this.getAttachedSide());
        sidePaneGroup.add(new SidePaneItem(dockableFrame.getSideTitle(), dockableFrame.getFrameIcon(), dockableFrame, this._mouseInputCreator.createAutoHideMouseInputListener(dockableFrame, n)));
        try {
            dockableFrame.getContext().setCurrentDockSide(n);
            dockableFrame.setAutohide(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        dockableFrame.addDockableFrameListener(this);
        dockableFrame.removePropertyChangeListener(this);
        dockableFrame.addPropertyChangeListener(this);
    }

    public void removeFrame(DockableFrame dockableFrame) {
        for (int i = 0; i < this.getGroups().size(); ++i) {
            SidePaneGroup sidePaneGroup = this.getGroups().get(i);
            dockableFrame.removePropertyChangeListener(this);
            dockableFrame.removeDockableFrameListener(this);
            if (!sidePaneGroup.removeComponent(dockableFrame)) continue;
            if (sidePaneGroup.size() != 0) break;
            this.removeGroup(i);
            break;
        }
        if (this.getGroups().size() == 0) {
            this.removeAll();
        }
        this.invalidateScrollPane();
    }

    @Override
    public void removeGroup(SidePaneGroup sidePaneGroup) {
        super.removeGroup(sidePaneGroup);
        for (SidePaneItem sidePaneItem : sidePaneGroup) {
            sidePaneItem.getComponent().removePropertyChangeListener(this);
            if (!(sidePaneItem.getComponent() instanceof DockableFrame)) continue;
            ((DockableFrame)sidePaneItem.getComponent()).removeDockableFrameListener(this);
        }
        this.invalidateScrollPane();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        SidePaneItem sidePaneItem;
        if ("sideTitle".equals(propertyChangeEvent.getPropertyName())) {
            SidePaneItem sidePaneItem2 = this.getSidePaneItem((DockableFrame)propertyChangeEvent.getSource());
            if (sidePaneItem2 != null) {
                sidePaneItem2.setTitle((String)propertyChangeEvent.getNewValue());
                this.repaint();
            }
        } else if ("frameIcon".equals(propertyChangeEvent.getPropertyName()) && (sidePaneItem = this.getSidePaneItem((DockableFrame)propertyChangeEvent.getSource())) != null) {
            sidePaneItem.setIcon((Icon)propertyChangeEvent.getNewValue());
            this.repaint();
        }
    }

    public List<String> getAllFrameKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<SidePaneGroup> list = this.getGroups();
        for (SidePaneGroup sidePaneGroup : list) {
            for (Object e : sidePaneGroup) {
                SidePaneItem sidePaneItem = (SidePaneItem)e;
                if (!(sidePaneItem.getComponent() instanceof DockableFrame)) continue;
                arrayList.add(((DockableFrame)sidePaneItem.getComponent()).getKey());
            }
        }
        return arrayList;
    }

    private void invalidateScrollPane() {
        Container container = SwingUtilities.getAncestorOfClass(SimpleScrollPane.class, this);
        if (container != null) {
            this.invalidate();
            this.getParent().doLayout();
        }
    }

    @Override
    public void dockableFrameAdded(DockableFrameEvent dockableFrameEvent) {
    }

    @Override
    public void dockableFrameRemoved(DockableFrameEvent dockableFrameEvent) {
    }

    @Override
    public void dockableFrameShown(DockableFrameEvent dockableFrameEvent) {
    }

    @Override
    public void dockableFrameHidden(DockableFrameEvent dockableFrameEvent) {
    }

    @Override
    public void dockableFrameDocked(DockableFrameEvent dockableFrameEvent) {
    }

    @Override
    public void dockableFrameFloating(DockableFrameEvent dockableFrameEvent) {
    }

    @Override
    public void dockableFrameAutohidden(DockableFrameEvent dockableFrameEvent) {
        if (dockableFrameEvent.getDockableFrame().isAutohide() || dockableFrameEvent.getDockableFrame().isAutohideShowing()) {
            this.repaint();
        }
    }

    @Override
    public void dockableFrameAutohideShowing(DockableFrameEvent dockableFrameEvent) {
        if (dockableFrameEvent.getDockableFrame().isAutohide() || dockableFrameEvent.getDockableFrame().isAutohideShowing()) {
            this.repaint();
        }
    }

    @Override
    public void dockableFrameActivated(DockableFrameEvent dockableFrameEvent) {
        if (dockableFrameEvent.getDockableFrame().isAutohide() || dockableFrameEvent.getDockableFrame().isAutohideShowing()) {
            this.repaint();
        } else if (dockableFrameEvent.getOppositeDockableFrame() != null && (dockableFrameEvent.getOppositeDockableFrame().isAutohide() || dockableFrameEvent.getOppositeDockableFrame().isAutohideShowing())) {
            this.repaint();
        }
    }

    @Override
    public void dockableFrameDeactivated(DockableFrameEvent dockableFrameEvent) {
        if (dockableFrameEvent.getDockableFrame().isAutohide() || dockableFrameEvent.getDockableFrame().isAutohideShowing()) {
            this.repaint();
        } else if (dockableFrameEvent.getOppositeDockableFrame() != null && (dockableFrameEvent.getOppositeDockableFrame().isAutohide() || dockableFrameEvent.getOppositeDockableFrame().isAutohideShowing())) {
            this.repaint();
        }
    }

    @Override
    public void dockableFrameTabShown(DockableFrameEvent dockableFrameEvent) {
    }

    @Override
    public void dockableFrameTabHidden(DockableFrameEvent dockableFrameEvent) {
    }

    @Override
    public void dockableFrameMaximized(DockableFrameEvent dockableFrameEvent) {
    }

    @Override
    public void dockableFrameRestored(DockableFrameEvent dockableFrameEvent) {
    }

    @Override
    public void dockableFrameTransferred(DockableFrameEvent dockableFrameEvent) {
    }

    @Override
    public void dockableFrameMoved(DockableFrameEvent dockableFrameEvent) {
    }

    public static interface MouseInputCreator {
        public MouseInputListener createAutoHideMouseInputListener(DockableFrame var1, int var2);
    }
}

