/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.BasicDiffPane;
import com.jidesoft.diff.Diff;
import com.jidesoft.diff.DiffDivider;
import com.jidesoft.diff.DiffMargin;
import com.jidesoft.diff.DiffRowNumberMargin;
import com.jidesoft.diff.DiffTableStyleProvider;
import com.jidesoft.diff.Difference;
import com.jidesoft.diff.LazyLoadTableRowData;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grid.TreeTableSearchable;
import com.jidesoft.margin.RowMarginSupport;
import com.jidesoft.margin.TableRowMarginSupport;
import com.jidesoft.marker.MarkerSupport;
import com.jidesoft.marker.TableRowMarkerSupport;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class TableDiffPane
extends BasicDiffPane<Object> {
    private Object[] _fromItems;
    private Object[] _toItems;
    protected DiffTableStyleProvider _fromTableStyleProvider;
    protected DiffTableStyleProvider _toTableStyleProvider;

    public TableDiffPane() {
    }

    public TableDiffPane(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public void flip() {
        this._fromItems = null;
        this._toItems = null;
        super.flip();
    }

    protected Object[] createArrayFromTableModel(TableModel tableModel) {
        Object[] objectArray = new Object[tableModel.getRowCount()];
        int n = 0;
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            objectArray[i] = this.getTableRowData(tableModel, i);
            if (++n < 10000) continue;
            if (Thread.currentThread().isInterrupted()) {
                return new Object[0];
            }
            n = 0;
        }
        return objectArray;
    }

    protected Object getTableRowData(TableModel tableModel, int n) {
        return new LazyLoadTableRowData(tableModel, n);
    }

    private List<Object> getRowData(TableModel tableModel, int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(){
            private static final long serialVersionUID = -3491850231727214748L;

            @Override
            public boolean equals(Object object) {
                return object instanceof List && JideSwingUtilities.equals(this, object, true);
            }
        };
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            arrayList.add(tableModel.getValueAt(n, i));
        }
        return arrayList;
    }

    @Override
    protected void customizePane(JComponent jComponent, int n) {
        super.customizePane(jComponent, n);
        JTable jTable = null;
        if (n == 0) {
            jTable = (JTable)this._fromComponent;
            this._fromMarginArea.setBorder(BorderFactory.createEmptyBorder(jTable.getTableHeader().getPreferredSize().height + 1, 0, 1, 0));
            if (this._fromDiffMargin instanceof DiffMargin) {
                ((DiffMargin)this._fromDiffMargin).setDelta(-2);
            }
            if (this._fromDiffLineNumberMargin instanceof DiffRowNumberMargin) {
                ((DiffRowNumberMargin)this._fromDiffLineNumberMargin).setDelta(-2);
            }
            this._fromTableStyleProvider = new DiffTableStyleProvider(this, n);
            if (jTable instanceof CellStyleTable) {
                ((CellStyleTable)jTable).setTableStyleProvider(this._fromTableStyleProvider);
                ((CellStyleTable)jTable).setGridColorProvider(this._fromTableStyleProvider);
            }
            jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    TableDiffPane.this.updateSelectedDifference(0);
                }
            });
            jTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (((JTable)TableDiffPane.this._fromComponent).getModel() != tableModelEvent.getSource() && tableModelEvent.getSource() instanceof TableModel) {
                        ((TableModel)tableModelEvent.getSource()).removeTableModelListener(this);
                        return;
                    }
                    TableDiffPane.access$002(TableDiffPane.this, null);
                    if (TableDiffPane.this._diffed) {
                        TableDiffPane.this.runDiff();
                    }
                }
            });
        } else if (n == 1) {
            jTable = (JTable)this._toComponent;
            this._toMarginArea.setBorder(BorderFactory.createEmptyBorder(jTable.getTableHeader().getPreferredSize().height + 1, 0, 1, 0));
            if (this._toDiffMargin instanceof DiffMargin) {
                ((DiffMargin)this._toDiffMargin).setDelta(-2);
            }
            if (this._toDiffLineNumberMargin instanceof DiffRowNumberMargin) {
                ((DiffRowNumberMargin)this._toDiffLineNumberMargin).setDelta(-2);
            }
            this._toTableStyleProvider = new DiffTableStyleProvider(this, n);
            if (jTable instanceof CellStyleTable) {
                ((CellStyleTable)jTable).setTableStyleProvider(this._toTableStyleProvider);
                ((CellStyleTable)jTable).setGridColorProvider(this._toTableStyleProvider);
            }
            jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    TableDiffPane.this.updateSelectedDifference(1);
                }
            });
            jTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (((JTable)TableDiffPane.this._toComponent).getModel() != tableModelEvent.getSource() && tableModelEvent.getSource() instanceof TableModel) {
                        ((TableModel)tableModelEvent.getSource()).removeTableModelListener(this);
                        return;
                    }
                    TableDiffPane.access$102(TableDiffPane.this, null);
                    if (TableDiffPane.this._diffed) {
                        TableDiffPane.this.runDiff();
                    }
                }
            });
        }
        if (jTable instanceof JideTable) {
            jTable.setAutoResizeMode(256);
            ((JideTable)jTable).setColumnAutoResizable(true);
            new TreeTableSearchable(jTable);
        }
        if (jTable instanceof SortableTable) {
            ((SortableTable)jTable).setSortable(false);
        }
    }

    @Override
    protected void customizePanes(JComponent[] jComponentArray) {
        super.customizePanes(jComponentArray);
        TableUtils.synchronizeTableColumnWidthNow((JTable)this._fromComponent, (JTable)this._toComponent);
        TableUtils.synchronizeTableColumnWidth(new JTable[]{(JTable)this._fromComponent, (JTable)this._toComponent});
    }

    @Override
    protected MarkerSupport createMarkerSupport(JComponent jComponent) {
        return new TableRowMarkerSupport((JTable)jComponent);
    }

    @Override
    protected RowMarginSupport createRowMarginSupport(JComponent jComponent, JScrollPane jScrollPane) {
        return new TableRowMarginSupport((JTable)jComponent, jScrollPane);
    }

    @Override
    public JComponent createComponent(Object object, int n) {
        return new SortableTable((TableModel)object);
    }

    @Override
    protected void adjustDividerOffset(DiffDivider diffDivider, int n) {
        diffDivider.adjustFirstVerticalOffset(0, 2 + this._fromTitle.getPreferredSize().height + ((JTable)this._fromComponent).getTableHeader().getPreferredSize().height);
        diffDivider.adjustSecondVerticalOffset(0, 2 + this._toTitle.getPreferredSize().height + ((JTable)this._toComponent).getTableHeader().getPreferredSize().height);
        diffDivider.setFirstBottomMargin(this._fromScrollPane.getHorizontalScrollBar().isVisible() ? this._fromScrollPane.getHorizontalScrollBar().getPreferredSize().height : 0);
        diffDivider.setSecondBottomMargin(this._toScrollPane.getHorizontalScrollBar().isVisible() ? this._toScrollPane.getHorizontalScrollBar().getPreferredSize().height : 0);
    }

    @Override
    public Object[] getFromItems() {
        if (this._fromItems == null) {
            this._fromItems = this.createArrayFromTableModel(((JTable)this._fromComponent).getModel());
        }
        return this._fromItems;
    }

    @Override
    public Object[] getToItems() {
        if (this._toItems == null) {
            this._toItems = this.createArrayFromTableModel(((JTable)this._toComponent).getModel());
        }
        return this._toItems;
    }

    protected List<Object> getFromItems(int n, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = Math.min(n, n2); i <= Math.max(n, n2); ++i) {
            arrayList.addAll(this.getRowData(((JTable)this._fromComponent).getModel(), i));
        }
        return arrayList;
    }

    protected List<Object> getToItems(int n, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = Math.min(n, n2); i <= Math.max(n, n2); ++i) {
            arrayList.addAll(this.getRowData(((JTable)this._toComponent).getModel(), i));
        }
        return arrayList;
    }

    @Override
    protected int getSelectedIndex(int n) {
        JTable jTable = (JTable)(n == 0 ? this._fromComponent : this._toComponent);
        return jTable.getSelectedRow();
    }

    @Override
    protected Diff<?> createLinesDiff(int n, int n2, int n3, int n4) {
        Diff<Object> diff = new Diff<Object>(this.getFromItems(n, n2), this.getToItems(n3, n4));
        diff.setItemsConsistent(false);
        return diff;
    }

    @Override
    public void highlightChangedExactly(List<Difference> list, int n, int n2, int n3, int n4, Color color, Color color2, String string) {
        if (list != null && list.size() >= 1) {
            super.highlightChangedExactly(list, n, n2, n3, n4, color, color2, string);
            this._fromTableStyleProvider.addPositionHighlight(n - 1);
            this._fromTableStyleProvider.addPositionHighlight(n2);
            this._toTableStyleProvider.addPositionHighlight(n3 - 1);
            this._toTableStyleProvider.addPositionHighlight(n4);
            for (Difference difference : list) {
                int n5;
                int n6;
                int n7;
                for (n7 = difference.getDeletedStart(); n7 <= difference.getDeletedEnd(); ++n7) {
                    n6 = n + n7 / ((JTable)this._fromComponent).getColumnCount();
                    n5 = n7 % ((JTable)this._fromComponent).getColumnCount();
                    if (difference.getDeletedEnd() == -1) {
                        this._fromTableStyleProvider.addInsertedCellHighlight(n6, n5);
                        continue;
                    }
                    if (difference.getAddedEnd() == -1) {
                        this._fromTableStyleProvider.addDeletedCellHighlight(n6, n5);
                        continue;
                    }
                    this._fromTableStyleProvider.addChangedCellHighlight(n6, n5);
                }
                for (n7 = difference.getAddedStart(); n7 <= difference.getAddedEnd(); ++n7) {
                    n6 = n3 + n7 / ((JTable)this._toComponent).getColumnCount();
                    n5 = n7 % ((JTable)this._toComponent).getColumnCount();
                    if (difference.getAddedEnd() == -1) {
                        this._toTableStyleProvider.addDeletedCellHighlight(n6, n5);
                        continue;
                    }
                    if (difference.getDeletedEnd() == -1) {
                        this._toTableStyleProvider.addInsertedCellHighlight(n6, n5);
                        continue;
                    }
                    this._toTableStyleProvider.addChangedCellHighlight(n6, n5);
                }
            }
        } else {
            this.highlightChanged(n, n2, n3, n4, color, color2, string);
        }
    }

    @Override
    public void highlightChanged(int n, int n2, int n3, int n4, Color color, Color color2, String string) {
        super.highlightChanged(n, n2, n3, n4, color, color2, string);
        this._fromTableStyleProvider.addChangedHighlight(n, n2);
        this._toTableStyleProvider.addChangedHighlight(n3, n4);
    }

    @Override
    public void highlightInserted(int n, int n2, int n3, Color color, Color color2, String string) {
        super.highlightInserted(n, n2, n3, color, color2, string);
        if (n > 0) {
            this._fromTableStyleProvider.addPositionHighlight(n - 1);
        }
        this._toTableStyleProvider.addInsertedHighlight(n2, n3);
    }

    @Override
    public void highlightDeleted(int n, int n2, int n3, Color color, Color color2, String string) {
        super.highlightDeleted(n, n2, n3, color, color2, string);
        this._fromTableStyleProvider.addDeletedHighlight(n, n2);
        if (n3 > 0) {
            this._toTableStyleProvider.addPositionHighlight(n3 - 1);
        }
    }

    @Override
    public void clearHighlights() {
        super.clearHighlights();
        this._fromTableStyleProvider.clearAllHighlights();
        this._toTableStyleProvider.clearAllHighlights();
    }

    @Override
    public boolean delete(int n, int n2, boolean bl) {
        TableModel tableModel = ((JTable)this._toComponent).getModel();
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel);
        if (tableModel2 instanceof DefaultTableModel) {
            int n3;
            int[] nArray = new int[n2];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray[n3] = TableModelWrapperUtils.getActualRowAt(tableModel, n + n3);
            }
            Arrays.sort(nArray);
            for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                ((DefaultTableModel)tableModel2).removeRow(nArray[n3]);
            }
            if (bl && this._diffed) {
                this.runDiff();
            }
            return true;
        }
        if (tableModel2 instanceof IExpandableTreeTableModel) {
            for (int i = n2 - 1; i >= 0; --i) {
                ((IExpandableTreeTableModel)((Object)tableModel2)).removeRow(n + i);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean insert(int n, int n2, int n3, boolean bl) {
        TableModel tableModel = ((JTable)this._toComponent).getModel();
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel);
        if (tableModel2 instanceof DefaultTableModel) {
            int n4;
            Object[][] objectArrayArray = new Object[n3][];
            TableModel tableModel3 = ((JTable)this._fromComponent).getModel();
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = tableModel3.getColumnCount();
                Object[] objectArray = new Object[n5];
                for (int i = 0; i < n5; ++i) {
                    objectArray[i] = tableModel3.getValueAt(n4 + n2, i);
                }
                objectArrayArray[n4] = objectArray;
            }
            for (n4 = objectArrayArray.length - 1; n4 >= 0; --n4) {
                ((DefaultTableModel)tableModel2).insertRow(n, objectArrayArray[n4]);
            }
            if (bl && this._diffed) {
                this.runDiff();
            }
            return true;
        }
        if (tableModel2 instanceof IExpandableTreeTableModel) {
            Row row;
            TableModel tableModel4 = ((JTable)this._fromComponent).getModel();
            TableModel tableModel5 = TableModelWrapperUtils.getActualTableModel(tableModel4);
            if (!(tableModel5 instanceof IExpandableTreeTableModel)) {
                return false;
            }
            ArrayList<Row> arrayList = new ArrayList<Row>();
            Expandable expandable = null;
            for (int i = 0; i < n3; ++i) {
                row = ((IExpandableTreeTableModel)((Object)tableModel5)).getRowAt(n2 + i);
                arrayList.add(row);
                if (row == null) {
                    return false;
                }
                if (expandable == null) {
                    expandable = row.getParent();
                    continue;
                }
                if (row.getParent() == expandable) continue;
                return false;
            }
            Row row2 = ((IExpandableTreeTableModel)((Object)tableModel2)).getRowAt(n - 1);
            row = ((IExpandableTreeTableModel)((Object)tableModel2)).getRowAt(n);
            if (row2 == null || row == null || row2.getParent() != row.getParent()) {
                return false;
            }
            int n6 = row2.getParent().getChildIndex(row);
            ((IExpandableTreeTableModel)((Object)tableModel2)).addRows((Row)((Object)row2.getParent()), n6, arrayList);
        }
        return false;
    }

    @Override
    public void setChangedColor(Color color) {
        super.setChangedColor(color);
        if (this._fromTableStyleProvider != null) {
            this._fromTableStyleProvider.setChangedColor(color);
        }
        if (this._toTableStyleProvider != null) {
            this._toTableStyleProvider.setChangedColor(color);
        }
    }

    @Override
    public void setInsertedColor(Color color) {
        super.setInsertedColor(color);
        if (this._fromTableStyleProvider != null) {
            this._fromTableStyleProvider.setInsertedColor(color);
        }
        if (this._toTableStyleProvider != null) {
            this._toTableStyleProvider.setInsertedColor(color);
        }
    }

    @Override
    public void setDeletedColor(Color color) {
        super.setDeletedColor(color);
        if (this._fromTableStyleProvider != null) {
            this._fromTableStyleProvider.setDeletedColor(color);
        }
        if (this._toTableStyleProvider != null) {
            this._toTableStyleProvider.setDeletedColor(color);
        }
    }

    static /* synthetic */ Object[] access$002(TableDiffPane tableDiffPane, Object[] objectArray) {
        tableDiffPane._fromItems = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[] access$102(TableDiffPane tableDiffPane, Object[] objectArray) {
        tableDiffPane._toItems = objectArray;
        return objectArray;
    }
}

