/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.highlight.LayeredHighlighter;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;

class SeparatorHighlightPainter
extends LayeredHighlighter.LayerPainter {
    private Color _color;
    private int _highlightStartOffset = -1;
    private int _highlightEndOffset = -1;

    public SeparatorHighlightPainter(Color color) {
        this._color = color;
    }

    @Override
    public boolean isOccupyNextLine() {
        return true;
    }

    public void setHighlightStartOffset(int n) {
        this._highlightStartOffset = n;
    }

    public void setHighlightEndOffset(int n) {
        this._highlightEndOffset = n;
    }

    @Override
    public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, CodeEditor codeEditor) {
        CaretPosition caretPosition = codeEditor.offsetToViewPosition(n);
        CaretPosition caretPosition2 = codeEditor.offsetToViewPosition(n2);
        int n3 = caretPosition.line;
        if (n >= codeEditor.getDocumentLength() && caretPosition.column != 0) {
            ++n3;
        }
        int n4 = caretPosition2.line;
        if (n2 >= codeEditor.getDocumentLength() && caretPosition2.column != 0) {
            ++n4;
        }
        FontMetrics fontMetrics = codeEditor.getPainter().getFontMetrics();
        int n5 = fontMetrics.getLeading() + fontMetrics.getMaxDescent();
        int n6 = codeEditor.lineToY(n3);
        int n7 = codeEditor.lineToY(n4 != -1 ? n4 : n3 + 1);
        Color color = graphics.getColor();
        graphics.setColor(this._color);
        if (n == this._highlightStartOffset || this._highlightStartOffset < 0) {
            graphics.drawLine(0, n6 + n5, codeEditor.getPainter().getWidth(), n6 + n5);
        }
        if (n2 == this._highlightEndOffset || this._highlightEndOffset < 0) {
            graphics.drawLine(0, n7 + n5, codeEditor.getPainter().getWidth(), n7 + n5);
        }
        graphics.setColor(color);
        return shape;
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Shape shape, CodeEditor codeEditor) {
    }
}

