/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.DiffDivider;
import com.jidesoft.diff.Difference;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.highlight.LayeredHighlighter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;

class LineHighlightPainter
extends LayeredHighlighter.LayerPainter {
    private Color _color;
    private DiffDivider _divider;
    private Difference _difference;

    public LineHighlightPainter(Color color, DiffDivider diffDivider, Difference difference) {
        this._color = color;
        this._divider = diffDivider;
        this._difference = difference;
    }

    @Override
    public boolean isOccupyNextLine() {
        return false;
    }

    @Override
    public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, CodeEditor codeEditor) {
        CaretPosition caretPosition = codeEditor.offsetToViewPosition(n);
        CaretPosition caretPosition2 = codeEditor.offsetToViewPosition(n2);
        if (n >= codeEditor.getDocumentLength() && caretPosition.column != 0) {
            caretPosition = new CaretPosition(caretPosition.line + 1, 0);
        }
        if (n2 >= codeEditor.getDocumentLength() && caretPosition2.column != 0) {
            caretPosition2 = new CaretPosition(caretPosition2.line + 1, 0);
        }
        int n3 = caretPosition.line;
        int n4 = caretPosition2.line;
        FontMetrics fontMetrics = codeEditor.getPainter().getFontMetrics();
        int n5 = fontMetrics.getLeading() + fontMetrics.getMaxDescent();
        int n6 = codeEditor.lineToY(n3);
        int n7 = codeEditor.lineToY(n4 != -1 ? n4 : n3 + 1);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        if (this._divider != null && this._difference != null && this._divider.getSelectedDifference() == this._difference) {
            Color color = this._divider.getSelectedColor(this._color);
            graphics2D.setColor(color);
        } else {
            graphics2D.setColor(this._color);
        }
        if (n6 == n7) {
            int n8 = codeEditor.columnToX(n3, caretPosition.column);
            int n9 = codeEditor.columnToX(n3, caretPosition2.column);
            if (n9 == n8) {
                graphics2D.fillRect(n8, n6 + n5, 1, codeEditor.getLineHeight());
            } else {
                graphics2D.fillRect(n8, n6 + n5, n9 - n8, codeEditor.getLineHeight());
            }
        } else {
            graphics2D.fillRect(0, n6 + n5, codeEditor.getPainter().getWidth(), n7 - n6);
        }
        graphics2D.dispose();
        return shape;
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Shape shape, CodeEditor codeEditor) {
    }
}

