/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.BasicDiffPane;
import com.jidesoft.diff.TableDiffPane;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.GridColorProvider;
import com.jidesoft.grid.TableStyleProvider;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;

public class DiffTableStyleProvider
implements TableStyleProvider,
GridColorProvider {
    private Color _insertedColor;
    private Color _changedColor;
    private Color _deletedColor;
    private Color _conflictedColor;
    private BasicDiffPane _diffPane;
    private int _locationIndex;
    protected final CellStyle CELL_STYLE = new CellStyle();
    private Map<Integer, Integer> _rows = new HashMap<Integer, Integer>();
    private Map<Integer, Map<Integer, Integer>> _cells = new HashMap<Integer, Map<Integer, Integer>>();
    private Set<Integer> _gridLines = new HashSet<Integer>();

    public DiffTableStyleProvider() {
        this._diffPane = null;
    }

    public DiffTableStyleProvider(TableDiffPane tableDiffPane, int n) {
        this._diffPane = tableDiffPane;
        this._locationIndex = n;
    }

    public Color getInsertedColor() {
        if (this._insertedColor == null) {
            this._insertedColor = UIDefaultsLookup.getColor("DiffMerge.inserted");
        }
        return this._insertedColor;
    }

    public void setInsertedColor(Color color) {
        this._insertedColor = color;
    }

    public Color getChangedColor() {
        if (this._changedColor == null) {
            this._changedColor = UIDefaultsLookup.getColor("DiffMerge.changed");
        }
        return this._changedColor;
    }

    public void setChangedColor(Color color) {
        this._changedColor = color;
    }

    public Color getDeletedColor() {
        if (this._deletedColor == null) {
            this._deletedColor = UIDefaultsLookup.getColor("DiffMerge.deleted");
        }
        return this._deletedColor;
    }

    public void setDeletedColor(Color color) {
        this._deletedColor = color;
    }

    public Color getConflictedColor() {
        if (this._conflictedColor == null) {
            this._conflictedColor = UIDefaultsLookup.getColor("DiffMerge.conflicted");
        }
        return this._conflictedColor;
    }

    public void setConflictedColor(Color color) {
        this._conflictedColor = color;
    }

    @Override
    public CellStyle getCellStyleAt(JTable jTable, int n, int n2) {
        int n3 = this.getCellStyle(n, n2);
        boolean bl = false;
        switch (n3) {
            case 124: {
                this.CELL_STYLE.setBackground(this.getChangedColor());
                bl = true;
                break;
            }
            case 126: {
                this.CELL_STYLE.setBackground(this.getDeletedColor());
                bl = true;
                break;
            }
            case 125: {
                this.CELL_STYLE.setBackground(this.getInsertedColor());
                bl = true;
                break;
            }
            case 127: {
                this.CELL_STYLE.setBackground(this.getConflictedColor());
                bl = true;
                break;
            }
            default: {
                this.CELL_STYLE.setBackground(null);
            }
        }
        if (bl) {
            Object object;
            boolean bl2 = false;
            if (this._diffPane != null && (object = this._diffPane.getMatchingDifference(this._locationIndex, n, true)) != null && object == this._diffPane._fromToDivider.getSelectedDifference()) {
                bl2 = true;
            }
            if (bl2) {
                object = this.CELL_STYLE.getBackground();
                object = this._diffPane._fromToDivider.getSelectedColor((Color)object);
                this.CELL_STYLE.setBackground((Color)object);
            }
        }
        return bl ? this.CELL_STYLE : null;
    }

    protected int getCellStyle(int n, int n2) {
        if (this._rows.containsKey(n)) {
            return this._rows.get(n);
        }
        Map<Integer, Integer> map = this._cells.get(n);
        if (map == null) {
            return -1;
        }
        return map.containsKey(n2) ? map.get(n2) : -1;
    }

    @Override
    public Color getGridColor(int n) {
        return this._gridLines.contains(n) ? Color.GRAY : null;
    }

    @Override
    public Color getVerticalGridColor(int n) {
        return null;
    }

    public void clearAllHighlights() {
        this._rows.clear();
        this._cells.clear();
        this._gridLines.clear();
    }

    public void addChangedCellHighlight(int n, int n2) {
        Map<Integer, Integer> map = this._cells.get(n);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            this._cells.put(n, map);
        }
        map.put(n2, 124);
    }

    public void addDeletedCellHighlight(int n, int n2) {
        Map<Integer, Integer> map = this._cells.get(n);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            this._cells.put(n, map);
        }
        map.put(n2, 126);
    }

    public void addInsertedCellHighlight(int n, int n2) {
        Map<Integer, Integer> map = this._cells.get(n);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            this._cells.put(n, map);
        }
        map.put(n2, 125);
    }

    public void addConflictedCellHighlight(int n, int n2) {
        Map<Integer, Integer> map = this._cells.get(n);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            this._cells.put(n, map);
        }
        map.put(n2, 127);
    }

    public void addChangedHighlight(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this._rows.put(i, 124);
        }
        if (n > 1) {
            this._gridLines.add(n - 1);
        }
        this._gridLines.add(n2);
    }

    public void addDeletedHighlight(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this._rows.put(i, 126);
        }
        if (n > 1) {
            this._gridLines.add(n - 1);
        }
        this._gridLines.add(n2);
    }

    public void addInsertedHighlight(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this._rows.put(i, 125);
        }
        if (n > 1) {
            this._gridLines.add(n - 1);
        }
        this._gridLines.add(n2);
    }

    public void addConflictHighlight(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this._rows.put(i, 127);
        }
        if (n > 1) {
            this._gridLines.add(n - 1);
        }
        this._gridLines.add(n2);
    }

    public void addPositionHighlight(int n) {
        this._gridLines.add(n);
    }
}

