/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.Conflict;
import com.jidesoft.diff.Difference;
import com.jidesoft.diff.TableDiffPane;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JPanel;

public class DiffDivider
extends JPanel {
    private RowConverter _firstConverter;
    private RowConverter _secondConverter;
    private List<Difference> _differences;
    private Difference _selectedDifference;
    private int _firstOffsetY;
    private int _secondOffsetY;
    private int _firstTopMargin;
    private int _secondTopMargin;
    private int _firstBottomMargin;
    private int _secondBottomMargin;
    private Color _insertedColor;
    private Color _changedColor;
    private Color _deletedColor;
    private Color _conflictedColor;
    private boolean _opposite;
    public static final String PROPERTY_SELECTED_DIFFERENCE = "selectedDifference";

    public DiffDivider() {
    }

    public DiffDivider(RowConverter rowConverter, RowConverter rowConverter2) {
        this._firstConverter = rowConverter;
        this._secondConverter = rowConverter2;
    }

    public DiffDivider(RowConverter rowConverter, RowConverter rowConverter2, List<Difference> list) {
        this(rowConverter, rowConverter2);
        this.setDifferences(list);
    }

    public RowConverter getFirstConverter() {
        return this._firstConverter;
    }

    public void setFirstConverter(RowConverter rowConverter) {
        this._firstConverter = rowConverter;
    }

    public RowConverter getSecondConverter() {
        return this._secondConverter;
    }

    public void setSecondConverter(RowConverter rowConverter) {
        this._secondConverter = rowConverter;
    }

    public Color getInsertedColor() {
        if (this._insertedColor == null) {
            this._insertedColor = UIDefaultsLookup.getColor("DiffMerge.inserted");
        }
        return this._insertedColor;
    }

    public void setInsertedColor(Color color) {
        this._insertedColor = color;
        this.repaint();
    }

    public Color getChangedColor() {
        if (this._changedColor == null) {
            this._changedColor = UIDefaultsLookup.getColor("DiffMerge.changed");
        }
        return this._changedColor;
    }

    public void setChangedColor(Color color) {
        this._changedColor = color;
        this.repaint();
    }

    public Color getDeletedColor() {
        if (this._deletedColor == null) {
            this._deletedColor = UIDefaultsLookup.getColor("DiffMerge.deleted");
        }
        return this._deletedColor;
    }

    public void setDeletedColor(Color color) {
        this._deletedColor = color;
        this.repaint();
    }

    public Color getConflictedColor() {
        if (this._conflictedColor == null) {
            this._conflictedColor = UIDefaultsLookup.getColor("DiffMerge.conflicted");
        }
        return this._conflictedColor;
    }

    public void setConflictedColor(Color color) {
        this._conflictedColor = color;
        this.repaint();
    }

    public List<Difference> getDifferences() {
        return this._differences;
    }

    public void setDifferences(List<Difference> list) {
        this._differences = list;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(30, 30);
    }

    public int getFirstOffsetY() {
        return this._firstOffsetY;
    }

    public void setFirstOffsetY(int n) {
        this._firstOffsetY = n;
    }

    public int getSecondOffsetY() {
        return this._secondOffsetY;
    }

    public void setSecondOffsetY(int n) {
        this._secondOffsetY = n;
    }

    public int getFirstTopMargin() {
        return this._firstTopMargin;
    }

    public void setFirstTopMargin(int n) {
        this._firstTopMargin = n;
    }

    public int getSecondTopMargin() {
        return this._secondTopMargin;
    }

    public void setSecondTopMargin(int n) {
        this._secondTopMargin = n;
    }

    public int getFirstBottomMargin() {
        return this._firstBottomMargin;
    }

    public void setFirstBottomMargin(int n) {
        this._firstBottomMargin = n;
    }

    public int getSecondBottomMargin() {
        return this._secondBottomMargin;
    }

    public void setSecondBottomMargin(int n) {
        this._secondBottomMargin = n;
    }

    public boolean isOpposite() {
        return this._opposite;
    }

    public void setOpposite(boolean bl) {
        this._opposite = bl;
    }

    public void setSelectedDifference(Difference difference) {
        if (this._selectedDifference != difference) {
            Difference difference2 = this._selectedDifference;
            this._selectedDifference = difference;
            this.firePropertyChange(PROPERTY_SELECTED_DIFFERENCE, difference2, this._selectedDifference);
            this.repaint();
        }
    }

    public Difference getSelectedDifference() {
        return this._selectedDifference;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this._differences != null) {
            Rectangle rectangle = graphics.getClipBounds();
            int n = rectangle.y;
            int n2 = rectangle.y + rectangle.height;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            JideSwingUtilities.setupShapeAntialiasing(graphics2D);
            JideSwingUtilities.setupAntialiasing(this, graphics2D);
            int n3 = this.getFirstOffsetY();
            int n4 = this.getSecondOffsetY();
            int n5 = this.getWidth();
            int n6 = this.getHeight();
            Polygon polygon = new Polygon(new int[]{0, n5, n5, 0}, new int[]{this.getFirstTopMargin(), this.getSecondTopMargin(), n6 - this.getFirstBottomMargin(), n6 - this.getSecondBottomMargin()}, 4);
            graphics2D.setClip(polygon);
            int n7 = 0;
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof TableDiffPane)) continue;
                n7 = 0;
                break;
            }
            for (Difference difference : this._differences) {
                Color color;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12 = this.isOpposite() ? difference.getDeletedStart() : difference.getAddedStart();
                int n13 = this.isOpposite() ? difference.getDeletedEnd() : difference.getAddedEnd();
                int n14 = this.isOpposite() ? difference.getAddedStart() : difference.getDeletedStart();
                int n15 = this.isOpposite() ? difference.getAddedEnd() : difference.getDeletedEnd();
                boolean bl = false;
                boolean bl2 = false;
                if (n15 == -1) {
                    bl = true;
                } else if (n13 == -1) {
                    bl2 = true;
                }
                if (bl) {
                    n10 = n11 = this._firstConverter.indexToY(n14) + n3 + n7;
                    n9 = this._secondConverter.indexToY(n12) + n4 + n7;
                    n8 = this._secondConverter.indexToY(n13 + 1) + n4 + n7;
                } else if (bl2) {
                    n11 = this._firstConverter.indexToY(n14) + n3 + n7;
                    n10 = this._firstConverter.indexToY(n15 + 1) + n3 + n7;
                    n8 = n9 = this._secondConverter.indexToY(n12) + n4 + n7;
                } else {
                    n11 = this._firstConverter.indexToY(n14) + n3 + n7;
                    n10 = this._firstConverter.indexToY(n15 + 1) + n3 + n7;
                    n9 = this._secondConverter.indexToY(n12) + n4 + n7;
                    n8 = this._secondConverter.indexToY(n13 + 1) + n4 + n7;
                }
                if (n > n11 && n > n9 && n > n8 && n > n10) continue;
                if (n2 <= n11 && n2 <= n9 && n2 <= n8 && n2 <= n10) break;
                Polygon polygon2 = new Polygon(new int[]{0, n5, n5, 0}, new int[]{n11, n9, n8, n10}, 4);
                Color color2 = difference.isConflicting() ? this.getConflictedColor() : (bl ? this.getInsertedColor() : (color = bl2 ? this.getDeletedColor() : this.getChangedColor()));
                if (this._selectedDifference != null) {
                    if (this._selectedDifference == difference) {
                        color = this.getSelectedColor(color);
                    } else if (!this._opposite && this._selectedDifference.getAddedStart() == difference.getAddedStart() && this._selectedDifference.getAddedEnd() == difference.getAddedEnd() && this._selectedDifference.getDeletedStart() == difference.getDeletedStart() && this._selectedDifference.getDeletedEnd() == difference.getDeletedEnd()) {
                        color = this.getSelectedColor(color);
                    } else if (this._opposite && this._selectedDifference instanceof Conflict && this._selectedDifference.getAddedStart() == difference.getAddedStart() && this._selectedDifference.getAddedEnd() == difference.getAddedEnd() && ((Conflict)this._selectedDifference).getDeleted2Start() == difference.getDeletedStart() && ((Conflict)this._selectedDifference).getDeleted2End() == difference.getDeletedEnd()) {
                        color = this.getSelectedColor(color);
                    }
                }
                graphics2D.setColor(color);
                graphics2D.fillPolygon(polygon2);
                graphics2D.setColor(Color.GRAY);
                graphics2D.drawLine(0, n11, n5, n9);
                graphics2D.drawLine(0, n10, n5, n8);
            }
            graphics2D.dispose();
        }
    }

    protected Color getSelectedColor(Color color) {
        return color.darker();
    }

    private int numberLines(int n, int n2) {
        return n2 == -1 ? 0 : n2 - n + 1;
    }

    protected int getSecondMatchLine(int n, int n2) {
        int n3;
        int n4 = n3 = n2 + n / 4;
        if (this._differences != null) {
            for (Difference difference : this._differences) {
                if (n3 < difference.getDeletedStart()) break;
                if ((n4 -= this.numberLines(difference.getDeletedStart(), difference.getDeletedEnd()) - this.numberLines(difference.getAddedStart(), difference.getAddedEnd())) > 0) continue;
                return difference.getAddedStart();
            }
            return Math.max(0, n4 - n / 4);
        }
        return n2;
    }

    protected int getFirstMatchLine(int n, int n2) {
        int n3;
        int n4 = n3 = n2 + n / 4;
        if (this._differences != null) {
            for (Difference difference : this._differences) {
                if (n3 < difference.getAddedStart()) break;
                if ((n4 -= this.numberLines(difference.getAddedStart(), difference.getAddedEnd()) - this.numberLines(difference.getDeletedStart(), difference.getDeletedEnd())) > 0) continue;
                return difference.getDeletedStart();
            }
            return Math.max(0, n4 - n / 4);
        }
        return n2;
    }

    protected void adjustFirstVerticalOffset(int n, int n2) {
        this.setFirstOffsetY(n2 + n);
        this.setFirstTopMargin(n2);
    }

    protected void adjustSecondVerticalOffset(int n, int n2) {
        this.setSecondOffsetY(n2 + n);
        this.setSecondTopMargin(n2);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(16384)) {
            Lm.showInvalidProductMessage(DiffDivider.class.getName(), 16384);
        }
    }

    public static interface RowConverter {
        public int indexToY(int var1);
    }
}

