/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.AbstractDiffPane;
import com.jidesoft.diff.CodeEditorDiffMarkerArea;
import com.jidesoft.diff.Diff;
import com.jidesoft.diff.DiffDivider;
import com.jidesoft.diff.DiffMargin;
import com.jidesoft.diff.DiffMarkerArea;
import com.jidesoft.diff.DiffRowNumberMargin;
import com.jidesoft.diff.Difference;
import com.jidesoft.diff.DifferenceList;
import com.jidesoft.margin.AbstractMargin;
import com.jidesoft.margin.MarginArea;
import com.jidesoft.margin.RowMarginSupport;
import com.jidesoft.marker.MarkerArea;
import com.jidesoft.marker.MarkerSupport;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public abstract class BasicDiffPane<T>
extends AbstractDiffPane {
    protected final int GAP_TITLE_PANE = 2;
    protected JComponent _fromComponent;
    protected JComponent _toComponent;
    protected JScrollPane _fromScrollPane;
    protected JScrollPane _toScrollPane;
    protected DiffDivider _fromToDivider;
    protected AbstractMargin _fromDiffMargin;
    protected AbstractMargin _toDiffMargin;
    protected JComponent _fromTitle;
    protected JComponent _toTitle;
    protected MarginArea _fromMarginArea;
    protected MarginArea _toMarginArea;
    protected AbstractMargin _fromDiffLineNumberMargin;
    protected AbstractMargin _toDiffLineNumberMargin;
    protected MarkerArea _fromMarkerArea;
    protected MarkerArea _toMarkerArea;
    protected RowMarginSupport _fromRowMarginSupport;
    protected RowMarginSupport _toRowMarginSupport;
    protected List<Difference> _differences;
    private boolean _highlightExactChange = false;
    private boolean _readOnly = false;
    private boolean _selectOnNavigation = true;
    protected static final int POSITION_BEFORE_FIRST = 0;
    protected static final int POSITION_ON_FIRST = 1;
    protected static final int POSITION_IN_THE_MIDDLE = 2;
    protected static final int POSITION_ON_LAST = 3;
    protected static final int POSITION_AFTER_LAST = 4;
    protected static final int POSITION_ON_FIRST_AND_LAST = 5;
    private boolean _ignoreFromScrollEvent = false;
    private boolean _ignoreToScrollEvent = false;
    private AdjustmentListener _fromHorizontalAdjustmentListener;
    private AdjustmentListener _fromVerticalAdjustmentListener;
    private AdjustmentListener _toHorizontalAdjustmentListener;
    private AdjustmentListener _toVerticalAdjustmentListener;
    protected boolean _diffed = false;

    public BasicDiffPane() {
        super("", "");
    }

    public BasicDiffPane(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public void flip() {
        String string = this.getFromTitle();
        String string2 = this.getToTitle();
        this.superFlip();
        if (this._diffed) {
            List<Difference> list = this.getDifferences();
            ArrayList arrayList = list instanceof DifferenceList ? new DifferenceList() : new ArrayList();
            if (list != null) {
                for (Difference difference : list) {
                    List<Difference> list2;
                    if (difference == null) continue;
                    Difference difference2 = new Difference(difference.getAddedStart(), difference.getAddedEnd(), difference.getDeletedStart(), difference.getDeletedEnd());
                    arrayList.add(difference2);
                    if (!(list instanceof DifferenceList) || !(arrayList instanceof DifferenceList) || (list2 = ((DifferenceList)list).getLinesDiff(difference)) == null) continue;
                    ArrayList<Difference> arrayList2 = new ArrayList<Difference>();
                    for (Difference difference3 : list2) {
                        if (difference3 == null) continue;
                        arrayList2.add(new Difference(difference3.getAddedStart(), difference3.getAddedEnd(), difference3.getDeletedStart(), difference3.getDeletedEnd()));
                    }
                    ((DifferenceList)arrayList).addLinesDiff(difference2, arrayList2);
                }
                this.differencesUpdated(arrayList);
            }
        }
        this.setFromTitle(string2);
        this.setToTitle(string);
        JideSwingUtilities.invalidateRecursively(this);
    }

    void superFlip() {
        super.flip();
    }

    protected AbstractMargin createDiffMargin(RowMarginSupport rowMarginSupport, boolean bl) {
        DiffMargin diffMargin = new DiffMargin(rowMarginSupport, bl);
        diffMargin.setEditable(!this.isReadOnly());
        return diffMargin;
    }

    @Override
    public JComponent createPane(Object object, int n) {
        if (n == 0) {
            this._fromComponent = this.createComponent(object, n);
            this._fromScrollPane = new JScrollPane(this._fromComponent);
            this._fromRowMarginSupport = this.createRowMarginSupport(this._fromComponent, this._fromScrollPane);
            this._fromDiffMargin = this.createDiffMargin(this._fromRowMarginSupport, true);
            this._fromDiffLineNumberMargin = new DiffRowNumberMargin(this._fromRowMarginSupport);
            this._fromMarkerArea = new DiffMarkerArea(this.createMarkerSupport(this._fromComponent));
            ((DiffMarkerArea)this._fromMarkerArea).setChangedColor(this.getChangedColor());
            ((DiffMarkerArea)this._fromMarkerArea).setInsertedColor(this.getInsertedColor());
            ((DiffMarkerArea)this._fromMarkerArea).setDeletedColor(this.getDeletedColor());
            this._fromMarginArea = new MarginArea();
            this._fromMarginArea.addMarginComponent(this._fromDiffLineNumberMargin);
            this._fromMarginArea.addMarginComponent(this._fromDiffMargin);
            this.customizePane(this._fromComponent, 0);
            JPanel jPanel = new JPanel(new BorderLayout(1, 1));
            jPanel.add((Component)this._fromMarkerArea, "Before");
            jPanel.add(this._fromScrollPane);
            jPanel.add((Component)this._fromMarginArea, "After");
            JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
            jPanel2.add(jPanel);
            this._fromTitle = this.createFromTitle();
            jPanel2.add((Component)this._fromTitle, "First");
            return jPanel2;
        }
        this._toComponent = this.createComponent(object, n);
        this._toScrollPane = new JScrollPane(this._toComponent);
        this._toRowMarginSupport = this.createRowMarginSupport(this._toComponent, this._toScrollPane);
        this._toDiffMargin = this.createDiffMargin(this._toRowMarginSupport, false);
        this._toDiffLineNumberMargin = new DiffRowNumberMargin(this._toRowMarginSupport);
        this._toMarkerArea = new DiffMarkerArea(this.createMarkerSupport(this._toComponent));
        ((DiffMarkerArea)this._toMarkerArea).setChangedColor(this.getChangedColor());
        ((DiffMarkerArea)this._toMarkerArea).setInsertedColor(this.getInsertedColor());
        ((DiffMarkerArea)this._toMarkerArea).setDeletedColor(this.getDeletedColor());
        this._toMarginArea = new MarginArea();
        this._toMarginArea.removeAll();
        this._toMarginArea.addMarginComponent(this._toDiffLineNumberMargin);
        this._toMarginArea.addMarginComponent(this._toDiffMargin);
        this.customizePane(this._toComponent, 1);
        JPanel jPanel = new JPanel(new BorderLayout(1, 1));
        jPanel.add((Component)this._toMarginArea, "Before");
        jPanel.add(this._toScrollPane);
        jPanel.add((Component)this._toMarkerArea, "After");
        JPanel jPanel3 = new JPanel(new BorderLayout(2, 2));
        jPanel3.add(jPanel);
        this._toTitle = this.createToTitle();
        jPanel3.add((Component)this._toTitle, "First");
        return jPanel3;
    }

    protected abstract MarkerSupport createMarkerSupport(JComponent var1);

    protected abstract RowMarginSupport createRowMarginSupport(JComponent var1, JScrollPane var2);

    @Override
    public DiffDivider createDivider(int n) {
        return new DiffDivider();
    }

    @Override
    protected void customizeDivider(DiffDivider diffDivider, int n) {
        this._fromToDivider = diffDivider;
        this._fromToDivider.setChangedColor(this.getChangedColor());
        this._fromToDivider.setInsertedColor(this.getInsertedColor());
        this._fromToDivider.setDeletedColor(this.getDeletedColor());
        this._fromToDivider.setFirstConverter(this.createFromRowConverter());
        this._fromToDivider.setSecondConverter(this.createToRowConverter());
        this._fromToDivider.addPropertyChangeListener("selectedDifference", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (BasicDiffPane.this._fromComponent != null) {
                    BasicDiffPane.this._fromComponent.repaint();
                }
                if (BasicDiffPane.this._toComponent != null) {
                    BasicDiffPane.this._toComponent.repaint();
                }
            }
        });
    }

    @Override
    public void setChangedColor(Color color) {
        super.setChangedColor(color);
        if (this._fromToDivider != null) {
            this._fromToDivider.setChangedColor(this.getChangedColor());
        }
        if (this._fromMarkerArea instanceof DiffMarkerArea) {
            ((DiffMarkerArea)this._fromMarkerArea).setChangedColor(this.getChangedColor());
        } else if (this._fromMarkerArea instanceof CodeEditorDiffMarkerArea) {
            ((CodeEditorDiffMarkerArea)this._fromMarkerArea).setChangedColor(this.getChangedColor());
        }
        if (this._toMarkerArea instanceof DiffMarkerArea) {
            ((DiffMarkerArea)this._toMarkerArea).setChangedColor(this.getChangedColor());
        } else if (this._toMarkerArea instanceof CodeEditorDiffMarkerArea) {
            ((CodeEditorDiffMarkerArea)this._toMarkerArea).setChangedColor(this.getChangedColor());
        }
    }

    @Override
    public void setInsertedColor(Color color) {
        super.setInsertedColor(color);
        if (this._fromToDivider != null) {
            this._fromToDivider.setInsertedColor(this.getInsertedColor());
        }
        if (this._fromMarkerArea instanceof DiffMarkerArea) {
            ((DiffMarkerArea)this._fromMarkerArea).setInsertedColor(this.getInsertedColor());
        } else if (this._fromMarkerArea instanceof CodeEditorDiffMarkerArea) {
            ((CodeEditorDiffMarkerArea)this._fromMarkerArea).setInsertedColor(this.getInsertedColor());
        }
        if (this._toMarkerArea instanceof DiffMarkerArea) {
            ((DiffMarkerArea)this._toMarkerArea).setInsertedColor(this.getInsertedColor());
        } else if (this._toMarkerArea instanceof CodeEditorDiffMarkerArea) {
            ((CodeEditorDiffMarkerArea)this._toMarkerArea).setInsertedColor(this.getInsertedColor());
        }
    }

    @Override
    public void setDeletedColor(Color color) {
        super.setDeletedColor(color);
        if (this._fromToDivider != null) {
            this._fromToDivider.setDeletedColor(this.getDeletedColor());
        }
        if (this._fromMarkerArea instanceof DiffMarkerArea) {
            ((DiffMarkerArea)this._fromMarkerArea).setDeletedColor(this.getDeletedColor());
        } else if (this._fromMarkerArea instanceof CodeEditorDiffMarkerArea) {
            ((CodeEditorDiffMarkerArea)this._fromMarkerArea).setDeletedColor(this.getDeletedColor());
        }
        if (this._toMarkerArea instanceof DiffMarkerArea) {
            ((DiffMarkerArea)this._toMarkerArea).setDeletedColor(this.getDeletedColor());
        } else if (this._toMarkerArea instanceof CodeEditorDiffMarkerArea) {
            ((CodeEditorDiffMarkerArea)this._toMarkerArea).setDeletedColor(this.getDeletedColor());
        }
    }

    @Override
    protected void adjustDividerOffset(DiffDivider diffDivider, int n) {
        super.adjustDividerOffset(diffDivider, n);
        diffDivider.adjustSecondVerticalOffset(-1, 2 + this._toTitle.getPreferredSize().height);
        diffDivider.adjustFirstVerticalOffset(-1, 2 + this._fromTitle.getPreferredSize().height);
    }

    protected JComponent createFromTitle() {
        return new JLabel();
    }

    protected JComponent createToTitle() {
        return new JLabel();
    }

    public String getFromTitle() {
        if (this._fromTitle instanceof JLabel) {
            return ((JLabel)this._fromTitle).getText();
        }
        return null;
    }

    public void setFromTitle(String string) {
        String string2;
        if (this._fromTitle instanceof JLabel && !JideSwingUtilities.equals(string2 = this.getFromTitle(), string)) {
            ((JLabel)this._fromTitle).setText(string);
            this.adjustDividerOffset(this._fromToDivider, 0);
        }
    }

    public String getToTitle() {
        if (this._toTitle instanceof JLabel) {
            return ((JLabel)this._toTitle).getText();
        }
        return null;
    }

    public void setToTitle(String string) {
        String string2;
        if (this._toTitle instanceof JLabel && !JideSwingUtilities.equals(string2 = this.getToTitle(), string)) {
            ((JLabel)this._toTitle).setText(string);
            this.adjustDividerOffset(this._fromToDivider, 0);
        }
    }

    public abstract JComponent createComponent(Object var1, int var2);

    protected DiffDivider.RowConverter createFromRowConverter() {
        return new DiffDivider.RowConverter(){

            @Override
            public int indexToY(int n) {
                return BasicDiffPane.this._fromRowMarginSupport.rowToPosition(n);
            }
        };
    }

    public abstract T[] getFromItems();

    public abstract T[] getToItems();

    public JComponent getFromComponent() {
        return this._fromComponent;
    }

    public JComponent getToComponent() {
        return this._toComponent;
    }

    protected DiffDivider.RowConverter createToRowConverter() {
        return new DiffDivider.RowConverter(){

            @Override
            public int indexToY(int n) {
                return BasicDiffPane.this._toRowMarginSupport.rowToPosition(n);
            }
        };
    }

    protected void synchronizeViewport(DiffDivider diffDivider, boolean bl, boolean bl2) {
        RowMarginSupport rowMarginSupport = (RowMarginSupport)this._fromDiffLineNumberMargin.getMarginSupport();
        RowMarginSupport rowMarginSupport2 = (RowMarginSupport)this._toDiffLineNumberMargin.getMarginSupport();
        JViewport jViewport = this._toScrollPane.getViewport();
        JViewport jViewport2 = this._fromScrollPane.getViewport();
        if (bl2) {
            if (bl) {
                Point point = jViewport2.getViewPosition();
                if (diffDivider.getDifferences() != null) {
                    int n = rowMarginSupport.positionToRow(0);
                    int n2 = rowMarginSupport.positionToRow(jViewport2.getViewSize().height) / rowMarginSupport.getRowHeight(0);
                    int n3 = diffDivider.getSecondMatchLine(n2, n);
                    point.y = jViewport.getViewPosition().y + rowMarginSupport2.rowToPosition(n3) - rowMarginSupport.rowToPosition(n);
                }
                point.y = Math.max(0, Math.min(point.y, (int)(jViewport.getView().getSize().getHeight() - jViewport.getSize().getHeight())));
                jViewport.setViewPosition(point);
            } else {
                Point point = jViewport.getViewPosition();
                if (diffDivider.getDifferences() != null) {
                    int n = rowMarginSupport2.positionToRow(0);
                    int n4 = rowMarginSupport2.positionToRow(jViewport.getViewSize().height) / rowMarginSupport.getRowHeight(0);
                    int n5 = diffDivider.getFirstMatchLine(n4, n);
                    point.y = jViewport2.getViewPosition().y + rowMarginSupport.rowToPosition(n5) - rowMarginSupport2.rowToPosition(n);
                }
                point.y = Math.max(0, Math.min(point.y, (int)(jViewport2.getView().getSize().getHeight() - jViewport2.getSize().getHeight())));
                jViewport2.setViewPosition(point);
            }
        } else if (bl) {
            Point point = jViewport2.getViewPosition();
            point.y = jViewport.getViewPosition().y;
            jViewport.setViewPosition(point);
        } else {
            Point point = jViewport.getViewPosition();
            point.y = jViewport2.getViewPosition().y;
            jViewport2.setViewPosition(point);
        }
    }

    Difference getMatchingDifference(int n, int n2) {
        return this.getMatchingDifference(n, n2, false);
    }

    Difference getMatchingDifference(int n, int n2, boolean bl) {
        if (this._differences != null && this._differences.size() > 0 && n2 >= 0) {
            int n3;
            Difference difference = this._differences.get(0);
            Difference difference2 = this._differences.get(this._differences.size() - 1);
            int n4 = n == 0 ? difference.getDeletedStart() : difference.getAddedStart();
            int n5 = n == 0 ? difference2.getDeletedStart() : difference2.getAddedStart();
            int n6 = n3 = n == 0 ? difference2.getDeletedEnd() : difference2.getAddedEnd();
            if (n2 >= n4 && (n2 <= n5 || n3 >= 0 && n2 <= n3)) {
                int n7 = 0;
                int n8 = this._differences.size();
                int n9 = n8 / 2;
                while (n7 < n8) {
                    int n10;
                    Difference difference3 = this._differences.get(n9);
                    int n11 = n == 0 ? difference3.getDeletedStart() : difference3.getAddedStart();
                    int n12 = n10 = n == 0 ? difference3.getDeletedEnd() : difference3.getAddedEnd();
                    if (n2 == n11 || n10 >= 0 && n2 >= n11 && n2 <= n10) {
                        Difference difference42;
                        int n13;
                        if (!bl) {
                            return difference3;
                        }
                        if (n == 0 && difference3.getDeletedEnd() >= 0 || n != 0 && difference3.getAddedEnd() >= 0) {
                            return difference3;
                        }
                        ArrayList<Difference> arrayList = new ArrayList<Difference>();
                        for (n13 = n9 + 1; n13 < this._differences.size() && (difference42 = this._differences.get(n13)) != null && n11 == (n == 0 ? difference42.getDeletedStart() : difference42.getAddedStart()); ++n13) {
                            arrayList.add(difference42);
                        }
                        for (n13 = n9 - 1; n13 >= 0 && (difference42 = this._differences.get(n13)) != null && n11 == (n == 0 ? difference42.getDeletedStart() : difference42.getAddedStart()); --n13) {
                            arrayList.add(difference42);
                        }
                        if (arrayList.size() > 0) {
                            for (Difference difference42 : arrayList) {
                                if ((n != 0 || difference42.getDeletedEnd() < 0) && (n == 0 || difference42.getAddedEnd() < 0)) continue;
                                return difference42;
                            }
                        }
                        return difference3;
                    }
                    if (n2 > n11) {
                        n7 = n9 + 1;
                    } else {
                        n8 = n9;
                    }
                    n9 = n7 + (n8 - n7) / 2;
                }
            }
        }
        return null;
    }

    void updateSelectedDifference(int n) {
        int n2 = this.getSelectedIndex(n);
        this._fromToDivider.setSelectedDifference(this.getMatchingDifference(n, n2));
        this.updateActions(n);
    }

    @Override
    protected void updateActions(int n) {
        if (this._differences == null || this._differences.size() == 0) {
            ((Action)this._actions.get("first")).setEnabled(false);
            ((Action)this._actions.get("next")).setEnabled(false);
            ((Action)this._actions.get("previous")).setEnabled(false);
            ((Action)this._actions.get("last")).setEnabled(false);
        } else if (n == -1) {
            ((Action)this._actions.get("first")).setEnabled(true);
            ((Action)this._actions.get("next")).setEnabled(true);
            ((Action)this._actions.get("previous")).setEnabled(true);
            ((Action)this._actions.get("last")).setEnabled(true);
        } else {
            int n2;
            Difference difference = this._fromToDivider.getSelectedDifference();
            int n3 = this._differences.indexOf(difference);
            if (n3 < 0) {
                Difference difference2 = this._differences.get(0);
                Difference difference3 = this._differences.get(this._differences.size() - 1);
                int n4 = n == 0 ? difference2.getDeletedStart() : difference2.getAddedStart();
                int n5 = n == 0 ? difference3.getDeletedStart() : difference3.getAddedStart();
                n2 = this.getCaretPosition(n, n4, n5);
            } else {
                n2 = n3 == 0 ? (this._differences.size() > 1 ? 1 : 5) : (n3 == this._differences.size() - 1 ? 3 : 2);
            }
            if (n2 == 0) {
                ((Action)this._actions.get("first")).setEnabled(false);
                ((Action)this._actions.get("next")).setEnabled(true);
                ((Action)this._actions.get("previous")).setEnabled(false);
                ((Action)this._actions.get("last")).setEnabled(true);
            } else if (n2 == 1) {
                ((Action)this._actions.get("first")).setEnabled(false);
                ((Action)this._actions.get("next")).setEnabled(this._differences.size() != 0);
                ((Action)this._actions.get("previous")).setEnabled(false);
                ((Action)this._actions.get("last")).setEnabled(this._differences.size() != 0);
            } else if (n2 == 5) {
                ((Action)this._actions.get("first")).setEnabled(false);
                ((Action)this._actions.get("next")).setEnabled(false);
                ((Action)this._actions.get("previous")).setEnabled(false);
                ((Action)this._actions.get("last")).setEnabled(false);
            } else if (n2 == 2) {
                ((Action)this._actions.get("first")).setEnabled(true);
                ((Action)this._actions.get("next")).setEnabled(true);
                ((Action)this._actions.get("previous")).setEnabled(true);
                ((Action)this._actions.get("last")).setEnabled(true);
            } else if (n2 == 3) {
                ((Action)this._actions.get("first")).setEnabled(this._differences.size() != 0);
                ((Action)this._actions.get("next")).setEnabled(false);
                ((Action)this._actions.get("previous")).setEnabled(this._differences.size() != 0);
                ((Action)this._actions.get("last")).setEnabled(false);
            } else if (n2 == 4) {
                ((Action)this._actions.get("first")).setEnabled(true);
                ((Action)this._actions.get("next")).setEnabled(false);
                ((Action)this._actions.get("previous")).setEnabled(true);
                ((Action)this._actions.get("last")).setEnabled(false);
            }
        }
    }

    protected abstract int getSelectedIndex(int var1);

    protected int getCaretPosition(int n, int n2, int n3) {
        int n4 = this.getSelectedIndex(n);
        if (n4 < n2) {
            return 0;
        }
        if (n4 == n2) {
            return n2 != n3 ? 1 : 5;
        }
        if (n4 > n2 && n4 < n3) {
            return 2;
        }
        if (n4 == n3) {
            return 3;
        }
        if (n4 > n3) {
            return 4;
        }
        return -1;
    }

    @Override
    public void firstChange() {
        super.firstChange();
        if (this._differences != null && this._differences.size() > 0) {
            if (this._toComponent.hasFocus()) {
                int n = this._differences.get(0).getAddedStart();
                int n2 = this._differences.get(0).getAddedEnd();
                this.scrollTo(false, n, n2);
                this._fromToDivider.setSelectedDifference(this._differences.get(0));
            } else {
                if (!this._fromComponent.hasFocus()) {
                    this._fromComponent.requestFocusInWindow();
                }
                int n = this._differences.get(0).getDeletedStart();
                int n3 = this._differences.get(0).getDeletedEnd();
                this.scrollTo(true, n, n3);
                this._fromToDivider.setSelectedDifference(this._differences.get(0));
            }
            this.updateActions(this._fromComponent.hasFocus() ? 0 : 1);
        }
    }

    @Override
    public void previousChange() {
        super.previousChange();
        if (this._toComponent.hasFocus()) {
            int n;
            int n2;
            int n3 = this._fromToDivider.getSelectedDifference() == null ? ((n2 = BasicDiffPane.binarySearchAdded(this._differences, n = this.getSelectedIndex(1))) < 0 ? Math.abs(n2) - 2 : Math.abs(n2) - 1) : this._differences.indexOf(this._fromToDivider.getSelectedDifference()) - 1;
            if (n3 >= 0 && n3 < this._differences.size()) {
                Difference difference = this._differences.get(n3);
                n2 = difference.getAddedStart();
                int n4 = difference.getAddedEnd();
                this.scrollTo(false, n2, n4);
                this._fromToDivider.setSelectedDifference(difference);
            }
        } else {
            int n;
            int n5;
            int n6;
            if (!this._fromComponent.hasFocus()) {
                this._fromComponent.requestFocusInWindow();
            }
            if ((n6 = this._fromToDivider.getSelectedDifference() == null ? ((n5 = BasicDiffPane.binarySearchDeleted(this._differences, n = this.getSelectedIndex(0))) < 0 ? Math.abs(n5) - 2 : Math.abs(n5) - 1) : this._differences.indexOf(this._fromToDivider.getSelectedDifference()) - 1) >= 0 && n6 < this._differences.size()) {
                Difference difference = this._differences.get(n6);
                n5 = difference.getDeletedStart();
                int n7 = difference.getDeletedEnd();
                this.scrollTo(true, n5, n7);
                this._fromToDivider.setSelectedDifference(difference);
            }
        }
        this.updateActions(this._fromComponent.hasFocus() ? 0 : 1);
    }

    @Override
    public void nextChange() {
        super.nextChange();
        if (this._toComponent.hasFocus()) {
            int n;
            int n2;
            int n3 = this._fromToDivider.getSelectedDifference() == null ? ((n2 = BasicDiffPane.binarySearchAdded(this._differences, n = this.getSelectedIndex(1))) < 0 ? Math.abs(n2) - 1 : Math.abs(n2) + 1) : this._differences.indexOf(this._fromToDivider.getSelectedDifference()) + 1;
            if (n3 >= 0 && n3 < this._differences.size()) {
                Difference difference = this._differences.get(n3);
                n2 = difference.getAddedStart();
                int n4 = difference.getAddedEnd();
                this.scrollTo(false, n2, n4);
                this._fromToDivider.setSelectedDifference(difference);
            }
        } else {
            int n;
            int n5;
            int n6;
            if (!this._fromComponent.hasFocus()) {
                this._fromComponent.requestFocusInWindow();
            }
            if ((n6 = this._fromToDivider.getSelectedDifference() == null ? ((n5 = BasicDiffPane.binarySearchDeleted(this._differences, n = this.getSelectedIndex(0))) < 0 ? Math.abs(n5) - 1 : Math.abs(n5) + 1) : this._differences.indexOf(this._fromToDivider.getSelectedDifference()) + 1) >= 0 && n6 < this._differences.size()) {
                Difference difference = this._differences.get(n6);
                n5 = difference.getDeletedStart();
                int n7 = difference.getDeletedEnd();
                this.scrollTo(true, n5, n7);
                this._fromToDivider.setSelectedDifference(difference);
            }
        }
        this.updateActions(this._fromComponent.hasFocus() ? 0 : 1);
    }

    @Override
    public void lastChange() {
        super.lastChange();
        if (this._differences != null && this._differences.size() > 0) {
            if (this._toComponent.hasFocus()) {
                int n = this._differences.get(this._differences.size() - 1).getAddedStart();
                int n2 = this._differences.get(this._differences.size() - 1).getAddedEnd();
                this.scrollTo(false, n, n2);
                this._fromToDivider.setSelectedDifference(this._differences.get(this._differences.size() - 1));
            } else {
                if (!this._fromComponent.hasFocus()) {
                    this._fromComponent.requestFocusInWindow();
                }
                int n = this._differences.get(this._differences.size() - 1).getDeletedStart();
                int n3 = this._differences.get(this._differences.size() - 1).getDeletedEnd();
                this.scrollTo(true, n, n3);
                this._fromToDivider.setSelectedDifference(this._differences.get(this._differences.size() - 1));
            }
            this.updateActions(this._fromComponent.hasFocus() ? 0 : 1);
        }
    }

    protected void scrollTo(boolean bl, int n, int n2) {
        RowMarginSupport rowMarginSupport = bl ? this._fromRowMarginSupport : this._toRowMarginSupport;
        rowMarginSupport.scrollTo(n, (n2 >= 0 ? n2 : n) + 10, this.isSelectOnNavigation());
        rowMarginSupport.scrollTo(n, n, this.isSelectOnNavigation());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this._fromScrollPane != null) {
            if (this._fromVerticalAdjustmentListener != null) {
                this._fromScrollPane.getVerticalScrollBar().removeAdjustmentListener(this._fromVerticalAdjustmentListener);
            }
            if (this._fromHorizontalAdjustmentListener != null) {
                this._fromScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this._fromHorizontalAdjustmentListener);
            }
            this._fromVerticalAdjustmentListener = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (BasicDiffPane.this._ignoreFromScrollEvent) {
                        return;
                    }
                    BasicDiffPane.this._ignoreToScrollEvent = true;
                    try {
                        BasicDiffPane.this.synchronizeViewport(BasicDiffPane.this._fromToDivider, true, true);
                        BasicDiffPane.this._fromToDivider.repaint();
                        BasicDiffPane.this._toDiffMargin.repaint();
                        BasicDiffPane.this._toDiffLineNumberMargin.repaint();
                    }
                    finally {
                        BasicDiffPane.this._ignoreToScrollEvent = false;
                    }
                }
            };
            this._fromScrollPane.getVerticalScrollBar().addAdjustmentListener(this._fromVerticalAdjustmentListener);
            this._fromHorizontalAdjustmentListener = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (BasicDiffPane.this._ignoreFromScrollEvent) {
                        return;
                    }
                    BasicDiffPane.this._ignoreToScrollEvent = true;
                    try {
                        BasicDiffPane.this.synchronizeViewport(BasicDiffPane.this._fromToDivider, true, false);
                        BasicDiffPane.this._fromToDivider.repaint();
                        BasicDiffPane.this._fromDiffMargin.repaint();
                        BasicDiffPane.this._fromDiffLineNumberMargin.repaint();
                    }
                    finally {
                        BasicDiffPane.this._ignoreToScrollEvent = false;
                    }
                }
            };
            this._fromScrollPane.getHorizontalScrollBar().addAdjustmentListener(this._fromHorizontalAdjustmentListener);
        }
        if (this._toScrollPane != null) {
            if (this._toVerticalAdjustmentListener != null) {
                this._toScrollPane.getVerticalScrollBar().removeAdjustmentListener(this._toVerticalAdjustmentListener);
            }
            if (this._toHorizontalAdjustmentListener != null) {
                this._toScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this._toHorizontalAdjustmentListener);
            }
            this._toVerticalAdjustmentListener = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (BasicDiffPane.this._ignoreToScrollEvent) {
                        return;
                    }
                    BasicDiffPane.this._ignoreFromScrollEvent = true;
                    try {
                        BasicDiffPane.this.synchronizeViewport(BasicDiffPane.this._fromToDivider, false, true);
                        BasicDiffPane.this._fromToDivider.repaint();
                        BasicDiffPane.this._fromDiffLineNumberMargin.repaint();
                        BasicDiffPane.this._fromDiffMargin.repaint();
                    }
                    finally {
                        BasicDiffPane.this._ignoreFromScrollEvent = false;
                    }
                }
            };
            this._toScrollPane.getVerticalScrollBar().addAdjustmentListener(this._toVerticalAdjustmentListener);
            this._toHorizontalAdjustmentListener = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (BasicDiffPane.this._ignoreToScrollEvent) {
                        return;
                    }
                    BasicDiffPane.this._ignoreFromScrollEvent = true;
                    try {
                        BasicDiffPane.this.synchronizeViewport(BasicDiffPane.this._fromToDivider, false, false);
                        BasicDiffPane.this._fromToDivider.repaint();
                    }
                    finally {
                        BasicDiffPane.this._ignoreFromScrollEvent = false;
                    }
                }
            };
            this._toScrollPane.getHorizontalScrollBar().addAdjustmentListener(this._toHorizontalAdjustmentListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._fromScrollPane != null) {
            if (this._fromVerticalAdjustmentListener != null) {
                this._fromScrollPane.getVerticalScrollBar().removeAdjustmentListener(this._fromVerticalAdjustmentListener);
            }
            if (this._fromHorizontalAdjustmentListener != null) {
                this._fromScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this._fromHorizontalAdjustmentListener);
            }
        }
        if (this._toScrollPane != null) {
            if (this._toVerticalAdjustmentListener != null) {
                this._toScrollPane.getVerticalScrollBar().removeAdjustmentListener(this._toVerticalAdjustmentListener);
            }
            if (this._toHorizontalAdjustmentListener != null) {
                this._toScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this._toHorizontalAdjustmentListener);
            }
        }
        this._fromVerticalAdjustmentListener = null;
        this._fromHorizontalAdjustmentListener = null;
        this._toVerticalAdjustmentListener = null;
        this._toHorizontalAdjustmentListener = null;
    }

    private String getChangeToolTip(int n, int n2) {
        if (n2 == -1 || n == n2) {
            return MessageFormat.format(this.getResourceString("DiffPane.lineChanged"), n + 1);
        }
        return MessageFormat.format(this.getResourceString("DiffPane.linesChanged"), n + 1, n2 + 1);
    }

    public List<Difference> getDifferencesForDiff() {
        List<Difference> list = this.diff(this.getFromItems(), this.getToItems());
        if (list instanceof DifferenceList && this.isHighlightExactChange()) {
            for (Difference difference : list) {
                int n = difference.getAddedStart();
                int n2 = difference.getAddedEnd();
                int n3 = difference.getDeletedStart();
                int n4 = difference.getDeletedEnd();
                boolean bl = false;
                boolean bl2 = false;
                if (n4 == -1) {
                    bl = true;
                } else if (n2 == -1) {
                    bl2 = true;
                }
                if (bl2 || bl) continue;
                Diff<?> diff = n4 - n3 == 0 && n2 - n == 0 ? this.createLineDiff(n, n3) : this.createLinesDiff(n3, n4, n, n2);
                List<Difference> list2 = null;
                if (diff != null) {
                    list2 = diff.diff();
                    this.customizeLinesDiff(diff, list2);
                }
                ((DifferenceList)list).addLinesDiff(difference, list2);
            }
        }
        return list;
    }

    public List<Difference> getDifferences() {
        return this._differences;
    }

    protected List<Difference> diff(T[] TArray, T[] TArray2) {
        Diff<T> diff = this.createDiff(TArray, TArray2);
        return diff.diff();
    }

    protected Diff<T> createDiff(T[] TArray, T[] TArray2) {
        return new Diff<T>(TArray, TArray2);
    }

    public List<Difference> diff() {
        this._diffed = true;
        List<Difference> list = this.getDifferencesForDiff();
        this.differencesUpdated(list);
        return list;
    }

    public void runDiff() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                BasicDiffPane.this.diff();
            }
        });
    }

    public void clearDiff() {
        this._diffed = false;
        this.differencesUpdated(null);
    }

    public boolean isHighlightExactChange() {
        return this._highlightExactChange;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setReadOnly(boolean bl) {
        this._readOnly = bl;
        ((DiffMargin)this._fromDiffMargin).setEditable(!this._readOnly);
        ((DiffMargin)this._toDiffMargin).setEditable(!this._readOnly);
    }

    public void setHighlightExactChange(boolean bl) {
        if (this._highlightExactChange != bl) {
            this._highlightExactChange = bl;
            this.diff();
        }
    }

    protected void differencesUpdated(final List<Difference> list) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalDifferencesUpdated(list);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BasicDiffPane.this.internalDifferencesUpdated(list);
                }
            });
        }
    }

    private void internalDifferencesUpdated(final List<Difference> list) {
        this._differences = list;
        this.updateActions(this._fromComponent.hasFocus() ? 0 : (this._toComponent.hasFocus() ? 1 : -1));
        this.updateMessage();
        this._fromToDivider.setDifferences(list);
        HashMap<Integer, Difference> hashMap = new HashMap<Integer, Difference>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashMap<Integer, Difference> hashMap2 = new HashMap<Integer, Difference>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        this.clearHighlights();
        this.startHighlights();
        if (list != null) {
            for (Difference difference : list) {
                int n = difference.getAddedStart();
                int n2 = difference.getAddedEnd();
                int n3 = difference.getDeletedStart();
                int n4 = difference.getDeletedEnd();
                if (n4 == -1) {
                    hashMap.put(n3, difference);
                } else {
                    hashMap.put(n3, difference);
                    hashSet.add(n4 + 1);
                }
                if (n2 == -1) {
                    hashMap2.put(n, difference);
                } else {
                    hashMap2.put(n, difference);
                    hashSet2.add(n2 + 1);
                }
                boolean bl = false;
                boolean bl2 = false;
                if (n4 == -1) {
                    bl = true;
                } else if (n2 == -1) {
                    bl2 = true;
                }
                Color color = bl ? this._insertedColor : (bl2 ? this._deletedColor : this._changedColor);
                Color color2 = Color.GRAY;
                String string = this.getChangeToolTip(n, n2);
                if (bl2) {
                    this.highlightDeleted(n3, n4, n, color, color2, string);
                    continue;
                }
                if (bl) {
                    this.highlightInserted(n3, n, n2, color, color2, string);
                    continue;
                }
                if (this.isHighlightExactChange()) {
                    Diff<?> diff;
                    if (list instanceof DifferenceList) {
                        diff = ((DifferenceList)list).getLinesDiff(difference);
                        if (diff != null) {
                            this.highlightChangedExactly((List<Difference>)((Object)diff), n3, n4, n, n2, color, color2, string);
                            continue;
                        }
                        this.highlightChanged(n3, n4, n, n2, color, color2, string);
                        continue;
                    }
                    diff = n4 - n3 == 0 && n2 - n == 0 ? this.createLineDiff(n, n3) : this.createLinesDiff(n3, n4, n, n2);
                    if (diff != null) {
                        List<Difference> list2 = diff.diff();
                        if (Thread.currentThread().isInterrupted()) continue;
                        this.customizeLinesDiff(diff, list2);
                        this.highlightChangedExactly(list2, n3, n4, n, n2, color, color2, string);
                        continue;
                    }
                    this.highlightChanged(n3, n4, n, n2, color, color2, string);
                    continue;
                }
                this.highlightChanged(n3, n4, n, n2, color, color2, string);
            }
        }
        this.endHighlights();
        ((DiffMargin)this._fromDiffMargin).setDifferences(hashMap, hashSet);
        ((DiffRowNumberMargin)this._fromDiffLineNumberMargin).setDifferences(hashMap, hashSet);
        ((DiffMargin)this._toDiffMargin).setDifferences(hashMap2, hashSet2);
        ((DiffRowNumberMargin)this._toDiffLineNumberMargin).setDifferences(hashMap2, hashSet2);
        ((DiffMargin)this._fromDiffMargin).setHandler(new DiffMargin.Handler(){

            @Override
            public void handle(Difference difference, int n) {
                boolean bl = difference.getAddedEnd() == -1 ? BasicDiffPane.this.insert(difference.getAddedStart(), difference.getDeletedStart(), difference.getDeletedEnd() - difference.getDeletedStart() + 1, false) : BasicDiffPane.this.replace(difference.getAddedStart(), difference.getAddedEnd() - difference.getAddedStart() + 1, difference.getDeletedStart(), difference.getDeletedEnd() - difference.getDeletedStart() + 1, false);
                if (bl) {
                    List<Difference> list2 = BasicDiffPane.this.acceptDifference(list, difference);
                    BasicDiffPane.this.differencesUpdated(list2);
                }
            }
        });
        ((DiffMargin)this._toDiffMargin).setHandler(new DiffMargin.Handler(){

            @Override
            public void handle(Difference difference, int n) {
                boolean bl;
                if (difference.getDeletedEnd() == -1 && difference.getAddedEnd() != -1 && (bl = BasicDiffPane.this.delete(difference.getAddedStart(), difference.getAddedEnd() - difference.getAddedStart() + 1, false))) {
                    List<Difference> list2 = BasicDiffPane.this.acceptDifference(list, difference);
                    BasicDiffPane.this.differencesUpdated(list2);
                }
            }
        });
        if (list != null && list.size() > 0) {
            this._fromMarkerArea.setMode(100);
            this._toMarkerArea.setMode(100);
        } else {
            this._fromMarkerArea.setMode(0);
            this._toMarkerArea.setMode(0);
        }
    }

    protected List<Difference> customizeLinesDiff(Diff diff, List<Difference> list) {
        return list;
    }

    protected static int binarySearchAdded(List<Difference> list, int n) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4;
            int n5 = n2 + n3 >>> 1;
            Difference difference = list.get(n5);
            int n6 = difference.getAddedStart() < n ? -1 : (n4 = difference.getAddedStart() > n ? 1 : 0);
            if (n4 < 0) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > 0) {
                n3 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n2 + 1);
    }

    protected static int binarySearchDeleted(List<Difference> list, int n) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4;
            int n5 = n2 + n3 >>> 1;
            Difference difference = list.get(n5);
            int n6 = difference.getDeletedStart() < n ? -1 : (n4 = difference.getDeletedStart() > n ? 1 : 0);
            if (n4 < 0) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > 0) {
                n3 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n2 + 1);
    }

    protected int getToMatchingRow(int n) {
        int n2 = n;
        if (this._differences != null) {
            for (Difference difference : this._differences) {
                if (n < difference.getDeletedStart()) break;
                n2 -= this.numberLines(difference.getDeletedStart(), difference.getDeletedEnd()) - this.numberLines(difference.getAddedStart(), difference.getAddedEnd());
            }
            return Math.max(0, n2);
        }
        return n;
    }

    protected int getFromMatchingRow(int n) {
        int n2 = n;
        if (this._differences != null) {
            for (Difference difference : this._differences) {
                if (n < difference.getAddedStart()) break;
                n2 -= this.numberLines(difference.getAddedStart(), difference.getAddedEnd()) - this.numberLines(difference.getDeletedStart(), difference.getDeletedEnd());
            }
            return Math.max(0, n2);
        }
        return n;
    }

    private int numberLines(int n, int n2) {
        return n2 == -1 ? 0 : n2 - n + 1;
    }

    public void clearHighlights() {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().clearMarkers();
        this._toMarkerArea.getMarkerSupport().getMarkerModel().clearMarkers();
    }

    public void startHighlights() {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().setAdjusting(true);
        this._toMarkerArea.getMarkerSupport().getMarkerModel().setAdjusting(true);
    }

    public void endHighlights() {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().setAdjusting(false);
        this._toMarkerArea.getMarkerSupport().getMarkerModel().setAdjusting(false);
        this._fromComponent.repaint();
        this._toComponent.repaint();
    }

    @Deprecated
    public Diff<?> createLineDiff(int n, int n2) {
        return this.createLinesDiff(n2, n2, n, n);
    }

    protected Diff<?> createLinesDiff(int n, int n2, int n3, int n4) {
        return null;
    }

    public void highlightChangedExactly(List<Difference> list, int n, int n2, int n3, int n4, Color color, Color color2, String string) {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n, n2, 124, "");
        this._toMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n3, n4, 124, string);
    }

    public void highlightChanged(int n, int n2, int n3, int n4, Color color, Color color2, String string) {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n, n2, 124, "");
        this._toMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n3, n4, 124, string);
    }

    public void highlightInserted(int n, int n2, int n3, Color color, Color color2, String string) {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n, n, 126, "");
        this._toMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n2, n3, 125, string);
    }

    public void highlightDeleted(int n, int n2, int n3, Color color, Color color2, String string) {
        this._fromMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n, n2, 125, "");
        this._toMarkerArea.getMarkerSupport().getMarkerModel().addMarker(n3, n3, 126, string);
    }

    protected List<Difference> acceptDifference(List<Difference> list, Difference difference) {
        boolean bl = false;
        int n = 0;
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        for (Difference difference2 : list) {
            if (difference2.getDeletedStart() == difference.getDeletedStart() && difference2.getDeletedEnd() == difference.getDeletedEnd()) {
                bl = true;
                if (difference.getAddedEnd() == -1) {
                    n = -(difference.getDeletedEnd() - difference.getDeletedStart() + 1);
                    continue;
                }
                if (difference.getDeletedEnd() == -1) {
                    n = difference.getAddedEnd() - difference.getAddedStart() + 1;
                    continue;
                }
                n = difference.getAddedEnd() - difference.getAddedStart() + 1 - (difference.getDeletedEnd() - difference.getDeletedStart() + 1);
                continue;
            }
            if (bl && n != 0) {
                difference2.adjustAdded(-n);
            }
            arrayList.add(difference2);
        }
        return arrayList;
    }

    private void updateMessage() {
        if (this._differences == null || this._differences.size() == 0) {
            this.setMessage(this.getResourceString("DiffPane.noChange"));
        } else if (this._differences.size() == 1) {
            this.setMessage(this.getResourceString("DiffPane.oneChange"));
        } else {
            this.setMessage(MessageFormat.format(this.getResourceString("DiffPane.hasChanges"), this._differences.size()));
        }
    }

    public abstract boolean delete(int var1, int var2, boolean var3);

    public abstract boolean insert(int var1, int var2, int var3, boolean var4);

    public boolean replace(int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2 = this.delete(n, n2, false);
        if (bl2) {
            bl2 = this.insert(n, n3, n4, false);
        }
        if (bl2 && bl && this._diffed) {
            this.runDiff();
        }
        return bl2;
    }

    public boolean isSelectOnNavigation() {
        return this._selectOnNavigation;
    }

    public void setSelectOnNavigation(boolean bl) {
        this._selectOnNavigation = bl;
    }
}

