/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.database;

import com.jidesoft.database.BatchedOperations;
import com.jidesoft.database.CrudTableModel;
import com.jidesoft.database.DefaultRecord;
import com.jidesoft.database.Record;
import com.jidesoft.database.TableModelCache;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperImpl;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableModel;

public class BatchedCrudTableModelWrapper
extends TableModelWrapperImpl
implements CrudTableModel,
TableModelWrapper,
BatchedOperations {
    private static final long serialVersionUID = 9059733619283066142L;
    protected TableModelCache _cache = new TableModelCache();
    private Vector<Integer> _rowsDeleted = new Vector();
    private Vector<Record> _rowsInserted = new Vector();
    private int _countDeleted = 0;
    private int _countInserted = 0;
    private boolean _isAutoCommit = false;

    public BatchedCrudTableModelWrapper(TableModel tableModel) {
        super(tableModel);
        if (!(tableModel instanceof CrudTableModel)) {
            throw new IllegalArgumentException("The model wrapped in BatchedCrudTableModelWrapper must be a CrudTableModel instance.");
        }
    }

    @Override
    public int getRowCount() {
        return this._model.getRowCount() - this._countDeleted + this._countInserted;
    }

    private int getActualRowCount() {
        return this._model.getRowCount() - this._countDeleted;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (!this._isAutoCommit) {
            if (n >= this.getActualRowCount()) {
                Record record = this._rowsInserted.get(n - this.getActualRowCount());
                if (record != null) {
                    object = record.getValue(this.getColumnName(n2));
                }
            } else {
                int n3 = this.getActualIndexAt(n);
                object = this._cache.isCachedValueValid(n3, n2) ? this._cache.getValueAt(n3, n2) : this._model.getValueAt(n3, n2);
            }
        } else {
            object = this._model.getValueAt(n, n2);
        }
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (!this._isAutoCommit) {
            int n3 = this.getActualRowCount();
            if (n >= n3) {
                this.setInsertedRowValueAt(object, n - n3, n2);
            } else {
                this._cache.setValueAt(object, this.getActualIndexAt(n), n2);
            }
            this.fireTableCellUpdated(n, n2);
        } else {
            this._model.setValueAt(object, n, n2);
        }
    }

    private void setInsertedRowValueAt(Object object, int n, int n2) {
        Record record;
        if (this._rowsInserted.get(n) == null) {
            record = this.createRowRecord();
            this._rowsInserted.setElementAt(record, n);
        } else {
            record = this._rowsInserted.get(n);
        }
        record.setValue(this.getColumnName(n2), object);
    }

    @Override
    public void rollback() {
        this.resetState();
        this.fireTableStructureChanged();
    }

    protected int getActualIndexAt(int n) {
        int n2;
        int n3 = n;
        Iterator<Integer> iterator = this._rowsDeleted.iterator();
        while (iterator.hasNext() && (n2 = iterator.next().intValue()) <= n) {
            ++n3;
        }
        return n3;
    }

    protected void resetState() {
        this._rowsDeleted.clear();
        this._rowsInserted.clear();
        this._countDeleted = 0;
        this._countInserted = 0;
        this._cache = new TableModelCache();
    }

    @Override
    public void commit() throws Exception {
        int[] nArray = this.unboxIntegerList(this._cache.getRowIndices());
        int[] nArray2 = this.unboxIntegerList(this._rowsDeleted);
        int n = 0;
        int n2 = 0;
        if (nArray2.length > 0 && nArray.length > 0 && nArray2[0] < nArray[0]) {
            do {
                ((CrudTableModel)this._model).deleteRow(nArray2[n++]);
            } while (n < nArray2.length && nArray2[n] < nArray[0]);
        }
        for (int n3 : nArray) {
            while (n < nArray2.length && nArray2[n] < n3) {
                ((CrudTableModel)this._model).deleteRow(nArray2[n++]);
            }
            ((CrudTableModel)this._model).updateRow(n3 - n2, this.readRow(n3 - n2));
        }
        while (n < nArray2.length) {
            ((CrudTableModel)this._model).deleteRow(nArray2[n++]);
        }
        Object object = this._rowsInserted.iterator();
        while (object.hasNext()) {
            Record record = (Record)object.next();
            ((CrudTableModel)this._model).insertRow(record);
        }
        this.resetState();
        this.fireTableDataChanged();
    }

    private int[] unboxIntegerList(List<Integer> list) {
        if (list == null) {
            return new int[0];
        }
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = list.get(i);
        }
        return nArray;
    }

    @Override
    public void insertRow(Record record) throws Exception {
        if (!this._isAutoCommit) {
            this._rowsInserted.add(record != Record.EMPTY ? record : null);
            int n = this.getRowCount();
            ++this._countInserted;
            this.fireTableRowsInserted(n, n);
        } else {
            ((CrudTableModel)this._model).insertRow(record);
        }
    }

    @Override
    public Record readRow(int n) throws Exception {
        Record record = this.createRowRecord();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            record.setValue(this.getColumnName(i), this.getValueAt(n, i));
        }
        return record;
    }

    protected Record createRowRecord() {
        return new DefaultRecord();
    }

    @Override
    public void updateRow(int n, Record record) throws Exception {
        if (!this._isAutoCommit) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.setValueAt(record.getValue(this.getColumnName(i)), n, i);
            }
            this.fireTableRowsUpdated(n, n);
        } else {
            ((CrudTableModel)this._model).updateRow(n, record);
        }
    }

    @Override
    public void deleteRow(int n) throws Exception {
        if (!this._isAutoCommit) {
            if (n >= this.getActualRowCount()) {
                this._rowsInserted.removeElementAt(n - this.getActualRowCount());
                --this._countInserted;
            } else {
                int n2 = this.getActualIndexAt(n);
                this._rowsDeleted.add(n);
                if (this._cache.getRowIndices() != null && this._cache.getRowIndices().contains(n2)) {
                    this._cache.invalidateCache(n2);
                }
                ++this._countDeleted;
                Collections.sort(this._rowsDeleted);
            }
            this.fireTableRowsDeleted(n, n);
        } else {
            ((CrudTableModel)this._model).deleteRow(n);
        }
    }

    @Override
    public void setAutoCommit(boolean bl) {
        if (this._isAutoCommit && !bl) {
            this.rollback();
        }
        this._isAutoCommit = bl;
        this.resetState();
    }

    @Override
    public boolean isAutoCommit() {
        return this._isAutoCommit;
    }
}

