/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dashboard;

import com.jidesoft.dashboard.Dashboard;
import com.jidesoft.dashboard.DraggingImagePanel;
import com.jidesoft.dashboard.Gadget;
import com.jidesoft.dashboard.GadgetComponent;
import com.jidesoft.dashboard.GadgetContainer;
import com.jidesoft.dashboard.GadgetEvent;
import com.jidesoft.dashboard.GadgetManager;
import com.jidesoft.dashboard.GadgetPaletteButton;
import com.jidesoft.dashboard.PlaceHolder;
import com.jidesoft.dashboard.ResizableGadgetContainer;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

class GadgetMouseListener
implements MouseInputListener,
KeyListener {
    private Point _pressedPoint;
    private int _xOffset;
    private int _yOffset;
    private boolean _dragging = false;
    private Component _actualComponent = null;
    private boolean _draggingButton;
    private Point _dragStartViewPosition;
    private Container _oldContainer = null;
    private int _oldIndex = -1;
    private Object _oldConstraints = null;
    private Component _dragComponent = null;
    private JComponent _dummyComponent = null;
    private Component _dropComponent;
    private JLayeredPane _layeredPane;
    private RootPaneContainer _rootPaneContainer;
    private Map<Rectangle, PlaceHolder> _gadgetBounds;
    private Map<Rectangle, Container> _gadgetContainerBounds;
    private JViewport _viewport;
    private Rectangle _viewportBounds;
    private boolean _before;
    private Component _tempRemoveComponent;

    GadgetMouseListener() {
    }

    private Rectangle getGadgetBoundsOnScreen(Component component) {
        Rectangle rectangle = component.getBounds();
        Point point = component.getLocationOnScreen();
        rectangle.x = point.x;
        rectangle.y = point.y;
        rectangle.height += 6;
        return rectangle;
    }

    private Rectangle findContainingGadgetContainerBounds(Point point) {
        for (Rectangle rectangle : this._gadgetContainerBounds.keySet()) {
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.width += 6;
            if (!rectangle2.contains(point)) continue;
            return rectangle;
        }
        return null;
    }

    private int getGadgetContainerWidth(Point point) {
        int n = 0;
        for (Rectangle rectangle : this._gadgetContainerBounds.keySet()) {
            if (rectangle.x < point.x && rectangle.x + rectangle.width + 6 > point.x) {
                LayoutManager layoutManager = this._gadgetContainerBounds.get(rectangle).getLayout();
                if (layoutManager instanceof FlowLayout) {
                    return 0;
                }
                if (layoutManager instanceof GridLayout) {
                    return rectangle.width / ((GridLayout)layoutManager).getColumns();
                }
                return rectangle.width;
            }
            if (n != 0) continue;
            n = rectangle.width;
        }
        return n > 0 ? n : 100;
    }

    private Rectangle findContainingGadgetBounds(Point point) {
        for (Rectangle rectangle : this._gadgetBounds.keySet()) {
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.width += 6;
            rectangle2.height += 6;
            if (!rectangle2.contains(point)) continue;
            return rectangle;
        }
        return null;
    }

    private void replaceComponent(Component component, Component component2, boolean bl) {
        Container container;
        if (component2.getParent() != null && component2.getParent().getParent() instanceof Dashboard) {
            if (this._tempRemoveComponent != null) {
                this.replaceComponent(component2, this._tempRemoveComponent, true);
            } else {
                this.replaceComponent(component2, (Component)((Object)((Dashboard)component2.getParent().getParent()).createDefaultPlaceHolder()), true);
            }
        }
        if (component instanceof GadgetComponent) {
            if (component2 instanceof DraggingImagePanel && component != this._actualComponent) {
                this._tempRemoveComponent = component;
            } else if (!bl) {
                ((GadgetComponent)((Object)component)).getGadget().getGadgetManager().hideGadgetComponent((GadgetComponent)((Object)component));
            }
        }
        if (component instanceof DraggingImagePanel && component2 == this._tempRemoveComponent) {
            this._tempRemoveComponent = null;
        }
        if ((container = component.getParent()) != null && container.getParent() instanceof Dashboard) {
            int n = GadgetManager.indexOfGadgetContainer(container, component);
            Object object = ((Dashboard)container.getParent()).getComponentConstraints(n);
            container.remove(component);
            n = Math.min(n, this.getGadgetContainerComponentCount(container));
            container.add(component2, object, n);
            container.doLayout();
        }
    }

    private int getGadgetContainerComponentCount(Container container) {
        Component[] componentArray = container.getComponents();
        int n = container.getComponentCount();
        for (Component component : componentArray) {
            if (!(component instanceof Box.Filler)) continue;
            --n;
        }
        return n;
    }

    private void addComponent(Container container, Component component, Component component2, boolean bl) {
        GadgetManager.removeGadgetComponent(container, component2);
        int n = GadgetManager.indexOfGadgetContainer(container, component);
        if (n < 0) {
            n = 0;
            bl = true;
        }
        GadgetManager.addGadgetComponent(container, component2, bl ? n : n + 1);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 && this._dragging) {
            this.cancelDragging();
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Component component;
        if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent) && (component = mouseEvent.getComponent()) instanceof GadgetPaletteButton) {
            GadgetPaletteButton gadgetPaletteButton = (GadgetPaletteButton)component;
            Gadget gadget = gadgetPaletteButton.getGadget();
            GadgetManager gadgetManager = gadget.getGadgetManager();
            gadgetManager.gadgetButtonDoubleClicked(gadget);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this._dragging) {
            this.cancelDragging();
        }
        this._pressedPoint = mouseEvent.getPoint();
        this._xOffset = this._pressedPoint.x;
        this._yOffset = this._pressedPoint.y;
        SwingUtilities.convertPointToScreen(this._pressedPoint, (Component)mouseEvent.getSource());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.stopDragging();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._pressedPoint == null) {
            return;
        }
        if (!this._dragging) {
            this.startDragging(mouseEvent);
        } else {
            this.dragging(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDragging(MouseEvent mouseEvent) {
        Component component;
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, component);
        for (component = mouseEvent.getComponent(); component != null && component.getParent() != null && !(component instanceof GadgetComponent) && !(component instanceof GadgetPaletteButton); component = component.getParent()) {
        }
        if (component == null) {
            return;
        }
        while (component.getParent() instanceof GadgetComponent) {
            component = component.getParent();
        }
        if (!(component instanceof JComponent)) {
            return;
        }
        if (component.getParent() instanceof JPanel && Boolean.TRUE.equals(((JPanel)component.getParent()).getClientProperty("Dashboard.MaximizedGadgetContainer"))) {
            return;
        }
        this._rootPaneContainer = (RootPaneContainer)((Object)((JComponent)component).getTopLevelAncestor());
        if (this._rootPaneContainer == null) {
            return;
        }
        this._layeredPane = this._rootPaneContainer.getLayeredPane();
        if (Math.abs(point.x - this._pressedPoint.x) > 10 || Math.abs(point.y - this._pressedPoint.y) > 10) {
            Object object;
            Container container;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            if (component instanceof GadgetPaletteButton) {
                container = (GadgetPaletteButton)component;
                this._draggingButton = true;
                this._actualComponent = (Component)((Object)((GadgetPaletteButton)container).getGadget().createGadgetComponent());
                if (this._actualComponent == null) {
                    return;
                }
                this.initializeGadgetBounds();
                ((GadgetPaletteButton)container).getGadget().getGadgetManager().installListeners(this._actualComponent);
                ((GadgetPaletteButton)container).getGadget().getGadgetManager().fireGadgetEvent(new GadgetEvent(((GadgetPaletteButton)container).getGadget(), 13203, (GadgetComponent)((Object)this._actualComponent)));
                object = this._actualComponent.getPreferredSize();
                ((Dimension)object).width = Math.max(((Dimension)object).width, this.getGadgetContainerWidth(point));
                this._actualComponent.setSize(((Dimension)object).width, ((Dimension)object).height);
            } else {
                if (component instanceof GadgetComponent && !((GadgetComponent)((Object)component)).getGadget().getGadgetManager().isRearrangable()) {
                    return;
                }
                this._actualComponent = component;
                this._draggingButton = false;
            }
            this._dragging = true;
            container = this._actualComponent.getParent();
            if (container != null) {
                this._oldContainer = container;
                this._oldIndex = GadgetManager.indexOfGadgetContainer(container, this._actualComponent);
                this.initializeGadgetBounds();
                if ((this._gadgetContainerBounds == null || this._gadgetContainerBounds.size() <= 0) && container.getParent() instanceof Dashboard) {
                    this._oldConstraints = ((Dashboard)container.getParent()).getComponentConstraints(this._oldIndex);
                }
            } else if (SystemInfo.isJdk8Above()) {
                this._layeredPane.add(this._actualComponent);
            }
            if (!SystemInfo.isJdk8Above()) {
                this._layeredPane.add(this._actualComponent);
            }
            object = graphicsConfiguration.createCompatibleImage(this._actualComponent.getWidth(), this._actualComponent.getHeight(), 3);
            Map<Component, Boolean> map = JideSwingUtilities.disableDoubleBuffered(this._actualComponent);
            Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
            try {
                this._actualComponent.repaint();
                this._actualComponent.paint(graphics2D);
            }
            finally {
                graphics2D.dispose();
                JideSwingUtilities.restoreDoubleBuffered(this._actualComponent, map);
            }
            this._dummyComponent = new DraggingImagePanel((BufferedImage)object);
            this._dragComponent = new DraggingImagePanel((BufferedImage)object, 0.5f);
            if (container != null) {
                if (this._gadgetContainerBounds == null || this._gadgetContainerBounds.size() <= 0) {
                    container.add(this._dummyComponent, this._oldConstraints, this._oldIndex);
                } else {
                    GadgetManager.addGadgetComponent(container, this._dummyComponent, this._oldIndex);
                }
                container.invalidate();
                container.doLayout();
            }
            this._actualComponent.setVisible(false);
            int n = this._actualComponent.getWidth();
            int n2 = this._actualComponent.getHeight();
            this._layeredPane.add(this._dragComponent);
            SwingUtilities.convertPointFromScreen(point, this._layeredPane);
            this._dragComponent.setBounds(point.x - this._xOffset, point.y - this._yOffset, n, n2);
        }
    }

    private void initializeGadgetBounds() {
        Container container;
        this._gadgetBounds = new HashMap<Rectangle, PlaceHolder>();
        this._gadgetContainerBounds = new HashMap<Rectangle, Container>();
        for (container = this._actualComponent.getParent(); container != null && !(container instanceof Dashboard); container = container.getParent()) {
        }
        final Dashboard dashboard = (Dashboard)container;
        final GadgetManager gadgetManager = ((GadgetComponent)((Object)this._actualComponent)).getGadget().getGadgetManager();
        JideSwingUtilities.setRecursively(this._rootPaneContainer.getContentPane(), new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component component) {
                if (component instanceof GadgetComponent) {
                    Gadget gadget = ((GadgetComponent)((Object)component)).getGadget();
                    if (gadget == null) {
                        return false;
                    }
                    GadgetManager gadgetManager2 = gadget.getGadgetManager();
                    if (gadgetManager2 == null) {
                        return false;
                    }
                    Dashboard dashboard2 = gadgetManager2.getDashboard(gadgetManager2.getActiveDashboardKey());
                    if (dashboard2 == null || dashboard2.getMaximizedComponent() == component) {
                        return false;
                    }
                }
                return (GadgetManager.isGadgetContainer(component) || component instanceof GadgetComponent && GadgetManager.isGadgetContainer(component.getParent()) || component instanceof PlaceHolder && component.getParent() != null && component.getParent().getParent() instanceof Dashboard) && component.isShowing() && (dashboard == null || gadgetManager == null || gadgetManager.isAllowDragBetweenDashboard() || dashboard.isAncestorOf(component));
            }

            @Override
            public void action(Component component) {
                Rectangle rectangle = GadgetMouseListener.this.getGadgetBoundsOnScreen(component);
                if (component instanceof GadgetComponent) {
                    GadgetMouseListener.this._gadgetBounds.put(rectangle, (PlaceHolder)((Object)component));
                } else if (component instanceof PlaceHolder && component.getParent() != null && component.getParent().getParent() instanceof Dashboard) {
                    GadgetMouseListener.this._gadgetBounds.put(rectangle, (PlaceHolder)((Object)component));
                } else if (GadgetManager.isGadgetContainer(component)) {
                    GadgetMouseListener.this._gadgetContainerBounds.put(rectangle, (Container)component);
                    GadgetMouseListener.this._viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, component);
                    if (GadgetMouseListener.this._viewport != null) {
                        GadgetMouseListener.this._viewportBounds = new Rectangle();
                        ((GadgetMouseListener)GadgetMouseListener.this)._viewportBounds.x = ((GadgetMouseListener)GadgetMouseListener.this)._viewport.getLocationOnScreen().x;
                        ((GadgetMouseListener)GadgetMouseListener.this)._viewportBounds.y = ((GadgetMouseListener)GadgetMouseListener.this)._viewport.getLocationOnScreen().y;
                        ((GadgetMouseListener)GadgetMouseListener.this)._viewportBounds.width = GadgetMouseListener.this._viewport.getWidth();
                        ((GadgetMouseListener)GadgetMouseListener.this)._viewportBounds.height = GadgetMouseListener.this._viewport.getHeight();
                        GadgetMouseListener.this._dragStartViewPosition = GadgetMouseListener.this._viewport.getViewPosition();
                    }
                }
            }

            @Override
            public void postAction(Component component) {
            }
        });
    }

    private void dragging(MouseEvent mouseEvent) {
        if (this._layeredPane != null && this._dragComponent != null) {
            Serializable serializable;
            Cloneable cloneable;
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            Point point2 = (Point)point.clone();
            if (this._viewport != null) {
                cloneable = this._viewport.getViewSize();
                serializable = this._viewport.getViewPosition();
                if (!this._viewportBounds.contains(point)) {
                    if (point.y < this._viewportBounds.y) {
                        if (((Point)serializable).y > 0) {
                            ((Point)serializable).y = Math.max(((Point)serializable).y - this._viewportBounds.y + point.y, 0);
                            this._viewport.setViewPosition((Point)serializable);
                            return;
                        }
                    } else if (point.y >= this._viewportBounds.y + this._viewportBounds.height && ((Point)serializable).y < cloneable.height - this._viewportBounds.height) {
                        ((Point)serializable).y = Math.min(((Point)serializable).y + point.y - this._viewportBounds.y - this._viewportBounds.height, cloneable.height - this._viewportBounds.height);
                        this._viewport.setViewPosition((Point)serializable);
                        return;
                    }
                }
                if (this._viewport.getViewPosition() != this._dragStartViewPosition && this._dragStartViewPosition != null) {
                    point2.x += this._viewport.getViewPosition().x - this._dragStartViewPosition.x;
                    point2.y += this._viewport.getViewPosition().y - this._dragStartViewPosition.y;
                }
            }
            if ((cloneable = this.findContainingGadgetBounds(point2)) != null) {
                serializable = (Component)((Object)this._gadgetBounds.get(cloneable));
                boolean bl = point2.y < ((Rectangle)cloneable).y + ((Rectangle)cloneable).height / 2;
                Container container = GadgetManager.getAncestorOfGadgetContainer((Component)serializable);
                if (container != null && container.getLayout() instanceof FlowLayout) {
                    boolean bl2 = bl = point2.x < ((Rectangle)cloneable).x + ((Rectangle)cloneable).width / 2;
                }
                if (this._dropComponent != serializable || this._before != bl) {
                    this._before = bl;
                    this._dropComponent = serializable;
                    if (container != null) {
                        Container container2 = this._dummyComponent.getParent();
                        this.addComponent(container, (Component)serializable, this._dummyComponent, bl);
                        this.adjustLayout(container, container2);
                    } else {
                        Container container3 = this._dropComponent.getParent();
                        Container container4 = this._dummyComponent.getParent();
                        if (!(container3 instanceof JLayeredPane)) {
                            this.replaceComponent(this._dropComponent, this._dummyComponent, false);
                            this.adjustLayout(container3, container4);
                        }
                    }
                }
            } else {
                cloneable = this.findContainingGadgetContainerBounds(point);
                if (cloneable != null) {
                    serializable = this._gadgetContainerBounds.get(cloneable);
                    if (serializable != null) {
                        Container container = this._dummyComponent.getParent();
                        int n = GadgetManager.getGadgetContainerComponentCount((Container)serializable);
                        if (n < 1 || GadgetManager.getGadgetComponent((Container)serializable, n - 1) != this._dummyComponent) {
                            GadgetManager.addGadgetComponent((Container)serializable, this._dummyComponent, n);
                            this.adjustLayout((Container)serializable, container);
                        }
                    }
                } else if (this._actualComponent instanceof GadgetComponent && this._draggingButton && !((GadgetComponent)((Object)this._actualComponent)).getGadget().getGadgetManager().isAllowDragOutside()) {
                    if (this._dummyComponent != null && (serializable = this._dummyComponent.getParent()) != null) {
                        GadgetManager.removeGadgetComponent((Container)serializable, this._dummyComponent);
                        ((Container)serializable).invalidate();
                        ((Container)serializable).doLayout();
                    }
                    this._dropComponent = null;
                }
            }
            SwingUtilities.convertPointFromScreen(point, this._layeredPane);
            this._dragComponent.setLocation(point.x - this._xOffset, point.y - this._yOffset);
        }
    }

    private void adjustLayout(Container container, Container container2) {
        Container container3;
        Container container4;
        if (container2 != null && container2 != container) {
            container2.invalidate();
            container2.repaint();
            container2.doLayout();
        }
        if (container != null) {
            container.invalidate();
            container.repaint();
            container.doLayout();
        }
        if ((container4 = SwingUtilities.getAncestorOfClass(Dashboard.class, container2)) instanceof Dashboard) {
            ((Dashboard)container4).revalidate();
        }
        if ((container3 = SwingUtilities.getAncestorOfClass(Dashboard.class, container)) instanceof Dashboard && container3 != container4) {
            ((Dashboard)container3).revalidate();
        }
        if (this._gadgetContainerBounds == null || this._gadgetContainerBounds.size() <= 0) {
            this.initializeGadgetBounds();
        }
    }

    private void stopDragging() {
        Gadget gadget;
        if (!this._dragging || this._rootPaneContainer == null || this._dummyComponent == null || this._actualComponent == null || this._dragComponent == null) {
            return;
        }
        this._rootPaneContainer.getLayeredPane().remove(this._actualComponent);
        this._rootPaneContainer.getLayeredPane().remove(this._dragComponent);
        this._rootPaneContainer.getLayeredPane().invalidate();
        this._rootPaneContainer.getLayeredPane().repaint();
        if (this._dummyComponent != null && this._dummyComponent.getParent() != null) {
            Container container = this._dummyComponent.getParent();
            gadget = ((GadgetComponent)((Object)this._actualComponent)).getGadget();
            if (gadget == null || gadget.getGadgetManager() == null) {
                this.cancelDragging();
                return;
            }
            if (container instanceof GadgetContainer || container instanceof ResizableGadgetContainer) {
                int n = GadgetManager.indexOfGadgetContainer(container, this._dummyComponent);
                if (!gadget.getGadgetManager().validateGadgetDragging(gadget, container, n, this._draggingButton)) {
                    this.cancelDragging();
                    return;
                }
                GadgetManager.removeGadgetComponent(container, this._dummyComponent);
                if (this._oldContainer != null) {
                    GadgetManager.removeGadgetComponent(this._oldContainer, this._actualComponent);
                    if (this._oldContainer == container) {
                        n = Math.min(n, this.getGadgetContainerComponentCount(container));
                    }
                }
                this._actualComponent.setVisible(true);
                GadgetManager.addGadgetComponent(container, this._actualComponent, n);
            } else {
                if (!gadget.getGadgetManager().validateGadgetDragging(gadget, container, GadgetManager.indexOfGadgetContainer(container, this._dummyComponent), this._draggingButton)) {
                    this.cancelDragging();
                    return;
                }
                this._actualComponent.setVisible(true);
                this.replaceComponent(this._dummyComponent, this._actualComponent, false);
            }
            Container container2 = SwingUtilities.getAncestorOfClass(Dashboard.class, container);
            container.doLayout();
            if (container2 instanceof Dashboard) {
                ((Dashboard)container2).revalidate();
            }
        } else {
            this.cancelDragging();
            return;
        }
        gadget.getGadgetManager().fireGadgetEvent(new GadgetEvent(gadget, 13201, (GadgetComponent)((Object)this._actualComponent)));
        if (this._rootPaneContainer != null) {
            this._rootPaneContainer.getLayeredPane().repaint();
        }
        this.dispose();
    }

    private void cancelDragging() {
        Object object;
        if (!this._dragging) {
            return;
        }
        if (this._actualComponent != null && this._actualComponent.getParent() == this._layeredPane) {
            this._layeredPane.remove(this._actualComponent);
        }
        if (this._dragComponent != null) {
            this._layeredPane.remove(this._dragComponent);
        }
        if (this._dummyComponent != null && this._dummyComponent.getParent() != null) {
            object = this._dummyComponent.getParent();
            if (object != null && ((Component)object).getParent() instanceof Dashboard && ((Dashboard)((Component)object).getParent()).isPredefinedLayoutSet()) {
                if (this._tempRemoveComponent != null) {
                    this.replaceComponent(this._dummyComponent, this._tempRemoveComponent, false);
                } else {
                    this.replaceComponent(this._dummyComponent, (Component)((Object)((Dashboard)((Component)object).getParent()).createDefaultPlaceHolder()), false);
                }
            } else {
                GadgetManager.removeGadgetComponent((Container)object, this._dummyComponent);
            }
        }
        if (this._oldContainer != null) {
            this._actualComponent.setVisible(true);
            if (this._oldContainer.getParent() instanceof Dashboard && ((Dashboard)this._oldContainer.getParent()).isPredefinedLayoutSet()) {
                this.replaceComponent(this._oldContainer.getComponent(this._oldIndex), this._actualComponent, false);
            } else if (this._actualComponent.getParent() != this._oldContainer) {
                GadgetManager.addGadgetComponent(this._oldContainer, this._actualComponent, this._oldIndex);
            }
            this._oldContainer.doLayout();
        } else {
            object = ((GadgetComponent)((Object)this._actualComponent)).getGadget();
            object.getGadgetManager().hideGadgetComponent((GadgetComponent)((Object)this._actualComponent));
        }
        if (this._rootPaneContainer != null) {
            this._rootPaneContainer.getLayeredPane().repaint();
        }
        this.dispose();
    }

    private void dispose() {
        this._rootPaneContainer = null;
        this._dummyComponent = null;
        this._dragComponent = null;
        this._dropComponent = null;
        this._actualComponent = null;
        this._oldContainer = null;
        this._oldIndex = -1;
        this._pressedPoint = null;
        this._dragging = false;
        this._draggingButton = false;
        this._dragStartViewPosition = null;
        this._layeredPane = null;
        this._tempRemoveComponent = null;
        if (this._gadgetBounds != null) {
            this._gadgetBounds.clear();
            this._gadgetBounds = null;
        }
        if (this._gadgetContainerBounds != null) {
            this._gadgetContainerBounds.clear();
            this._gadgetContainerBounds = null;
        }
    }
}

