/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dashboard;

import com.jidesoft.dashboard.Dashboard;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public class GadgetContainer
extends JPanel {
    private Map<String, String> _settings;

    public GadgetContainer(int n) {
        this.setLayout(new JideBoxLayout(this, 1, n));
        this.setOpaque(false);
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof JideBoxLayout || layoutManager instanceof FlowLayout || layoutManager instanceof GridLayout) {
            super.setLayout(layoutManager);
        }
    }

    private Dimension getMyPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = this.getSize().width;
        if (this.getLayout() instanceof FlowLayout && this.isShowing() && n < dimension.width) {
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension2 = componentArray[i].getPreferredSize();
                if ((n2 += dimension2.width + ((FlowLayout)this.getLayout()).getHgap()) > n) {
                    ++n3;
                    n2 = i > n4 + 1 ? dimension2.width : 0;
                    int n5 = n4 = i > n4 + 1 ? i - 1 : i;
                }
                if (n2 <= n) continue;
                ++n3;
                n2 = 0;
                n4 = i;
            }
            dimension.height *= n3 + 1;
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getMyPreferredSize();
        Container container = this.getParent();
        if (SystemInfo.isJdk15Above() && this.isPreferredSizeSet()) {
            if (container instanceof JideSplitPane) {
                int n = 0;
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    Component component = container.getComponent(i);
                    if (!(component instanceof GadgetContainer)) continue;
                    Dimension dimension2 = ((GadgetContainer)component).getMyPreferredSize();
                    if (component.isPreferredSizeSet()) {
                        component.setPreferredSize(null);
                        n = Math.max(n, ((GadgetContainer)component).getMyPreferredSize().height);
                        component.setPreferredSize(dimension2);
                        continue;
                    }
                    n = Math.max(n, dimension2.height);
                }
                this.setPreferredSize(null);
                dimension.height = n;
                this.setPreferredSize(dimension);
            } else {
                this.setPreferredSize(null);
            }
        }
        return dimension;
    }

    @Override
    public void remove(int n) {
        super.remove(n);
        Container container = this.getParent();
        if (container instanceof JideSplitPane) {
            while ((container = container.getParent()) != null && !(container instanceof Dashboard)) {
            }
            this.revalidate();
            if (container != null) {
                ((Dashboard)container).getNormalGadgetContainer().revalidate();
                ((Dashboard)container).revalidate();
            }
        }
    }

    public Map<String, String> getSettings() {
        if (this._settings == null) {
            this._settings = new HashMap<String, String>();
        }
        return this._settings;
    }

    public void setSettings(Map<String, String> map) {
        this._settings = map;
    }
}

