/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dashboard;

import com.jidesoft.dashboard.Dashboard;
import com.jidesoft.dashboard.DashboardEvent;
import com.jidesoft.dashboard.DashboardHolder;
import com.jidesoft.dashboard.DashboardListener;
import com.jidesoft.dashboard.DashboardResource;
import com.jidesoft.dashboard.GadgetEvent;
import com.jidesoft.dashboard.GadgetListener;
import com.jidesoft.dashboard.GadgetManager;
import com.jidesoft.dashboard.GadgetPalette;
import com.jidesoft.dashboard.GadgetPaletteInstaller;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.TabEditingEvent;
import com.jidesoft.swing.TabEditingListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;

public class DashboardTabbedPane
extends JideTabbedPane
implements TabEditingListener,
GadgetListener,
DashboardListener,
GadgetPaletteInstaller,
DashboardHolder {
    private Container _toolBar;
    private GadgetManager _gadgetManager;
    private transient GadgetPalette _gadgetPalette;
    protected JideButton _showPaletteButton;
    private boolean _useFloatingPalette = false;
    private int _paletteSide = 5;
    private static final String CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER = "Dashboard.titlePropertyChangeListener";
    public static final String BUTTON_NAME_ADD_DASHBOARD = "Dashboard.add";
    public static final String BUTTON_NAME_SHOW_GADGET_PALETTE = "GadgetPalette.show";

    public DashboardTabbedPane() {
        this._gadgetManager = new GadgetManager();
        this.initComponents();
    }

    public DashboardTabbedPane(GadgetManager gadgetManager) {
        this._gadgetManager = gadgetManager;
        this.initComponents();
    }

    public DashboardTabbedPane(int n) {
        super(n, 1);
        this.initComponents();
    }

    @Override
    public void editingStarted(TabEditingEvent tabEditingEvent) {
    }

    @Override
    public void editingStopped(TabEditingEvent tabEditingEvent) {
        Dashboard dashboard = this.getGadgetManager().getDashboard(tabEditingEvent.getTabIndex());
        dashboard.setTitle(tabEditingEvent.getNewTitle());
    }

    @Override
    public void editingCanceled(TabEditingEvent tabEditingEvent) {
    }

    @Override
    public GadgetManager getGadgetManager() {
        return this._gadgetManager;
    }

    @Override
    public void removeTabAt(int n) {
        this._gadgetManager.removeDashboard(this.getTitleAt(n));
    }

    protected void initComponents() {
        this._gadgetManager.addDashboardListener(this);
        this._gadgetManager.addGadgetListener(this);
        this.setTabEditingAllowed(true);
        this.addTabEditingListener(this);
        this.setShowCloseButton(true);
        this.setShowCloseButtonOnTab(true);
        this.setShowCloseButtonOnSelectedTab(true);
        this._toolBar = this.createToolBarComponent();
        this.setTabLeadingComponent(this._toolBar);
        this.addKeyListener(this._gadgetManager.getCancelDragAndDropKeyListener());
        this.setCloseAction(new AbstractAction(){
            private static final long serialVersionUID = -6321245600238187486L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dashboard dashboard;
                int n = DashboardTabbedPane.this.getSelectedIndex();
                if (n >= 0 && n < DashboardTabbedPane.this._gadgetManager.getDashboardCount() && (dashboard = DashboardTabbedPane.this._gadgetManager.getDashboard(n)) != null) {
                    DashboardTabbedPane.this.getGadgetManager().removeDashboard(dashboard.getKey());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){
            boolean _paletteVisible = false;

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DashboardTabbedPane.this.layoutPalette();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                super.componentMoved(componentEvent);
                DashboardTabbedPane.this.layoutPalette();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                super.componentShown(componentEvent);
                if (this._paletteVisible) {
                    this._paletteVisible = false;
                    DashboardTabbedPane.this.showPalette();
                }
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                super.componentHidden(componentEvent);
                if (DashboardTabbedPane.this.isPaletteVisible()) {
                    this._paletteVisible = true;
                    DashboardTabbedPane.this.hidePalette();
                }
            }
        });
    }

    protected Container createToolBarComponent() {
        JideButton jideButton = new JideButton();
        jideButton.putClientProperty("hideActionText", Boolean.TRUE);
        jideButton.setAction(new AbstractAction(this.getResourceString(BUTTON_NAME_ADD_DASHBOARD), this.getImageIcon("icons/add.png")){
            private static final long serialVersionUID = -8651408051308635053L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n = 1;
                while (true) {
                    object = MessageFormat.format(DashboardTabbedPane.this.getResourceString("Dashboard.untitled"), n);
                    if (DashboardTabbedPane.this.getGadgetManager().getDashboard((String)object) == null) break;
                    ++n;
                }
                object = DashboardTabbedPane.this.createDashboard(MessageFormat.format(DashboardTabbedPane.this.getResourceString("Dashboard.untitled"), n));
                DashboardTabbedPane.this.getGadgetManager().addDashboard((Dashboard)object);
                DashboardTabbedPane.this.setSelectedIndex(DashboardTabbedPane.this.getTabCount() - 1);
            }
        });
        jideButton.setName(BUTTON_NAME_ADD_DASHBOARD);
        this._showPaletteButton = new JideButton(new AbstractAction(this.getResourceString(BUTTON_NAME_SHOW_GADGET_PALETTE), this.getImageIcon("icons/property.png")){
            private static final long serialVersionUID = 353336825344755865L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DashboardTabbedPane.this.togglePalette(DashboardTabbedPane.this);
            }
        });
        this._showPaletteButton.setName(BUTTON_NAME_SHOW_GADGET_PALETTE);
        UIResourceToolBar uIResourceToolBar = new UIResourceToolBar();
        uIResourceToolBar.setOpaque(false);
        uIResourceToolBar.setRollover(true);
        uIResourceToolBar.setFloatable(false);
        uIResourceToolBar.putClientProperty("Synthetica.opaque", false);
        uIResourceToolBar.add(jideButton);
        uIResourceToolBar.add(this._showPaletteButton);
        return uIResourceToolBar;
    }

    @Override
    public Dashboard createDashboard(String string) {
        return new Dashboard(string);
    }

    private void layoutPalette() {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null && this._gadgetPalette != null) {
            JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
            this.layoutPalette(jLayeredPane);
        }
    }

    @Override
    public void eventHappened(GadgetEvent gadgetEvent) {
    }

    @Override
    public void eventHappened(DashboardEvent dashboardEvent) {
        if (dashboardEvent.getID() == 13099) {
            final Dashboard dashboard = (Dashboard)dashboardEvent.getSource();
            JScrollPane jScrollPane = new JScrollPane(dashboard);
            this.insertTab(dashboard.getTitle(), dashboard.getIcon(), jScrollPane, null, dashboardEvent.getIndex());
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if ("title".equals(string)) {
                        DashboardTabbedPane.this.setTitleAt(DashboardTabbedPane.this.getGadgetManager().getDashboardIndex(dashboard.getKey()), (String)propertyChangeEvent.getNewValue());
                    }
                }
            };
            dashboard.addPropertyChangeListener("title", propertyChangeListener);
            dashboard.putClientProperty(CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER, propertyChangeListener);
        } else if (dashboardEvent.getID() == 13100) {
            Dashboard dashboard = (Dashboard)dashboardEvent.getSource();
            if (dashboard == null) {
                return;
            }
            String string = dashboard.getKey();
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)dashboard.getClientProperty(CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER);
            if (propertyChangeListener != null) {
                dashboard.removePropertyChangeListener("title", propertyChangeListener);
                dashboard.putClientProperty(CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER, null);
            }
            super.removeTabAt(dashboardEvent.getIndex());
            int n = this.getSelectedIndex();
            if (JideSwingUtilities.equals(this._gadgetManager.getActiveDashboardKey(), string) && n >= 0 && n < this.getTabCount()) {
                this._gadgetManager.setActiveDashboardKey(this.getTitleAt(n));
            }
        } else if (dashboardEvent.getID() == 13101) {
            Dashboard dashboard = (Dashboard)dashboardEvent.getSource();
            int n = this.indexOfDashboard(dashboard);
            if (n >= 0 && n <= this.getTabCount() - 1) {
                Component component = this.getComponentAt(n);
                String string = this.getTitleAt(n);
                Icon icon = this.getIconAt(n);
                String string2 = this.getToolTipTextAt(n);
                super.removeTabAt(n);
                this.insertTab(string, icon, component, string2, dashboardEvent.getIndex());
            }
        } else if (dashboardEvent.getID() == 13102 && this.getSelectedIndex() != dashboardEvent.getIndex()) {
            this.setSelectedIndex(dashboardEvent.getIndex());
        }
    }

    @Override
    public void setSelectedIndex(int n) {
        super.setSelectedIndex(n);
        this.getGadgetManager().setActiveDashboardKey(this.getGadgetManager().getDashboard(n).getKey());
    }

    public int getDashboardCount() {
        return this.getTabCount();
    }

    public Dashboard getDashboardAt(int n) {
        Component component;
        Component component2 = this.getComponentAt(n);
        if (component2 instanceof JScrollPane && (component = ((JScrollPane)component2).getViewport().getView()) instanceof Dashboard) {
            return (Dashboard)component;
        }
        return null;
    }

    public int indexOfDashboard(Dashboard dashboard) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Dashboard dashboard2 = this.getDashboardAt(i);
            if ((dashboard2 == null || !dashboard2.equals(dashboard)) && (dashboard2 != null || dashboard2 != dashboard)) continue;
            return i;
        }
        return -1;
    }

    public void togglePalette(Component component) {
        if (this.isPaletteVisible()) {
            this.hidePalette();
        } else {
            this.showPalette(component);
        }
    }

    private void layoutPalette(JLayeredPane jLayeredPane) {
        if (this._gadgetPalette != null) {
            if (!this.isUseFloatingPalette() && this._gadgetPalette.getParent() != null && this._gadgetPalette.getParent().getLayout() instanceof BorderLayout) {
                this._gadgetPalette.validate();
            } else {
                Rectangle rectangle = this.getBounds();
                rectangle = SwingUtilities.convertRectangle(this.getParent(), rectangle, jLayeredPane);
                Insets insets = this.getContentBorderInsets();
                Dimension dimension = this._gadgetPalette.getPreferredSize();
                switch (this.getPaletteSide()) {
                    case 7: {
                        rectangle.width = dimension.width;
                        rectangle.y += insets.top + 1;
                        rectangle.height -= insets.top + insets.bottom + 2;
                        break;
                    }
                    case 3: {
                        rectangle.x = rectangle.x + rectangle.width - dimension.width;
                        rectangle.width = dimension.width;
                        rectangle.y += insets.top + 1;
                        rectangle.height -= insets.top + insets.bottom + 2;
                        break;
                    }
                    case 1: {
                        rectangle.y = 0;
                        rectangle.height = dimension.height;
                        rectangle.x += insets.left + 1;
                        rectangle.width -= insets.left + insets.right + 2;
                        rectangle.y += insets.top;
                        break;
                    }
                    default: {
                        rectangle.y = rectangle.y + rectangle.height - dimension.height;
                        rectangle.height = dimension.height;
                        rectangle.x += insets.left + 1;
                        rectangle.width -= insets.left + insets.right + 2;
                        rectangle.y -= insets.bottom;
                    }
                }
                this._gadgetPalette.setBounds(rectangle);
                this._gadgetPalette.validate();
            }
        }
    }

    public Container getValidParent(Component component) {
        do {
            if (component.getParent() == null || !(component.getParent().getLayout() instanceof BorderLayout)) continue;
            return component.getParent();
        } while ((component = component.getParent()) != null);
        return null;
    }

    public boolean isPaletteVisible() {
        return this._gadgetPalette != null && this._gadgetPalette.isVisible();
    }

    public void setPaletteSide(int n) {
        if (this._paletteSide != n) {
            this._paletteSide = n;
            boolean bl = this.isPaletteVisible();
            if (bl) {
                this.hidePalette();
            }
            this._gadgetPalette = null;
            if (bl) {
                this.showPalette();
            }
        }
    }

    @Override
    public int getPaletteSide() {
        return this._paletteSide;
    }

    public void showPalette() {
        this.showPalette(this);
    }

    @Override
    public void showPalette(Component component) {
        Container container = this.getValidParent(component);
        if (!this.isUseFloatingPalette() && container != null) {
            if (this._gadgetPalette == null) {
                this._gadgetPalette = this.createGadgetPalette();
                if (this._showPaletteButton != null) {
                    this._showPaletteButton.setSelected(true);
                }
                switch (this.getPaletteSide()) {
                    case 3: {
                        container.add((Component)this._gadgetPalette, "After");
                        break;
                    }
                    case 7: {
                        container.add((Component)this._gadgetPalette, "Before");
                        break;
                    }
                    case 1: {
                        container.add((Component)this._gadgetPalette, "First");
                        break;
                    }
                    default: {
                        container.add((Component)this._gadgetPalette, "Last");
                    }
                }
                container.validate();
            }
        } else {
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null && this._gadgetPalette == null) {
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                this._gadgetPalette = this.createGadgetPalette();
                jLayeredPane.add((Component)this._gadgetPalette, JLayeredPane.PALETTE_LAYER);
                this.layoutPalette(jLayeredPane);
                if (this._showPaletteButton != null) {
                    this._showPaletteButton.setSelected(true);
                }
            }
        }
    }

    protected GadgetPalette createGadgetPalette() {
        return new GadgetPalette(this._gadgetManager, this);
    }

    @Override
    public void hidePalette() {
        Container container = this.getValidParent(this);
        if (!this.isUseFloatingPalette() && container != null) {
            if (this._gadgetPalette != null) {
                container.remove(this._gadgetPalette);
                this._gadgetPalette.setVisible(false);
                this._gadgetPalette = null;
                if (this._showPaletteButton != null) {
                    this._showPaletteButton.setSelected(false);
                }
                container.validate();
            }
        } else {
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null && this._gadgetPalette != null) {
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                jLayeredPane.remove(this._gadgetPalette);
                this._gadgetPalette.setVisible(false);
                this._gadgetPalette = null;
                jLayeredPane.repaint();
                if (this._showPaletteButton != null) {
                    this._showPaletteButton.setSelected(false);
                }
            }
        }
    }

    public Container getToolBarComponent() {
        return this._toolBar;
    }

    public void setToolBar(JToolBar jToolBar) {
        this._toolBar = jToolBar;
    }

    @Override
    public Dashboard getActiveDashboard() {
        int n = this.getSelectedIndex();
        if (n < 0 || n >= this.getDashboardCount()) {
            return null;
        }
        return this.getDashboardAt(n);
    }

    public boolean isUseFloatingPalette() {
        return this._useFloatingPalette;
    }

    public void setUseFloatingPalette(boolean bl) {
        this._useFloatingPalette = bl;
    }

    public void setToolBarAlignment(int n) {
        if (n == 10) {
            this.setTabTrailingComponent(null);
            this.setTabLeadingComponent(this._toolBar);
        } else if (n == 11) {
            this.setTabLeadingComponent(null);
            this.setTabTrailingComponent(this._toolBar);
        }
    }

    public int getToolBarAlignment() {
        if (this.getTabTrailingComponent() == this._toolBar) {
            return 11;
        }
        if (this.getTabLeadingComponent() == this._toolBar) {
            return 10;
        }
        return -1;
    }

    protected ImageIcon getImageIcon(String string) {
        return IconsFactory.getImageIcon(DashboardTabbedPane.class, string);
    }

    @Override
    public String getResourceString(String string) {
        if (string != null && string.startsWith("JideTabbedPane")) {
            return super.getResourceString(string);
        }
        return DashboardResource.getResourceBundle(this.getLocale()).getString(string);
    }

    class UIResourceToolBar
    extends JToolBar
    implements UIResource {
    }
}

