/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dashboard;

import com.jidesoft.dashboard.Dashboard;
import com.jidesoft.dashboard.DashboardEvent;
import com.jidesoft.dashboard.DashboardHolder;
import com.jidesoft.dashboard.DashboardListener;
import com.jidesoft.dashboard.DashboardResource;
import com.jidesoft.dashboard.GadgetEvent;
import com.jidesoft.dashboard.GadgetListener;
import com.jidesoft.dashboard.GadgetManager;
import com.jidesoft.dashboard.GadgetPalette;
import com.jidesoft.dashboard.GadgetPaletteInstaller;
import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentComponentAdapter;
import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentPane;
import com.jidesoft.document.FloatingDocumentContainer;
import com.jidesoft.document.IDocumentGroup;
import com.jidesoft.document.TdiGroup;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.TabEditingEvent;
import com.jidesoft.swing.TabEditingListener;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;

public class DashboardDocumentPane
extends DocumentPane
implements TabEditingListener,
GadgetListener,
DashboardListener,
GadgetPaletteInstaller,
DashboardHolder {
    private GadgetManager _gadgetManager;
    private transient GadgetPalette _gadgetPalette;
    private boolean _useFloatingPalette = false;
    private int _paletteSide = 5;
    private final String CLIENT_PROPERTY_PROPERTY_CHANGE_LISTENER = "Dashboard.titlePropertyChangeListener";
    private AbstractAction _toggleAction;
    private int _toolbarAlignment = 10;
    public DocumentComponentAdapter _documentComponentListener;
    public PropertyChangeListener _propertyChangeListener;

    public DashboardDocumentPane() {
        this._gadgetManager = new GadgetManager();
        this.initComponents();
    }

    public DashboardDocumentPane(GadgetManager gadgetManager) {
        this._gadgetManager = gadgetManager;
        this.initComponents();
    }

    @Override
    public void editingStarted(TabEditingEvent tabEditingEvent) {
    }

    @Override
    public void editingStopped(TabEditingEvent tabEditingEvent) {
        Component component;
        int n = tabEditingEvent.getTabIndex();
        Component component2 = ((JideTabbedPane)tabEditingEvent.getSource()).getComponentAt(n);
        if (component2 instanceof JScrollPane && (component = ((JScrollPane)component2).getViewport().getView()) instanceof Dashboard) {
            ((Dashboard)component).setTitle(tabEditingEvent.getNewTitle());
        }
    }

    @Override
    public void editingCanceled(TabEditingEvent tabEditingEvent) {
    }

    @Override
    public GadgetManager getGadgetManager() {
        return this._gadgetManager;
    }

    protected void initComponents() {
        this._gadgetManager.addDashboardListener(this);
        this._gadgetManager.addGadgetListener(this);
        this.setGroupsAllowed(false);
        this.setTabbedPaneCustomizer(new DocumentPane.TabbedPaneCustomizer(){

            @Override
            public void customize(JideTabbedPane jideTabbedPane) {
                jideTabbedPane.setTabEditingAllowed(true);
                jideTabbedPane.addTabEditingListener(DashboardDocumentPane.this);
                jideTabbedPane.setShowCloseButton(true);
                jideTabbedPane.setShowCloseButtonOnTab(true);
                jideTabbedPane.setShowCloseButtonOnSelectedTab(true);
                Container container = DashboardDocumentPane.this.createToolBarComponent();
                if (DashboardDocumentPane.this.getToolBarAlignment() == 10 || DashboardDocumentPane.this.getToolBarAlignment() == 2) {
                    jideTabbedPane.setTabLeadingComponent(container);
                    jideTabbedPane.setTabTrailingComponent(null);
                } else {
                    jideTabbedPane.setTabLeadingComponent(null);
                    jideTabbedPane.setTabTrailingComponent(container);
                }
            }
        });
        this.addKeyListener(this._gadgetManager.getCancelDragAndDropKeyListener());
        this.addComponentListener(new ComponentAdapter(){
            boolean _paletteVisible = false;

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DashboardDocumentPane.this.layoutPalette();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                super.componentMoved(componentEvent);
                DashboardDocumentPane.this.layoutPalette();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                super.componentShown(componentEvent);
                if (this._paletteVisible) {
                    this._paletteVisible = false;
                    DashboardDocumentPane.this.showPalette((Component)componentEvent.getSource());
                }
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                super.componentHidden(componentEvent);
                if (DashboardDocumentPane.this.isPaletteVisible((Component)componentEvent.getSource())) {
                    this._paletteVisible = true;
                    DashboardDocumentPane.this.hidePalette();
                }
            }
        });
    }

    protected Container createToolBarComponent() {
        JideButton jideButton = new JideButton();
        jideButton.putClientProperty("hideActionText", Boolean.TRUE);
        jideButton.setAction(new AbstractAction(this.getResourceString("Dashboard.add"), this.getImageIcon("icons/add.png")){
            private static final long serialVersionUID = -8113332934276372196L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n = 1;
                while (true) {
                    object = MessageFormat.format(DashboardDocumentPane.this.getResourceString("Dashboard.untitled"), n);
                    if (DashboardDocumentPane.this.getGadgetManager().getDashboard((String)object) == null) break;
                    ++n;
                }
                object = DashboardDocumentPane.this.createDashboard(MessageFormat.format(DashboardDocumentPane.this.getResourceString("Dashboard.untitled"), n));
                DashboardDocumentPane.this.getGadgetManager().addDashboard((Dashboard)object);
                DashboardDocumentPane.this.setActiveDocument(((Dashboard)object).getKey());
            }
        });
        if (this._toggleAction == null) {
            this._toggleAction = new AbstractAction(this.getResourceString("GadgetPalette.show"), this.getImageIcon("icons/property.png")){
                private static final long serialVersionUID = 799265632345872546L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DashboardDocumentPane.this.togglePalette((Component)actionEvent.getSource());
                }
            };
        }
        JideButton jideButton2 = new JideButton(this._toggleAction);
        UIResourceToolBar uIResourceToolBar = new UIResourceToolBar();
        uIResourceToolBar.setOpaque(false);
        uIResourceToolBar.setRollover(true);
        uIResourceToolBar.setFloatable(false);
        uIResourceToolBar.putClientProperty("Synthetica.opaque", false);
        uIResourceToolBar.add(jideButton);
        uIResourceToolBar.add(jideButton2);
        return uIResourceToolBar;
    }

    @Override
    public Dashboard createDashboard(String string) {
        return new Dashboard(string);
    }

    private void layoutPalette() {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null && this._gadgetPalette != null) {
            JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
            this.layoutPalette(jLayeredPane);
        }
    }

    @Override
    protected boolean isDocumentGroupEmpty(IDocumentGroup iDocumentGroup) {
        return super.isDocumentGroupEmpty(iDocumentGroup) && (!(iDocumentGroup instanceof JideTabbedPane) || ((JideTabbedPane)((Object)iDocumentGroup)).getTabLeadingComponent() == null);
    }

    @Override
    public void eventHappened(GadgetEvent gadgetEvent) {
    }

    @Override
    public void eventHappened(DashboardEvent dashboardEvent) {
        if (dashboardEvent.getID() == 13099) {
            DocumentComponent documentComponent;
            Dashboard dashboard = (Dashboard)dashboardEvent.getSource();
            if (!this.isDocumentOpened(dashboard.getKey())) {
                documentComponent = this.createDocumentComponent(dashboard);
                this.openDocument(documentComponent);
            } else {
                documentComponent = this.getDocument(dashboard.getKey());
            }
            if (this._documentComponentListener == null) {
                this._documentComponentListener = new DocumentComponentAdapter(){

                    @Override
                    public void documentComponentOpened(DocumentComponentEvent documentComponentEvent) {
                        JComponent jComponent = documentComponentEvent.getDocumentComponent().getComponent();
                        if (jComponent instanceof JScrollPane) {
                            DashboardDocumentPane.this._gadgetManager.addDashboard((Dashboard)((JScrollPane)jComponent).getViewport().getView());
                        }
                    }

                    @Override
                    public void documentComponentClosed(DocumentComponentEvent documentComponentEvent) {
                        DashboardDocumentPane.this._gadgetManager.removeDashboard(documentComponentEvent.getDocumentComponent().getName());
                    }
                };
            }
            documentComponent.addDocumentComponentListener(this._documentComponentListener);
            if (this._propertyChangeListener == null) {
                this._propertyChangeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        String string = propertyChangeEvent.getPropertyName();
                        if (propertyChangeEvent.getSource() instanceof Dashboard) {
                            Dashboard dashboard = (Dashboard)propertyChangeEvent.getSource();
                            if ("title".equals(string)) {
                                DashboardDocumentPane.this.getDocument(dashboard.getKey()).setTitle((String)propertyChangeEvent.getNewValue());
                            } else if ("icon".equals(string)) {
                                DashboardDocumentPane.this.getDocument(dashboard.getKey()).setIcon((Icon)propertyChangeEvent.getNewValue());
                            }
                        }
                    }
                };
            }
            if (dashboard.getClientProperty("Dashboard.titlePropertyChangeListener") != this._propertyChangeListener) {
                dashboard.addPropertyChangeListener("title", this._propertyChangeListener);
                dashboard.putClientProperty("Dashboard.titlePropertyChangeListener", this._propertyChangeListener);
            }
        } else if (dashboardEvent.getID() == 13100) {
            DocumentComponent documentComponent;
            String string;
            DocumentComponent documentComponent2;
            Dashboard dashboard = (Dashboard)dashboardEvent.getSource();
            if (dashboard == null) {
                return;
            }
            String string2 = dashboard.getKey();
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)dashboard.getClientProperty("Dashboard.titlePropertyChangeListener");
            if (propertyChangeListener != null) {
                dashboard.removePropertyChangeListener("title", propertyChangeListener);
                dashboard.putClientProperty("Dashboard.titlePropertyChangeListener", null);
            }
            if ((documentComponent2 = this.getDocument(string2)) != null && this._documentComponentListener != null) {
                documentComponent2.removeDocumentComponentListener(this._documentComponentListener);
            }
            if (this.isDocumentOpened(string2)) {
                this.closeDocument(string2);
            }
            if (JideSwingUtilities.equals(this._gadgetManager.getActiveDashboardKey(), string2) && (string = (documentComponent = this.getActiveDocument()).getName()) != null) {
                this._gadgetManager.setActiveDashboardKey(string);
            }
        } else if (dashboardEvent.getID() != 13101 && dashboardEvent.getID() == 13102) {
            Dashboard dashboard = (Dashboard)dashboardEvent.getSource();
            this.setActiveDocument(dashboard.getKey());
        }
    }

    protected DocumentComponent createDocumentComponent(final Dashboard dashboard) {
        DocumentComponent documentComponent = new DocumentComponent(new JScrollPane(dashboard), dashboard.getKey(), dashboard.getTitle(), dashboard.getIcon());
        documentComponent.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getNewValue();
                if ("title".equals(propertyChangeEvent.getPropertyName())) {
                    if (object instanceof String) {
                        dashboard.setTitle((String)object);
                    }
                } else if ("icon".equals(propertyChangeEvent.getPropertyName()) && object instanceof Icon) {
                    dashboard.setIcon((Icon)object);
                }
            }
        });
        return documentComponent;
    }

    @Override
    public void setActiveDocument(String string, boolean bl) {
        super.setActiveDocument(string, bl);
        this.getGadgetManager().setActiveDashboardKey(string);
    }

    public int getDashboardCount() {
        return this.getDocumentCount();
    }

    public Dashboard getDashboardAt(int n) {
        DocumentComponent documentComponent = this.getDocumentAt(n);
        JComponent jComponent = documentComponent.getComponent();
        if (jComponent instanceof JScrollPane) {
            return (Dashboard)((JScrollPane)jComponent).getViewport().getView();
        }
        return null;
    }

    public int indexOfDashboard(Dashboard dashboard) {
        return this.indexOfDocument(dashboard.getKey());
    }

    public void togglePalette(Component component) {
        if (this.isPaletteVisible(component)) {
            this.hidePalette();
        } else {
            this.showPalette(component);
        }
    }

    private void layoutPalette(JLayeredPane jLayeredPane) {
        if (this._gadgetPalette != null) {
            if (!this.isUseFloatingPalette() && this._gadgetPalette.getParent() != null && this._gadgetPalette.getParent().getLayout() instanceof BorderLayout) {
                this._gadgetPalette.validate();
            } else {
                Rectangle rectangle = this.getBounds();
                rectangle = SwingUtilities.convertRectangle(this.getParent(), rectangle, jLayeredPane);
                Insets insets = this.getInsets();
                Dimension dimension = this._gadgetPalette.getPreferredSize();
                switch (this.getPaletteSide()) {
                    case 7: {
                        rectangle.width = dimension.width;
                        rectangle.y += insets.top + 1;
                        rectangle.height -= insets.top + insets.bottom + 2;
                        break;
                    }
                    case 3: {
                        rectangle.x = rectangle.x + rectangle.width - dimension.width;
                        rectangle.width = dimension.width;
                        rectangle.y += insets.top + 1;
                        rectangle.height -= insets.top + insets.bottom + 2;
                        break;
                    }
                    case 1: {
                        rectangle.y = 0;
                        rectangle.height = dimension.height;
                        rectangle.x += insets.left + 1;
                        rectangle.width -= insets.left + insets.right + 2;
                        rectangle.y += insets.top;
                        break;
                    }
                    default: {
                        rectangle.y = rectangle.y + rectangle.height - dimension.height;
                        rectangle.height = dimension.height;
                        rectangle.x += insets.left + 1;
                        rectangle.width -= insets.left + insets.right + 2;
                        rectangle.y -= insets.bottom;
                    }
                }
                this._gadgetPalette.setBounds(rectangle);
                this._gadgetPalette.validate();
            }
        }
    }

    public Container getValidParent(Component component) {
        do {
            if (component.getParent() == null || !(component.getParent().getLayout() instanceof BorderLayout)) continue;
            return component.getParent();
        } while ((component = component.getParent()) != null);
        return null;
    }

    public boolean isPaletteVisible(Component component) {
        if (this._gadgetPalette == null || !this._gadgetPalette.isVisible()) {
            return false;
        }
        Container container = this.getValidParent(component);
        if (!this.isUseFloatingPalette() && container != null) {
            if (this._gadgetPalette != null && container != this._gadgetPalette.getParent()) {
                return false;
            }
        } else {
            JRootPane jRootPane = null;
            List<FloatingDocumentContainer> list = this.getFloatingContainers();
            for (FloatingDocumentContainer floatingDocumentContainer : list) {
                if (!floatingDocumentContainer.isActive()) continue;
                jRootPane = floatingDocumentContainer.getRootPane();
                break;
            }
            if (jRootPane == null) {
                jRootPane = this.getRootPane();
            }
            if (jRootPane != null && this._gadgetPalette != null && container != this._gadgetPalette.getParent()) {
                return false;
            }
        }
        return true;
    }

    public void setPaletteSide(int n) {
        if (this._paletteSide != n) {
            this._paletteSide = n;
            boolean bl = this.isPaletteVisible(this);
            if (bl) {
                this.hidePalette();
            }
            this._gadgetPalette = null;
            if (bl) {
                this.showPalette(this);
            }
        }
    }

    @Override
    public int getPaletteSide() {
        return this._paletteSide;
    }

    @Override
    public void showPalette(Component component) {
        if (this._gadgetPalette != null) {
            this.hidePalette();
        }
        Container container = this.getValidParent(component);
        if (!this.isUseFloatingPalette() && container != null) {
            if (this._gadgetPalette == null) {
                this._gadgetPalette = this.createGadgetPalette();
                if (this._toggleAction != null && SystemInfo.isJdk6Above()) {
                    this._toggleAction.putValue("SwingSelectedKey", true);
                }
                switch (this.getPaletteSide()) {
                    case 3: {
                        container.add((Component)this._gadgetPalette, "After");
                        break;
                    }
                    case 7: {
                        container.add((Component)this._gadgetPalette, "Before");
                        break;
                    }
                    case 1: {
                        container.add((Component)this._gadgetPalette, "First");
                        break;
                    }
                    default: {
                        container.add((Component)this._gadgetPalette, "Last");
                    }
                }
                container.validate();
            }
        } else {
            JRootPane jRootPane = null;
            List<FloatingDocumentContainer> list = this.getFloatingContainers();
            for (FloatingDocumentContainer floatingDocumentContainer : list) {
                if (!floatingDocumentContainer.isActive()) continue;
                jRootPane = floatingDocumentContainer.getRootPane();
                break;
            }
            if (jRootPane == null) {
                jRootPane = this.getRootPane();
            }
            if (jRootPane != null && this._gadgetPalette == null) {
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                this._gadgetPalette = this.createGadgetPalette();
                jLayeredPane.add((Component)this._gadgetPalette, JLayeredPane.PALETTE_LAYER);
                this.layoutPalette(jLayeredPane);
                if (this._toggleAction != null && SystemInfo.isJdk6Above()) {
                    this._toggleAction.putValue("SwingSelectedKey", true);
                }
            }
        }
    }

    protected GadgetPalette createGadgetPalette() {
        return new GadgetPalette(this._gadgetManager, this);
    }

    @Override
    public void hidePalette() {
        if (this._gadgetPalette != null) {
            Container container = this._gadgetPalette.getParent();
            this._gadgetPalette.setVisible(false);
            if (container != null) {
                container.remove(this._gadgetPalette);
                container.validate();
                container.repaint();
            }
            this._gadgetPalette = null;
            if (this._toggleAction != null && SystemInfo.isJdk6Above()) {
                this._toggleAction.putValue("SwingSelectedKey", false);
            }
        }
    }

    @Override
    public Dashboard getActiveDashboard() {
        return this._gadgetManager.getDashboard(this.getActiveDocumentName());
    }

    public boolean isUseFloatingPalette() {
        return this._useFloatingPalette;
    }

    public void setUseFloatingPalette(boolean bl) {
        this._useFloatingPalette = bl;
    }

    public void setToolBarAlignment(int n) {
        this._toolbarAlignment = n;
        final DocumentPane.TabbedPaneCustomizer tabbedPaneCustomizer = this.getTabbedPaneCustomizer();
        if (tabbedPaneCustomizer != null) {
            JideSwingUtilities.setRecursively(this, new JideSwingUtilities.Handler(){

                @Override
                public boolean condition(Component component) {
                    return component instanceof IDocumentGroup;
                }

                @Override
                public void action(Component component) {
                    if (component instanceof JideTabbedPane) {
                        tabbedPaneCustomizer.customize((JideTabbedPane)component);
                    }
                }

                @Override
                public void postAction(Component component) {
                }
            });
        }
    }

    public int getToolBarAlignment() {
        return this._toolbarAlignment;
    }

    protected ImageIcon getImageIcon(String string) {
        return IconsFactory.getImageIcon(DashboardDocumentPane.class, string);
    }

    @Override
    protected String getResourceString(String string) {
        try {
            return DashboardResource.getResourceBundle(this.getLocale()).getString(string);
        }
        catch (Exception exception) {
            return super.getResourceString(string);
        }
    }

    @Override
    public void closeAll() {
        super.closeAll();
        for (int i = 0; i < this.getDocumentGroupCount(); ++i) {
            IDocumentGroup iDocumentGroup = this.getDocumentGroupAt(i);
            Container container = ((Component)((Object)iDocumentGroup)).getParent();
            if (container == null) continue;
            JideSwingUtilities.removeFromParentWithFocusTransfer((Component)((Object)iDocumentGroup));
            if (!(iDocumentGroup instanceof TdiGroup)) continue;
            ((TdiGroup)iDocumentGroup).uninstallListeners();
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(1024)) {
            Lm.showInvalidProductMessage(DashboardDocumentPane.class.getName(), 1024);
        }
    }

    class UIResourceToolBar
    extends JToolBar
    implements UIResource {
    }
}

