/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dashboard;

import com.jidesoft.dashboard.DefaultPlaceHolder;
import com.jidesoft.dashboard.Gadget;
import com.jidesoft.dashboard.GadgetComponent;
import com.jidesoft.dashboard.GadgetContainer;
import com.jidesoft.dashboard.GadgetEvent;
import com.jidesoft.dashboard.GadgetManager;
import com.jidesoft.dashboard.PlaceHolder;
import com.jidesoft.dashboard.PredefinedLayoutAdapter;
import com.jidesoft.dashboard.ResizableGadgetContainer;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSplitPaneLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class Dashboard
extends JPanel
implements Scrollable {
    int _columnCount = 0;
    public static final int H_GAP = 6;
    public static final int V_GAP = 6;
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_COLUMN_COUNT = "columnCount";
    private String _key;
    private String _title;
    private Icon _icon;
    private static int _defaultColumnCount;
    private Map<String, String> _settings;
    private JPanel _normalGadgetContainer;
    private JPanel _maximizedGadgetContainer;
    private boolean _showGripper = true;
    private int _maximizedColumn = -1;
    private int _maximizedRow = -1;
    private int _maximizedIndex = -1;
    private Object _maximizedConstraints = null;
    private Component _maximizedComponent;
    private boolean _columnResizable = false;
    private boolean _rowResizable = false;
    private static final String CONTAINER_NORMAL = "normal";
    private static final String CONTAINER_MAXIMIZED = "maximized";
    private LayoutManager _predefinedLayout = null;
    private PredefinedLayoutAdapter _layoutAdapter;
    private List<Object> _constraintsList;
    private MouseAdapter _handler;
    public static final int COMPONENT_MAXIMIZED = -2;

    public Dashboard() {
        this.initDashboard();
        this.setColumnCount(Dashboard.getDefaultColumnCount());
    }

    public Dashboard(String string) {
        this._key = string;
        this.initDashboard();
        this.setColumnCount(Dashboard.getDefaultColumnCount());
    }

    public Dashboard(String string, String string2) {
        this._key = string;
        this._title = string2;
        this.initDashboard();
        this.setColumnCount(Dashboard.getDefaultColumnCount());
    }

    public Dashboard(String string, String string2, Icon icon) {
        this._key = string;
        this._title = string2;
        this._icon = icon;
        this.initDashboard();
        this.setColumnCount(Dashboard.getDefaultColumnCount());
    }

    public Dashboard(String string, String string2, int n) {
        this._key = string;
        this._title = string2;
        this.initDashboard();
        this.setColumnCount(n);
    }

    public Dashboard(String string, String string2, Icon icon, int n) {
        this._key = string;
        this._title = string2;
        this._icon = icon;
        this.initDashboard();
        this.setColumnCount(n);
    }

    public static int getDefaultColumnCount() {
        return _defaultColumnCount;
    }

    public static void setDefaultColumnCount(int n) {
        _defaultColumnCount = n;
    }

    protected void initDashboard() {
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.setLayout(new CardLayout());
        this._normalGadgetContainer = this.createNormalGadgetContainer(this.isColumnResizable());
        this._maximizedGadgetContainer = this.createMaximizedGadgetContainer();
        this._maximizedGadgetContainer.setOpaque(false);
        this.add((Component)this.getNormalGadgetContainer(), CONTAINER_NORMAL);
        this.add((Component)this.getMaximizedGadgetContainer(), CONTAINER_MAXIMIZED);
    }

    public int getColumnIndex(JComponent jComponent) {
        if (jComponent.getParent() == this._maximizedGadgetContainer) {
            return -2;
        }
        int n = this.getColumnCount() - 1;
        for (int i = this._normalGadgetContainer.getComponentCount() - 1; i >= 0; --i) {
            Component component = this._normalGadgetContainer.getComponent(i);
            if (!GadgetManager.isGadgetContainer(component)) continue;
            if (component == jComponent.getParent()) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public int getRowIndex(JComponent jComponent) {
        if (jComponent.getParent() == this._maximizedGadgetContainer) {
            return -2;
        }
        for (int i = this._normalGadgetContainer.getComponentCount() - 1; i >= 0; --i) {
            Component component = this._normalGadgetContainer.getComponent(i);
            if (component != jComponent.getParent()) continue;
            if (component instanceof GadgetContainer) {
                return JideSwingUtilities.getComponentIndex((Container)component, jComponent);
            }
            if (!(component instanceof ResizableGadgetContainer)) continue;
            return ((ResizableGadgetContainer)component).indexOfPane(jComponent);
        }
        return -1;
    }

    private void fireColumnResizeEvents(Component component) {
        Component[] componentArray;
        if (!GadgetManager.isGadgetContainer(component)) {
            return;
        }
        if (((JideSplitPaneLayout)this._normalGadgetContainer.getLayout()).getConstraintMap().get(component) == "fix") {
            return;
        }
        for (Component component2 : componentArray = ((Container)component).getComponents()) {
            if (!(component2 instanceof GadgetComponent)) continue;
            Gadget gadget = ((GadgetComponent)((Object)component2)).getGadget();
            gadget.getGadgetManager().fireGadgetEvent(new GadgetEvent(gadget, 13207, (GadgetComponent)((Object)component2)));
        }
    }

    @Deprecated
    protected JPanel createNormalGadgetContainer() {
        return this.createNormalGadgetContainer(true);
    }

    protected JPanel createNormalGadgetContainer(boolean bl) {
        if (bl && !this.isPredefinedLayoutSet()) {
            JideSplitPane jideSplitPane = new JideSplitPane();
            jideSplitPane.setShowGripper(this._showGripper);
            jideSplitPane.setLayout(this.getDashboardLayout(jideSplitPane));
            jideSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object = propertyChangeEvent.getSource();
                    if ("dividerLocation".equals(propertyChangeEvent.getPropertyName()) && object instanceof JideSplitPane) {
                        JideSplitPane jideSplitPane = (JideSplitPane)object;
                        for (int i = 0; i < jideSplitPane.getComponentCount(); ++i) {
                            Component component = jideSplitPane.getComponent(i);
                            if (!(component instanceof JideSplitPaneDivider) || component.getBounds().x != (Integer)propertyChangeEvent.getOldValue()) continue;
                            if (i > 0) {
                                Dashboard.this.fireColumnResizeEvents(jideSplitPane.getComponent(i - 1));
                            }
                            if (i >= jideSplitPane.getComponentCount() - 1) break;
                            Dashboard.this.fireColumnResizeEvents(jideSplitPane.getComponent(i + 1));
                            break;
                        }
                    }
                }
            });
            return jideSplitPane;
        }
        JPanel jPanel = new JPanel(){

            @Override
            protected void addImpl(Component component, Object object, int n) {
                super.addImpl(component, object, n);
                if (Dashboard.this.isPredefinedLayoutSet()) {
                    if (n < 0) {
                        Dashboard.this.getConstraintsList().add(object);
                    } else if (n <= Dashboard.this.getConstraintsList().size()) {
                        Dashboard.this.getConstraintsList().add(n, object);
                    }
                }
            }

            @Override
            public void removeAll() {
                super.removeAll();
                if (Dashboard.this.isPredefinedLayoutSet()) {
                    Dashboard.this.getConstraintsList().clear();
                }
            }

            @Override
            public void remove(int n) {
                super.remove(n);
                if (Dashboard.this.isPredefinedLayoutSet() && n >= 0 && n < Dashboard.this.getConstraintsList().size()) {
                    Dashboard.this.getConstraintsList().remove(n);
                }
            }
        };
        jPanel.setLayout(this.getDashboardLayout(jPanel));
        jPanel.setOpaque(false);
        if (this.isPredefinedLayoutSet() && this.getLayoutAdapter() != null) {
            if (this._handler == null) {
                this._handler = new MouseAdapter(){
                    private Dimension _originalSize;
                    private Point _originalPosition;
                    private int _resizeDirection;
                    private Component _compToResize;

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        this._compToResize = Dashboard.this.getComponentAtLeft(mouseEvent.getPoint());
                        this._resizeDirection = 0;
                        if (this._compToResize == null) {
                            this._compToResize = Dashboard.this.getComponentAtTop(mouseEvent.getPoint());
                            this._resizeDirection = 1;
                        }
                        if (this._compToResize != null) {
                            this._originalPosition = mouseEvent.getPoint();
                            this._originalSize = this._compToResize.getSize();
                        }
                    }

                    @Override
                    public void mouseMoved(MouseEvent mouseEvent) {
                        Component component = Dashboard.this.getComponentAtLeft(mouseEvent.getPoint());
                        if (component != null) {
                            Dashboard.this.getNormalGadgetContainer().setCursor(JideCursors.getPredefinedCursor(20));
                            return;
                        }
                        component = Dashboard.this.getComponentAtTop(mouseEvent.getPoint());
                        if (component != null) {
                            Dashboard.this.getNormalGadgetContainer().setCursor(JideCursors.getPredefinedCursor(21));
                            return;
                        }
                        Dashboard.this.getNormalGadgetContainer().setCursor(Cursor.getDefaultCursor());
                    }

                    @Override
                    public void mouseDragged(MouseEvent mouseEvent) {
                        if (Dashboard.this.getLayoutAdapter() != null && this._originalPosition != null && this._compToResize != null) {
                            int n;
                            if (this._resizeDirection == 0) {
                                n = mouseEvent.getX() - this._originalPosition.x;
                                Dashboard.this.getNormalGadgetContainer().setCursor(JideCursors.getPredefinedCursor(20));
                            } else {
                                n = mouseEvent.getY() - this._originalPosition.y;
                                Dashboard.this.getNormalGadgetContainer().setCursor(JideCursors.getPredefinedCursor(21));
                            }
                            Dashboard.this.getLayoutAdapter().resizeComponent(Dashboard.this.getNormalGadgetContainer().getLayout(), this._compToResize, this._resizeDirection, this._originalSize, n);
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        this._compToResize = null;
                        this._originalSize = null;
                        this._originalPosition = null;
                        Dashboard.this.getNormalGadgetContainer().setCursor(Cursor.getDefaultCursor());
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        Dashboard.this.getNormalGadgetContainer().setCursor(Cursor.getDefaultCursor());
                    }
                };
            }
            jPanel.addMouseListener(this._handler);
            jPanel.addMouseMotionListener(this._handler);
        }
        return jPanel;
    }

    protected Component getComponentAtLeft(Point point) {
        if (this.isPredefinedLayoutSet() && this.getLayoutAdapter() != null) {
            for (Component component : this.getNormalGadgetContainer().getComponents()) {
                if (point.x < component.getX() + component.getWidth() - 1 || point.x > component.getX() + component.getWidth() + 3 || point.y < component.getY() || point.y > component.getY() + component.getHeight()) continue;
                if (this.getLayoutAdapter().isComponentResizable(this.getPredefinedLayout(), component, 0)) {
                    return component;
                }
                return null;
            }
        }
        return null;
    }

    protected Component getComponentAtTop(Point point) {
        if (this.isPredefinedLayoutSet()) {
            for (Component component : this.getNormalGadgetContainer().getComponents()) {
                if (point.y < component.getY() + component.getHeight() - 1 || point.y > component.getY() + component.getHeight() + 3 || point.x < component.getX() || point.x > component.getX() + component.getWidth()) continue;
                if (this.getLayoutAdapter().isComponentResizable(this.getPredefinedLayout(), component, 1)) {
                    return component;
                }
                return null;
            }
        }
        return null;
    }

    protected LayoutManager getDashboardLayout(Container container) {
        if (this.isPredefinedLayoutSet()) {
            return this._predefinedLayout;
        }
        if (this.isColumnResizable()) {
            return new DashboardLayout(container);
        }
        return new GridLayout(1, this.getColumnCount(), 6, 6);
    }

    public void addPlaceHolder() {
        this.addPlaceHolder(null);
    }

    public void addPlaceHolder(Object object) {
        this.addPlaceHolder(this.createDefaultPlaceHolder(), object);
    }

    private void addPlaceHolder(Object object, int n) {
        this.addPlaceHolder(this.createDefaultPlaceHolder(), object, n);
    }

    public void addPlaceHolder(PlaceHolder placeHolder, Object object) {
        if (this.isPredefinedLayoutSet() && placeHolder instanceof Component) {
            this.getNormalGadgetContainer().add((Component)((Object)placeHolder), object);
        }
    }

    private void addPlaceHolder(PlaceHolder placeHolder, Object object, int n) {
        if (this.isPredefinedLayoutSet() && placeHolder instanceof Component && n >= 0 && n <= this.getNormalGadgetContainer().getComponentCount()) {
            this.getNormalGadgetContainer().add((Component)((Object)placeHolder), object, n);
        }
    }

    public void removePredefinedGadgetPosition(int n) {
        if (this.isPredefinedLayoutSet()) {
            this.getNormalGadgetContainer().remove(n);
        }
    }

    protected PlaceHolder createDefaultPlaceHolder() {
        DefaultPlaceHolder defaultPlaceHolder = new DefaultPlaceHolder(this.getImageIcon("icons/dashboard.png"));
        defaultPlaceHolder.setPreferredSize(new Dimension(200, 200));
        return defaultPlaceHolder;
    }

    private int getComponentIndex(JComponent jComponent) {
        int n = this.getNormalGadgetContainer().getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (this.getNormalGadgetContainer().getComponent(i) != jComponent) continue;
            return i;
        }
        return -1;
    }

    protected ImageIcon getImageIcon(String string) {
        return IconsFactory.getImageIcon(Dashboard.class, string);
    }

    protected JPanel createMaximizedGadgetContainer() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        jPanel.putClientProperty("Dashboard.MaximizedGadgetContainer", true);
        return jPanel;
    }

    public void showNormalGadgetContainer() {
        if (this.getLayout() instanceof CardLayout) {
            ((CardLayout)this.getLayout()).show(this, CONTAINER_NORMAL);
        }
    }

    public void showMaximizedGadgetContainer() {
        if (this.getLayout() instanceof CardLayout) {
            ((CardLayout)this.getLayout()).show(this, CONTAINER_MAXIMIZED);
        }
    }

    @Deprecated
    public void maximizeGadget(GadgetComponent gadgetComponent) {
        this.maximizeGadgetComponent(gadgetComponent);
    }

    public void maximizeGadgetComponent(GadgetComponent gadgetComponent) {
        if (!(gadgetComponent instanceof JComponent)) {
            return;
        }
        if (this.isPredefinedLayoutSet()) {
            int n = this.getComponentIndex((JComponent)((Object)gadgetComponent));
            this.maximizeGadgetComponent(n);
            return;
        }
        int n = this.getColumnIndex((JComponent)((Object)gadgetComponent));
        int n2 = this.getRowIndex((JComponent)((Object)gadgetComponent));
        this.maximizeGadgetComponent(n, n2);
    }

    @Deprecated
    public void maximizeGadget(int n, int n2) {
        this.maximizeGadgetComponent(n, n2);
    }

    public void maximizeGadgetComponent(int n) {
        if (n >= this.getNormalGadgetContainer().getComponentCount() || n < 0 || !this.isPredefinedLayoutSet()) {
            return;
        }
        Component component = this.getNormalGadgetContainer().getComponent(n);
        this.restoreGadgetComponent();
        this.setMaximizedComponent(component);
        this.setMaximizedIndex(n);
        this.setMaximizedConstraints(this.getComponentConstraints(n));
        this.getNormalGadgetContainer().remove(n);
        this.getMaximizedGadgetContainer().add(component);
        if (component instanceof GadgetComponent) {
            Gadget gadget = ((GadgetComponent)((Object)component)).getGadget();
            gadget.getGadgetManager().fireGadgetEvent(new GadgetEvent(gadget, 13205, (GadgetComponent)((Object)component)));
        }
        this.showMaximizedGadgetContainer();
    }

    public void maximizeGadgetComponent(int n, int n2) {
        Object object;
        if (n >= this.getColumnCount() || n < 0) {
            return;
        }
        Container container = this.getGadgetContainer(n);
        int n3 = GadgetManager.getGadgetContainerComponentCount(container);
        if (n2 >= n3) {
            return;
        }
        Component component = GadgetManager.getGadgetComponent(container, n2);
        if (this.getMaximizedColumn() == n && this.getMaximizedRow() <= n2) {
            ++n2;
        }
        this.restoreGadgetComponent();
        this.setMaximizedColumn(n);
        this.setMaximizedRow(n2);
        this.setMaximizedComponent(component);
        GadgetManager.removeGadgetComponent(container, component);
        this.getMaximizedGadgetContainer().add(component);
        if (component instanceof GadgetComponent) {
            object = ((GadgetComponent)((Object)component)).getGadget();
            object.getGadgetManager().fireGadgetEvent(new GadgetEvent(object, 13205, (GadgetComponent)((Object)component)));
        }
        this.showMaximizedGadgetContainer();
        object = SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (object != null && this.getParent() instanceof JViewport) {
            this.setPreferredSize(this.getParent().getSize());
        }
    }

    @Deprecated
    public void restoreGadget() {
        this.restoreGadgetComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreGadgetComponent() {
        try {
            Object object;
            Component component = this.getMaximizedComponent();
            if (this.isPredefinedLayoutSet()) {
                if (this.getMaximizedIndex() >= 0 && this.getMaximizedIndex() <= this.getNormalGadgetContainer().getComponentCount() && component != null) {
                    this.getNormalGadgetContainer().add(component, this.getMaximizedConstraints(), this.getMaximizedIndex());
                }
            } else {
                if (component == null || this.getMaximizedColumn() < 0 || this.getMaximizedColumn() >= this.getColumnCount()) {
                    return;
                }
                object = this.getGadgetContainer(this.getMaximizedColumn());
                int n = GadgetManager.getGadgetContainerComponentCount((Container)object);
                int n2 = this.getMaximizedRow();
                if (n2 > n) {
                    n2 = n;
                }
                GadgetManager.addGadgetComponent((Container)object, component, n2);
            }
            if (component != null) {
                this.getMaximizedGadgetContainer().remove(component);
            }
            if (component instanceof GadgetComponent) {
                object = ((GadgetComponent)((Object)component)).getGadget();
                object.getGadgetManager().fireGadgetEvent(new GadgetEvent(object, 13206, (GadgetComponent)((Object)component)));
            }
        }
        finally {
            this.setMaximizedComponent(null);
            this.setMaximizedColumn(-1);
            this.setMaximizedRow(-1);
            this.setMaximizedIndex(-1);
            this.setMaximizedConstraints(null);
            this.showNormalGadgetContainer();
            this.setPreferredSize(null);
        }
    }

    public void setShowGripper(boolean bl) {
        if (this._normalGadgetContainer != null && this._normalGadgetContainer instanceof JideSplitPane) {
            ((JideSplitPane)this._normalGadgetContainer).setShowGripper(bl);
        }
        this._showGripper = bl;
    }

    public boolean isShowGripper() {
        return this._normalGadgetContainer != null && this._normalGadgetContainer instanceof JideSplitPane && ((JideSplitPane)this._normalGadgetContainer).isShowGripper();
    }

    protected JPanel createSubpanel() {
        if (!this.isRowResizable()) {
            GadgetContainer gadgetContainer = new GadgetContainer(6);
            gadgetContainer.add(Box.createGlue(), "vary");
            return gadgetContainer;
        }
        return new ResizableGadgetContainer(6);
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public void setColumnCount(int n) {
        int n2 = this._columnCount;
        if (n2 != n) {
            this.restoreGadgetComponent();
            this._columnCount = n;
            if (this._columnCount > n2) {
                for (int i = n2; i < this._columnCount; ++i) {
                    this.getNormalGadgetContainer().add(this.createSubpanel());
                }
            } else {
                if (this._columnCount == 0) {
                    this.getNormalGadgetContainer().removeAll();
                    this.getMaximizedGadgetContainer().removeAll();
                    return;
                }
                Container container = (Container)this.getNormalGadgetContainer().getComponent(this.getNormalGadgetContainer() instanceof JideSplitPane ? this._columnCount * 2 : this._columnCount - 1);
                for (int i = this._columnCount; i < n2; ++i) {
                    Component[] componentArray;
                    Container container2 = (Container)this.getNormalGadgetContainer().getComponent(this.getNormalGadgetContainer() instanceof JideSplitPane ? this._columnCount * 2 : this._columnCount);
                    block2: for (Component component : componentArray = container2.getComponents()) {
                        if (!(component instanceof GadgetComponent)) continue;
                        Component[] componentArray2 = container.getComponents();
                        for (int j = 0; j < componentArray2.length; ++j) {
                            Component component2 = componentArray2[j];
                            if (component2 instanceof GadgetComponent) continue;
                            container.add(component, j);
                            continue block2;
                        }
                    }
                    this.getNormalGadgetContainer().remove(container2);
                }
            }
            this.invalidate();
            this.revalidate();
            this.doLayout();
            this.firePropertyChange(PROPERTY_COLUMN_COUNT, n2, this._columnCount);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
    }

    public String getTitle() {
        if (this._title == null) {
            return this.getKey();
        }
        return this._title;
    }

    public void setTitle(String string) {
        String string2 = this._title;
        if (!JideSwingUtilities.equals(string, this._title)) {
            this._title = string;
            this.firePropertyChange(PROPERTY_TITLE, string2, this._title);
        }
    }

    public String getKey() {
        return this._key;
    }

    public void setKey(String string) {
        String string2 = this._key;
        if (!JideSwingUtilities.equals(string, this._key)) {
            this._key = string;
            this.firePropertyChange(PROPERTY_KEY, string2, this._key);
        }
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        String string = this._key;
        if (icon != this._icon) {
            this._icon = icon;
            this.firePropertyChange(PROPERTY_ICON, string, this._icon);
        }
    }

    public Map<String, String> getSettings() {
        if (this._settings == null) {
            this._settings = new HashMap<String, String>();
        }
        return this._settings;
    }

    public void setSettings(Map<String, String> map) {
        this._settings = map;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return rectangle.height;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            int n = jViewport.getHeight();
            Dimension dimension = this.getPreferredSize();
            Dimension dimension2 = this.getMaximumSize();
            if (n >= dimension.height && n <= dimension2.height) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            int n = jViewport.getWidth();
            Dimension dimension = this.getMinimumSize();
            Dimension dimension2 = this.getMaximumSize();
            if (n >= dimension.width && n <= dimension2.width) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public GadgetComponent[] getGadgetComponents() {
        final ArrayList arrayList = new ArrayList();
        JideSwingUtilities.setRecursively(this, new JideSwingUtilities.Handler(){

            @Override
            public boolean condition(Component component) {
                return component instanceof GadgetComponent;
            }

            @Override
            public void action(Component component) {
                arrayList.add((GadgetComponent)((Object)component));
            }

            @Override
            public void postAction(Component component) {
            }
        });
        return arrayList.toArray(new GadgetComponent[arrayList.size()]);
    }

    public Container getGadgetContainer(int n) {
        if (n >= this.getColumnCount() || n < 0) {
            return null;
        }
        Component component = this.getNormalGadgetContainer() instanceof JideSplitPane ? ((JideSplitPane)this.getNormalGadgetContainer()).getPaneAt(n) : this.getNormalGadgetContainer().getComponent(n);
        return GadgetManager.isGadgetContainer(component) ? (Container)component : null;
    }

    JPanel getNormalGadgetContainer() {
        return this._normalGadgetContainer;
    }

    JPanel getMaximizedGadgetContainer() {
        return this._maximizedGadgetContainer;
    }

    int getMaximizedColumn() {
        return this._maximizedColumn;
    }

    void setMaximizedColumn(int n) {
        this._maximizedColumn = n;
    }

    int getMaximizedRow() {
        return this._maximizedRow;
    }

    void setMaximizedRow(int n) {
        this._maximizedRow = n;
    }

    Component getMaximizedComponent() {
        return this._maximizedComponent;
    }

    void setMaximizedComponent(Component component) {
        this._maximizedComponent = component;
    }

    int getMaximizedIndex() {
        return this._maximizedIndex;
    }

    void setMaximizedIndex(int n) {
        this._maximizedIndex = n;
    }

    Object getMaximizedConstraints() {
        return this._maximizedConstraints;
    }

    void setMaximizedConstraints(Object object) {
        this._maximizedConstraints = object;
    }

    public boolean isColumnResizable() {
        return this._columnResizable;
    }

    public void setColumnResizable(boolean bl) {
        if (this.isPredefinedLayoutSet() || this._columnResizable == bl) {
            return;
        }
        this._columnResizable = bl;
        Container[] containerArray = new Container[this.getColumnCount()];
        for (int i = 0; i < containerArray.length; ++i) {
            containerArray[i] = this.getGadgetContainer(i);
        }
        this._normalGadgetContainer.setVisible(false);
        this.remove(this._normalGadgetContainer);
        this._normalGadgetContainer = this.createNormalGadgetContainer(this._columnResizable);
        this.add((Component)this._normalGadgetContainer, CONTAINER_NORMAL);
        for (Container container : containerArray) {
            if (container == null) {
                this._normalGadgetContainer.add(this.createSubpanel());
                continue;
            }
            this._normalGadgetContainer.add(container);
        }
        this.showNormalGadgetContainer();
        this.doLayout();
    }

    public boolean isRowResizable() {
        return this._rowResizable;
    }

    public void setRowResizable(boolean bl) {
        if (this._rowResizable != bl) {
            this._rowResizable = bl;
            int n = this.getColumnCount();
            this.setColumnCount(0);
            this.setColumnCount(n);
        }
    }

    public void setPredefinedLayout(LayoutManager layoutManager) {
        if (this._predefinedLayout != layoutManager) {
            this._predefinedLayout = layoutManager;
            this._normalGadgetContainer.setVisible(false);
            this.remove(this._normalGadgetContainer);
            this._normalGadgetContainer = this.createNormalGadgetContainer(this._columnResizable);
            if (this._constraintsList != null) {
                this._constraintsList.clear();
                this._constraintsList = null;
            }
            this.add((Component)this._normalGadgetContainer, CONTAINER_NORMAL);
            this.showNormalGadgetContainer();
            this.doLayout();
        }
    }

    public LayoutManager getPredefinedLayout() {
        return this._predefinedLayout;
    }

    public boolean isPredefinedLayoutSet() {
        return this._predefinedLayout != null;
    }

    public void setLayoutAdapter(PredefinedLayoutAdapter predefinedLayoutAdapter) {
        this._layoutAdapter = predefinedLayoutAdapter;
    }

    public PredefinedLayoutAdapter getLayoutAdapter() {
        return this._layoutAdapter;
    }

    private List<Object> getConstraintsList() {
        if (this._constraintsList == null) {
            this._constraintsList = new ArrayList<Object>();
        }
        return this._constraintsList;
    }

    protected Object getComponentConstraints(int n) {
        if (n < 0 || n >= this.getConstraintsList().size()) {
            return null;
        }
        return this.getConstraintsList().get(n);
    }

    private Object getComponentConstraints(JComponent jComponent) {
        if (!this.isPredefinedLayoutSet()) {
            return null;
        }
        int n = this.getComponentIndex(jComponent);
        List<Object> list = this.getConstraintsList();
        if (n >= 0 && list != null && n < list.size()) {
            return list.get(n);
        }
        return null;
    }

    private void setComponentConstraints(JComponent jComponent, Object object) {
        if (!this.isPredefinedLayoutSet()) {
            return;
        }
        int n = this.getComponentIndex(jComponent);
        List<Object> list = this.getConstraintsList();
        if (n >= 0 && list != null && n < list.size()) {
            list.remove(n);
            list.add(n, object);
        }
        this.getNormalGadgetContainer().remove(jComponent);
        this.getNormalGadgetContainer().add(jComponent, object, n);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(1024)) {
            Lm.showInvalidProductMessage(Dashboard.class.getName(), 1024);
        }
        _defaultColumnCount = 3;
    }

    private static interface PopupMenuCustomizer {
        public void customize(JPopupMenu var1, JComponent var2);
    }

    private class DashboardLayout
    extends JideSplitPaneLayout {
        private static final long serialVersionUID = -837392220191857184L;

        public DashboardLayout(Container container) {
            super(container);
        }

        @Override
        protected boolean calculateComponentSizes(int n, int n2, int n3) {
            int n4;
            boolean bl = super.calculateComponentSizes(n, n2, n3);
            boolean bl2 = false;
            int n5 = 0;
            int n6 = 0;
            for (n4 = 0; n4 < this._target.getComponentCount(); n4 += 2) {
                if (!this._target.getComponent(n4).isVisible()) continue;
                if (this._componentSizes[n4] == 0) {
                    bl2 = true;
                }
                n5 += this._componentSizes[n4];
                ++n6;
            }
            if (n6 == 0) {
                return bl;
            }
            n4 = n5 / n6;
            if (bl2) {
                for (int i = 0; i < this._target.getComponentCount() - 1; i += 2) {
                    if (!this._target.getComponent(i).isVisible()) continue;
                    this._componentSizes[i] = n4;
                    n5 -= this._componentSizes[i];
                }
                this._componentSizes[this._target.getComponentCount() - 1] = n5;
            }
            return bl;
        }
    }
}

