/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.csv;

import com.jidesoft.csv.CsvParseEvent;
import com.jidesoft.csv.CsvParseListener;
import com.jidesoft.csv.CsvValueAccumulator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class CsvReader {
    private static final Logger logger = Logger.getLogger(CsvReader.class.getName());
    private BufferedReader bufferedReader;
    private char separator = (char)44;
    private boolean trimmingValues = true;
    private ArrayList<List<String>> lines = new ArrayList();
    private CsvValueAccumulator accumulator = new CsvValueAccumulator(this.separator);

    public CsvReader() {
        this(null, ',');
    }

    public CsvReader(char c) {
        this(null, c);
    }

    public CsvReader(Reader reader) {
        this(reader, ',');
    }

    public CsvReader(Reader reader, char c) {
        this.setReader(reader);
        this.setSeparator(c);
        DefaultParseListener defaultParseListener = new DefaultParseListener();
        this.accumulator.addParseListener(defaultParseListener);
    }

    public void ensureCapacity(int n) {
        this.lines.ensureCapacity(n);
    }

    public void setReader(Reader reader) {
        this.bufferedReader = reader == null || CsvReader.isBufferedReader(reader) ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public Reader getReader() {
        return this.bufferedReader;
    }

    public void setSeparator(char c) {
        this.separator = c;
        this.accumulator.setSeparator(c);
    }

    public char getSeparator() {
        return this.separator;
    }

    public boolean isTrimmingValues() {
        return this.trimmingValues;
    }

    public void setTrimmingValues(boolean bl) {
        this.trimmingValues = bl;
        this.accumulator.setTrimming(bl);
    }

    public List<List<String>> parse(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Cannot parse a null File!");
        }
        FileReader fileReader = new FileReader(file);
        return this.parse(fileReader);
    }

    public List<List<String>> parse(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Cannot parse a null Input Stream!");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this.parse(bufferedReader);
    }

    public static boolean isBufferedReader(Reader reader) {
        return reader instanceof BufferedReader;
    }

    public List<List<String>> parse() throws IOException {
        if (this.bufferedReader == null) {
            throw new IllegalStateException("Reader has not been set - use the setReader() method before calling this method");
        }
        this.lines.clear();
        String string = this.bufferedReader.readLine();
        while (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                this.accumulator.push(c);
            }
            this.accumulator.newLine();
            string = this.bufferedReader.readLine();
        }
        return this.lines;
    }

    public List<List<String>> parse(Reader reader) throws IOException {
        this.setReader(reader);
        return this.parse();
    }

    public void parseForEffects(CsvParseListener csvParseListener) throws IOException {
        CsvValueAccumulator csvValueAccumulator = new CsvValueAccumulator(this.separator);
        csvValueAccumulator.addParseListener(csvParseListener);
        if (this.bufferedReader == null) {
            throw new IllegalStateException("The reader must be set before calling parseForEffects");
        }
        CsvParseEvent csvParseEvent = new CsvParseEvent((Object)this, CsvParseEvent.EventType.INPUT_START);
        csvParseListener.parsed(csvParseEvent);
        String string = this.bufferedReader.readLine();
        while (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                csvValueAccumulator.push(c);
            }
            csvValueAccumulator.newLine();
            string = this.bufferedReader.readLine();
        }
        CsvParseEvent csvParseEvent2 = new CsvParseEvent((Object)this, CsvParseEvent.EventType.INPUT_END);
        csvParseListener.parsed(csvParseEvent2);
    }

    class DefaultParseListener
    implements CsvParseListener {
        DefaultParseListener() {
        }

        @Override
        public void parsed(CsvParseEvent csvParseEvent) {
            if (csvParseEvent.getType() != CsvParseEvent.EventType.TOKEN && csvParseEvent.getType() == CsvParseEvent.EventType.LINE) {
                CsvReader.this.lines.add(csvParseEvent.getTokens());
            }
        }
    }
}

