/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.csv;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;

public class CsvParseEvent
extends EventObject {
    private static final long serialVersionUID = 608711844568541863L;
    private EventType type;
    private List<String> tokens;

    public CsvParseEvent(Object object, EventType eventType) {
        super(object);
        this.type = eventType;
    }

    public CsvParseEvent(Object object, EventType eventType, String string) {
        super(object);
        this.type = eventType;
        this.setToken(string);
    }

    public CsvParseEvent(Object object, String string) {
        this(object, EventType.TOKEN, string);
    }

    public CsvParseEvent(Object object, List<String> list) {
        super(object);
        this.type = EventType.LINE;
        this.setTokens(list);
    }

    public void setToken(String string) {
        this.tokens = Arrays.asList(string);
    }

    public String getToken() {
        if (this.tokens == null || this.tokens.size() < 1) {
            return null;
        }
        return this.tokens.get(0);
    }

    public void setTokens(List<String> list) {
        this.tokens = list;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public EventType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return String.format("CsvParseEvent[source=%s, type=%s, token='%s']", new Object[]{this.source, this.type, this.tokens});
    }

    public static enum EventType {
        TOKEN,
        LINE,
        INPUT_START,
        INPUT_END,
        FILE;

    }
}

