/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ExComboBoxSearchable;
import com.jidesoft.combobox.TreeExComboBox;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeExComboBoxSearchable
extends ExComboBoxSearchable
implements TreeModelListener {
    private boolean _recursive = false;
    private transient List<TreePath> _treePaths;

    public TreeExComboBoxSearchable(TreeExComboBox treeExComboBox) {
        super(treeExComboBox);
        if (treeExComboBox.getTreeModel() != null) {
            treeExComboBox.getTreeModel().addTreeModelListener(this);
        }
        treeExComboBox.addPropertyChangeListener("treeModel", this);
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    public void setRecursive(boolean bl) {
        this._recursive = bl;
        this.resetTreePathes();
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof TreeExComboBox && ((TreeExComboBox)this._component).getTreeModel() != null) {
            ((TreeExComboBox)this._component).getTreeModel().removeTreeModelListener(this);
        }
        this._component.removePropertyChangeListener("treeModel", this);
    }

    private JTree getTree() {
        if (this.getComboBox() instanceof TreeExComboBox) {
            return ((TreeExComboBox)this.getComboBox()).getTree();
        }
        return null;
    }

    @Override
    public void showPopup(String string) {
        if (!this.getComboBox().isPopupVisible() && this.isShowPopupDuringSearching()) {
            this.getComboBox().showPopup();
        }
        if (this.getTree() != null) {
            super.showPopup(string);
        }
    }

    @Override
    protected void setSelectedIndex(int n, boolean bl) {
        ((TreeExComboBox)this._component).showPopup();
        JTree jTree = ((TreeExComboBox)this._component).getTree();
        if (jTree == null) {
            return;
        }
        if (!this.isRecursive()) {
            if (bl) {
                jTree.addSelectionInterval(n, n);
            } else {
                jTree.setSelectionRow(n);
            }
            jTree.scrollRowToVisible(n);
        } else {
            Object object = this.getElementAt(n);
            if (object instanceof TreePath) {
                TreePath treePath = (TreePath)object;
                if (bl) {
                    jTree.addSelectionPath(treePath);
                } else {
                    jTree.setSelectionPath(treePath);
                }
                jTree.scrollPathToVisible(treePath);
            }
        }
        if (((TreeExComboBox)this._component).getPopupLocation() == 1) {
            this.setPopupLocation(3);
        } else {
            this.setPopupLocation(1);
        }
    }

    @Override
    protected int getSelectedIndex() {
        JTree jTree = ((TreeExComboBox)this._component).getTree();
        if (jTree == null) {
            return -1;
        }
        if (!this.isRecursive()) {
            int[] nArray = jTree.getSelectionRows();
            return nArray != null && nArray.length != 0 ? nArray[0] : -1;
        }
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            return this.getTreePathes().indexOf(treePathArray[0]);
        }
        return -1;
    }

    @Override
    protected Object getElementAt(int n) {
        if (n == -1) {
            return null;
        }
        if (!this.isRecursive()) {
            JTree jTree = ((TreeExComboBox)this._component).getTree();
            if (jTree == null) {
                return null;
            }
            return jTree.getPathForRow(n);
        }
        return this.getTreePathes().get(n);
    }

    @Override
    protected int getElementCount() {
        if (!this.isRecursive()) {
            JTree jTree = ((TreeExComboBox)this._component).getTree();
            if (jTree == null) {
                return 0;
            }
            return jTree.getRowCount();
        }
        return this.getTreePathes().size();
    }

    protected void populateTreePaths() {
        this._treePaths = new ArrayList<TreePath>();
        Object object = ((TreeExComboBox)this._component).getTreeModel().getRoot();
        this.populateTreePaths0(object, new TreePath(object), ((TreeExComboBox)this._component).getTreeModel());
    }

    private void populateTreePaths0(Object object, TreePath treePath, TreeModel treeModel) {
        this._treePaths.add(treePath);
        for (int i = 0; i < treeModel.getChildCount(object); ++i) {
            Object object2 = treeModel.getChild(object, i);
            this.populateTreePaths0(object2, treePath.pathByAddingChild(object2), treeModel);
        }
    }

    protected void resetTreePathes() {
        this._treePaths = null;
    }

    protected List<TreePath> getTreePathes() {
        if (this._treePaths == null) {
            this.populateTreePaths();
        }
        return this._treePaths;
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object instanceof TreePath) {
            Object object2 = ((TreePath)object).getLastPathComponent();
            return object2.toString();
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.resetTreePathes();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if ("treeModel".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof TreeModel) {
                ((TreeModel)propertyChangeEvent.getOldValue()).removeTreeModelListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof TreeModel) {
                ((TreeModel)propertyChangeEvent.getNewValue()).addTreeModelListener(this);
            }
            this.resetTreePathes();
        }
    }
}

