/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.combobox.TreeChooserPanel;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeComboBox
extends AbstractComboBox {
    protected TreeCellRenderer renderer;
    protected int maximumRowCount = 8;
    protected Object _object;
    protected TreeModel _treeModel;
    private boolean _doubleClickExpand;
    public static final String TREE_MODEL_PROPERTY = "treeModel";

    public TreeComboBox() {
        this.setType(String.class);
        this.initComponent();
    }

    public TreeComboBox(Object[] objectArray) {
        this._object = objectArray;
        this.setType(String.class);
        this.initComponent();
    }

    public TreeComboBox(Vector<?> vector) {
        this._object = vector;
        this.setType(String.class);
        this.initComponent();
    }

    public TreeComboBox(Hashtable<?, ?> hashtable) {
        this._object = hashtable;
        this.setType(String.class);
        this.initComponent();
    }

    public TreeComboBox(TreeNode treeNode) {
        this._object = treeNode;
        this.setType(String.class);
        this.initComponent();
    }

    public TreeComboBox(TreeNode treeNode, boolean bl) {
        this._object = new DefaultTreeModel(treeNode, bl);
        this.setType(String.class);
        this.initComponent();
    }

    public TreeComboBox(TreeModel treeModel) {
        this._object = treeModel;
        this.setType(String.class);
        this.initComponent();
    }

    @Override
    protected void initComponent(ComboBoxModel comboBoxModel) {
        super.initComponent(comboBoxModel);
        this._treeModel = TreeChooserPanel.createTreeModel(this._object);
    }

    protected List<TreePath> populateTreePaths(JTree jTree) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        Object object = jTree.getModel().getRoot();
        this.populateTreePaths0(object, jTree, new TreePath(object), jTree.getModel(), arrayList);
        return arrayList;
    }

    private void populateTreePaths0(Object object, JTree jTree, TreePath treePath, TreeModel treeModel, List<TreePath> list) {
        if (jTree.isRootVisible() || treePath.getLastPathComponent() != jTree.getModel().getRoot()) {
            list.add(treePath);
        }
        for (int i = 0; i < treeModel.getChildCount(object); ++i) {
            Object object2 = treeModel.getChild(object, i);
            this.populateTreePaths0(object2, jTree, treePath.pathByAddingChild(object2), treeModel, list);
        }
    }

    @Override
    public AbstractComboBox.EditorComponent createEditorComponent() {
        if (this.isEditable()) {
            return new TreeEditorComponent(this.getType());
        }
        return new AbstractComboBox.DefaultRendererComponent(this.getType()){

            @Override
            public Object getItem() {
                return TreeComboBox.this.validateItem(super.getItem());
            }

            @Override
            protected String convertElementToString(Object object) {
                return TreeComboBox.this.convertElementToString(object);
            }
        };
    }

    @Override
    public PopupPanel createPopupComponent() {
        TreeChooserPanel treeChooserPanel = this.createTreeChooserPanel(this.getTreeModel());
        treeChooserPanel.setResizable(true);
        treeChooserPanel.setResizableCorners(16);
        treeChooserPanel.setMaximumRowCount(this.maximumRowCount);
        treeChooserPanel.setDoubleClickExpand(this.isDoubleClickExpand());
        return treeChooserPanel;
    }

    protected TreeChooserPanel createTreeChooserPanel(TreeModel treeModel) {
        TreeChooserPanel treeChooserPanel = new TreeChooserPanel(treeModel){

            @Override
            protected JTree createTree(TreeModel treeModel) {
                JTree jTree = TreeComboBox.this.createTree(treeModel);
                if (jTree == null) {
                    return super.createTree(treeModel);
                }
                return jTree;
            }

            @Override
            protected void setupTree(final JTree jTree) {
                super.setupTree(jTree);
                jTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        TreePath treePath = treeSelectionEvent.getPath();
                        if (treePath != null && !Boolean.TRUE.equals(jTree.getClientProperty("PopupPanel.selectedByMouseRollover"))) {
                            if (!treeSelectionEvent.isAddedPath(treePath) || !this.isValidSelection(treePath)) {
                                TreeComboBox.this.setSelectedItem(null, !treeSelectionEvent.isAddedPath(treePath));
                                TreeComboBox.this.getEditor().setItem(null);
                            } else {
                                this.setSelectedObject((Object)treePath, false);
                                TreeComboBox.this.getEditor().setItem(treePath);
                                TreeComboBox.this.getEditor().selectAll();
                            }
                        }
                    }
                });
                TreeComboBox.this.setupTree(jTree);
            }

            @Override
            protected boolean isValidSelection(TreePath treePath) {
                return TreeComboBox.this.isValidSelection(treePath);
            }
        };
        treeChooserPanel.setCellRenderer(this.getCellRenderer());
        return treeChooserPanel;
    }

    protected JTree createTree(TreeModel treeModel) {
        return null;
    }

    protected void setupTree(JTree jTree) {
        Font font = this.getFont();
        if (font != null && !(font instanceof UIResource)) {
            jTree.setFont(font);
        }
    }

    private Object validateItem(Object object) {
        if (!this.isPopupVisible()) {
            return object;
        }
        JTree jTree = this.getTree();
        if (jTree == null || object == null) {
            return null;
        }
        if (object instanceof TreePath) {
            return object;
        }
        List<TreePath> list = this.populateTreePaths(jTree);
        for (TreePath treePath : list) {
            if (!this.isValidSelection(treePath) || !object.equals(this.convertElementToString(treePath))) continue;
            return treePath;
        }
        return null;
    }

    public void setMaximumRowCount(int n) {
        int n2 = this.maximumRowCount;
        this.maximumRowCount = n;
        this.firePropertyChange("maximumRowCount", n2, this.maximumRowCount);
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        TreeCellRenderer treeCellRenderer2 = this.renderer;
        this.renderer = treeCellRenderer;
        this.firePropertyChange("renderer", treeCellRenderer2, this.renderer);
        this.invalidate();
    }

    public TreeCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public JTree getTree() {
        if (!this.isPopupVisible() && this.isShowing()) {
            if (this.getPopupType() == 0) {
                this.showPopupPanelAsPopup(false);
            } else {
                this.showPopup();
            }
        }
        if (this.getPopupPanel() != null && this.getPopupPanel() instanceof TreeChooserPanel) {
            return ((TreeChooserPanel)this.getPopupPanel()).getTree();
        }
        return null;
    }

    @Override
    protected JComponent getDelegateTarget() {
        if (this.getPopupPanel() != null && this.getPopupPanel() instanceof TreeChooserPanel) {
            return ((TreeChooserPanel)this.getPopupPanel()).getTree();
        }
        return null;
    }

    protected String convertElementToString(Object object) {
        if (object instanceof TreePath) {
            Object object2 = ((TreePath)object).getLastPathComponent();
            return object2.toString();
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    protected boolean isValidSelection(TreePath treePath) {
        return true;
    }

    public TreeModel getTreeModel() {
        return this._treeModel;
    }

    public void setTreeModel(TreeModel treeModel) {
        TreeModel treeModel2 = this._treeModel;
        this._treeModel = treeModel;
        this.resetPopup();
        this.firePropertyChange(TREE_MODEL_PROPERTY, treeModel2, treeModel);
    }

    public boolean isDoubleClickExpand() {
        return this._doubleClickExpand;
    }

    public void setDoubleClickExpand(boolean bl) {
        this._doubleClickExpand = bl;
        if (this._popupPanel instanceof TreeChooserPanel) {
            ((TreeChooserPanel)this._popupPanel).setDoubleClickExpand(this.isDoubleClickExpand());
        }
    }

    class TreeEditorComponent
    extends AbstractComboBox.DefaultTextFieldEditorComponent {
        public TreeEditorComponent(Class<?> clazz) {
            super(clazz);
        }

        @Override
        protected String convertElementToString(Object object) {
            return TreeComboBox.this.convertElementToString(object);
        }
    }
}

