/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.InfiniteComboBoxModel;
import com.jidesoft.spinner.SpinnerWheelSupport;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public abstract class NumberSpinnerComboBox
extends AbstractComboBox {
    private SpinnerNumberModel _spinnerNumberModel;
    private String _decimalFormatPattern;

    protected NumberSpinnerComboBox(SpinnerNumberModel spinnerNumberModel) {
        this._spinnerNumberModel = spinnerNumberModel;
        InfiniteComboBoxModel infiniteComboBoxModel = new InfiniteComboBoxModel();
        infiniteComboBoxModel.setSelectedItem(this._spinnerNumberModel.getValue());
        this.initComponent(infiniteComboBoxModel);
    }

    @Override
    public AbstractComboBox.EditorComponent createEditorComponent() {
        if (this.isEditable()) {
            return new NumberSpinnerEditorComponent(Number.class);
        }
        return null;
    }

    public SpinnerNumberModel getSpinnerNumberModel() {
        return this._spinnerNumberModel;
    }

    public void setSpinnerNumberModel(SpinnerNumberModel spinnerNumberModel) {
        this._spinnerNumberModel = spinnerNumberModel;
        if (this.getEditor() instanceof AbstractComboBox.SpinnerEditorComponent) {
            NumberSpinner numberSpinner = (NumberSpinner)((AbstractComboBox.SpinnerEditorComponent)this.getEditor()).getEditorComponent();
            numberSpinner.resetEditor(this.getSpinnerNumberModel());
        }
    }

    @Override
    protected JSpinner createSpinner() {
        return new NumberSpinner();
    }

    public String getDecimalFormatPattern() {
        return this._decimalFormatPattern;
    }

    public void setDecimalFormatPattern(String string) {
        this._decimalFormatPattern = string;
        if (this.getEditor() instanceof AbstractComboBox.SpinnerEditorComponent) {
            NumberSpinner numberSpinner = (NumberSpinner)((AbstractComboBox.SpinnerEditorComponent)this.getEditor()).getEditorComponent();
            numberSpinner.resetEditor(this.getSpinnerNumberModel());
        }
    }

    protected class NumberSpinner
    extends JSpinner {
        public NumberSpinner() {
            super(NumberSpinnerComboBox.this.getSpinnerNumberModel());
            SpinnerWheelSupport.installMouseWheelSupport(this);
        }

        public void resetEditor(SpinnerModel spinnerModel) {
            this.setModel(spinnerModel);
            this.setEditor(this.createEditor(spinnerModel));
        }

        @Override
        protected JComponent createEditor(SpinnerModel spinnerModel) {
            if (spinnerModel instanceof SpinnerNumberModel) {
                String string = NumberSpinnerComboBox.this.getDecimalFormatPattern();
                return string == null ? new JSpinner.NumberEditor(this) : new JSpinner.NumberEditor((JSpinner)this, string);
            }
            return super.createEditor(spinnerModel);
        }
    }

    public class NumberSpinnerEditorComponent
    extends AbstractComboBox.SpinnerEditorComponent {
        public NumberSpinnerEditorComponent(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public Object getItem() {
            return this._spinner.getValue();
        }

        @Override
        public void setItem(Object object) {
            this._spinner.setValue(object);
        }
    }
}

