/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.DefaultButtonProvider;
import com.jidesoft.combobox.ListChooserPanel;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.swing.AutoScroll;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.ListSearchable;
import com.jidesoft.swing.PartialEtchedBorder;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;

public class MultiSelectListChooserPanel
extends ListChooserPanel
implements DefaultButtonProvider {
    private JScrollPane _scroller;
    private AutoScroll _autoScroll;
    protected ListModel _listModel;
    protected JButton _okButton;
    protected JButton _cancelButton;
    protected Action _okAction;
    protected Action _cancelAction;
    private boolean _doubleClickEnabled = true;

    public MultiSelectListChooserPanel() {
    }

    public MultiSelectListChooserPanel(Action action, Action action2) {
        this.init(action, action2);
    }

    public MultiSelectListChooserPanel(Object[] objectArray, Class<?> clazz) {
        super(objectArray, clazz);
    }

    public MultiSelectListChooserPanel(Object[] objectArray, Class<?> clazz, Action action, Action action2) {
        super(objectArray, clazz);
        this.init(action, action2);
    }

    public MultiSelectListChooserPanel(Vector<?> vector, Class<?> clazz) {
        super(vector, clazz);
    }

    public MultiSelectListChooserPanel(Vector<?> vector, Class<?> clazz, Action action, Action action2) {
        super(vector, clazz);
        this.init(action, action2);
    }

    public MultiSelectListChooserPanel(ComboBoxModel comboBoxModel, Class<?> clazz) {
        super(comboBoxModel, clazz);
    }

    public MultiSelectListChooserPanel(ComboBoxModel comboBoxModel, Class<?> clazz, Action action, Action action2) {
        super(comboBoxModel, clazz);
        this.init(action, action2);
    }

    public MultiSelectListChooserPanel(ComboBoxModel comboBoxModel, Class<?> clazz, ConverterContext converterContext) {
        super(comboBoxModel, clazz, converterContext);
    }

    public MultiSelectListChooserPanel(ComboBoxModel comboBoxModel, Class<?> clazz, ConverterContext converterContext, Action action, Action action2) {
        super(comboBoxModel, clazz, converterContext);
        this.init(action, action2);
    }

    public void setOkAction(Action action) {
        this._okAction = action;
        if (this._okButton != null) {
            this._okButton.setAction(this._okAction);
        }
        this.init(this.getOkAction(), this.getCancelAction());
    }

    public Action getOkAction() {
        return this._okAction;
    }

    public void setCancelAction(Action action) {
        this._cancelAction = action;
        if (this._cancelButton != null) {
            this._cancelButton.setAction(this._cancelAction);
        }
        this.init(this.getOkAction(), this.getCancelAction());
    }

    public Action getCancelAction() {
        return this._cancelAction;
    }

    @Override
    public JButton getDefaultButton() {
        return this._okButton;
    }

    public Component createButtonPanel(int n) {
        String string = JideSwingUtilities.getOKString(this.getLocale());
        String string2 = JideSwingUtilities.getCancelString(this.getLocale());
        ButtonPanel buttonPanel = new ButtonPanel(n);
        buttonPanel.setBackground(this.getBackground());
        this._okButton = new JButton(string);
        this._okButton.setActionCommand("OK");
        Action action = this.getOkAction();
        if (action != null) {
            if (action.getValue("Name") == null) {
                action.putValue("Name", string);
                action.putValue("ActionCommandKey", "OK");
            }
            this._okButton.setAction(action);
        }
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiSelectListChooserPanel.this.prepareSelectedObject();
                MultiSelectListChooserPanel.this.setSelectedObject(MultiSelectListChooserPanel.this.getSelectedObject());
            }
        });
        buttonPanel.addButton((AbstractButton)this._okButton, "AFFIRMATIVE");
        this._cancelButton = new JButton(string2);
        this._cancelButton.setActionCommand("Cancel");
        Action action2 = this.getCancelAction();
        if (action2 != null) {
            if (action2.getValue("Name") == null) {
                action2.putValue("Name", string2);
                action2.putValue("ActionCommandKey", "Cancel");
            }
            this._cancelButton.setAction(action2);
        }
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiSelectListChooserPanel.this.setSelectedObject(MultiSelectListChooserPanel.this.getPreviousSelectedObject());
            }
        });
        buttonPanel.addButton((AbstractButton)this._cancelButton, "CANCEL");
        if (n == 1 || n == 3) {
            buttonPanel.setBorder(BorderFactory.createCompoundBorder(new PartialEtchedBorder(8), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        } else {
            buttonPanel.setBorder(BorderFactory.createCompoundBorder(new PartialEtchedBorder(1), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        }
        return buttonPanel;
    }

    private void init(Action action, Action action2) {
        this._okAction = action;
        this._cancelAction = action2;
        Component component = this.createButtonPanel(4);
        if (component != null) {
            this.add(component, "Last");
        }
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.setDefaultFocusComponent(this._list);
    }

    @Override
    protected JList createList(ComboBoxModel comboBoxModel) {
        Vector<Object> vector = this.convertComboBoxModelToVector(comboBoxModel);
        this._listModel = this.createListModel(vector);
        return new ListChooserPanel.ListEx(this._listModel){

            @Override
            public void processMouseEvent(MouseEvent mouseEvent) {
                this.superProcessMouseEvent(mouseEvent);
            }
        };
    }

    protected ListModel createListModel(Vector<?> vector) {
        DefaultListModel defaultListModel = new DefaultListModel();
        for (Object obj : vector) {
            defaultListModel.addElement(obj);
        }
        return defaultListModel;
    }

    protected Vector<Object> convertComboBoxModelToVector(ComboBoxModel comboBoxModel) {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            Object e = comboBoxModel.getElementAt(i);
            if (this._class == null && e != null) {
                vector.add(e);
                continue;
            }
            vector.add(e);
        }
        return vector;
    }

    @Override
    protected void setupList(JList jList) {
        super.setupList(jList);
        if (!(jList.getClientProperty("Searchable") instanceof Searchable)) {
            ListSearchable listSearchable = SearchableUtils.installSearchable(jList);
            listSearchable.setHeavyweightComponentEnabled(true);
            listSearchable.setUseRendererAsConverter(true);
        }
        jList.setSelectionMode(2);
    }

    @Override
    AbstractAction createEnterAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 8319462990433718719L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiSelectListChooserPanel.this.setSelectedObject(MultiSelectListChooserPanel.this.getSelectedObject());
            }
        };
    }

    protected Object[] retrieveListSelection() {
        return this._list.getSelectedValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateListSelection(Object object, boolean bl) {
        if (this._list == null) {
            return;
        }
        try {
            this._list.getSelectionModel().setValueIsAdjusting(true);
            if (object != null) {
                if (object.getClass().isArray()) {
                    int n = Array.getLength(object);
                    int[] nArray = new int[n];
                    Arrays.fill(nArray, -1);
                    for (int i = 0; i < this._list.getModel().getSize(); ++i) {
                        Object e = this._list.getModel().getElementAt(i);
                        for (int j = 0; j < n; ++j) {
                            if (nArray[j] != -1) continue;
                            Object object2 = Array.get(object, j);
                            if (object2 != null && object2.equals(e)) {
                                nArray[j] = i;
                                continue;
                            }
                            if (object2 != null || object2 != e) continue;
                            nArray[j] = i;
                        }
                    }
                    this._list.setSelectedIndices(nArray);
                    if (nArray.length >= 1) {
                        this._list.ensureIndexIsVisible(nArray[0]);
                    }
                } else {
                    this._list.setSelectedValue(object, true);
                }
            } else {
                this._list.clearSelection();
            }
        }
        finally {
            this._list.getSelectionModel().setValueIsAdjusting(false);
        }
    }

    @Override
    public Object getSelectedObject() {
        if (this._list != null) {
            return this.retrieveListSelection();
        }
        return null;
    }

    @Override
    protected Handler createHandler() {
        return new Handler();
    }

    @Override
    protected boolean isAutoScroll() {
        return false;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        int n = listDataEvent.getIndex0();
        int n2 = listDataEvent.getIndex1();
        if (this._listModel instanceof DefaultListModel) {
            for (int i = n2; i >= n; --i) {
                ((DefaultListModel)this._listModel).insertElementAt(this._model.getElementAt(i), n);
            }
        } else {
            this.configureListModel(this._model);
        }
        super.intervalAdded(listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        int n = listDataEvent.getIndex0();
        int n2 = listDataEvent.getIndex1();
        if (this._listModel instanceof DefaultListModel) {
            for (int i = n2; i >= n; --i) {
                ((DefaultListModel)this._listModel).removeElementAt(n);
            }
        } else {
            this.configureListModel(this._model);
        }
        super.intervalRemoved(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getIndex0() >= 0 || listDataEvent.getIndex1() >= 0) {
            this.configureListModel(this._model);
        }
        super.contentsChanged(listDataEvent);
    }

    protected void configureListModel(ComboBoxModel comboBoxModel) {
        if (this._list != null) {
            Vector<Object> vector = this.convertComboBoxModelToVector(comboBoxModel);
            ListModel listModel = this._list.getModel();
            if (listModel.getSize() == vector.size()) {
                boolean bl = false;
                for (int i = vector.size() - 1; i >= 0; --i) {
                    if (JideSwingUtilities.equals(vector.get(i), listModel.getElementAt(i))) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return;
                }
            }
            this._listModel = this.createListModel(vector);
            this._list.setModel(this._listModel);
        }
    }

    protected void prepareSelectedObject() {
    }

    public boolean isDoubleClickEnabled() {
        return this._doubleClickEnabled;
    }

    public void setDoubleClickEnabled(boolean bl) {
        this._doubleClickEnabled = bl;
    }

    protected class Handler
    extends ListChooserPanel.Handler {
        private static final long serialVersionUID = 8747239924092579259L;

        protected Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (MultiSelectListChooserPanel.this.isDoubleClickEnabled() && !mouseEvent.isConsumed() && mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getSource() == MultiSelectListChooserPanel.this._list) {
                Object object = MultiSelectListChooserPanel.this._list.getSelectedValue();
                int n = MultiSelectListChooserPanel.this._list.getSelectedIndex();
                if (!JideSwingUtilities.equals(CheckBoxList.ALL_ENTRY, object)) {
                    if (object != null || n >= 0) {
                        if (MultiSelectListChooserPanel.this._list instanceof CheckBoxList && !((CheckBoxList)MultiSelectListChooserPanel.this._list).isCheckBoxEnabled(n)) {
                            return;
                        }
                        Object[] objectArray = new Object[]{object};
                        object = objectArray;
                    }
                    MultiSelectListChooserPanel.this.updateListSelection(object, false);
                    MultiSelectListChooserPanel.this.setSelectedObject(object);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed() || mouseEvent.getSource() == MultiSelectListChooserPanel.this._list) {
                return;
            }
            super.mouseReleased(mouseEvent);
        }
    }
}

