/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.ListChooserPanel;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;

public class ListComboBox
extends AbstractComboBox {
    protected int _maximumRowCount = 8;
    private boolean _isDisplaySizeDirty = true;
    private Dimension _cachedDisplaySize;
    public static Object[] BOOLEAN_ARRAY = new Object[]{Boolean.TRUE, Boolean.FALSE};

    public ListComboBox() {
        this(new Object[0]);
    }

    public ListComboBox(Object[] objectArray) {
        this(objectArray, Object.class);
    }

    public ListComboBox(Vector<?> vector) {
        this(vector, Object.class);
    }

    public ListComboBox(ComboBoxModel comboBoxModel) {
        this(comboBoxModel, Object.class);
    }

    public ListComboBox(Object[] objectArray, Class<?> clazz) {
        super(0);
        this.setType(clazz);
        this.initComponent(new DefaultComboBoxModel<Object>(objectArray));
        this.setPopupCancelBehavior(3);
    }

    public ListComboBox(Vector<?> vector, Class<?> clazz) {
        super(0);
        this.setType(clazz);
        this.initComponent(new DefaultComboBoxModel(vector));
        this.setPopupCancelBehavior(3);
    }

    public ListComboBox(ComboBoxModel comboBoxModel, Class<?> clazz) {
        super(0);
        this.setType(clazz);
        this.initComponent(comboBoxModel);
        this.setPopupCancelBehavior(3);
    }

    @Override
    protected void initComponent(ComboBoxModel comboBoxModel) {
        super.initComponent(comboBoxModel);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("model".equals(string) || "border".equals(string) || "prototypeDisplayValue".equals(string)) {
                    ListComboBox.this._isDisplaySizeDirty = true;
                    ListComboBox.this.revalidate();
                    ListComboBox.this.repaint();
                }
            }
        });
    }

    @Override
    public AbstractComboBox.EditorComponent createEditorComponent() {
        if (this.isEditable()) {
            return new ListEditorComponent(this.getType());
        }
        return new ListRendererComponent(this.getType());
    }

    @Override
    public PopupPanel createPopupComponent() {
        ListChooserPanel listChooserPanel = this.createListChooserPanel(this.dataModel, this.getType(), this.getConverter(), this.getConverterContext());
        listChooserPanel.setResizable(true);
        listChooserPanel.setResizableCorners(16);
        listChooserPanel.setMaximumRowCount(this.getMaximumRowCount());
        return listChooserPanel;
    }

    protected ListChooserPanel createListChooserPanel(final ComboBoxModel comboBoxModel, Class<?> clazz, ObjectConverter objectConverter, ConverterContext converterContext) {
        ListChooserPanel listChooserPanel = new ListChooserPanel(comboBoxModel, clazz, objectConverter, converterContext){

            @Override
            protected JList createList(ComboBoxModel comboBoxModel2) {
                JList jList = ListComboBox.this.createList(comboBoxModel2);
                if (jList == null) {
                    return super.createList(comboBoxModel2);
                }
                return jList;
            }

            @Override
            protected void setupList(final JList jList) {
                this.setHorizontalAlignment(ListComboBox.this.getHorizontalAlignment());
                this.setVerticalAlignment(ListComboBox.this.getVerticalAlignment());
                super.setupList(jList);
                jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        int n;
                        if (!listSelectionEvent.getValueIsAdjusting() && !Boolean.TRUE.equals(jList.getClientProperty("PopupPanel.selectedByMouseRollover")) && (n = jList.getSelectedIndex()) != -1) {
                            Object e = comboBoxModel.getElementAt(n);
                            if (ListComboBox.this.getEditor().getItem() != e) {
                                boolean bl = false;
                                if (ListComboBox.this.selectedItemReminder != null && ListComboBox.this.selectedItemReminder != "__UNINITIALIZED__" && comboBoxModel instanceof DefaultComboBoxModel) {
                                    boolean bl2 = bl = ((DefaultComboBoxModel)comboBoxModel).getIndexOf(ListComboBox.this.selectedItemReminder) < 0;
                                }
                                if (!bl) {
                                    Object object = this.getSelectedObject();
                                    boolean bl3 = !JideSwingUtilities.equals(object, e);
                                    this.setSelectedObject(e, false);
                                    ListComboBox.this.getEditor().setItem(e);
                                    if (bl3) {
                                        ListComboBox.this.fireItemStateChanged(new ItemEvent(ListComboBox.this, 701, object, 2));
                                        ListComboBox.this.selectedItemChanged(e);
                                        ListComboBox.this.fireItemStateChanged(new ItemEvent(ListComboBox.this, 701, e, 1));
                                    }
                                    ListComboBox.this.getEditor().selectAll();
                                } else {
                                    ListComboBox.this.setSelectedItem(e);
                                }
                            }
                        }
                    }
                });
                ListComboBox.this.setupList(jList);
            }
        };
        listChooserPanel.setRenderer(this.getRenderer());
        return listChooserPanel;
    }

    @Override
    protected List<KeyStroke> getDelegateKeyStrokes() {
        List<KeyStroke> list = super.getDelegateKeyStrokes();
        list.remove(KeyStroke.getKeyStroke(37, 0));
        list.remove(KeyStroke.getKeyStroke(39, 0));
        return list;
    }

    protected JList createList(ComboBoxModel comboBoxModel) {
        return null;
    }

    protected void setupList(JList jList) {
        Font font = this.getFont();
        if (font != null && !(font instanceof UIResource)) {
            jList.setFont(font);
        }
    }

    protected void registerNavigationKeys(final AbstractComboBox.EditorComponent editorComponent, JComponent jComponent) {
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -8693235147642042528L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListComboBox.this.toggleValue(editorComponent, 36);
            }
        }, KeyStroke.getKeyStroke(36, 2), 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 5305502700089335457L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListComboBox.this.toggleValue(editorComponent, 35);
            }
        }, KeyStroke.getKeyStroke(35, 2), 0);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 2472276835042794474L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ListComboBox.this.isEditable() && !ListComboBox.this.isPopupVisible()) {
                    ListComboBox.this.showPopup();
                } else {
                    ListComboBox.this.toggleValue(editorComponent, 38);
                }
            }
        };
        jComponent.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(38, 0), 0);
        jComponent.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(224, 0), 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -5884680403511235136L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListComboBox.this.toggleValue(editorComponent, 33);
            }
        }, KeyStroke.getKeyStroke(33, 0), 0);
        AbstractAction abstractAction2 = new AbstractAction(){
            private static final long serialVersionUID = 8630117465224110953L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ListComboBox.this.isEditable() && !ListComboBox.this.isPopupVisible()) {
                    ListComboBox.this.showPopup();
                } else {
                    ListComboBox.this.toggleValue(editorComponent, 40);
                }
            }
        };
        jComponent.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(40, 0), 0);
        jComponent.registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(225, 0), 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -8556107413331623296L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListComboBox.this.toggleValue(editorComponent, 34);
            }
        }, KeyStroke.getKeyStroke(34, 0), 0);
    }

    private int getNextIndex(ListComboBox listComboBox, int n) {
        if (n == 33) {
            int n2 = listComboBox.getMaximumRowCount();
            int n3 = listComboBox.getSelectedIndex() - n2;
            return n3 < 0 ? 0 : n3;
        }
        if (n == 34) {
            int n4;
            int n5 = listComboBox.getMaximumRowCount();
            int n6 = listComboBox.getSelectedIndex() + n5;
            return n6 < (n4 = listComboBox.dataModel.getSize()) ? n6 : n4 - 1;
        }
        if (n == 36) {
            return 0;
        }
        if (n == 35) {
            return listComboBox.dataModel.getSize() - 1;
        }
        if (n == 40) {
            int n7;
            int n8 = listComboBox.getSelectedIndex() + 1;
            return n8 < (n7 = listComboBox.dataModel.getSize()) ? n8 : 0;
        }
        if (n == 38) {
            int n9 = listComboBox.getSelectedIndex() - 1;
            int n10 = listComboBox.dataModel.getSize();
            return n9 < 0 ? n10 - 1 : n9;
        }
        return listComboBox.getSelectedIndex();
    }

    private void toggleValue(AbstractComboBox.EditorComponent editorComponent, int n) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.dataModel.getSize() == 0) {
            return;
        }
        boolean bl = this.getClientProperty("AbstractComboBox.isTableCellEditor") != null;
        int n2 = this.getNextIndex(this, n);
        if (bl) {
            editorComponent.setItem(this.dataModel.getElementAt(n2));
        } else {
            this.setSelectedItem(this.dataModel.getElementAt(n2));
        }
    }

    public void setMaximumRowCount(int n) {
        int n2 = this._maximumRowCount;
        if (n2 != n) {
            this._maximumRowCount = n;
            this.firePropertyChange("maximumRowCount", n2, this._maximumRowCount);
        }
    }

    public int getMaximumRowCount() {
        return this._maximumRowCount;
    }

    public void setSelectedIndex(int n) {
        int n2 = this.dataModel.getSize();
        if (n == -1) {
            this.setSelectedItem(null);
        } else {
            if (n < -1 || n >= n2) {
                throw new IllegalArgumentException("setSelectedIndex: " + n + " out of bounds");
            }
            this.setSelectedItem(this.dataModel.getElementAt(n));
        }
    }

    public int getSelectedIndex() {
        Object object = this.dataModel.getSelectedItem();
        int n = this.dataModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.dataModel.getElementAt(i);
            if (e == null || !e.equals(object)) continue;
            return i;
        }
        return -1;
    }

    public JList getList() {
        if (this.getPopupPanel() == null && !this.isPopupVisible() && this.isShowing()) {
            if (this.getPopupType() == 0) {
                this.showPopupPanelAsPopup(false);
            } else {
                this.showPopup();
            }
        }
        if (this.getPopupPanel() != null && this.getPopupPanel() instanceof ListChooserPanel) {
            return ((ListChooserPanel)this.getPopupPanel()).getList();
        }
        return null;
    }

    @Override
    protected JComponent getDelegateTarget() {
        if (this.getPopupPanel() != null && this.getPopupPanel() instanceof ListChooserPanel) {
            return ((ListChooserPanel)this.getPopupPanel()).getList();
        }
        return null;
    }

    public void addItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).addElement(object);
    }

    public void insertItemAt(Object object, int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).insertElementAt(object, n);
    }

    public void removeItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElement(object);
    }

    public void removeItemAt(int n) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElementAt(n);
    }

    public void removeAllItems() {
        this.checkMutableComboBoxModel();
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.dataModel;
        int n = mutableComboBoxModel.getSize();
        if (mutableComboBoxModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)mutableComboBoxModel).removeAllElements();
        } else {
            for (int i = 0; i < n; ++i) {
                Object e = mutableComboBoxModel.getElementAt(0);
                mutableComboBoxModel.removeElement(e);
            }
        }
        this.selectedItemReminder = null;
        this.getEditor().setItem(null);
    }

    void checkMutableComboBoxModel() {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Cannot use this method with a non-Mutable data model.");
        }
    }

    protected class ListRendererComponent
    extends AbstractComboBox.DefaultRendererComponent {
        public ListRendererComponent(Class<?> clazz) {
            super(clazz);
        }

        @Override
        protected void registerKeys(JComponent jComponent) {
            super.registerKeys(jComponent);
            ListComboBox.this.registerNavigationKeys(this, ListComboBox.this);
        }

        @Override
        public Dimension getPreferredSize() {
            Object object = ListComboBox.this.getPrototypeDisplayValue();
            Dimension dimension = new Dimension(0, 0);
            if (object == null) {
                if (!ListComboBox.this._isDisplaySizeDirty && ListComboBox.this._cachedDisplaySize != null) {
                    return ListComboBox.this._cachedDisplaySize;
                }
                ComboBoxModel comboBoxModel = ListComboBox.this.getModel();
                int n = comboBoxModel.getSize();
                JTextField jTextField = ListComboBox.this.createTextField();
                jTextField.setFont(ListComboBox.this.getFont());
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        Object e = comboBoxModel.getElementAt(i);
                        jTextField.setText(this.convertElementToString(e));
                        dimension.width = Math.max(dimension.width, jTextField.getPreferredSize().width);
                        dimension.height = Math.max(dimension.height, jTextField.getPreferredSize().height);
                    }
                    ListComboBox.this._cachedDisplaySize = new Dimension(dimension.width, dimension.height);
                    ListComboBox.this._isDisplaySizeDirty = false;
                    Insets insets = jTextField.getInsets();
                    if (!ListComboBox.this.isAquaLnfInUse()) {
                        dimension.width -= insets.left + insets.right;
                        dimension.height -= insets.top + insets.bottom;
                    }
                    return dimension;
                }
            }
            return super.getPreferredSize();
        }
    }

    protected class ListEditorComponent
    extends AbstractComboBox.DefaultTextFieldEditorComponent {
        public ListEditorComponent(Class<?> clazz) {
            super(clazz);
            this._textField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (ListEditorComponent.this.isEnabled() && ListComboBox.this.isButtonVisible() && mouseEvent.getClickCount() == 2 && ListComboBox.this.isToggleValueOnDoubleClick()) {
                        ListComboBox.this.toggleValue(ListEditorComponent.this, 40);
                    }
                }
            });
        }

        @Override
        protected void registerKeys(JComponent jComponent) {
            super.registerKeys(jComponent);
            ListComboBox.this.registerNavigationKeys(this, jComponent);
        }

        @Override
        public Dimension getPreferredSize() {
            Object object = ListComboBox.this.getPrototypeDisplayValue();
            Dimension dimension = new Dimension(0, 0);
            if (object == null) {
                if (!ListComboBox.this._isDisplaySizeDirty && ListComboBox.this._cachedDisplaySize != null) {
                    return ListComboBox.this._cachedDisplaySize;
                }
                ComboBoxModel comboBoxModel = ListComboBox.this.getModel();
                int n = comboBoxModel.getSize();
                JTextField jTextField = ListComboBox.this.createTextField();
                jTextField.setFont(ListComboBox.this.getFont());
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        Object e = comboBoxModel.getElementAt(i);
                        jTextField.setText(this.convertElementToString(e));
                        dimension.width = Math.max(dimension.width, jTextField.getPreferredSize().width);
                        dimension.height = Math.max(dimension.height, jTextField.getPreferredSize().height);
                    }
                    ListComboBox.this._cachedDisplaySize = new Dimension(dimension.width, dimension.height);
                    ListComboBox.this._isDisplaySizeDirty = false;
                    Insets insets = jTextField.getInsets();
                    if (!ListComboBox.this.isAquaLnfInUse()) {
                        dimension.width -= insets.left + insets.right;
                        dimension.height -= insets.top + insets.bottom;
                    }
                    return dimension;
                }
            }
            return super.getPreferredSize();
        }
    }
}

