/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ColorChooserPanel;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;

public class JideColorSplitButton
extends JideSplitButton {
    private Color _selectedColor;
    private ColorIcon _colorIcon;
    private Rectangle _rect;
    public ColorChooserPanel _colorChooserPanel;
    public ItemListener _itemListener;

    public JideColorSplitButton() {
        this((Icon)null);
    }

    public JideColorSplitButton(Icon icon) {
        this(icon, null);
    }

    public JideColorSplitButton(Icon icon, Rectangle rectangle) {
        this.setColorIcon(icon);
        this._rect = rectangle;
        this._colorChooserPanel = this.createColorChooserPanel();
        this.add(this._colorChooserPanel);
        this._itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    JideColorSplitButton.this._colorIcon.setColor((Color)itemEvent.getItem());
                    JideColorSplitButton.this.setSelectedColor((Color)itemEvent.getItem());
                    JideColorSplitButton.this.hideMenu();
                    JideColorSplitButton.this.repaint();
                    ActionEvent actionEvent = new ActionEvent(this, 1001, "");
                    JideColorSplitButton.this.fireActionPerformed(actionEvent);
                }
            }
        };
        this._colorChooserPanel.addItemListener(this._itemListener);
    }

    protected ColorChooserPanel createColorChooserPanel() {
        ColorChooserPanel colorChooserPanel = new ColorChooserPanel(1, true, true){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setBackground(UIDefaultsLookup.getColor("MenuItem.background"));
            }
        };
        colorChooserPanel.setBackground(UIDefaultsLookup.getColor("MenuItem.background"));
        return colorChooserPanel;
    }

    public Icon getColorIcon() {
        return this._colorIcon.getIcon();
    }

    public void setColorIcon(Icon icon) {
        this._colorIcon = new ColorIcon(icon);
        this.setIcon(this._colorIcon);
    }

    public void setLastSelectedColor(Color color) {
        this._colorIcon.setColor(color);
    }

    public Color getLastSelectedColor() {
        return this._colorIcon.getColor();
    }

    public Color getSelectedColor() {
        return this._selectedColor;
    }

    public void setSelectedColor(Color color) {
        this._selectedColor = color;
        this._colorChooserPanel.removeItemListener(this._itemListener);
        this._colorChooserPanel.setSelectedColor(color);
        this._colorChooserPanel.addItemListener(this._itemListener);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(JideColorSplitButton.class.getName(), 4);
        }
    }

    private class ColorIcon
    implements Icon {
        private Icon _icon;
        private Color _color;

        public ColorIcon() {
            JideColorSplitButton.this.setOpaque(false);
        }

        public ColorIcon(Icon icon) {
            this._icon = icon;
        }

        public Icon getIcon() {
            return this._icon;
        }

        public void setIcon(Icon icon) {
            this._icon = icon;
        }

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color color) {
            this._color = color;
        }

        @Override
        public int getIconHeight() {
            return this._icon != null ? this._icon.getIconHeight() : 16;
        }

        @Override
        public int getIconWidth() {
            return this._icon != null ? this._icon.getIconWidth() : 16;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this._icon != null) {
                this._icon.paintIcon(component, graphics, n, n2);
            }
            if (this.getColor() == null) {
                graphics.setColor(Color.BLACK);
                if (JideColorSplitButton.this._rect != null) {
                    graphics.drawRect(n + ((JideColorSplitButton)JideColorSplitButton.this)._rect.x, n2 + ((JideColorSplitButton)JideColorSplitButton.this)._rect.y, ((JideColorSplitButton)JideColorSplitButton.this)._rect.width, ((JideColorSplitButton)JideColorSplitButton.this)._rect.height);
                } else {
                    graphics.drawRect(n, n2 + this.getIconHeight() - 4, this.getIconWidth(), 4);
                }
            } else {
                graphics.setColor(this.getColor());
                if (JideColorSplitButton.this._rect != null) {
                    graphics.fillRect(n + ((JideColorSplitButton)JideColorSplitButton.this)._rect.x, n2 + ((JideColorSplitButton)JideColorSplitButton.this)._rect.y, ((JideColorSplitButton)JideColorSplitButton.this)._rect.width, ((JideColorSplitButton)JideColorSplitButton.this)._rect.height);
                } else {
                    graphics.fillRect(n, n2 + this.getIconHeight() - 4, this.getIconWidth(), 4);
                }
            }
        }
    }
}

