/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ButtonPopupPanel;
import com.jidesoft.combobox.FontChooserResource;
import com.jidesoft.combobox.Resource;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.spinner.SpinnerWheelSupport;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialLineBorder;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InsetsChooserPanel
extends ButtonPopupPanel {
    private JComponent _previewComponent;
    private JSpinner _topSpinner;
    private JSpinner _bottomSpinner;
    private JSpinner _leftSpinner;
    private JSpinner _rightSpinner;
    private Insets _oldInsets;
    private JComponent _previewPanel;
    static final String PROPERTY_INSETS = "insets";

    public InsetsChooserPanel() {
        this.initComponents();
        this.installListeners();
    }

    public InsetsChooserPanel(Action action, Action action2) {
        super(action, action2);
        this.initComponents();
        this.installListeners();
    }

    private void installListeners() {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                InsetsChooserPanel.this.setPreviewComponentInsets();
            }
        };
        this._topSpinner.addChangeListener(changeListener);
        this._leftSpinner.addChangeListener(changeListener);
        this._bottomSpinner.addChangeListener(changeListener);
        this._rightSpinner.addChangeListener(changeListener);
        this.setPreviewComponentInsets();
    }

    protected void setPreviewComponentInsets() {
        Insets insets = this.internalGetSelectedInsets();
        if (!JideSwingUtilities.equals(insets, this._oldInsets)) {
            if (this._previewComponent instanceof InsetsPreviewComponent) {
                ((InsetsPreviewComponent)this._previewComponent).setInsets(insets);
            }
            this.firePropertyChange(PROPERTY_INSETS, this._oldInsets, insets);
            this._oldInsets = insets;
        }
    }

    protected void initComponents() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        this._previewPanel = this.createPreviewPanel();
        jPanel.add(this._previewPanel);
        jPanel.add((Component)this.createInsetsChooserPanel(), "Last");
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new BorderLayout());
        this.add(jPanel);
        Component component = this.createButtonPanel(4);
        if (component != null) {
            this.add(component, "Last");
        }
        this.setDefaultFocusComponent(this._topSpinner);
    }

    private JComponent createInsetsChooserPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 3, 6, 6));
        this._topSpinner = this.createSpinner(this.createSpinnerModel());
        this._leftSpinner = this.createSpinner(this.createSpinnerModel());
        this._bottomSpinner = this.createSpinner(this.createSpinnerModel());
        this._rightSpinner = this.createSpinner(this.createSpinnerModel());
        jPanel.add(new JPanel());
        jPanel.add(this.createLabeledComponent(this.getResourceString("InsetsChooser.top"), 0, this._topSpinner));
        jPanel.add(new JPanel());
        jPanel.add(this.createLabeledComponent(this.getResourceString("InsetsChooser.left"), 0, this._leftSpinner));
        jPanel.add(new JPanel());
        jPanel.add(this.createLabeledComponent(this.getResourceString("InsetsChooser.right"), 0, this._rightSpinner));
        jPanel.add(new JPanel());
        jPanel.add(this.createLabeledComponent(this.getResourceString("InsetsChooser.bottom"), 0, this._bottomSpinner));
        jPanel.add(new JPanel());
        return jPanel;
    }

    protected String getResourceString(String string) {
        if (string != null && string.startsWith("FontChooser")) {
            return FontChooserResource.getResourceBundle(this.getLocale()).getString(string);
        }
        return Resource.getResourceBundle(this.getLocale()).getString(string);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._topSpinner != null && this._topSpinner.getParent() != null && this._topSpinner.getParent().getComponent(0) instanceof JLabel) {
            ((JLabel)this._topSpinner.getParent().getComponent(0)).setText(this.getResourceString("InsetsChooser.top"));
        }
        if (this._leftSpinner != null && this._leftSpinner.getParent() != null && this._leftSpinner.getParent().getComponent(0) instanceof JLabel) {
            ((JLabel)this._leftSpinner.getParent().getComponent(0)).setText(this.getResourceString("InsetsChooser.left"));
        }
        if (this._rightSpinner != null && this._rightSpinner.getParent() != null && this._rightSpinner.getParent().getComponent(0) instanceof JLabel) {
            ((JLabel)this._rightSpinner.getParent().getComponent(0)).setText(this.getResourceString("InsetsChooser.right"));
        }
        if (this._bottomSpinner != null && this._bottomSpinner.getParent() != null && this._bottomSpinner.getParent().getComponent(0) instanceof JLabel) {
            ((JLabel)this._bottomSpinner.getParent().getComponent(0)).setText(this.getResourceString("InsetsChooser.bottom"));
        }
        if (this._previewPanel != null) {
            this._previewPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(new PartialLineBorder(Color.gray, 1, true), " " + this.getResourceString("FontChooser.Preview.text") + " ", 4, 2), BorderFactory.createEmptyBorder(2, 4, 4, 4)));
        }
    }

    protected SpinnerModel createSpinnerModel() {
        return new SpinnerNumberModel(6, 0, 100, 1);
    }

    protected JSpinner createSpinner(SpinnerModel spinnerModel) {
        JSpinner jSpinner = new JSpinner(spinnerModel);
        SpinnerWheelSupport.installMouseWheelSupport(jSpinner);
        return jSpinner;
    }

    private JComponent createLabeledComponent(String string, int n, Component component) {
        JLabel jLabel = new JLabel(string);
        jLabel.setDisplayedMnemonicIndex(n);
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        jPanel.add((Component)jLabel, "First");
        jPanel.add(component, "Center");
        jLabel.setLabelFor(component);
        return jPanel;
    }

    protected JComponent createPreviewPanel() {
        this._previewComponent = this.createPreviewComponent();
        this._previewComponent.setPreferredSize(new Dimension(200, 60));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this._previewComponent);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(new PartialLineBorder(Color.gray, 1, true), " " + this.getResourceString("FontChooser.Preview.text") + " ", 4, 2), BorderFactory.createEmptyBorder(2, 4, 4, 4)));
        return jPanel;
    }

    protected JComponent createPreviewComponent() {
        return new InsetsPreviewComponent();
    }

    public Insets getSelectedInsets() {
        Object object = this.getSelectedObject();
        if (object instanceof Insets) {
            return (Insets)object;
        }
        return null;
    }

    public void setSelectedInsets(Insets insets) {
        this.setSelectedObject(insets);
    }

    @Override
    public Object getSelectedObject() {
        Object object = super.getSelectedObject();
        if (!(object instanceof Insets)) {
            return object;
        }
        return this.internalGetSelectedInsets();
    }

    @Override
    protected void prepareSelectedObject() {
        if (super.getSelectedObject() == null) {
            this.setSelectedObject((Object)this.internalGetSelectedInsets(), false);
        }
    }

    Insets internalGetSelectedInsets() {
        return new Insets((Integer)this._topSpinner.getValue(), (Integer)this._leftSpinner.getValue(), (Integer)this._bottomSpinner.getValue(), (Integer)this._rightSpinner.getValue());
    }

    @Override
    public void setSelectedObject(Object object) {
        if (object instanceof Insets) {
            Insets insets = (Insets)object;
            this._topSpinner.setValue(insets.top);
            this._leftSpinner.setValue(insets.left);
            this._bottomSpinner.setValue(insets.bottom);
            this._rightSpinner.setValue(insets.right);
        }
        super.setSelectedObject(object);
    }

    public static void main(String[] stringArray) {
        LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
        final JDialog jDialog = new JDialog();
        jDialog.getContentPane().add(new InsetsChooserPanel(new AbstractAction(){
            private static final long serialVersionUID = -2584478256709594066L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        }, new AbstractAction(){
            private static final long serialVersionUID = -2188721215505472689L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        }));
        jDialog.pack();
        jDialog.setDefaultCloseOperation(2);
        jDialog.setVisible(true);
    }

    class InsetsPreviewComponent
    extends JComponent {
        private Insets _insets = null;

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this._insets == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(UIDefaultsLookup.getColor("controlShadow"));
            int n = this.getWidth() - 1;
            int n2 = this.getHeight() - 1;
            graphics2D.drawRect(0, 0, n, n2);
            graphics2D.setColor(this.getForeground());
            graphics2D.setStroke(new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{2.0f, 2.0f, 0.0f, 2.0f}, 0.0f));
            graphics2D.drawLine(0, this._insets.top, n, this._insets.top);
            graphics2D.drawLine(this._insets.left, 0, this._insets.left, n2);
            graphics2D.drawLine(0, n2 - this._insets.bottom, n, n2 - this._insets.bottom);
            graphics2D.drawLine(n - this._insets.right, 0, n - this._insets.right, n2);
        }

        @Override
        public Insets getInsets() {
            return this._insets;
        }

        public void setInsets(Insets insets) {
            this._insets = insets;
            this.repaint();
        }
    }
}

