/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ButtonPopupPanel;
import com.jidesoft.combobox.FontChooserResource;
import com.jidesoft.combobox.FontListCellRenderer;
import com.jidesoft.spinner.SpinnerWheelSupport;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialLineBorder;
import com.jidesoft.swing.SearchableUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontChooserPanel
extends ButtonPopupPanel {
    protected JLabel _previewLabel;
    protected JComboBox _fontNameComboBox;
    protected JSpinner _sizeSpinner;
    protected JCheckBox _boldCheckBox;
    protected JCheckBox _italicCheckBox;
    private JLabel _fontLabel;
    private JLabel _sizeLabel;
    private JLabel _styleLabel;
    private Font _oldFont;
    private JComponent _previewPanel;
    static final String PROPERTY_FONT = "font";
    private String _previewText;
    protected ComboBoxModel _fontNameComboBoxModel;

    public FontChooserPanel() {
        this.initComponents();
        this.installListeners();
    }

    public FontChooserPanel(Action action, Action action2) {
        super(action, action2);
        this.initComponents();
        this.installListeners();
    }

    protected void installListeners() {
        this._fontNameComboBoxModel = this.createFontNameComboBoxModel();
        this._fontNameComboBox.setModel(this._fontNameComboBoxModel);
        this._fontNameComboBox.setRenderer(new FontListCellRenderer(this._fontNameComboBox.getRenderer()));
        this._fontNameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooserPanel.this.setPreviewLabelFont();
            }
        });
        this._sizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FontChooserPanel.this.setPreviewLabelFont();
            }
        });
        this._boldCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooserPanel.this.setPreviewLabelFont();
            }
        });
        this._italicCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooserPanel.this.setPreviewLabelFont();
            }
        });
        this.setPreviewLabelFont();
    }

    protected void setPreviewLabelFont() {
        Font font = this.internalGetSelectedFont();
        if (!JideSwingUtilities.equals(this._oldFont, font)) {
            this._previewLabel.setFont(font);
            this.firePropertyChange(PROPERTY_FONT, this._oldFont, font);
            this._oldFont = font;
        }
    }

    protected DefaultComboBoxModel createFontNameComboBoxModel() {
        return new DefaultComboBoxModel<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    public ComboBoxModel getFontNameComboBoxModel() {
        return this._fontNameComboBoxModel;
    }

    public void setFontNameComboBoxModel(ComboBoxModel comboBoxModel) {
        this._fontNameComboBoxModel = comboBoxModel;
        if (this._fontNameComboBox != null) {
            this._fontNameComboBox.setModel(comboBoxModel);
        }
    }

    protected void initComponents() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        this._previewPanel = this.createPreviewPanel();
        jPanel.add(this._previewPanel);
        jPanel.add((Component)this.createFontChooserPanel(), "Last");
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new BorderLayout());
        this.add(jPanel);
        Component component = this.createButtonPanel(4);
        if (component != null) {
            this.add(component, "Last");
        }
        this.setDefaultFocusComponent(this._fontNameComboBox);
    }

    protected JComponent createFontChooserPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this._fontNameComboBox = new JComboBox();
        this._fontNameComboBox.setPrototypeDisplayValue("W");
        SearchableUtils.installSearchable(this._fontNameComboBox);
        this._sizeSpinner = new JSpinner(new SpinnerNumberModel(10, 1, 100, 1));
        SpinnerWheelSupport.installMouseWheelSupport(this._sizeSpinner);
        this._boldCheckBox = new JCheckBox(this.getResourceString("FontChooser.Bold.text"));
        this._boldCheckBox.setMnemonic(this.getResourceString("FontChooser.Bold.mnemonic").charAt(0));
        this._italicCheckBox = new JCheckBox(this.getResourceString("FontChooser.Italic.text"));
        this._italicCheckBox.setMnemonic(this.getResourceString("FontChooser.Italic.mnemonic").charAt(0));
        this._italicCheckBox.setOpaque(false);
        this._boldCheckBox.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 3, 6);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        this._fontLabel = new JLabel(this.getResourceString("FontChooser.Font.text"));
        this._fontLabel.setDisplayedMnemonic(this.getResourceString("FontChooser.Font.mnemonic").charAt(0));
        this._fontLabel.setLabelFor(this._fontNameComboBox);
        jPanel.add((Component)this._fontLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this._sizeLabel = new JLabel(this.getResourceString("FontChooser.Size.text"));
        this._sizeLabel.setDisplayedMnemonic(this.getResourceString("FontChooser.Size.mnemonic").charAt(0));
        jPanel.add((Component)this._sizeLabel, gridBagConstraints);
        this._sizeLabel.setLabelFor(this._sizeSpinner);
        gridBagConstraints.gridy = 2;
        this._styleLabel = new JLabel(this.getResourceString("FontChooser.Style.text"));
        jPanel.add((Component)this._styleLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this._fontNameComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this._sizeSpinner, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 0, 0));
        jPanel2.add(this._boldCheckBox);
        jPanel2.add(this._italicCheckBox);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    protected JComponent createPreviewPanel() {
        this._previewText = "ABCDEFabcdef 012345";
        this._previewLabel = new JLabel(this._previewText);
        this._previewLabel.setHorizontalAlignment(0);
        this._previewLabel.setVerticalAlignment(0);
        this._previewLabel.setPreferredSize(new Dimension(200, 60));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this._previewLabel);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(new PartialLineBorder(Color.gray, 1, true), " " + this.getResourceString("FontChooser.Preview.text") + " ", 4, 2), BorderFactory.createEmptyBorder(2, 4, 4, 4)));
        return jPanel;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._boldCheckBox != null) {
            this._boldCheckBox.setText(this.getResourceString("FontChooser.Bold.text"));
            this._boldCheckBox.setMnemonic(this.getResourceString("FontChooser.Bold.mnemonic").charAt(0));
        }
        if (this._italicCheckBox != null) {
            this._italicCheckBox.setText(this.getResourceString("FontChooser.Italic.text"));
            this._italicCheckBox.setMnemonic(this.getResourceString("FontChooser.Italic.mnemonic").charAt(0));
        }
        if (this._fontLabel != null) {
            this._fontLabel.setText(this.getResourceString("FontChooser.Font.text"));
            this._fontLabel.setDisplayedMnemonic(this.getResourceString("FontChooser.Font.mnemonic").charAt(0));
        }
        if (this._sizeLabel != null) {
            this._sizeLabel.setText(this.getResourceString("FontChooser.Size.text"));
            this._sizeLabel.setDisplayedMnemonic(this.getResourceString("FontChooser.Size.mnemonic").charAt(0));
        }
        if (this._sizeLabel != null) {
            this._styleLabel.setText(this.getResourceString("FontChooser.Style.text"));
        }
        if (this._previewPanel != null) {
            this._previewPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(new PartialLineBorder(Color.gray, 1, true), " " + this.getResourceString("FontChooser.Preview.text") + " ", 4, 2), BorderFactory.createEmptyBorder(2, 4, 4, 4)));
        }
    }

    public Font getSelectedFont() {
        Object object = this.getSelectedObject();
        if (object instanceof Font) {
            return (Font)object;
        }
        return null;
    }

    public void setSelectedFont(Font font) {
        this.setSelectedObject(font);
    }

    @Override
    public Object getSelectedObject() {
        Object object = super.getSelectedObject();
        if (!(object instanceof Font)) {
            return object;
        }
        return this.internalGetSelectedFont();
    }

    @Override
    protected void prepareSelectedObject() {
        if (super.getSelectedObject() == null) {
            this.setSelectedObject((Object)this.internalGetSelectedFont(), false);
        }
    }

    Font internalGetSelectedFont() {
        return new Font((String)this._fontNameComboBox.getSelectedItem(), (this._boldCheckBox.isSelected() ? 1 : 0) | (this._italicCheckBox.isSelected() ? 2 : 0), (Integer)this._sizeSpinner.getValue());
    }

    @Override
    public void setSelectedObject(Object object) {
        if (object instanceof Font) {
            Font font = (Font)object;
            this._fontNameComboBox.setSelectedItem(font.getName());
            this._sizeSpinner.setValue(font.getSize());
            this._boldCheckBox.setSelected((font.getStyle() & 1) != 0);
            this._italicCheckBox.setSelected((font.getStyle() & 2) != 0);
        }
        super.setSelectedObject(object);
    }

    public String getPreviewText() {
        return this._previewText;
    }

    public void setPreviewText(String string) {
        this._previewText = string;
        if (this._previewLabel != null) {
            this._previewLabel.setText(this._previewText);
        }
    }

    protected String getResourceString(String string) {
        return FontChooserResource.getResourceBundle(this.getLocale()).getString(string);
    }
}

