/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.DefaultComboBoxModelWrapper;
import com.jidesoft.filter.Filter;
import com.jidesoft.list.ListFilter;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;

public class FilterableComboBoxModel<E>
extends DefaultComboBoxModelWrapper<E> {
    private static final long serialVersionUID = 8376246706531869607L;
    protected List<Filter<E>> _filters = new ArrayList<Filter<E>>();
    protected boolean _filtersApplied = false;
    private boolean _andMode = true;
    private boolean _reselectItemOnFiltering = true;

    public FilterableComboBoxModel() {
    }

    public FilterableComboBoxModel(ComboBoxModel<E> comboBoxModel) {
        super(comboBoxModel);
    }

    @Override
    public void setActualModel(ComboBoxModel<E> comboBoxModel) {
        super.setActualModel(comboBoxModel);
        if (this.getActualModel() != null) {
            this.reallocateIndexes();
            this.getActualModel().addListDataListener(this);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        int n;
        super.intervalAdded(listDataEvent);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = listDataEvent.getIndex1() - listDataEvent.getIndex0() + 1;
        if (this.isFiltersApplied()) {
            List<Filter<E>> list = this._filters;
            for (n = listDataEvent.getIndex0(); n <= listDataEvent.getIndex1(); ++n) {
                boolean bl = this.shouldBeFiltered(n, list);
                if (bl) continue;
                arrayList.add(n);
            }
        } else {
            for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                arrayList.add(i);
            }
        }
        int n3 = 0;
        n = this.getIndexes().length - 1;
        while (n >= 0) {
            if (this.getIndexes()[n] < listDataEvent.getIndex0()) {
                n3 = n + 1;
                break;
            }
            int[] nArray = this.getIndexes();
            int n4 = n--;
            nArray[n4] = nArray[n4] + n2;
        }
        if (arrayList.size() != 0) {
            this.insert(n3, arrayList);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        int n;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = listDataEvent.getIndex1() - listDataEvent.getIndex0() + 1;
        if (this.isFiltersApplied()) {
            for (n2 = listDataEvent.getIndex0(); n2 <= listDataEvent.getIndex1(); ++n2) {
                n = this.getIndexAt(n2);
                if (n == -1) continue;
                arrayList.add(n2);
            }
        } else {
            for (n2 = listDataEvent.getIndex0(); n2 <= listDataEvent.getIndex1(); ++n2) {
                arrayList.add(n2);
            }
        }
        n2 = 0;
        for (n = this.getIndexes().length - 1; n >= 0; --n) {
            if (this.getIndexes()[n] < listDataEvent.getIndex0()) {
                n2 = n + 1;
                break;
            }
            if (this.getIndexes()[n] <= listDataEvent.getIndex1()) continue;
            int[] nArray = this.getIndexes();
            int n4 = n;
            nArray[n4] = nArray[n4] - n3;
        }
        if (arrayList.size() != 0) {
            this.remove(n2, arrayList);
        }
        super.intervalRemoved(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        if (this.isFiltersApplied()) {
            List<Filter<E>> list = this._filters;
            for (n = listDataEvent.getIndex0(); n <= listDataEvent.getIndex1(); ++n) {
                boolean bl = this.getIndexAt(n) != -1;
                boolean bl2 = this.shouldBeFiltered(n, list);
                if (bl2 && bl) {
                    arrayList3.add(n);
                    continue;
                }
                if (!bl2 && !bl) {
                    arrayList2.add(n);
                    continue;
                }
                if (bl2 || !bl) continue;
                arrayList.add(n);
            }
        } else {
            this.fireContentsChanged(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
            return;
        }
        int n2 = 0;
        for (n = this.getIndexes().length - 1; n >= 0; --n) {
            if (this.getIndexes()[n] >= listDataEvent.getIndex0()) continue;
            n2 = n + 1;
            break;
        }
        if (arrayList3.size() != 0) {
            this.remove(n2, arrayList3);
        }
        if (arrayList2.size() != 0) {
            this.insert(n2, arrayList2);
        }
        if (arrayList.size() != 0) {
            this.fireContentsChanged(this, n2, n2 + arrayList.size() - 1);
        }
        super.contentsChanged(listDataEvent);
    }

    public void refresh() {
        int n = this.getSize();
        this.filter();
        if (this.isReselectItemOnFiltering()) {
            this.reselectItem();
        }
        if (n > 0) {
            this.fireIntervalRemoved(this, 0, n - 1);
        }
        if (this.getSize() > 0) {
            this.fireIntervalAdded(this, 0, this.getSize() - 1);
        }
    }

    private void filter() {
        int n = this.getActualModel().getSize();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.isFiltersApplied()) {
            List<Filter<E>> list = this._filters;
            for (int i = 0; i < n; ++i) {
                boolean bl = this.shouldBeFiltered(i, list);
                if (bl) continue;
                arrayList.add(i);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                arrayList.add(i);
            }
        }
        this.setIndexes(new int[arrayList.size()]);
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n2 = (Integer)arrayList.get(i);
            this.getIndexes()[i] = n2;
        }
    }

    protected boolean shouldBeFiltered(int n, List<Filter<E>> list) {
        boolean bl = false;
        if (this.isFiltersApplied()) {
            if (n >= this.getActualModel().getSize() || n < 0) {
                return bl;
            }
            Object e = this.getActualModel().getElementAt(n);
            if (list != null) {
                if (this.isAndMode()) {
                    for (Filter<E> filter : list) {
                        if (!filter.isEnabled()) continue;
                        if (filter instanceof ListFilter) {
                            ((ListFilter)filter).setRowIndex(n);
                        }
                        if (!filter.isValueFiltered(e)) continue;
                        bl = true;
                        break;
                    }
                } else {
                    boolean bl2 = false;
                    for (Filter<E> filter : list) {
                        if (!filter.isEnabled()) continue;
                        if (filter instanceof ListFilter) {
                            ((ListFilter)filter).setRowIndex(n);
                        }
                        if (filter.isValueFiltered(e)) continue;
                        bl2 = true;
                        break;
                    }
                    if (list.size() > 0 && !bl2) {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public void addFilters(List<Filter<E>> list) {
        for (Filter<E> filter : list) {
            this._filters.add(filter);
        }
    }

    public void addFilter(Filter<E> filter) {
        this._filters.add(filter);
    }

    public void removeFilter(Filter filter) {
        this._filters.remove(filter);
    }

    public void clearFilters() {
        this._filters.clear();
    }

    public Filter<E>[] getFilters() {
        List<Filter<E>> list = this.internalGetFilters();
        if (list != null) {
            return list.toArray(new Filter[list.size()]);
        }
        return new Filter[0];
    }

    private List<Filter<E>> internalGetFilters() {
        return this._filters;
    }

    public void setFiltersApplied(boolean bl) {
        this._filtersApplied = bl;
        this.filter();
        if (this.isReselectItemOnFiltering()) {
            this.reselectItem();
        }
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public boolean isFiltersApplied() {
        return this._filtersApplied;
    }

    public boolean isAndMode() {
        return this._andMode;
    }

    public void setAndMode(boolean bl) {
        this._andMode = bl;
    }

    private void insert(int n, List<Integer> list) {
        int[] nArray = (int[])this.getIndexes().clone();
        this.setIndexes(new int[nArray.length + list.size()]);
        System.arraycopy(nArray, 0, this.getIndexes(), 0, n);
        for (int i = 0; i < list.size(); ++i) {
            Integer n2 = list.get(i);
            this.getIndexes()[n + i] = n2;
        }
        System.arraycopy(nArray, n, this.getIndexes(), n + list.size(), this.getIndexes().length - n - list.size());
        this.fireIntervalAdded(this, n, n + list.size() - 1);
    }

    private void remove(int n, List<Integer> list) {
        int n2 = list.size();
        int[] nArray = (int[])this.getIndexes().clone();
        this.setIndexes(new int[nArray.length - n2]);
        System.arraycopy(nArray, 0, this.getIndexes(), 0, n);
        System.arraycopy(nArray, n + n2, this.getIndexes(), n, this.getIndexes().length - n);
        this.fireIntervalRemoved(this, n, n + n2 - 1);
    }

    public boolean isReselectItemOnFiltering() {
        return this._reselectItemOnFiltering;
    }

    public void setReselectItemOnFiltering(boolean bl) {
        this._reselectItemOnFiltering = bl;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(FilterableComboBoxModel.class.getName(), 4);
        }
    }
}

