/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.DateSelectionEvent;
import com.jidesoft.combobox.DateSelectionListener;
import com.jidesoft.combobox.DateSelectionModel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.event.EventListenerList;

public class DefaultDateSelectionModel
implements DateSelectionModel {
    private DateSelectionModel _model;
    private DateSelectionModel _oldSelectionModel;
    private boolean _isAdjusting;
    private boolean _pendingEvent;
    private EventListenerList _listenerList = null;
    private static Calendar calendar1 = Calendar.getInstance();
    private static Calendar calendar2 = Calendar.getInstance();

    public DefaultDateSelectionModel() {
        this.setSelectionMode(0);
    }

    public DefaultDateSelectionModel(int n) {
        this.setSelectionMode(n);
    }

    @Override
    public void addSelectionInterval(Date date, Date date2) {
        this._model.addSelectionInterval(DefaultDateSelectionModel.cloneDate(date), DefaultDateSelectionModel.cloneDate(date2));
    }

    @Override
    public void setSelectionInterval(Date date, Date date2) {
        this._model.setSelectionInterval(DefaultDateSelectionModel.cloneDate(date), DefaultDateSelectionModel.cloneDate(date2));
    }

    @Override
    public void clearSelection() {
        this._model.clearSelection();
    }

    @Override
    public boolean isSelectedDate(Date date) {
        return this._model.isSelectedDate(date);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this._model.isSelectionEmpty();
    }

    @Override
    public void removeSelectionInterval(Date date, Date date2) {
        this._model.removeSelectionInterval(DefaultDateSelectionModel.cloneDate(date), DefaultDateSelectionModel.cloneDate(date2));
    }

    @Override
    public synchronized void addDateSelectionListener(DateSelectionListener dateSelectionListener) {
        if (this._listenerList == null) {
            this._listenerList = new EventListenerList();
        }
        this._listenerList.add(DateSelectionListener.class, dateSelectionListener);
    }

    @Override
    public synchronized void removeDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this._listenerList.remove(DateSelectionListener.class, dateSelectionListener);
    }

    private void saveOldSelectionModel() {
        try {
            this._oldSelectionModel = (DateSelectionModel)this._model.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this._oldSelectionModel = null;
        }
    }

    DateSelectionModel getOldSelectionModel() {
        return this._oldSelectionModel;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    void fireValueChanged(DateSelectionEvent dateSelectionEvent) {
        if (this._isAdjusting) {
            this._pendingEvent = true;
            return;
        }
        if (this._listenerList == null) {
            return;
        }
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DateSelectionListener.class) continue;
            ((DateSelectionListener)objectArray[i + 1]).valueChanged(dateSelectionEvent);
        }
        this._oldSelectionModel = null;
    }

    @Override
    public int getSelectionMode() {
        return this._model.getSelectionMode();
    }

    @Override
    public void setSelectionMode(int n) {
        if (this._model != null && n == this.getSelectionMode()) {
            return;
        }
        switch (n) {
            case 0: {
                this._model = new SingleSelection(this);
                break;
            }
            case 1: {
                this._model = new SingleInterval(this);
                break;
            }
            default: {
                this._model = new MultipleInterval(this);
            }
        }
    }

    @Override
    public Date getLeadSelectionDate() {
        return DefaultDateSelectionModel.cloneDate(this._model.getLeadSelectionDate());
    }

    @Override
    public void setLeadSelectionDate(Date date) {
        this._model.setLeadSelectionDate(DefaultDateSelectionModel.cloneDate(date));
    }

    @Override
    public Date getAnchorSelectionDate() {
        return DefaultDateSelectionModel.cloneDate(this._model.getAnchorSelectionDate());
    }

    @Override
    public void setAnchorSelectionDate(Date date) {
        this._model.setAnchorSelectionDate(DefaultDateSelectionModel.cloneDate(date));
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        if (this._isAdjusting != bl) {
            this._isAdjusting = bl;
            if (bl) {
                this.saveOldSelectionModel();
            } else if (this._pendingEvent) {
                this.fireValueChanged(new DateSelectionEvent(this));
                this._pendingEvent = false;
            }
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this._isAdjusting;
    }

    @Override
    public Date getSelectedDate() {
        return DefaultDateSelectionModel.cloneDate(this._model.getSelectedDate());
    }

    @Override
    public void setSelectedDate(Date date) {
        this._model.setSelectedDate(DefaultDateSelectionModel.cloneDate(date));
    }

    @Override
    public Date[] getSelectedDates() {
        return this._model.getSelectedDates();
    }

    @Override
    public void setSelectedDates(Date[] dateArray) {
        this._model.setSelectedDates(dateArray);
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        calendar1.setTimeZone(timeZone);
        calendar2.setTimeZone(timeZone);
    }

    static Date cloneDate(Date date) {
        return date == null ? null : (Date)date.clone();
    }

    static Calendar cloneCalendar(Calendar calendar) {
        return calendar == null ? null : (Calendar)calendar.clone();
    }

    private static Date[] getDates(Date date, Date date2) {
        if (date == null || date2 == null) {
            return new Date[0];
        }
        ArrayList<Date> arrayList = new ArrayList<Date>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        while (date2.after(calendar.getTime()) || DefaultDateSelectionModel.isSameDay(date2, calendar.getTime())) {
            arrayList.add(calendar.getTime());
            calendar.add(6, 1);
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new Date[arrayList.size()]);
    }

    private static synchronized boolean isSameDay() {
        if (calendar1.get(6) != calendar2.get(6)) {
            return false;
        }
        return calendar1.get(1) == calendar2.get(1);
    }

    static synchronized boolean isSameDay(Date date, Date date2) {
        calendar1.setTime(date);
        calendar2.setTime(date2);
        return DefaultDateSelectionModel.isSameDay();
    }

    private static synchronized boolean isEqualDay(Date date, Date date2) {
        return date == null && date2 == null || date != null && date2 != null && date.equals(date2);
    }

    private static class MultipleInterval
    extends AbstractDateSelectionModel {
        private List<Date> _selection;
        private transient Calendar _calendar;
        private Date _lead;
        private Date _anchor;
        private DefaultDateSelectionModel _model;

        MultipleInterval(DefaultDateSelectionModel defaultDateSelectionModel) {
            this._model = defaultDateSelectionModel;
            this._selection = new ArrayList<Date>();
            this._calendar = Calendar.getInstance();
        }

        @Override
        public void addSelectionInterval(Date date, Date date2) {
            Date date3;
            Date date4;
            if (date == null || date2 == null) {
                return;
            }
            if (!this._model._isAdjusting) {
                this._model.saveOldSelectionModel();
            }
            if (date.before(date2)) {
                date4 = date;
                date3 = date2;
            } else {
                date4 = date2;
                date3 = date;
            }
            this._calendar.setTime(date4);
            boolean bl = false;
            do {
                boolean bl2;
                if (bl2 = this.addSelectedDate(this._calendar.getTime())) {
                    bl = true;
                }
                this._calendar.add(6, 1);
            } while (date3.after(this._calendar.getTime()) || DefaultDateSelectionModel.isSameDay(date3, this._calendar.getTime()));
            if (!DefaultDateSelectionModel.isEqualDay(this._anchor, date)) {
                this._anchor = date;
                bl = true;
            }
            if (!DefaultDateSelectionModel.isEqualDay(this._lead, date2)) {
                this._lead = date2;
                bl = true;
            }
            if (bl) {
                this._model.fireValueChanged(new DateSelectionEvent(this._model));
            }
        }

        @Override
        public void setSelectionInterval(Date date, Date date2) {
            if (DefaultDateSelectionModel.isEqualDay(date, date2)) {
                this.setSelectedDate(date);
            } else {
                this.clearSelection();
                this.addSelectionInterval(date, date2);
            }
        }

        @Override
        public void clearSelection() {
            if (this._selection.size() > 0) {
                if (!this._model._isAdjusting) {
                    this._model.saveOldSelectionModel();
                }
                this._selection.clear();
                this._model.fireValueChanged(new DateSelectionEvent(this._model));
            }
        }

        @Override
        public boolean isSelectedDate(Date date) {
            if (this._selection.isEmpty()) {
                return false;
            }
            if (date == null) {
                return false;
            }
            if (this._selection.contains(date)) {
                return true;
            }
            for (Date date2 : this._selection) {
                if (!DefaultDateSelectionModel.isSameDay(date2, date)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSelectionEmpty() {
            return this._selection.isEmpty();
        }

        @Override
        public void removeSelectionInterval(Date date, Date date2) {
            Date[] dateArray;
            Date date3;
            Date date4;
            if (date == null || date2 == null) {
                return;
            }
            if (!this._model._isAdjusting) {
                this._model.saveOldSelectionModel();
            }
            if (date.before(date2)) {
                date4 = date;
                date3 = date2;
            } else {
                date4 = date2;
                date3 = date;
            }
            block0: for (Date date5 : dateArray = DefaultDateSelectionModel.getDates(date4, date3)) {
                for (Date date6 : this._selection) {
                    if (!DefaultDateSelectionModel.isSameDay(date5, date6)) continue;
                    this._selection.remove(date6);
                    continue block0;
                }
            }
            this.setAnchorSelectionDate(date);
            this.setLeadSelectionDate(date2);
            this._model.fireValueChanged(new DateSelectionEvent(this._model));
        }

        @Override
        public int getSelectionMode() {
            return 2;
        }

        @Override
        public Date getLeadSelectionDate() {
            return this._lead;
        }

        @Override
        public void setLeadSelectionDate(Date date) {
            if (!DefaultDateSelectionModel.isEqualDay(this._lead, date)) {
                if (!this._model._isAdjusting) {
                    this._model.saveOldSelectionModel();
                }
                this._lead = date;
                this._model.fireValueChanged(new DateSelectionEvent(this._model));
            }
        }

        @Override
        public Date getAnchorSelectionDate() {
            return this._anchor;
        }

        @Override
        public void setAnchorSelectionDate(Date date) {
            if (!DefaultDateSelectionModel.isEqualDay(this._anchor, date)) {
                if (!this._model._isAdjusting) {
                    this._model.saveOldSelectionModel();
                }
                this._anchor = date;
                this._model.fireValueChanged(new DateSelectionEvent(this._model));
            }
        }

        @Override
        public Date getSelectedDate() {
            if (this._selection.isEmpty()) {
                return null;
            }
            return this.getLeadSelectionDate();
        }

        @Override
        public void setSelectedDate(Date date) {
            if (this._selection.size() == 1 && DefaultDateSelectionModel.isEqualDay(date, this._selection.get(0))) {
                return;
            }
            if (!this._model._isAdjusting) {
                this._model.saveOldSelectionModel();
            }
            boolean bl = false;
            if (this._selection.size() > 0) {
                this._selection.clear();
                bl = true;
            }
            if (date != null) {
                boolean bl2 = this.addSelectedDate(date);
                if (bl2) {
                    bl = true;
                }
                if (!DefaultDateSelectionModel.isEqualDay(this._anchor, date)) {
                    this._anchor = date;
                    bl = true;
                }
                if (!DefaultDateSelectionModel.isEqualDay(this._lead, date)) {
                    this._lead = date;
                    bl = true;
                }
            }
            if (bl) {
                this._model.fireValueChanged(new DateSelectionEvent(this._model));
            }
        }

        private boolean addSelectedDate(Date date) {
            if (date != null && !this._selection.contains(date)) {
                this._selection.add(date);
                return true;
            }
            return false;
        }

        @Override
        public Date[] getSelectedDates() {
            Collections.sort(this._selection);
            return this._selection.toArray(new Date[this._selection.size()]);
        }

        @Override
        public void setSelectedDates(Date[] dateArray) {
            if (!this._model._isAdjusting) {
                this._model.saveOldSelectionModel();
            }
            this._selection.clear();
            if (dateArray != null && dateArray.length >= 1) {
                for (int i = 0; i < dateArray.length; ++i) {
                    this.addSelectedDate(dateArray[i]);
                    if (i != dateArray.length - 1) continue;
                    this.setLeadSelectionDate(dateArray[i]);
                }
            }
            this._model.fireValueChanged(new DateSelectionEvent(this._model));
        }

        @Override
        public void setTimeZone(TimeZone timeZone) {
            calendar1.setTimeZone(timeZone);
            calendar2.setTimeZone(timeZone);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Object object = super.clone();
            if (this._selection != null) {
                ((MultipleInterval)object)._selection = new ArrayList<Date>();
                ((MultipleInterval)object)._selection.addAll(this._selection);
            }
            if (this._lead != null) {
                ((MultipleInterval)object)._lead = (Date)this._lead.clone();
            }
            if (this._anchor != null) {
                ((MultipleInterval)object)._anchor = (Date)this._anchor.clone();
            }
            return object;
        }
    }

    private static class SingleInterval
    extends AbstractDateSelectionModel {
        private Date _from;
        private Date _to;
        private Date _lead;
        private Date _anchor;
        private DefaultDateSelectionModel _model;

        SingleInterval(DefaultDateSelectionModel defaultDateSelectionModel) {
            this._model = defaultDateSelectionModel;
        }

        @Override
        public void addSelectionInterval(Date date, Date date2) {
            this.setSelectionInterval(date, date2);
        }

        @Override
        public void setSelectionInterval(Date date, Date date2) {
            boolean bl = false;
            if (!this._model._isAdjusting) {
                this._model.saveOldSelectionModel();
            }
            if (date == null || date2 == null) {
                if (this._from != null || this._to != null) {
                    this._from = null;
                    this._to = null;
                    bl = true;
                }
            } else {
                if (date.after(date2)) {
                    if (!DefaultDateSelectionModel.isEqualDay(this._from, date2)) {
                        this._from = date2;
                        bl = true;
                    }
                    if (!DefaultDateSelectionModel.isEqualDay(this._to, date)) {
                        this._to = date;
                        bl = true;
                    }
                } else {
                    if (!DefaultDateSelectionModel.isEqualDay(this._from, date)) {
                        this._from = date;
                        bl = true;
                    }
                    if (!DefaultDateSelectionModel.isEqualDay(this._to, date2)) {
                        this._to = date2;
                        bl = true;
                    }
                }
                if (!DefaultDateSelectionModel.isEqualDay(this._anchor, date)) {
                    this._anchor = date;
                    bl = true;
                }
                if (!DefaultDateSelectionModel.isEqualDay(this._lead, date2)) {
                    this._lead = date2;
                    bl = true;
                }
            }
            if (bl) {
                this._model.fireValueChanged(new DateSelectionEvent(this._model));
            }
        }

        @Override
        public void clearSelection() {
            this.setSelectionInterval(null, null);
        }

        @Override
        public boolean isSelectedDate(Date date) {
            if (date == null) {
                return false;
            }
            if (this._from == null || this._to == null) {
                return false;
            }
            if (DefaultDateSelectionModel.isSameDay(date, this._from) || DefaultDateSelectionModel.isSameDay(date, this._to)) {
                return true;
            }
            return !date.before(this._from) && !date.after(this._to);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this._from == null || this._to == null;
        }

        @Override
        public void removeSelectionInterval(Date date, Date date2) {
            Date date3;
            Date date4;
            if (date == null || date2 == null) {
                return;
            }
            if (this._from == null || this._to == null) {
                return;
            }
            if (date.before(this._from) && date2.before(this._from)) {
                return;
            }
            if (date.after(this._to) && date2.after(this._to)) {
                return;
            }
            if (!this._model._isAdjusting) {
                this._model.saveOldSelectionModel();
            }
            if (date.before(date2)) {
                date4 = date;
                date3 = date2;
            } else {
                date4 = date2;
                date3 = date;
            }
            boolean bl = false;
            if (date4.before(this._from) && date3.after(this._to)) {
                this.clearSelection();
            } else if (date4.before(this._from) && date3.before(this._to)) {
                if (!DefaultDateSelectionModel.isEqualDay(this._to, date3)) {
                    this._to = date3;
                    bl = true;
                }
            } else if (date4.after(this._from) && date3.after(this._to)) {
                if (!DefaultDateSelectionModel.isEqualDay(this._from, date4)) {
                    this._from = date4;
                    bl = true;
                }
            } else if (!date4.after(this._from) || date3.before(this._to)) {
                // empty if block
            }
            if (bl) {
                this._model.fireValueChanged(new DateSelectionEvent(this._model));
            }
        }

        @Override
        public int getSelectionMode() {
            return 1;
        }

        @Override
        public Date getLeadSelectionDate() {
            return this._lead;
        }

        @Override
        public void setLeadSelectionDate(Date date) {
            if (!DefaultDateSelectionModel.isEqualDay(this._lead, date)) {
                if (!this._model._isAdjusting) {
                    this._model.saveOldSelectionModel();
                }
                this._lead = date;
                this._model.fireValueChanged(new DateSelectionEvent(this._model));
            }
        }

        @Override
        public Date getAnchorSelectionDate() {
            return this._anchor;
        }

        @Override
        public void setAnchorSelectionDate(Date date) {
            if (!DefaultDateSelectionModel.isEqualDay(this._anchor, date)) {
                if (!this._model._isAdjusting) {
                    this._model.saveOldSelectionModel();
                }
                this._anchor = date;
                this._model.fireValueChanged(new DateSelectionEvent(this._model));
            }
        }

        @Override
        public Date getSelectedDate() {
            return this._to;
        }

        @Override
        public void setSelectedDate(Date date) {
            this.setSelectionInterval(date, date);
        }

        @Override
        public Date[] getSelectedDates() {
            return DefaultDateSelectionModel.getDates(this._from, this._to);
        }

        @Override
        public void setSelectedDates(Date[] dateArray) {
            if (dateArray == null || dateArray.length == 0) {
                this.clearSelection();
            } else {
                this.setSelectionInterval(dateArray[0], dateArray[dateArray.length - 1]);
            }
        }

        @Override
        public void setTimeZone(TimeZone timeZone) {
            calendar1.setTimeZone(timeZone);
            calendar2.setTimeZone(timeZone);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Object object = super.clone();
            if (this._from != null) {
                ((SingleInterval)object)._from = (Date)this._from.clone();
            }
            if (this._to != null) {
                ((SingleInterval)object)._to = (Date)this._to.clone();
            }
            if (this._lead != null) {
                ((SingleInterval)object)._lead = (Date)this._lead.clone();
            }
            if (this._anchor != null) {
                ((SingleInterval)object)._anchor = (Date)this._anchor.clone();
            }
            return object;
        }
    }

    private static class SingleSelection
    extends AbstractDateSelectionModel {
        private Date _selection;
        private DefaultDateSelectionModel _model;

        SingleSelection(DefaultDateSelectionModel defaultDateSelectionModel) {
            this._model = defaultDateSelectionModel;
        }

        @Override
        public void addSelectionInterval(Date date, Date date2) {
            this.setSelectedDate(date2);
        }

        @Override
        public void setSelectionInterval(Date date, Date date2) {
            this.setSelectedDate(date2);
        }

        @Override
        public void clearSelection() {
            this.setSelectedDate(null);
        }

        @Override
        public boolean isSelectedDate(Date date) {
            return this._selection != null && date != null && DefaultDateSelectionModel.isSameDay(date, this._selection);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this._selection == null;
        }

        @Override
        public void removeSelectionInterval(Date date, Date date2) {
            if (DefaultDateSelectionModel.isSameDay(this._selection, date) || DefaultDateSelectionModel.isSameDay(this._selection, date2)) {
                this.clearSelection();
            }
        }

        @Override
        public int getSelectionMode() {
            return 0;
        }

        @Override
        public Date getLeadSelectionDate() {
            return this._selection;
        }

        @Override
        public void setLeadSelectionDate(Date date) {
            this.setSelectedDate(date);
        }

        @Override
        public Date getAnchorSelectionDate() {
            return this._selection;
        }

        @Override
        public void setAnchorSelectionDate(Date date) {
            this.setSelectedDate(date);
        }

        @Override
        public Date getSelectedDate() {
            return this._selection;
        }

        @Override
        public void setSelectedDate(Date date) {
            if (!DefaultDateSelectionModel.isEqualDay(this._selection, date)) {
                if (!this._model._isAdjusting) {
                    this._model.saveOldSelectionModel();
                }
                this._selection = date;
                this._model.fireValueChanged(new DateSelectionEvent(this._model));
            }
        }

        @Override
        public Date[] getSelectedDates() {
            return new Date[]{this._selection};
        }

        @Override
        public void setSelectedDates(Date[] dateArray) {
            if (dateArray != null && dateArray.length > 0) {
                this.setSelectedDate(dateArray[0]);
            } else {
                this.setSelectedDate(null);
            }
        }

        @Override
        public void setTimeZone(TimeZone timeZone) {
            calendar1.setTimeZone(timeZone);
            calendar2.setTimeZone(timeZone);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Object object = super.clone();
            if (this._selection != null) {
                ((SingleSelection)object)._selection = (Date)this._selection.clone();
            }
            return object;
        }
    }

    private static abstract class AbstractDateSelectionModel
    implements DateSelectionModel {
        private AbstractDateSelectionModel() {
        }

        @Override
        public void setValueIsAdjusting(boolean bl) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }

        @Override
        public void setSelectionMode(int n) {
        }

        @Override
        public void addDateSelectionListener(DateSelectionListener dateSelectionListener) {
        }

        @Override
        public void removeDateSelectionListener(DateSelectionListener dateSelectionListener) {
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

