/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.DateFilter;
import com.jidesoft.combobox.DateModel;
import com.jidesoft.combobox.DateModelEvent;
import com.jidesoft.combobox.DateModelListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.event.EventListenerList;

public class DefaultDateModel
implements DateModel {
    private EventListenerList listenerList = new EventListenerList();
    private final DateFormat _dateFormatter = DateFormat.getDateInstance(3);
    private Calendar _minDate;
    private Calendar _maxDate;
    private Map<String, Calendar> _invalidDates = new HashMap<String, Calendar>();
    private List<DateFilter> _dateFilters = new ArrayList<DateFilter>();
    private Calendar _actualMinDate;
    private Calendar _actualMaxDate;
    private String _timeFormat;
    private DateFormat _dateFormat;
    private boolean _compareTime = false;
    public static final DateFilter WEEKDAY_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            int n = calendar.get(7);
            return n != 1 && n != 7;
        }

        @Override
        public Calendar getMinDate() {
            return null;
        }

        @Override
        public Calendar getMaxDate() {
            return null;
        }
    };
    public static final DateFilter THIS_WEEK = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            return calendar.get(3) == calendar2.get(3) && calendar.get(1) == calendar2.get(1);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(7, calendar.getActualMaximum(7));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(7, calendar.getActualMinimum(7));
            return calendar;
        }
    };
    public static final DateFilter THIS_MONTH_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            return calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(5, calendar.getActualMaximum(5));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(5, calendar.getActualMinimum(5));
            return calendar;
        }
    };
    public static final DateFilter LATER_THIS_MONTH = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            return calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1) && calendar.get(5) > calendar2.get(5);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(5, calendar.getActualMaximum(5));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            return Calendar.getInstance();
        }
    };
    public static final DateFilter WEEKEND_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            int n = calendar.get(7);
            return n == 1 || n == 7;
        }

        @Override
        public Calendar getMinDate() {
            return null;
        }

        @Override
        public Calendar getMaxDate() {
            return null;
        }
    };
    public static final DateFilter THIS_YEAR_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            return calendar.get(1) == calendar2.get(1);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.getActualMaximum(6));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.getActualMinimum(6));
            return calendar;
        }
    };
    public static final DateFilter NEXT_YEAR_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(1, 1);
            return calendar.get(1) == calendar2.get(1);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, 1);
            calendar.set(6, calendar.getActualMaximum(6));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, 1);
            calendar.set(6, calendar.getActualMinimum(6));
            return calendar;
        }
    };
    public static final DateFilter PREVIOUS_YEAR_ONLY = new DateFilter(){

        @Override
        public boolean isDateValid(Calendar calendar) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.add(1, -1);
            return calendar.get(1) == calendar2.get(1);
        }

        @Override
        public Calendar getMaxDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, -1);
            calendar.set(6, calendar.getActualMaximum(6));
            return calendar;
        }

        @Override
        public Calendar getMinDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, -1);
            calendar.set(6, calendar.getActualMinimum(6));
            return calendar;
        }
    };

    public DefaultDateModel() {
        this(null, null);
    }

    public DefaultDateModel(Calendar calendar, Calendar calendar2) {
        this._minDate = calendar;
        this._maxDate = calendar2;
    }

    private Calendar getMinimumDate() {
        Calendar calendar = null;
        for (DateFilter dateFilter : this._dateFilters) {
            Calendar calendar2 = dateFilter.getMinDate();
            if (calendar2 == null || calendar != null && DefaultDateModel.compareCalender(calendar2, calendar) != -1) continue;
            calendar = calendar2;
        }
        return calendar;
    }

    private Calendar getMaximumDate() {
        Calendar calendar = null;
        for (DateFilter dateFilter : this._dateFilters) {
            Calendar calendar2 = dateFilter.getMaxDate();
            if (calendar2 == null || calendar != null && DefaultDateModel.compareCalender(calendar, calendar2) != -1) continue;
            calendar = calendar2;
        }
        return calendar;
    }

    @Override
    public Calendar getMinDate() {
        Calendar calendar = this.getMinimumDate();
        if (calendar != null && this._minDate != null && DefaultDateModel.compareCalender(calendar, this._minDate) == 1) {
            return (Calendar)calendar.clone();
        }
        if (this._minDate == null) {
            return null;
        }
        return (Calendar)this._minDate.clone();
    }

    @Override
    public void setMinDate(Calendar calendar) {
        if (calendar == null) {
            this._minDate = null;
        } else {
            if (this._maxDate != null && DefaultDateModel.compareCalender(calendar, this._maxDate) > 0) {
                throw new IllegalArgumentException("Minimum date cannot be greater than Maximum date");
            }
            this._minDate = (Calendar)calendar.clone();
        }
        this.resetActualMinMaxDate();
        this.fireDateModelChanged(new DateModelEvent(this, 2));
    }

    @Override
    public Calendar getMaxDate() {
        Calendar calendar = this.getMaximumDate();
        if (calendar != null && this._maxDate != null && DefaultDateModel.compareCalender(calendar, this._maxDate) == -1) {
            return (Calendar)calendar.clone();
        }
        if (this._maxDate == null) {
            return null;
        }
        return (Calendar)this._maxDate.clone();
    }

    @Override
    public void setMaxDate(Calendar calendar) {
        if (calendar == null) {
            this._maxDate = calendar;
        } else {
            if (this._minDate != null && DefaultDateModel.compareCalender(this._minDate, calendar) > 0) {
                throw new IllegalArgumentException("Maximum date cannot be less than minimum date");
            }
            this._maxDate = (Calendar)calendar.clone();
        }
        this.resetActualMinMaxDate();
        this.fireDateModelChanged(new DateModelEvent(this, 2));
    }

    private static int compareCalender(Calendar calendar, Calendar calendar2) {
        return DefaultDateModel.compareCalender(calendar, calendar2, 5);
    }

    private static int compareCalender(Calendar calendar, Calendar calendar2, int n) {
        if (calendar.get(1) > calendar2.get(1)) {
            return 1;
        }
        if (calendar.get(1) < calendar2.get(1)) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        if (calendar.get(2) > calendar2.get(2)) {
            return 1;
        }
        if (calendar.get(2) < calendar2.get(2)) {
            return -1;
        }
        if (n == 2) {
            return 0;
        }
        if (calendar.get(5) > calendar2.get(5)) {
            return 1;
        }
        if (calendar.get(5) < calendar2.get(5)) {
            return -1;
        }
        if (n == 5) {
            return 0;
        }
        if (calendar.get(11) > calendar2.get(11)) {
            return 1;
        }
        if (calendar.get(11) < calendar2.get(11)) {
            return -1;
        }
        if (n == 11) {
            return 0;
        }
        if (calendar.get(12) > calendar2.get(12)) {
            return 1;
        }
        if (calendar.get(12) < calendar2.get(12)) {
            return -1;
        }
        if (n == 12) {
            return 0;
        }
        if (calendar.get(13) > calendar2.get(13)) {
            return 1;
        }
        if (calendar.get(13) < calendar2.get(13)) {
            return -1;
        }
        return 0;
    }

    private void initActualMinMaxDate() {
        if (this._actualMinDate == null) {
            this._actualMinDate = this.getMinDate();
        }
        if (this._actualMaxDate == null) {
            this._actualMaxDate = this.getMaxDate();
        }
    }

    private void resetActualMinMaxDate() {
        this._actualMinDate = null;
        this._actualMaxDate = null;
    }

    @Override
    public boolean timeInRange(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        this.initActualMinMaxDate();
        if (this._actualMinDate != null && DefaultDateModel.compareCalender(this._actualMinDate, calendar, 13) == 1) {
            return false;
        }
        return this._actualMaxDate == null || DefaultDateModel.compareCalender(calendar, this._actualMaxDate, 13) != 1;
    }

    @Override
    public boolean dayInRange(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        this.initActualMinMaxDate();
        if (this._actualMinDate != null && DefaultDateModel.compareCalender(this._actualMinDate, calendar) == 1) {
            return false;
        }
        return this._actualMaxDate == null || DefaultDateModel.compareCalender(calendar, this._actualMaxDate) != 1;
    }

    @Override
    public boolean monthInRange(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        this.initActualMinMaxDate();
        if (this._actualMinDate != null && DefaultDateModel.compareCalender(this._actualMinDate, calendar, 2) == 1) {
            return false;
        }
        return this._actualMaxDate == null || DefaultDateModel.compareCalender(calendar, this._actualMaxDate, 2) != 1;
    }

    @Override
    public boolean yearInRange(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        this.initActualMinMaxDate();
        if (this._actualMinDate != null && DefaultDateModel.compareCalender(this._actualMinDate, calendar, 1) == 1) {
            return false;
        }
        return this._actualMaxDate == null || DefaultDateModel.compareCalender(calendar, this._actualMaxDate, 1) != 1;
    }

    public void clearDateFilters() {
        this._dateFilters.clear();
        this.resetActualMinMaxDate();
        this.fireDateModelChanged(new DateModelEvent(this, 1));
    }

    public void addDateFilter(DateFilter dateFilter) {
        this._dateFilters.add(dateFilter);
        this.resetActualMinMaxDate();
        this.fireDateModelChanged(new DateModelEvent(this, 1));
    }

    public void removeDateFilter(DateFilter dateFilter) {
        this._dateFilters.remove(dateFilter);
        this.resetActualMinMaxDate();
        this.fireDateModelChanged(new DateModelEvent(this, 1));
    }

    @Override
    public boolean isValidDate(Calendar calendar) {
        if (calendar == null) {
            return true;
        }
        if (this.isCompareTime() ? !this.timeInRange(calendar) : !this.dayInRange(calendar)) {
            return false;
        }
        if (this._invalidDates.containsKey(this._dateFormatter.format(calendar.getTime()))) {
            return false;
        }
        for (DateFilter dateFilter : this._dateFilters) {
            if (dateFilter.isDateValid(calendar)) continue;
            return false;
        }
        return true;
    }

    public void clearInvalidDates() {
        this._invalidDates.clear();
        this.fireDateModelChanged(new DateModelEvent(this, 0));
    }

    public void addInvalidDate(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("null is not allowed at blackout date");
        }
        this._invalidDates.put(this._dateFormatter.format(calendar.getTime()), calendar);
        this.fireDateModelChanged(new DateModelEvent(this, 0));
    }

    public void removeInvalidDate(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("null is not allowed at blackout date");
        }
        this._invalidDates.remove(this._dateFormatter.format(calendar.getTime()));
        this.fireDateModelChanged(new DateModelEvent(this, 0));
    }

    @Override
    public String getTimeFormat() {
        return this._timeFormat;
    }

    @Override
    public void setTimeFormat(String string) {
        this._timeFormat = string;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.getDateFormat() == null) {
            return TimeZone.getDefault();
        }
        return this.getDateFormat().getTimeZone();
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (this.getDateFormat() == null) {
            this.setDateFormat(DateFormat.getDateInstance());
        }
        this.getDateFormat().setTimeZone(timeZone);
    }

    @Override
    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    @Override
    public void setDateFormat(DateFormat dateFormat) {
        this._dateFormat = dateFormat;
    }

    @Override
    public Calendar createCalendarInstance() {
        if (this.getDateFormat() == null) {
            return Calendar.getInstance();
        }
        return Calendar.getInstance(this.getDateFormat().getTimeZone());
    }

    @Override
    public void addDateModelListener(DateModelListener dateModelListener) {
        DateModelListener[] dateModelListenerArray;
        for (DateModelListener dateModelListener2 : dateModelListenerArray = this.getDateModelListeners()) {
            if (dateModelListener2 != dateModelListener) continue;
            return;
        }
        this.listenerList.add(DateModelListener.class, dateModelListener);
    }

    @Override
    public void removeDateModelListener(DateModelListener dateModelListener) {
        this.listenerList.remove(DateModelListener.class, dateModelListener);
    }

    public DateModelListener[] getDateModelListeners() {
        return (DateModelListener[])this.listenerList.getListeners(DateModelListener.class);
    }

    public void fireDateModelChanged(DateModelEvent dateModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DateModelListener.class) continue;
            ((DateModelListener)objectArray[i + 1]).dateModelChanged(dateModelEvent);
        }
    }

    @Override
    public boolean isCompareTime() {
        return this._compareTime;
    }

    @Override
    public void setCompareTime(boolean bl) {
        this._compareTime = bl;
    }
}

