/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ComboBoxModelWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DefaultComboBoxModelWrapper<E>
extends AbstractListModel<E>
implements ComboBoxModel<E>,
ComboBoxModelWrapper<E>,
ListDataListener {
    private static final long serialVersionUID = 8382850360356348056L;
    protected ComboBoxModel<E> _model;
    protected int[] _indexes;
    private Object _selectedObject;

    public DefaultComboBoxModelWrapper() {
    }

    public DefaultComboBoxModelWrapper(ComboBoxModel<E> comboBoxModel) {
        if (comboBoxModel == null) {
            throw new IllegalArgumentException("model passed to DefaultComboBoxModelWrapper cannot be null");
        }
        this.setActualModel(comboBoxModel);
    }

    @Override
    public void setActualModel(ComboBoxModel<E> comboBoxModel) {
        this._model = comboBoxModel;
    }

    @Override
    public ComboBoxModel<E> getActualModel() {
        return this._model;
    }

    @Override
    public int getActualIndexAt(int n) {
        if (this._indexes == null) {
            return n;
        }
        if (n < 0 || n >= this._indexes.length) {
            return -1;
        }
        return this._indexes[n];
    }

    @Override
    public int getIndexAt(int n) {
        if (this._indexes == null) {
            return n;
        }
        for (int i = 0; i < this._indexes.length; ++i) {
            int n2 = this._indexes[i];
            if (n2 != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E getElementAt(int n) {
        if (n < 0 || n >= this._indexes.length) {
            return null;
        }
        return this._model.getElementAt(this._indexes[n]);
    }

    @Override
    public int getSize() {
        if (this._indexes == null) {
            return 0;
        }
        return this._indexes.length;
    }

    protected void reallocateIndexes() {
        int n = this._model.getSize();
        this._indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this._indexes[i] = i;
        }
    }

    @Override
    public int[] getIndexes() {
        return this._indexes;
    }

    @Override
    public void setIndexes(int[] nArray) {
        this._indexes = nArray;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (this._selectedObject != null && !this._selectedObject.equals(object) || this._selectedObject == null && object != null) {
            this._selectedObject = object;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this._selectedObject;
    }

    void reselectItem() {
        Object object = this.getSelectedItem();
        for (int i = this.getSize() - 1; i >= 0; --i) {
            if (!JideSwingUtilities.equals(this.getElementAt(i), object)) continue;
            return;
        }
        this.setSelectedItem(this.getSize() > 0 ? this.getElementAt(0) : null);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getIndex0() < 0 || listDataEvent.getIndex1() < 0) {
            return;
        }
        this.reselectItem();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getIndex0() < 0 || listDataEvent.getIndex1() < 0) {
            return;
        }
        this.reselectItem();
    }
}

