/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.DateComboBox;
import com.jidesoft.spinner.DateSpinner;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;

public class DateSpinnerComboBox
extends DateComboBox {
    @Override
    public AbstractComboBox.EditorComponent createEditorComponent() {
        if (this.isEditable()) {
            DateSpinnerEditorComponent dateSpinnerEditorComponent = new DateSpinnerEditorComponent(Calendar.class);
            DateSpinner dateSpinner = (DateSpinner)dateSpinnerEditorComponent.getEditorComponent();
            SpinnerDateModel spinnerDateModel = (SpinnerDateModel)dateSpinner.getModel();
            dateSpinner.setModel(new SpinnerDateModel(spinnerDateModel.getDate(), spinnerDateModel.getStart(), spinnerDateModel.getEnd(), spinnerDateModel.getCalendarField()){
                Calendar calendar;
                private static final long serialVersionUID = -5613413997183981275L;
                {
                    this.calendar = Calendar.getInstance();
                }

                @Override
                public Object getNextValue() {
                    Date date;
                    while ((date = (Date)super.getNextValue()) != null) {
                        this.calendar.setTime(date);
                        if (DateSpinnerComboBox.this.getDateModel().isValidDate(this.calendar)) {
                            return date;
                        }
                        super.setValue(date);
                    }
                    return null;
                }

                @Override
                public Object getPreviousValue() {
                    Date date;
                    while ((date = (Date)super.getPreviousValue()) != null) {
                        this.calendar.setTime(date);
                        if (DateSpinnerComboBox.this.getDateModel().isValidDate(this.calendar)) {
                            return date;
                        }
                        super.setValue(date);
                    }
                    return null;
                }
            });
            return dateSpinnerEditorComponent;
        }
        return super.createEditorComponent();
    }

    @Override
    protected JSpinner createSpinner() {
        DateFormat dateFormat = this.getFormat();
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateInstance(3);
        }
        return new DateSpinner(((SimpleDateFormat)dateFormat).toPattern());
    }

    @Override
    public void setFormat(DateFormat dateFormat) {
        ((DateSpinner)this.getEditor().getEditorComponent()).setFormat(((SimpleDateFormat)dateFormat).toPattern());
        super.setFormat(dateFormat);
    }

    public class DateSpinnerEditorComponent
    extends AbstractComboBox.SpinnerEditorComponent {
        public DateSpinnerEditorComponent(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public Object getItem() {
            return this._spinner.getValue();
        }

        @Override
        public void setItem(Object object) {
            if (object instanceof Date) {
                this._spinner.setValue(object);
            } else if (object instanceof Calendar) {
                this._spinner.setValue(((Calendar)object).getTime());
            }
        }
    }
}

