/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.ColorResource;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;

public class ColorChooserPanel
extends PopupPanel
implements ItemListener {
    public static final int PALETTE_COLOR_15 = 0;
    public static final int PALETTE_COLOR_40 = 1;
    public static final int PALETTE_COLOR_216 = 2;
    public static final int PALETTE_GRAY_16 = 3;
    public static final int PALETTE_GRAY_102 = 4;
    public static final int PALETTE_GRAY_256 = 5;
    public static final int PALETTE_CUSTOMIZE = -1;
    private int _palette;
    private int _rows;
    private int _columns;
    private Color[] _possibleColors;
    private String[] _possibleColorsName;
    private int _buttonSize = 18;
    private static Color[] COLOR_40_COLORS;
    private String[] _color_40_names;
    private static Color[] COLOR_15_COLORS;
    private String[] _color_15_names;
    private static Color[] COLOR_216_COLORS;
    private static Color[] GRAYSCALE_16_COLORS;
    private static Color[] GRAYSCALE_102_COLORS;
    private static Color[] GRAYSCALE_256_COLORS;
    private boolean _allowDefaultColor;
    private boolean _allowMoreColors;
    protected AbstractButton _defaultColor;
    protected AbstractButton _moreColor;
    protected JPanel _colorPanel;
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    private ColorChooserDialogProvider _colorChooserDialogProvider;
    private ColorButton[] _buttons;
    private Point _lastPosition = new Point(0, 0);
    private static final int INDEX_DEFAULT_COLOR = -1;
    private static final int INDEX_MORE_COLOR = -2;

    public ColorChooserPanel() {
        this(1, false, true);
    }

    public ColorChooserPanel(int n) {
        this(n, false, true);
    }

    public ColorChooserPanel(int n, boolean bl, boolean bl2) {
        this(n, bl, bl2, Locale.getDefault());
    }

    public ColorChooserPanel(int n, boolean bl, boolean bl2, Locale locale) {
        this._palette = n;
        this._allowMoreColors = bl;
        this._allowDefaultColor = bl2;
        this.initColors();
        this.initComponent();
        this.addItemListener(this);
        this.setLocale(locale);
    }

    public ColorChooserPanel(Color[] colorArray, String[] stringArray, boolean bl, boolean bl2) {
        this(colorArray, stringArray, bl, bl2, Locale.getDefault());
    }

    public ColorChooserPanel(Color[] colorArray, String[] stringArray, boolean bl, boolean bl2, Locale locale) {
        this(colorArray, stringArray, 0, 0, bl, bl2, locale);
    }

    public ColorChooserPanel(Color[] colorArray, String[] stringArray, int n, int n2, boolean bl, boolean bl2, Locale locale) {
        if (colorArray.length == 0) {
            throw new IllegalArgumentException("The length of colors array passed in to ColorChooserPanel is 0.");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("The length of names array passed in to ColorChooserPanel is 0.");
        }
        if (colorArray.length != stringArray.length) {
            throw new IllegalArgumentException("The length of colors array passed in to ColorChooserPanel is not the same with the length of names array.");
        }
        if (colorArray.length < n) {
            throw new IllegalArgumentException("The length of colors array passed in to ColorChooserPanel is less than the input value of rows");
        }
        this._palette = -1;
        this._allowMoreColors = bl;
        this._allowDefaultColor = bl2;
        this._possibleColors = colorArray;
        this._possibleColorsName = stringArray;
        if (n2 <= 0 || n <= 0) {
            this._columns = ColorChooserPanel.calculateColumn(colorArray.length);
            this._rows = colorArray.length / this._columns;
        } else {
            this._rows = n;
            this._columns = n2;
        }
        this.initComponent();
        this.addItemListener(this);
        this.setLocale(locale);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        LookAndFeel.installColorsAndFont(this, "TextField.background", "TextField.foreground", "TextField.font");
    }

    protected void initColors() {
        switch (this._palette) {
            case 0: {
                this._rows = 3;
                this._columns = 5;
                this._possibleColors = ColorChooserPanel.getPaletteColors15();
                this._possibleColorsName = this.getPaletteNames15();
                break;
            }
            case 1: {
                this._rows = 5;
                this._columns = 8;
                this._possibleColors = ColorChooserPanel.getPaletteColors40();
                this._possibleColorsName = this.getPaletteNames40();
                break;
            }
            case 2: {
                this._rows = 12;
                this._columns = 18;
                this._possibleColors = ColorChooserPanel.getPaletteColors216();
                this._possibleColorsName = null;
                break;
            }
            case 3: {
                this._rows = 2;
                this._columns = 8;
                this._possibleColors = ColorChooserPanel.getPaletteGrayScale16();
                this._possibleColorsName = null;
                break;
            }
            case 4: {
                this._rows = 6;
                this._columns = 17;
                this._possibleColors = ColorChooserPanel.getPaletteGrayScale120();
                this._possibleColorsName = null;
                break;
            }
            case 5: {
                this._rows = 16;
                this._columns = 16;
                this._possibleColors = ColorChooserPanel.getPaletteGrayScale256();
                this._possibleColorsName = null;
            }
        }
    }

    protected static Color[] getPaletteGrayScale16() {
        if (GRAYSCALE_16_COLORS == null) {
            GRAYSCALE_16_COLORS = new Color[16];
            for (int i = 0; i < GRAYSCALE_16_COLORS.length; ++i) {
                int n = i * 16;
                ColorChooserPanel.GRAYSCALE_16_COLORS[i] = new Color(n, n, n);
            }
        }
        return GRAYSCALE_16_COLORS;
    }

    protected static Color[] getPaletteGrayScale120() {
        if (GRAYSCALE_102_COLORS == null) {
            GRAYSCALE_102_COLORS = new Color[102];
            int n = 0;
            for (int i = 0; i < GRAYSCALE_102_COLORS.length; ++i) {
                ColorChooserPanel.GRAYSCALE_102_COLORS[i] = new Color(n, n, n);
                if (i % 2 == 0) {
                    n += 3;
                    continue;
                }
                n += 2;
            }
        }
        return GRAYSCALE_102_COLORS;
    }

    protected static Color[] getPaletteGrayScale256() {
        if (GRAYSCALE_256_COLORS == null) {
            GRAYSCALE_256_COLORS = new Color[256];
            for (int i = 0; i < GRAYSCALE_256_COLORS.length; ++i) {
                ColorChooserPanel.GRAYSCALE_256_COLORS[i] = new Color(i, i, i);
            }
        }
        return GRAYSCALE_256_COLORS;
    }

    public Color[] getPossibleColors() {
        return this._possibleColors;
    }

    public String[] getPossibleColorsName() {
        return this._possibleColorsName;
    }

    public Color getSelectedColor() {
        Object object = this.getSelectedObject();
        if (object instanceof Color) {
            return (Color)object;
        }
        return null;
    }

    public void setSelectedColor(Color color) {
        AbstractButton abstractButton = this.getButton(this.getSelectedColor());
        if (abstractButton != null) {
            abstractButton.getModel().setRollover(false);
        }
        if (this._moreColor != null) {
            this._moreColor.getModel().setRollover(false);
        }
        if (this._defaultColor != null) {
            this._defaultColor.getModel().setRollover(false);
        }
        this.setSelectedObject(color);
    }

    private boolean isAllowDefaultColor() {
        return this._allowDefaultColor;
    }

    private boolean isAllowMoreColors() {
        return this._allowMoreColors;
    }

    protected void initComponent() {
        LookAndFeel.installColorsAndFont(this, "TextField.background", "TextField.foreground", "TextField.font");
        SelectAction selectAction = new SelectAction();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        LookAndFeel.installColorsAndFont(jPanel, "TextField.background", "TextField.foreground", "TextField.font");
        jPanel.setLayout(new BorderLayout(4, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        this._colorPanel = new NullPanel(new GridLayout(this._rows, this._columns, 0, 0));
        this._buttons = new ColorButton[this._possibleColors.length];
        for (int i = 0; i < this._possibleColors.length; ++i) {
            this._buttons[i] = new ColorButton(this._possibleColors[i], i){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    if (ColorChooserPanel.this._possibleColorsName != null && this.getIndex() < ColorChooserPanel.this._possibleColorsName.length) {
                        return ColorChooserPanel.this._possibleColorsName[this.getIndex()];
                    }
                    return ObjectConverterManager.toString(this.getColor());
                }
            };
            if (this._possibleColorsName != null && i < this._possibleColorsName.length) {
                this._buttons[i].setToolTipText(this._possibleColorsName[i]);
            } else {
                this._buttons[i].setToolTipText(ObjectConverterManager.toString(this._possibleColors[i]));
            }
            this._buttons[i].setPreferredSize(new Dimension(this._buttonSize, this._buttonSize));
            this._colorPanel.add(this._buttons[i]);
            this._buttons[i].addActionListener(selectAction);
        }
        jPanel.add((Component)this._colorPanel, "Center");
        if (this.isAllowDefaultColor()) {
            this._defaultColor = this.createButton("Color.none");
            this._defaultColor.setOpaque(false);
            jPanel.add((Component)this._defaultColor, "First");
            this._defaultColor.addActionListener(selectAction);
        }
        if (this.isAllowMoreColors()) {
            this._moreColor = this.createButton("Color.moreColors");
            this._moreColor.setOpaque(false);
            jPanel.add((Component)this._moreColor, "Last");
            this._moreColor.addActionListener(new MoreColorAction());
        }
        this.add(jPanel);
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.registerKeyStrokes();
    }

    protected AbstractButton createButton(String string) {
        JideButton jideButton = new JideButton(this.getResourceString(string));
        jideButton.setDefaultForeground(new Color(UIDefaultsLookup.getColor("controlText").getRGB()));
        return jideButton;
    }

    protected Color showColorChooser(Component component, String string, Color color) {
        ColorChooserDialogProvider colorChooserDialogProvider = this.getColorChooserDialogProvider();
        if (colorChooserDialogProvider != null) {
            return colorChooserDialogProvider.showColorChooserDialog(component, string, color);
        }
        return ColorChooserPanel.showColorChooserDialog(component, string, color);
    }

    public ColorChooserDialogProvider getColorChooserDialogProvider() {
        return this._colorChooserDialogProvider;
    }

    public void setColorChooserDialogProvider(ColorChooserDialogProvider colorChooserDialogProvider) {
        this._colorChooserDialogProvider = colorChooserDialogProvider;
    }

    public ColorButton[] getColorButtons() {
        return this._buttons;
    }

    public static Color showColorChooserDialog(Component component, String string, Color color) throws HeadlessException {
        ColorTracker colorTracker;
        JColorChooser jColorChooser = new JColorChooser(color != null ? color : Color.white);
        JDialog jDialog = JColorChooser.createDialog(component, string, true, jColorChooser, colorTracker = new ColorTracker(jColorChooser), null);
        JComponent jComponent = JideSwingUtilities.getFirstJComponent(jDialog);
        if (jComponent != null) {
            jComponent.putClientProperty("JidePopup.actualOwner", component);
        }
        jDialog.setVisible(true);
        return colorTracker.getColor();
    }

    private AbstractButton getButton(Color color) {
        if (color == null) {
            return this._defaultColor;
        }
        for (int i = 0; i < this._colorPanel.getComponentCount(); ++i) {
            Component component = this._colorPanel.getComponent(i);
            if (!(component instanceof ColorButton) || !color.equals(((ColorButton)component).getColor())) continue;
            return (ColorButton)component;
        }
        return null;
    }

    private void clearSelection() {
        for (int i = 0; i < this._colorPanel.getComponentCount(); ++i) {
            Component component = this._colorPanel.getComponent(i);
            if (!(component instanceof ColorButton)) continue;
            ((ColorButton)component).setSelected(false);
            ((ColorButton)component).getModel().setRollover(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItem() instanceof Color) {
            if (itemEvent.getStateChange() == 1) {
                AbstractButton abstractButton = this.getButton((Color)itemEvent.getItem());
                if (abstractButton != null) {
                    abstractButton.setSelected(true);
                    abstractButton.repaint();
                }
            } else if (itemEvent.getStateChange() == 2) {
                this.clearSelection();
            }
        }
    }

    protected void prevCell() {
        int n = this.getSelectedButtonIndex();
        this.setSelectedButtonIndex(n, false);
        n = n == 0 ? (this._defaultColor != null ? -1 : (this._moreColor != null ? -2 : this.getPossibleColors().length - 1)) : (n == -1 ? (this._moreColor != null ? -2 : this.getPossibleColors().length - 1) : (n <= -2 ? this.getPossibleColors().length - 1 : --n));
        this.setSelectedButtonIndex(n, true);
    }

    protected void nextCell() {
        int n = this.getSelectedButtonIndex();
        this.setSelectedButtonIndex(n, false);
        n = n == this.getPossibleColors().length - 1 ? (this._moreColor != null ? -2 : (this._defaultColor != null ? -1 : 0)) : (n <= -2 ? (this._defaultColor != null ? -1 : 0) : (n == -1 ? 0 : ++n));
        this.setSelectedButtonIndex(n, true);
    }

    protected void prevRow() {
        int n = this.getSelectedButtonIndex();
        this.setSelectedButtonIndex(n, false);
        n = n == -1 ? (this._moreColor != null ? -2 : this._lastPosition.x + (this._rows - 1) * this._columns) : (n <= -2 ? this._lastPosition.x + (this._rows - 1) * this._columns : (n >= 0 && n < this._columns ? (this._defaultColor != null ? -1 : (this._moreColor != null ? -2 : this._lastPosition.x + (this._rows - 1) * this._columns)) : (n -= this._columns)));
        this.setSelectedButtonIndex(n, true);
    }

    protected void nextRow() {
        int n = this.getSelectedButtonIndex();
        this.setSelectedButtonIndex(n, false);
        n = n >= (this._rows - 1) * this._columns && n < this._rows * this._columns ? (this._moreColor != null ? -2 : (this._defaultColor != null ? -1 : this._lastPosition.x)) : (n <= -2 ? (this._defaultColor != null ? -1 : this._lastPosition.x) : (n == -1 ? this._lastPosition.x : (n += this._columns)));
        this.setSelectedButtonIndex(n, true);
    }

    protected void firstCell() {
        int n = this.getSelectedButtonIndex();
        this.setSelectedButtonIndex(n, false);
        n = 0;
        this.setSelectedButtonIndex(n, true);
    }

    protected void lastCell() {
        int n = this.getSelectedButtonIndex();
        this.setSelectedButtonIndex(n, false);
        n = this.getPossibleColors().length - 1;
        this.setSelectedButtonIndex(n, true);
    }

    private int getSelectedButtonIndex() {
        if (this._defaultColor != null && this._defaultColor.isSelected()) {
            return -1;
        }
        if (this._moreColor != null && this._moreColor.isSelected()) {
            return -2;
        }
        for (int i = 0; i < this._colorPanel.getComponentCount(); ++i) {
            Component component = this._colorPanel.getComponent(i);
            if (!(component instanceof ColorButton) || !((ColorButton)component).isSelected()) continue;
            return i;
        }
        return -3;
    }

    private void setSelectedButtonIndex(int n, boolean bl) {
        if (n == -1 && this._defaultColor != null) {
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, this.getSelectedColor(), null);
            this._defaultColor.setSelected(bl);
            return;
        }
        if (n == -2 && this._moreColor != null) {
            this._moreColor.setSelected(bl);
            return;
        }
        if (n < 0) {
            n = this._lastPosition.x;
        }
        this._lastPosition.x = n % this._columns;
        this._lastPosition.y = n / this._columns;
        Component component = this._colorPanel.getComponent(n);
        if (component instanceof ColorButton) {
            ((ColorButton)component).setSelected(bl);
            if (bl) {
                this.firePropertyChange(PROPERTY_SELECTED_COLOR, null, ((ColorButton)component).getColor());
            }
        }
    }

    protected void registerKeyStrokes() {
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -2634180858281447699L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.prevCell();
            }
        }, KeyStroke.getKeyStroke(37, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -3414649134282507209L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.nextCell();
            }
        }, KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -4683903665679849538L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.prevRow();
            }
        }, KeyStroke.getKeyStroke(38, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 6791819790416330058L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.nextRow();
            }
        }, KeyStroke.getKeyStroke(40, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 3756684464718994582L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.firstCell();
            }
        }, KeyStroke.getKeyStroke(36, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -1347774392133100194L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.lastCell();
            }
        }, KeyStroke.getKeyStroke(35, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -49899669707624010L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColorChooserPanel.this.getSelectedButtonIndex();
                if (n == -1) {
                    ColorChooserPanel.this.setSelectedColor(null);
                } else if (n == -2) {
                    ColorChooserPanel.this._moreColor.doClick();
                } else if (n != -3) {
                    ColorChooserPanel.this.setSelectedColor(ColorChooserPanel.this.getPossibleColors()[n]);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
    }

    private static Color[] getPaletteColors15() {
        if (COLOR_15_COLORS == null) {
            COLOR_15_COLORS = new Color[]{new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 0, 255), new Color(0, 0, 255), new Color(255, 0, 0), new Color(0, 0, 128), new Color(0, 128, 128), new Color(0, 128, 0), new Color(0, 128, 0), new Color(128, 0, 0), new Color(128, 128, 0), new Color(128, 128, 128), new Color(192, 192, 192), new Color(0, 0, 0)};
        }
        return COLOR_15_COLORS;
    }

    private String[] getPaletteNames15() {
        if (this._color_15_names == null) {
            Locale locale = this.getLocale();
            this._color_15_names = new String[]{this.getResourceString("Color.Yellow", locale), this.getResourceString("Color.BrightGreen", locale), this.getResourceString("Color.Turquoise", locale), this.getResourceString("Color.Pink", locale), this.getResourceString("Color.Blue", locale), this.getResourceString("Color.Red", locale), this.getResourceString("Color.DarkBlue", locale), this.getResourceString("Color.Teal", locale), this.getResourceString("Color.Green", locale), this.getResourceString("Color.Violet", locale), this.getResourceString("Color.DarkRed", locale), this.getResourceString("Color.DarkYellow", locale), this.getResourceString("Color.Gray-40", locale), this.getResourceString("Color.Gray-25", locale), this.getResourceString("Color.Black")};
        }
        return this._color_15_names;
    }

    private static Color[] getPaletteColors40() {
        if (COLOR_40_COLORS == null) {
            COLOR_40_COLORS = new Color[]{new Color(0, 0, 0), new Color(153, 51, 0), new Color(51, 51, 0), new Color(0, 51, 0), new Color(0, 51, 102), new Color(0, 0, 128), new Color(51, 51, 153), new Color(51, 51, 51), new Color(128, 0, 0), new Color(255, 102, 0), new Color(128, 128, 0), new Color(0, 128, 0), new Color(0, 128, 128), new Color(0, 0, 255), new Color(102, 102, 153), new Color(128, 128, 128), new Color(255, 0, 0), new Color(255, 153, 0), new Color(153, 204, 0), new Color(51, 153, 102), new Color(51, 204, 204), new Color(51, 102, 255), new Color(128, 0, 128), new Color(153, 153, 153), new Color(255, 0, 255), new Color(255, 204, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(0, 204, 255), new Color(153, 51, 102), new Color(192, 192, 192), new Color(255, 153, 204), new Color(255, 204, 153), new Color(255, 255, 153), new Color(204, 255, 204), new Color(204, 255, 255), new Color(153, 204, 255), new Color(204, 153, 255), new Color(255, 255, 255)};
        }
        return COLOR_40_COLORS;
    }

    private String[] getPaletteNames40() {
        if (this._color_40_names == null) {
            Locale locale = this.getLocale();
            this._color_40_names = new String[]{this.getResourceString("Color.Black", locale), this.getResourceString("Color.Brown", locale), this.getResourceString("Color.OliveGreen", locale), this.getResourceString("Color.DarkGreen", locale), this.getResourceString("Color.DarkTeal", locale), this.getResourceString("Color.DarkBlue", locale), this.getResourceString("Color.Indigo", locale), this.getResourceString("Color.Gray-80", locale), this.getResourceString("Color.DarkRed", locale), this.getResourceString("Color.Orange", locale), this.getResourceString("Color.DarkYellow", locale), this.getResourceString("Color.Green", locale), this.getResourceString("Color.Teal", locale), this.getResourceString("Color.Blue", locale), this.getResourceString("Color.Blue-Gray", locale), this.getResourceString("Color.Gray-50", locale), this.getResourceString("Color.Red", locale), this.getResourceString("Color.LightOrange", locale), this.getResourceString("Color.Lime", locale), this.getResourceString("Color.SeaGreen", locale), this.getResourceString("Color.Aqua", locale), this.getResourceString("Color.LightBlue", locale), this.getResourceString("Color.Violet", locale), this.getResourceString("Color.Gray-40", locale), this.getResourceString("Color.Pink", locale), this.getResourceString("Color.Gold", locale), this.getResourceString("Color.Yellow", locale), this.getResourceString("Color.BrightGreen", locale), this.getResourceString("Color.Turquoise", locale), this.getResourceString("Color.SkyBlue", locale), this.getResourceString("Color.Plum", locale), this.getResourceString("Color.Gray-25", locale), this.getResourceString("Color.Rose", locale), this.getResourceString("Color.Tan", locale), this.getResourceString("Color.LightYellow", locale), this.getResourceString("Color.LightGreen", locale), this.getResourceString("Color.LightTurquoise", locale), this.getResourceString("Color.PaleBlue", locale), this.getResourceString("Color.Lavender", locale), this.getResourceString("Color.White")};
        }
        return this._color_40_names;
    }

    private static Color[] getPaletteColors216() {
        if (COLOR_216_COLORS == null) {
            COLOR_216_COLORS = new Color[]{new Color(0xFFFFFF), new Color(0xFFFFCC), new Color(0xFFFF99), new Color(0xFFFF66), new Color(0xFFFF33), new Color(0xFFFF00), new Color(0xCCFFFF), new Color(0xCCFFCC), new Color(0xCCFF99), new Color(0xCCFF66), new Color(0xCCFF33), new Color(0xCCFF00), new Color(0x99FFFF), new Color(0x99FFCC), new Color(0x99FF99), new Color(0x66FFFF), new Color(0x99FF66), new Color(0x99FF33), new Color(0x66FFCC), new Color(0xFFCCFF), new Color(0x99FF00), new Color(0x33FFFF), new Color(0xFFCCCC), new Color(0x33FFCC), new Color(65535), new Color(0x66FF99), new Color(0xFFCC99), new Color(0x66FF66), new Color(0x66FF33), new Color(65484), new Color(0x66FF00), new Color(0x33FF99), new Color(0xFFCC66), new Color(0xFFCC33), new Color(0xCCCCFF), new Color(0x33FF66), new Color(0x33FF33), new Color(65433), new Color(0xFFCC00), new Color(0x33FF00), new Color(65382), new Color(65331), new Color(65280), new Color(0xCCCCCC), new Color(0xCCCC99), new Color(0x99CCFF), new Color(0xCCCC66), new Color(0xCCCC00), new Color(0xCCCC33), new Color(0x99CCCC), new Color(0xFF99FF), new Color(0x99CC99), new Color(0x66CCFF), new Color(0xFF99CC), new Color(0x99CC66), new Color(0x66CCCC), new Color(0x99CC33), new Color(52479), new Color(0x33CCFF), new Color(0x99CC00), new Color(0xFF9999), new Color(0x66CC99), new Color(0xFF9966), new Color(0x66CC66), new Color(0x33CCCC), new Color(0xCC99FF), new Color(52428), new Color(0xFF9933), new Color(0xFF9900), new Color(0x66CC33), new Color(0x66CC00), new Color(0x33CC99), new Color(52377), new Color(0xCC99CC), new Color(0x33CC66), new Color(52326), new Color(0xCC9999), new Color(0xFF66FF), new Color(0x33CC33), new Color(0x33CC00), new Color(0xCC9966), new Color(52275), new Color(0x9999FF), new Color(52224), new Color(0xCC9933), new Color(0xCC9900), new Color(0xFF66CC), new Color(0x9999CC), new Color(0xFF6699), new Color(0x999999), new Color(0x6699FF), new Color(0xFF6666), new Color(0xCC66FF), new Color(0x999966), new Color(0x6699CC), new Color(0x999933), new Color(0xFFCC33), new Color(0xFF6600), new Color(0xFF33FF), new Color(0x3399FF), new Color(0x999900), new Color(0x669999), new Color(0xCC66CC), new Color(39423), new Color(0xFF33CC), new Color(0x3399CC), new Color(0xCC6699), new Color(0x669966), new Color(0xFF00FF), new Color(0x339999), new Color(0x669933), new Color(0x669900), new Color(0xFF3399), new Color(39372), new Color(0x9966FF), new Color(0xCC6666), new Color(39321), new Color(0xCC6633), new Color(0xCC6600), new Color(0x339966), new Color(0xFF00CC), new Color(0xFF3366), new Color(39270), new Color(0xCC33FF), new Color(0xFF3333), new Color(0x339933), new Color(39219), new Color(0x9966CC), new Color(0xFF3300), new Color(0xFF0099), new Color(0x339900), new Color(39168), new Color(0x6666FF), new Color(0xCC33CC), new Color(0xFF0066), new Color(0x996699), new Color(0xFF0033), new Color(0xFF0000), new Color(0xCC00FF), new Color(0xCC3399), new Color(0x996666), new Color(0x6666CC), new Color(0x996633), new Color(0x996600), new Color(0x3366FF), new Color(0xCC3366), new Color(0xCC00CC), new Color(0x9933FF), new Color(26367), new Color(0x666699), new Color(0xCC3333), new Color(0xCC3300), new Color(0x3366CC), new Color(0xCC0099), new Color(0x9933CC), new Color(0x666666), new Color(0x666633), new Color(26316), new Color(0x9900FF), new Color(0x666600), new Color(0xCC0066), new Color(0x336699), new Color(0x993399), new Color(0xCC0033), new Color(0x6633FF), new Color(0x336666), new Color(26265), new Color(0xCC0000), new Color(0x993366), new Color(0x9900CC), new Color(0x336633), new Color(26214), new Color(0x336600), new Color(0x6633CC), new Color(0x3333FF), new Color(26163), new Color(0x993333), new Color(0x993300), new Color(0x6600FF), new Color(0x990099), new Color(26112), new Color(13311), new Color(0x663399), new Color(39270), new Color(0x3333CC), new Color(0x663366), new Color(0x6600CC), new Color(0x990033), new Color(13260), new Color(0x990000), new Color(0x3300FF), new Color(0x663333), new Color(0x663300), new Color(0x660099), new Color(255), new Color(0x333399), new Color(0x3300CC), new Color(13209), new Color(0x333300), new Color(0x660066), new Color(0x333333), new Color(13158), new Color(204), new Color(0x660033), new Color(0x333300), new Color(0x660000), new Color(0x330099), new Color(13107), new Color(13056), new Color(153), new Color(0x330066), new Color(0x330033), new Color(102), new Color(0x330000), new Color(51), new Color(0)};
        }
        return COLOR_216_COLORS;
    }

    private static int calculateColumn(int n) {
        int n2;
        for (int i = n2 = (int)Math.ceil(Math.sqrt(n)); i <= n; ++i) {
            int n3 = n % i;
            if (n3 != 0) continue;
            return i;
        }
        return n2 + 1;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._color_15_names != null) {
            this._color_15_names = null;
            this._possibleColorsName = this.getPaletteNames40();
        }
        if (this._color_40_names != null) {
            this._color_40_names = null;
            this._possibleColorsName = this.getPaletteNames40();
        }
        if (this._defaultColor != null) {
            this._defaultColor.setText(this.getResourceString("Color.none", locale));
        }
        if (this._moreColor != null) {
            this._moreColor.setText(this.getResourceString("Color.moreColors", locale));
        }
    }

    protected String getResourceString(String string) {
        return ColorResource.getResourceBundle(this.getLocale()).getString(string);
    }

    protected String getResourceString(String string, Locale locale) {
        return ColorResource.getResourceBundle(locale).getString(string);
    }

    void setAlphaValue(int n) {
        for (ColorButton colorButton : this.getColorButtons()) {
            Color color = colorButton.getColor();
            if (color.getAlpha() != n) {
                colorButton.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
            }
            colorButton.invalidate();
        }
        this.repaint();
    }

    public class ColorButton
    extends JideButton {
        private static final int MARGIN = 3;
        private Color _color;
        private int _index;

        public ColorButton(Color color, int n) {
            this.setColor(color);
            this.setIndex(n);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setOpaque(false);
        }

        public Color getColor() {
            return this._color;
        }

        public void setColor(Color color) {
            this._color = color;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.getWidth() - 1;
            int n2 = this.getHeight() - 1;
            graphics.setColor(Color.gray);
            graphics.drawRect(3, 3, n - 6, n2 - 6);
            graphics.setColor(this._color);
            graphics.fillRect(4, 4, n - 6 - 1, n2 - 6 - 1);
        }

        int getIndex() {
            return this._index;
        }

        void setIndex(int n) {
            this._index = n;
        }
    }

    private class SelectAction
    implements ActionListener {
        private SelectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof ColorButton) {
                ColorButton colorButton = (ColorButton)actionEvent.getSource();
                ColorChooserPanel.this.setSelectedColor(colorButton.getColor());
                colorButton.repaint();
            } else if (actionEvent.getSource().equals(ColorChooserPanel.this._defaultColor)) {
                ColorChooserPanel.this.setSelectedColor(null);
            }
        }
    }

    private class MoreColorAction
    implements ActionListener {
        private MoreColorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)actionEvent.getSource();
            Color color = ColorChooserPanel.this.showColorChooser(component, ColorChooserPanel.this.getResourceString("Color.dialogTitle", ColorChooserPanel.this.getLocale()), ColorChooserPanel.this.getSelectedColor());
            if (color != null) {
                ColorChooserPanel.this.setSelectedColor(color);
            }
        }
    }

    private static class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;
        private static final long serialVersionUID = 4787690316171110620L;

        public ColorTracker(JColorChooser jColorChooser) {
            this.chooser = jColorChooser;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }

    public static interface ColorChooserDialogProvider {
        public Color showColorChooserDialog(Component var1, String var2, Color var3);
    }
}

