/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.DateChooserPanel;
import com.jidesoft.combobox.DateModel;
import com.jidesoft.combobox.DateModelEvent;
import com.jidesoft.combobox.DateModelListener;
import com.jidesoft.combobox.DateSelectionEvent;
import com.jidesoft.combobox.DateSelectionListener;
import com.jidesoft.combobox.DateSelectionModel;
import com.jidesoft.combobox.DefaultDateModel;
import com.jidesoft.combobox.DefaultDateSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class CalendarViewer
extends JPanel {
    private Dimension _calendarDimension = new Dimension(3, 4);
    private boolean _autoChangeDimension = false;
    private DateSelectionModel _selectionModel;
    private DateModel _dateModel;
    private DateChooserPanel[] _dateChooserPanels;
    private DateSelectionListener _dateSelectionListener;
    public static final String VIEWONLY_PROPERTY = "viewonly";
    public static final String PROPERTY_VIEWONLY = "viewonly";
    public static final String PROPERTY_ENABLED = "enabled";
    public static final String PROPERTY_CALENDAR_DIMENSION = "calendarDimension";
    private boolean _viewOnly = false;
    private boolean _enabled = true;
    private static final int HGAP = 6;
    private static final int VGAP = 6;

    public CalendarViewer() {
        this.installResizeListener();
        this.initComponents();
    }

    public CalendarViewer(Dimension dimension) {
        this._calendarDimension = dimension;
        this.installResizeListener();
        this.initComponents();
    }

    public CalendarViewer(DateModel dateModel) {
        this._dateModel = dateModel;
        this.installResizeListener();
        this.initComponents();
    }

    public CalendarViewer(DateModel dateModel, Dimension dimension) {
        this._dateModel = dateModel;
        this._calendarDimension = dimension;
        this.installResizeListener();
        this.initComponents();
    }

    private void installResizeListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (CalendarViewer.this.isAutoChangeDimension()) {
                    CalendarViewer.this.recalculateCalendarDimension();
                }
            }
        });
    }

    public void recalculateCalendarDimension() {
        Dimension dimension = this.getSize();
        DateChooserPanel dateChooserPanel = new DateChooserPanel();
        this.customizeDateChooserPanel(dateChooserPanel, 0, 0);
        Dimension dimension2 = dateChooserPanel.getPreferredSize();
        int n = dimension.width / (dimension2.width + 6);
        int n2 = dimension.height / (dimension2.height + 6);
        Dimension dimension3 = this.getCalendarDimension();
        if (n2 != dimension3.height || n != dimension3.width) {
            this.internalSetCalendarDimension(new Dimension(n, n2));
        }
    }

    private void initComponents() {
        int n;
        this.removeAll();
        int n2 = this._calendarDimension.width;
        int n3 = this._calendarDimension.height;
        if (n3 == 0 || n2 == 0) {
            return;
        }
        if (this.isAutoChangeDimension()) {
            this.setLayout(new FlowLayout(10, 6, 6));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        } else {
            this.setLayout(new GridLayout(n3, n2, 6, 6));
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        }
        if (this.getSelectionModel() == null) {
            this._selectionModel = new DefaultDateSelectionModel(2);
        }
        if (this.getDateModel() == null) {
            this.setDateModel(new DefaultDateModel());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DateChooserPanel dateChooserPanel = (DateChooserPanel)propertyChangeEvent.getSource();
                int n = dateChooserPanel.getDisplayIndex();
                Calendar calendar = (Calendar)propertyChangeEvent.getNewValue();
                calendar.add(2, -n);
                for (int i = 0; i < CalendarViewer.this._dateChooserPanels.length; ++i) {
                    DateChooserPanel dateChooserPanel2 = CalendarViewer.this._dateChooserPanels[i];
                    if (dateChooserPanel2 != dateChooserPanel) {
                        dateChooserPanel2.removePropertyChangeListener("displayMonth", this);
                        dateChooserPanel2.setDisplayedMonth(calendar.get(1), calendar.get(2), true);
                        dateChooserPanel2.addPropertyChangeListener("displayMonth", this);
                    }
                    calendar.add(2, 1);
                }
            }
        };
        this._dateSelectionListener = new DateSelectionListener(){

            @Override
            public void valueChanged(DateSelectionEvent dateSelectionEvent) {
                if (dateSelectionEvent.getSource() instanceof DateSelectionModel) {
                    CalendarViewer.this.updateAllCalendars((DateSelectionModel)dateSelectionEvent.getSource());
                } else {
                    CalendarViewer.this.updateAllCalendars(null);
                }
            }
        };
        this.getSelectionModel().addDateSelectionListener(this._dateSelectionListener);
        if (this._dateChooserPanels != null) {
            for (n = 0; n < this._dateChooserPanels.length; ++n) {
                DateChooserPanel dateChooserPanel = this._dateChooserPanels[n];
                dateChooserPanel.addPropertyChangeListener("displayMonth", propertyChangeListener);
                this._dateChooserPanels[n] = null;
            }
        }
        this._dateChooserPanels = new DateChooserPanel[n3 * n2];
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                DateChooserPanel dateChooserPanel = this.createDateChooserPanel(this.getDateModel(), this.getSelectionModel());
                dateChooserPanel.setCalendarViewer(this);
                dateChooserPanel.setDisplayIndex(n * n2 + i);
                this.customizeDateChooserPanel(dateChooserPanel, n, i);
                dateChooserPanel.setDisplayedMonth(calendar.get(1), calendar.get(2), true);
                dateChooserPanel.addPropertyChangeListener("displayMonth", propertyChangeListener);
                this.add(dateChooserPanel);
                this._dateChooserPanels[n * n2 + i] = dateChooserPanel;
                calendar.add(2, 1);
            }
        }
        this.repaint();
    }

    protected void customizeDateChooserPanel(final DateChooserPanel dateChooserPanel, int n, int n2) {
        int n3 = this.getCalendarDimension().height;
        int n4 = this.getCalendarDimension().width;
        dateChooserPanel.setShowPreviousButton(n == 0 && n2 == 0);
        dateChooserPanel.setShowPreviousYearButton(n == 0 && n2 == 0);
        dateChooserPanel.setShowNextButton(n == 0 && n2 == n4 - 1);
        dateChooserPanel.setShowNextYearButton(n == 0 && n2 == n4 - 1);
        dateChooserPanel.setShowPreviousMonthDays(n == 0 && n2 == 0);
        dateChooserPanel.setShowNextMonthDays(n == n3 - 1 && n2 == n4 - 1);
        dateChooserPanel.setShowTodayButton(false);
        dateChooserPanel.setShowNoneButton(false);
        this.addPropertyChangeListener("locale", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() instanceof Locale) {
                    dateChooserPanel.setLocale((Locale)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    protected DateChooserPanel createDateChooserPanel(DateModel dateModel, DateSelectionModel dateSelectionModel) {
        DateChooserPanel dateChooserPanel = new DateChooserPanel(dateModel);
        dateChooserPanel.setViewOnly(this.isViewOnly());
        dateChooserPanel.setSelectionModel(dateSelectionModel);
        return dateChooserPanel;
    }

    public DateChooserPanel[] getDateChooserPanels() {
        return this._dateChooserPanels;
    }

    private void updateAllCalendars(DateSelectionModel dateSelectionModel) {
        Serializable serializable;
        boolean[] blArray = null;
        if (dateSelectionModel instanceof DefaultDateSelectionModel && ((DefaultDateSelectionModel)dateSelectionModel).getOldSelectionModel() != null) {
            Date[] dateArray = dateSelectionModel.getSelectedDates();
            serializable = new HashSet();
            if (dateArray != null) {
                serializable.addAll(Arrays.asList(dateArray));
            }
            Date[] dateArray2 = ((DefaultDateSelectionModel)dateSelectionModel).getOldSelectionModel().getSelectedDates();
            HashSet<Date> hashSet = new HashSet<Date>();
            List<Date> list = null;
            if (dateArray2 != null) {
                list = Arrays.asList(dateArray2);
                hashSet.addAll(list);
            }
            hashSet.retainAll((Collection<?>)((Object)serializable));
            if (list != null) {
                serializable.addAll(list);
            }
            serializable.removeAll(hashSet);
            blArray = new boolean[this._dateChooserPanels.length];
            Object[] objectArray = new Object[this._dateChooserPanels.length];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = false;
                objectArray[i] = this._dateChooserPanels[i].getDisplayedDate();
            }
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                Date date = (Date)iterator.next();
                if (date == null) continue;
                int n = JideSwingUtilities.binarySearch(objectArray, date);
                if (n < 0) {
                    n = 0 - n - 1;
                }
                if (n >= this._dateChooserPanels.length || blArray[n] || n == 0 && date.before((Date)objectArray[0])) continue;
                blArray[n] = true;
            }
        }
        for (int i = 0; i < this._dateChooserPanels.length; ++i) {
            serializable = this._dateChooserPanels[i];
            if (blArray != null && blArray[i] == false) continue;
            ((DateChooserPanel)serializable).updateCalendar();
        }
    }

    public Dimension getCalendarDimension() {
        return this._calendarDimension;
    }

    public void setCalendarDimension(Dimension dimension) {
        if (this.isAutoChangeDimension()) {
            return;
        }
        this.internalSetCalendarDimension(dimension);
    }

    private void internalSetCalendarDimension(Dimension dimension) {
        Dimension dimension2 = this._calendarDimension;
        if (dimension != null && !dimension.equals(dimension2)) {
            this._calendarDimension = dimension;
            this.initComponents();
            this.revalidate();
            this.repaint();
            this.firePropertyChange(PROPERTY_CALENDAR_DIMENSION, dimension2, this._calendarDimension);
        }
    }

    public boolean isAutoChangeDimension() {
        return this._autoChangeDimension;
    }

    public void setAutoChangeDimension(boolean bl) {
        boolean bl2 = this._autoChangeDimension;
        if (bl2 != bl) {
            this._autoChangeDimension = bl;
            this.initComponents();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isAutoChangeDimension()) {
            DateChooserPanel dateChooserPanel = new DateChooserPanel();
            this.customizeDateChooserPanel(dateChooserPanel, 0, 0);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(10, 6, 6));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(dateChooserPanel);
            return jPanel.getPreferredSize();
        }
        return super.getMinimumSize();
    }

    public Calendar getMaxDisplayCalendar() {
        if (this._dateChooserPanels != null && this._dateChooserPanels.length > 0) {
            return this._dateChooserPanels[this._dateChooserPanels.length - 1].getDisplayedCalendar();
        }
        return null;
    }

    public Calendar getMinDisplayCalendar() {
        if (this._dateChooserPanels != null && this._dateChooserPanels.length > 0) {
            return this._dateChooserPanels[0].getDisplayedCalendar();
        }
        return null;
    }

    public DateSelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public void setSelectionModel(DateSelectionModel dateSelectionModel) {
        if (this._selectionModel != dateSelectionModel) {
            if (this._selectionModel != null && this._dateSelectionListener != null) {
                this._selectionModel.removeDateSelectionListener(this._dateSelectionListener);
            }
            for (DateChooserPanel dateChooserPanel : this._dateChooserPanels) {
                dateChooserPanel.setSelectionModel(dateSelectionModel);
            }
            this._selectionModel = dateSelectionModel;
            if (this._selectionModel != null && this._dateSelectionListener != null) {
                this._selectionModel.addDateSelectionListener(this._dateSelectionListener);
            }
        }
    }

    public DateModel getDateModel() {
        return this._dateModel;
    }

    public void setDateModel(DateModel dateModel) {
        this._dateModel = dateModel;
        this._dateModel.addDateModelListener(new DateModelListener(){

            @Override
            public void dateModelChanged(DateModelEvent dateModelEvent) {
                CalendarViewer.this.updateAllCalendars(null);
            }
        });
    }

    public boolean setDisplayedMonth(int n, int n2) {
        return this.setDisplayedMonth(n, n2, 0);
    }

    public boolean setDisplayedMonth(int n, int n2, int n3) {
        if (this._dateChooserPanels != null && this._dateChooserPanels.length > 0) {
            Calendar calendar;
            if (n3 < this._dateChooserPanels.length && (calendar = this._dateChooserPanels[n3].getDisplayedCalendar()).get(1) == n && calendar.get(2) == n2) {
                return true;
            }
            this.updateAllCalendars(null);
            calendar = this._dateChooserPanels[0].getDisplayedCalendar();
            Calendar calendar2 = this._dateChooserPanels[this._dateChooserPanels.length - 1].getDisplayedCalendar();
            calendar2.add(2, 1);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.set(1, n);
            calendar3.set(2, n2);
            calendar3.set(5, 1);
            if (this.getDateModel().monthInRange(calendar3)) {
                DateChooserPanel.convertToMidnight(calendar3);
                DateChooserPanel.convertToMidnight(calendar);
                DateChooserPanel.convertToMidnight(calendar2);
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n3 >= this._dateChooserPanels.length) {
                    n3 = this._dateChooserPanels.length - 1;
                }
                this._dateChooserPanels[n3].setDisplayedMonth(calendar3.get(1), calendar3.get(2), true);
                return true;
            }
        }
        return false;
    }

    public boolean isViewOnly() {
        return this._viewOnly;
    }

    public void setViewOnly(boolean bl) {
        boolean bl2 = this._viewOnly;
        if (bl2 != bl) {
            this._viewOnly = bl;
            this.firePropertyChange("viewonly", this._viewOnly, bl2);
            for (DateChooserPanel dateChooserPanel : this._dateChooserPanels) {
                dateChooserPanel.setViewOnly(this._viewOnly);
            }
            if (!this._viewOnly) {
                int n = this._calendarDimension.width;
                int n2 = this._calendarDimension.height;
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        this.customizeDateChooserPanel(this._dateChooserPanels[i * n + j], i, j);
                    }
                }
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this._enabled;
        if (bl2 != bl) {
            this._enabled = bl;
            this.firePropertyChange(PROPERTY_ENABLED, this._enabled, bl2);
            for (DateChooserPanel dateChooserPanel : this._dateChooserPanels) {
                dateChooserPanel.setEnabled(this._enabled);
            }
            if (!this._enabled) {
                int n = this._calendarDimension.width;
                int n2 = this._calendarDimension.height;
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        this.customizeDateChooserPanel(this._dateChooserPanels[i * n + j], i, j);
                    }
                }
            }
        }
    }

    public int getFirstDayOfWeek() {
        return this._dateChooserPanels != null && this._dateChooserPanels.length >= 1 ? this._dateChooserPanels[0].getFirstDayOfWeek() : -1;
    }

    public void setFirstDayOfWeek(int n) {
        if (this._dateChooserPanels != null) {
            for (DateChooserPanel dateChooserPanel : this._dateChooserPanels) {
                dateChooserPanel.setFirstDayOfWeek(n);
            }
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(CalendarViewer.class.getName(), 4);
        }
    }
}

