/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class AbstractComboBoxSearchable
extends Searchable
implements ListDataListener,
PropertyChangeListener,
PopupMenuListener {
    private boolean _showPopupDuringSearching = true;

    public AbstractComboBoxSearchable(AbstractComboBox abstractComboBox) {
        super(abstractComboBox);
        this.init();
    }

    private void init() {
        this.getComboBox().getModel().addListDataListener(this);
        this.getComboBox().addPopupMenuListener(this);
        this.getComboBox().addPropertyChangeListener("model", this);
    }

    protected AbstractComboBox getComboBox() {
        return (AbstractComboBox)this._component;
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        this.getComboBox().getModel().removeListDataListener(this);
        this.getComboBox().removePopupMenuListener(this);
        this.getComboBox().removePropertyChangeListener("model", this);
    }

    @Override
    protected String convertElementToString(Object object) {
        ObjectConverter objectConverter = this.getComboBox().getConverter();
        if (objectConverter != null) {
            return objectConverter.toString(object, this.getComboBox().getConverterContext());
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            ListModel listModel;
            this.hidePopup();
            ListModel listModel2 = (ListModel)propertyChangeEvent.getOldValue();
            if (listModel2 != null) {
                listModel2.removeListDataListener(this);
            }
            if ((listModel = (ListModel)propertyChangeEvent.getNewValue()) != null) {
                listModel.addListDataListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (this.isHideSearchPopupOnEvent()) {
            boolean bl = this.isShowPopupDuringSearching();
            this.setShowPopupDuringSearching(false);
            this.hidePopup();
            this.setShowPopupDuringSearching(bl);
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public boolean isShowPopupDuringSearching() {
        return this._showPopupDuringSearching;
    }

    public void setShowPopupDuringSearching(boolean bl) {
        this._showPopupDuringSearching = bl;
    }
}

