/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ColorFactory {
    private static final Logger logger = Logger.getLogger(ColorFactory.class.getName());
    private static final double root5 = Math.sqrt(5.0);
    private static final double gr = 2.0 / (1.0 + root5);
    private float hue;
    private float saturation;
    private float brightness;
    private Color[] initialColors = new Color[0];
    private List<Color> colors = new ArrayList<Color>();
    private int transparency = 255;
    private double minSaturation = 0.8;
    private double maxSaturation = 1.0;
    private double minBrightness = 0.5;
    private double maxBrightness = 1.0;

    public ColorFactory() {
        this.hue = (float)Math.random();
        this.saturation = (float)(this.minSaturation + Math.random() * (this.maxSaturation - this.minSaturation));
        this.brightness = (float)(this.minBrightness + Math.random() * (this.maxBrightness - this.minBrightness));
    }

    public ColorFactory(int n, Color ... colorArray) {
        this();
        this.setTransparency(n);
        this.initialColors = colorArray;
    }

    public ColorFactory(Color ... colorArray) {
        this();
        this.initialColors = colorArray;
    }

    public void clear() {
        this.colors.clear();
    }

    public int getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int n) {
        this.transparency = n;
    }

    public double getMinSaturation() {
        return this.minSaturation;
    }

    public void setMinSaturation(double d) {
        this.minSaturation = d;
    }

    public double getMaxSaturation() {
        return this.maxSaturation;
    }

    public void setMaxSaturation(double d) {
        this.maxSaturation = d;
    }

    public double getMinBrightness() {
        return this.minBrightness;
    }

    public void setMinBrightness(double d) {
        this.minBrightness = d;
    }

    public double getMaxBrightness() {
        return this.maxBrightness;
    }

    public void setMaxBrightness(double d) {
        this.maxBrightness = d;
    }

    public static double distance(Color color, Color color2) {
        if (color2 == null) {
            return 0.0;
        }
        return ColorFactory.distance(color, color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    private static int distance(Color color, int n, int n2, int n3) {
        if (color == null) {
            return 0;
        }
        int n4 = Math.abs(color.getRed() - n);
        int n5 = Math.abs(color.getGreen() - n2);
        int n6 = Math.abs(color.getBlue() - n3);
        return n4 + n5 + n6;
    }

    public double closest(Color color) {
        double d = Double.MAX_VALUE;
        for (Color color2 : this.colors) {
            double d2 = ColorFactory.distance(color, color2);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    private Color choose() {
        int n = this.colors.size();
        if (n < this.initialColors.length) {
            return this.initialColors[n];
        }
        this.hue = (float)((double)this.hue + gr);
        this.hue %= 1.0f;
        this.saturation = (float)(this.minSaturation + Math.random() * (this.maxSaturation - this.minSaturation));
        this.brightness = (float)(this.minBrightness + Math.random() * (this.maxBrightness - this.minBrightness));
        return Color.getHSBColor(this.hue, this.saturation, this.brightness);
    }

    public Color create() {
        Color color;
        int n;
        int n2 = 0;
        do {
            color = this.choose();
            assert (color.getAlpha() == 255);
            n = (int)this.closest(color);
            if (n != 0) continue;
            ++n2;
        } while (n == 0 && n2 < 10);
        this.colors.add(color);
        if (this.transparency != 255) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), this.transparency);
        }
        return color;
    }

    private static int colour(int n, int n2) {
        int n3 = n + n2;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        return n3;
    }

    public static Color intensify(Color color, int n) {
        return new Color(ColorFactory.colour(color.getRed(), n), ColorFactory.colour(color.getGreen(), n), ColorFactory.colour(color.getBlue(), n), color.getAlpha());
    }

    public static Color intensify2(Color color, int n) {
        int n2 = color == null ? 0 : color.getRed();
        int n3 = color == null ? 0 : color.getGreen();
        int n4 = color == null ? 0 : color.getBlue();
        int n5 = color == null ? 255 : color.getAlpha();
        int n6 = 3 * n;
        while (n6 > 0 && (n2 < 255 || n3 < 255 || n4 < 255)) {
            if (n2 < 255) {
                ++n2;
                --n6;
            }
            if (n3 < 255) {
                ++n3;
                --n6;
            }
            if (n4 >= 255) continue;
            ++n4;
            --n6;
        }
        return new Color(n2, n3, n4, n5);
    }

    public static Color transitionColor(Color color, Color color2, double d) {
        int n = color.getRed() + (int)(d * (double)(color2.getRed() - color.getRed()));
        int n2 = color.getGreen() + (int)(d * (double)(color2.getGreen() - color.getGreen()));
        int n3 = color.getBlue() + (int)(d * (double)(color2.getBlue() - color.getBlue()));
        int n4 = color.getAlpha() + (int)(d * (double)(color2.getAlpha() - color.getAlpha()));
        return new Color(n, n2, n3, n4);
    }
}

