/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ChartUtils {
    private static boolean assertEDTViolations = false;

    public static void setAssertEDTViolations(boolean bl) {
        assertEDTViolations = bl;
    }

    public static boolean isAssertingEDTViolations() {
        return assertEDTViolations;
    }

    public static void assertEDT() {
        if (assertEDTViolations) assert (SwingUtilities.isEventDispatchThread());
    }

    public static void runOnEdt(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void writeGifToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ChartUtils.writeToStream(component, "gif", fileOutputStream);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static void writeJpegToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ChartUtils.writeToStream(component, "jpg", fileOutputStream);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static void writePngToFile(Component component, File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ChartUtils.writeToStream(component, "png", fileOutputStream);
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static void writeToStream(Component component, OutputStream outputStream) {
        ChartUtils.writeToStream(component, "png", outputStream);
    }

    private static void writeToStream(Component component, String string, OutputStream outputStream) {
        BufferedImage bufferedImage = ChartUtils.createImage(component);
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
        }
        catch (IOException iOException) {
            Logger.getAnonymousLogger().severe(iOException.getMessage());
        }
    }

    public static BufferedImage createImage(Component component) {
        return ChartUtils.createImage(component, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createImage(Component component, int n) {
        Dimension dimension = component.getSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            boolean bl = jComponent.isDoubleBuffered();
            try {
                jComponent.setDoubleBuffered(false);
                jComponent.paint(graphics2D);
            }
            finally {
                jComponent.setDoubleBuffered(bl);
            }
        } else {
            component.paint(graphics2D);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image createThumbnailImage(Component component, int n, int n2) {
        BufferedImage bufferedImage = ChartUtils.createImage(component);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        double d = (double)n / (double)bufferedImage.getWidth();
        double d2 = (double)n2 / (double)bufferedImage.getHeight();
        assert (d <= 1.0) : "The thumbnail should be smaller than the original";
        assert (d2 <= 1.0) : "The thumbnail should be smaller than the original";
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        return bufferedImage2;
    }

    public static ImageIcon createThumbnail(Component component, int n, int n2) {
        return new ImageIcon(ChartUtils.createThumbnailImage(component, n, n2));
    }

    public static TexturePaint createTexture(JComponent jComponent, String string) {
        Image image = ChartUtils.createImage(string);
        MediaTracker mediaTracker = new MediaTracker(jComponent);
        mediaTracker.addImage(image, 1);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        int n = image.getWidth(jComponent);
        int n2 = image.getHeight(jComponent);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, jComponent);
        return new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public static Image createImage(String string) {
        ClassLoader classLoader = ChartUtils.class.getClassLoader();
        if (classLoader != null) {
            URL uRL = classLoader.getResource(string);
            if (uRL == null) {
                uRL = classLoader.getResource("/" + string);
            }
            return Toolkit.getDefaultToolkit().createImage(uRL);
        }
        return null;
    }

    public static void clearBufferedImage(BufferedImage bufferedImage, Color color) {
        if (bufferedImage == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(1, 1.0f));
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(color);
        graphics2D.fill(double_);
    }

    public static boolean isHardwareAccelerated(Image image) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        return image.getCapabilities(graphicsConfiguration).isAccelerated();
    }

    public static int[] getPixels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        if (n3 == 0 || n4 == 0) {
            return new int[0];
        }
        if (nArray == null) {
            nArray = new int[n3 * n4];
        } else if (nArray.length < n3 * n4) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int n5 = bufferedImage.getType();
        if (n5 == 2 || n5 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            return (int[])writableRaster.getDataElements(n, n2, n3, n4, nArray);
        }
        return bufferedImage.getRGB(n, n2, n3, n4, nArray, 0, n3);
    }

    public static void setPixels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        if (nArray == null || n3 == 0 || n4 == 0) {
            return;
        }
        if (nArray.length < n3 * n4) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int n5 = bufferedImage.getType();
        if (n5 == 2 || n5 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            writableRaster.setDataElements(n, n2, n3, n4, nArray);
        } else {
            bufferedImage.setRGB(n, n2, n3, n4, nArray, 0, n3);
        }
    }

    public static void copyImageToClipboard(Component component) {
        Dimension dimension = component.getSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        TransferableImage transferableImage = new TransferableImage(bufferedImage);
        component.paint(graphics);
        clipboard.setContents(transferableImage, null);
    }

    public static Font deriveResizedFont(Font font, Dimension dimension, Dimension dimension2) {
        if (dimension == null || dimension2 == null) {
            return font;
        }
        int n = dimension2.width;
        int n2 = dimension2.height;
        float f = (float)n2 / (float)dimension.height;
        float f2 = (float)n / (float)dimension.width;
        float f3 = Math.min(f, f2);
        float f4 = font.getSize2D() * f3;
        return font.deriveFont(f4);
    }

    public static Font deriveResizedFont(Font font, Dimension dimension, JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        Dimension dimension2 = jComponent.getSize();
        if (dimension2 == null || dimension == null) {
            return font;
        }
        int n = dimension2.width - insets.left - insets.right;
        int n2 = dimension2.height - insets.top - insets.bottom;
        return ChartUtils.deriveResizedFont(font, dimension, new Dimension(n, n2));
    }

    private static class TransferableImage
    implements Transferable {
        public static DataFlavor imageFlavor = DataFlavor.imageFlavor;
        private Image image;

        public TransferableImage(Image image) {
            this.image = image;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return imageFlavor.equals(dataFlavor);
        }

        @Override
        public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!imageFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.image;
        }
    }
}

