/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.style;

import com.jidesoft.chart.PointShape;
import com.jidesoft.chart.style.AbstractStyle;
import java.awt.Color;
import javax.xml.bind.annotation.XmlAttribute;

public class PointStyle
extends AbstractStyle {
    public static final int DEFAULT_SIZE = 5;
    public static final PointShape DEFAULT_SHAPE = PointShape.DISC;
    private PointShape shape = DEFAULT_SHAPE;
    private int size = 5;

    public PointStyle() {
    }

    public PointStyle(Color color) {
        this.setColor(color);
    }

    public PointStyle(Color color, PointShape pointShape) {
        this.setColor(color);
        this.setShape(pointShape);
    }

    public PointStyle(Color color, PointShape pointShape, int n) {
        this.setColor(color);
        this.setShape(pointShape);
        this.setSize(n);
    }

    @XmlAttribute
    public PointShape getShape() {
        return this.shape;
    }

    public void setShape(PointShape pointShape) {
        this.shape = pointShape;
    }

    @XmlAttribute
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.shape == null ? 0 : this.shape.hashCode());
        n = 31 * n + this.size;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PointStyle pointStyle = (PointStyle)object;
        if (this.shape == null ? pointStyle.shape != null : !this.shape.equals((Object)pointStyle.shape)) {
            return false;
        }
        return this.size == pointStyle.size;
    }

    public String toString() {
        return String.format("#<PointStyle shape=%s size=%s color=%s>", new Object[]{this.shape, this.size, this.getColor()});
    }
}

