/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.style;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.PointShape;
import com.jidesoft.chart.style.BarStyle;
import com.jidesoft.chart.style.LineFillExtent;
import com.jidesoft.chart.style.LineStyle;
import com.jidesoft.chart.style.PieStyle;
import com.jidesoft.chart.style.PointStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

public class ChartStyle {
    public static final ChartStyle DEFAULT_STYLE = new ChartStyle(Color.black, PointShape.DISC, 5).withPointsAndLines();
    private boolean linesVisible = true;
    private boolean pointsVisible = true;
    private boolean barVisible = false;
    private PointStyle pointStyle = new PointStyle();
    private LineStyle lineStyle = new LineStyle();
    private BarStyle barStyle = new BarStyle();
    private PieStyle pieStyle = new PieStyle();

    public ChartStyle() {
        this.setPointsVisible(false);
    }

    public ChartStyle(ChartStyle chartStyle) {
        if (chartStyle == null) {
            chartStyle = new ChartStyle(Color.black, false, true);
        }
        this.setPointsVisible(chartStyle.isPointsVisible());
        this.setLinesVisible(chartStyle.isLinesVisible());
        this.setBarsVisible(chartStyle.isBarsVisible());
        this.setLineWidth(chartStyle.getLineWidth());
        this.setLineColor(chartStyle.getLineColor());
        this.setLineFill(chartStyle.getLineFill());
        this.setPointSize(chartStyle.getPointSize());
        this.setPointColor(chartStyle.getPointColor());
        this.setPointShape(chartStyle.getPointShape());
        this.setBarColor(chartStyle.getBarColor());
        this.setBarWidth(chartStyle.getBarWidth());
        this.setBarWidthProportion(chartStyle.getBarWidthProportion());
        this.setPieSegmentsAlwaysExploded(chartStyle.isPieSegmentsAlwaysExploded());
    }

    public ChartStyle(Color color) {
        this.setPointColor(color);
        this.setLineColor(color);
        this.setBarColor(color);
        this.setLinesVisible(true);
        this.setPointsVisible(false);
        this.setBarsVisible(false);
    }

    public ChartStyle(Color color, PointShape pointShape) {
        this.setPointColor(color);
        this.setLineColor(color);
        this.setLinesVisible(false);
        this.setPointsVisible(true);
        this.setPointShape(pointShape);
    }

    public ChartStyle(Color color, PointShape pointShape, int n) {
        this.setPointColor(color);
        this.setLineColor(color);
        this.setLinesVisible(false);
        this.setPointsVisible(true);
        this.setPointSize(n);
        this.setPointShape(pointShape);
    }

    public ChartStyle(Color color, boolean bl, boolean bl2) {
        this.setPointColor(color);
        this.setLineColor(color);
        this.setBarColor(color);
        this.setPointsVisible(bl);
        this.setLinesVisible(bl2);
    }

    public ChartStyle(Color color, boolean bl, boolean bl2, boolean bl3) {
        this.setPointColor(color);
        this.setLineColor(color);
        this.setBarColor(color);
        this.setPointsVisible(bl);
        this.setLinesVisible(bl2);
        this.setBarsVisible(bl3);
    }

    public ChartStyle(Color color, PointShape pointShape, Color color2) {
        this.setPointColor(color);
        this.setLineColor(color2);
        this.setLinesVisible(true);
        this.setPointsVisible(true);
        this.setPointShape(pointShape);
        this.setPointShape(pointShape);
    }

    public ChartStyle withPoints() {
        this.setPointsVisible(true);
        this.setLinesVisible(false);
        this.setBarsVisible(false);
        return this;
    }

    public ChartStyle withLines() {
        this.setPointsVisible(false);
        this.setLinesVisible(true);
        this.setBarsVisible(false);
        return this;
    }

    public ChartStyle withLineFill(Paint paint) {
        this.setLinesVisible(true);
        this.setLineFill(paint);
        return this;
    }

    public ChartStyle withNothing() {
        this.setPointsVisible(false);
        this.setLinesVisible(false);
        this.setBarsVisible(false);
        return this;
    }

    public ChartStyle withBars() {
        this.setPointsVisible(false);
        this.setLinesVisible(false);
        this.setBarsVisible(true);
        return this;
    }

    public ChartStyle withBars(Paint paint) {
        this.setPointsVisible(false);
        this.setLinesVisible(false);
        this.setBarsVisible(true);
        this.setBarPaint(paint);
        return this;
    }

    public ChartStyle withPointsAndLines() {
        this.setPointsVisible(true);
        this.setLinesVisible(true);
        this.setBarsVisible(false);
        return this;
    }

    @XmlTransient
    public Color getPointColor() {
        return this.pointStyle.getColor();
    }

    public void setPointColor(Color color) {
        this.pointStyle.setColor(color);
    }

    @XmlTransient
    public int getPointSize() {
        return this.pointStyle.getSize();
    }

    public void setPointSize(int n) {
        this.pointStyle.setSize(n);
    }

    @XmlTransient
    public PointShape getPointShape() {
        return this.pointStyle.getShape();
    }

    public void setPointShape(PointShape pointShape) {
        this.pointStyle.setShape(pointShape);
    }

    @XmlTransient
    public Color getLineColor() {
        return this.lineStyle.getColor();
    }

    public void setLineColor(Color color) {
        this.lineStyle.setColor(color);
    }

    @XmlAttribute
    public boolean isLinesVisible() {
        return this.linesVisible;
    }

    public void setLinesVisible(boolean bl) {
        this.linesVisible = bl;
    }

    @XmlAttribute
    public boolean isPointsVisible() {
        return this.pointsVisible;
    }

    public void setPointsVisible(boolean bl) {
        this.pointsVisible = bl;
    }

    @XmlTransient
    public boolean isBarVisible() {
        return this.barVisible;
    }

    @XmlAttribute
    public boolean isBarsVisible() {
        return this.barVisible;
    }

    public void setBarVisible(boolean bl) {
        this.barVisible = bl;
    }

    public void setBarsVisible(boolean bl) {
        this.barVisible = bl;
    }

    @XmlTransient
    public Color getBarColor() {
        return this.barStyle.getColor();
    }

    @XmlTransient
    public Paint getBarPaint() {
        return this.barStyle.getPaint();
    }

    public void setBarColor(Color color) {
        this.barStyle.setColor(color);
    }

    public void setBarPaint(Paint paint) {
        this.barStyle.setPaint(paint);
    }

    public Integer getBarWidth() {
        return this.barStyle.getBarWidth();
    }

    public void setBarWidth(Integer n) {
        this.barStyle.setBarWidth(n);
    }

    public Double getBarWidthProportion() {
        return this.barStyle.getBarWidthProportion();
    }

    public void setBarWidthProportion(Double d) {
        this.barStyle.setBarWidthProportion(d);
    }

    @XmlTransient
    public PointShape getShape() {
        return this.pointStyle.getShape();
    }

    public void setShape(PointShape pointShape) {
        this.pointStyle.setShape(pointShape);
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    public BarStyle getBarStyle() {
        return this.barStyle;
    }

    public void setBarStyle(BarStyle barStyle) {
        this.barStyle = barStyle;
    }

    public Paint getLinePaint() {
        return this.getLineFill();
    }

    @XmlTransient
    public Paint getLineFill() {
        if (this.lineStyle == null) {
            return null;
        }
        return this.lineStyle.getFill();
    }

    public void setLineFill(Paint paint) {
        if (this.lineStyle == null) {
            this.lineStyle = new LineStyle();
        }
        this.lineStyle.setFill(paint);
    }

    public Orientation getLineFillOrientation() {
        if (this.lineStyle == null) {
            return null;
        }
        return this.lineStyle.getFillOrientation();
    }

    public void setLineFillOrientation(Orientation orientation) {
        if (this.lineStyle == null) {
            this.lineStyle = new LineStyle();
        }
        this.lineStyle.setFillOrientation(orientation);
    }

    public LineFillExtent getLineFillExtent() {
        if (this.lineStyle == null) {
            return null;
        }
        return this.lineStyle.getFillExtent();
    }

    public void setLineFillExtent(LineFillExtent lineFillExtent) {
        if (this.lineStyle == null) {
            this.lineStyle = new LineStyle();
        }
        this.lineStyle.setFillExtent(lineFillExtent);
    }

    @XmlTransient
    public int getLineWidth() {
        if (this.lineStyle == null) {
            return 1;
        }
        return this.lineStyle.getWidth();
    }

    public void setLineWidth(int n) {
        if (this.lineStyle == null) {
            this.lineStyle = new LineStyle(n);
        } else {
            this.lineStyle.setWidth(n);
        }
    }

    public void setLineStroke(BasicStroke basicStroke) {
        if (this.lineStyle == null) {
            this.lineStyle = new LineStyle(basicStroke);
        } else {
            this.lineStyle.setStroke(basicStroke);
        }
    }

    @XmlTransient
    public BasicStroke getLineStroke() {
        if (this.lineStyle == null) {
            return LineStyle.DEFAULT_STROKE;
        }
        return this.lineStyle.getStroke();
    }

    public PointStyle getPointStyle() {
        return this.pointStyle;
    }

    public void setPointStyle(PointStyle pointStyle) {
        this.pointStyle = pointStyle;
    }

    @XmlTransient
    public Orientation getBarOrientation() {
        return this.barStyle.getOrientation();
    }

    public void setBarOrientation(Orientation orientation) {
        this.barStyle.setOrientation(orientation);
    }

    public float getPieOffsetAngle() {
        return this.pieStyle.getOffsetAngle();
    }

    public void setPieOffsetAngle(float f) {
        this.pieStyle.setOffsetAngle(f);
    }

    public float getPieExplosionRatio() {
        return this.pieStyle.getExplosionRatio();
    }

    public void setPieExplosionRatio(float f) {
        this.pieStyle.setExplosionRatio(f);
    }

    public void setPieSegmentsAlwaysExploded(boolean bl) {
        this.pieStyle.setAlwaysExplodeSegments(bl);
    }

    public boolean isPieSegmentsAlwaysExploded() {
        return this.pieStyle.isAlwaysExplodeSegments();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.barStyle == null ? 0 : this.barStyle.hashCode());
        n = 31 * n + (this.barVisible ? 1231 : 1237);
        n = 31 * n + (this.lineStyle == null ? 0 : this.lineStyle.hashCode());
        n = 31 * n + (this.linesVisible ? 1231 : 1237);
        n = 31 * n + (this.pointStyle == null ? 0 : this.pointStyle.hashCode());
        n = 31 * n + (this.pointsVisible ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChartStyle chartStyle = (ChartStyle)object;
        if (this.barStyle == null ? chartStyle.barStyle != null : !this.barStyle.equals(chartStyle.barStyle)) {
            return false;
        }
        if (this.barVisible != chartStyle.barVisible) {
            return false;
        }
        if (this.lineStyle == null ? chartStyle.lineStyle != null : !this.lineStyle.equals(chartStyle.lineStyle)) {
            return false;
        }
        if (this.linesVisible != chartStyle.linesVisible) {
            return false;
        }
        if (this.pointStyle == null ? chartStyle.pointStyle != null : !this.pointStyle.equals(chartStyle.pointStyle)) {
            return false;
        }
        return this.pointsVisible == chartStyle.pointsVisible;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("#<ChartStyle ");
        stringBuilder.append("pointsVisible=");
        stringBuilder.append(this.pointsVisible);
        stringBuilder.append(" pointStyle= ");
        stringBuilder.append(this.pointStyle);
        stringBuilder.append(" linesVisible=");
        stringBuilder.append(this.linesVisible);
        stringBuilder.append(" lineStyle=");
        stringBuilder.append(this.lineStyle);
        stringBuilder.append(" barVisible=");
        stringBuilder.append(this.barVisible);
        stringBuilder.append(" barStyle=");
        stringBuilder.append(this.barStyle);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

