/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.render.AbstractBarRenderer;
import com.jidesoft.chart.render.BarRenderer2D;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.range.Positionable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.logging.Logger;

public class RaisedBarRenderer
extends AbstractBarRenderer
implements BarRenderer2D,
Serializable {
    private static final Logger logger = Logger.getLogger(RaisedBarRenderer.class.getName());
    private int edgeSize = 20;

    public RaisedBarRenderer() {
    }

    public RaisedBarRenderer(int n) {
        this();
        this.setEdgeSize(n);
    }

    public int getEdgeSize() {
        return this.edgeSize;
    }

    public void setEdgeSize(int n) {
        assert (n >= 0);
        this.edgeSize = n;
    }

    @Override
    public Shape renderBar(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, double d, double d2, double d3, double d4) {
        Serializable serializable;
        Object object;
        Positionable positionable;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        boolean bl4 = false;
        ChartStyle chartStyle = chart.getStyle(chartModel);
        Orientation orientation = chartStyle == null ? Orientation.vertical : chartStyle.getBarOrientation();
        Positionable positionable2 = chartable == null ? null : chartable.getX();
        Positionable positionable3 = positionable = chartable == null ? null : chartable.getY();
        if (orientation == Orientation.vertical && positionable2 instanceof ChartCategory) {
            object = (ChartCategory)positionable2;
            serializable = ((ChartCategory)object).getHighlight();
            if (serializable != null) {
                chartStyle = chart.getHighlightStyle((Highlight)serializable);
            }
        } else if (orientation == Orientation.horizontal && positionable instanceof ChartCategory && (serializable = ((ChartCategory)(object = (ChartCategory)positionable)).getHighlight()) != null) {
            chartStyle = chart.getHighlightStyle((Highlight)serializable);
        }
        object = this.createBarPaint(chart, chartable, chartStyle, bl, bl2, bl3, (int)d, (int)d2, (int)d3, (int)d4);
        if (object == null) {
            object = this.getBarColor(chart, chartable, chartStyle, bl, bl2, bl3);
        }
        if (orientation == Orientation.vertical) {
            if (d3 > (double)bl4) {
                d3 -= (double)bl4;
                d += (double)bl4 / 2.0;
            } else {
                d3 = 0.0;
            }
        }
        if (orientation == Orientation.horizontal) {
            if (d4 > (double)bl4) {
                d4 -= (double)bl4;
                d2 += (double)bl4 / 2.0;
            } else {
                d4 = 0.0;
            }
        }
        graphics2D2.setPaint((Paint)object);
        assert (d3 >= 0.0);
        if (d4 == 0.0) {
            if (this.isZeroHeightBarsVisible()) {
                serializable = new Rectangle2D.Double(d, d2, d3, d4);
                graphics2D2.fill((Shape)((Object)serializable));
            }
        } else if (d4 > 0.0) {
            serializable = new Rectangle2D.Double(d, d2, d3, d4);
            graphics2D2.fill((Shape)((Object)serializable));
        } else {
            d2 += d4;
            d4 = -d4;
            serializable = new Rectangle2D.Double(d, d2, d3, d4);
            graphics2D2.fill((Shape)((Object)serializable));
        }
        double d5 = Math.min((double)this.edgeSize, d4 / 2.0);
        double d6 = Math.min((double)this.edgeSize, d3 / 2.0);
        double d7 = Math.min(d5, d6);
        this.paintTop(graphics2D2, (Paint)object, orientation, d, d2, d3, d7);
        this.paintBottom(graphics2D2, (Paint)object, orientation, d, d2 + d4 - d7, d3, d7);
        this.paintLeft(graphics2D2, (Paint)object, orientation, d, d2, d7, d4);
        this.paintRight(graphics2D2, (Paint)object, orientation, d + d3 - d7, d2, d7, d4);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        if (this.alwaysShowOutlines || bl && chart.isSelectionShowsOutline()) {
            Color color = bl && chart.isSelectionShowsOutline() ? this.getSelectionColor() : (this.alwaysShowOutlines ? this.getOutlineColor() : chart.getBackground());
            graphics2D2.setColor(color);
            graphics2D2.setStroke(new BasicStroke(this.getOutlineWidth()));
            graphics2D2.draw(double_);
        }
        if (this.isLabelsVisible()) {
            this.renderBarLabel(graphics2D2, chart, chartModel, chartable, bl, bl2, bl3, d, d2, d3, d4);
        }
        graphics2D2.dispose();
        return double_;
    }

    @Override
    public Shape renderBar(Graphics graphics, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        return this.renderBar(graphics2D, chart, chartModel, chartable, bl, bl2, bl3, (double)n, (double)n2, (double)n3, (double)n4);
    }

    protected Paint createUpperTopPaint(Orientation orientation, Color color, int n, int n2, int n3, int n4) {
        return new GradientPaint(new Point(n, n2), color.darker(), new Point(n, n2 + n4 / 2), color.brighter());
    }

    protected Paint createLowerTopPaint(Orientation orientation, Color color, int n, int n2, int n3, int n4) {
        return new GradientPaint(new Point(n, n2 + n4 / 2), color.brighter(), new Point(n, n2 + n4), color);
    }

    protected Paint createBottomPaint(Orientation orientation, Color color, int n, int n2, int n3, int n4) {
        return new GradientPaint(new Point(n, n2), color, new Point(n, n2 + n4), color.darker());
    }

    protected Paint createLeftPaint(Orientation orientation, Color color, int n, int n2, int n3, int n4) {
        return new GradientPaint(new Point(n, n2), color.darker(), new Point(n + n3, n2), color);
    }

    protected Paint createRightPaint(Orientation orientation, Color color, int n, int n2, int n3, int n4) {
        return new GradientPaint(new Point(n, n2), color, new Point(n + n3, n2), color.darker());
    }

    private Shape paintTop(Graphics2D graphics2D, Paint paint, Orientation orientation, double d, double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d, d2);
        generalPath.lineTo(d + d3, d2);
        generalPath.lineTo(d + d3 - d4 / 2.0, d2 + d4 / 2.0);
        generalPath.lineTo(d + d4 / 2.0, d2 + d4 / 2.0);
        generalPath.closePath();
        Paint paint2 = paint instanceof Color ? this.createUpperTopPaint(orientation, (Color)paint, (int)d, (int)d2, (int)d3, (int)d4) : paint;
        graphics2D.setPaint(paint2);
        graphics2D.fill(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(d + d4 / 2.0, d2 + d4 / 2.0);
        generalPath2.lineTo(d + d3 - d4 / 2.0, d2 + d4 / 2.0);
        generalPath2.lineTo(d + d3 - d4, d2 + d4);
        generalPath2.lineTo(d + d4, d2 + d4);
        generalPath2.closePath();
        Paint paint3 = paint instanceof Color ? this.createLowerTopPaint(orientation, (Color)paint, (int)d, (int)d2, (int)d3, (int)d4) : paint;
        graphics2D.setPaint(paint3);
        graphics2D.fill(generalPath2);
        return generalPath;
    }

    private Shape paintBottom(Graphics2D graphics2D, Paint paint, Orientation orientation, double d, double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d + d4, d2);
        generalPath.lineTo(d + d3 - d4, d2);
        generalPath.lineTo(d + d3, d2 + d4);
        generalPath.lineTo(d, d2 + d4);
        generalPath.closePath();
        Paint paint2 = paint instanceof Color ? this.createBottomPaint(orientation, (Color)paint, (int)d, (int)d2, (int)d3, this.edgeSize) : paint;
        graphics2D.setPaint(paint2);
        graphics2D.fill(generalPath);
        return generalPath;
    }

    private Shape paintLeft(Graphics2D graphics2D, Paint paint, Orientation orientation, double d, double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d, d2);
        generalPath.lineTo(d + d3, d2 + d3);
        generalPath.lineTo(d + d3, d2 + d4 - d3);
        generalPath.lineTo(d, d2 + d4);
        generalPath.closePath();
        Paint paint2 = paint instanceof Color ? this.createLeftPaint(orientation, (Color)paint, (int)d, (int)d2, (int)d3, this.edgeSize) : paint;
        graphics2D.setPaint(paint2);
        graphics2D.fill(generalPath);
        return generalPath;
    }

    private Shape paintRight(Graphics2D graphics2D, Paint paint, Orientation orientation, double d, double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d, d2 + d3);
        generalPath.lineTo(d + d3, d2);
        generalPath.lineTo(d + d3, d2 + d4);
        generalPath.lineTo(d, d2 + d4 - d3);
        generalPath.closePath();
        Paint paint2 = paint instanceof Color ? this.createRightPaint(orientation, (Color)paint, (int)d, (int)d2, (int)d3, this.edgeSize) : paint;
        graphics2D.setPaint(paint2);
        graphics2D.fill(generalPath);
        return generalPath;
    }

    @Override
    public int getMinimumBreadth() {
        return 0;
    }
}

