/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.render.AbstractPieSegmentRenderer;
import com.jidesoft.chart.render.Pie3DSegment;
import com.jidesoft.chart.render.PieLabelRenderer;
import com.jidesoft.chart.render.PieLabelRenderer2D;
import com.jidesoft.chart.render.PieSegmentRenderer2D;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.ColorFactory;
import com.jidesoft.range.Positionable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.ListSelectionModel;

public class Pie3DRenderer
extends AbstractPieSegmentRenderer
implements PieSegmentRenderer2D {
    private final ColorFactory factory = new ColorFactory();
    private float thicknessRatio = 0.2f;

    public float getThicknessRatio() {
        return this.thicknessRatio;
    }

    public void setThicknessRatio(float f) {
        this.thicknessRatio = f;
    }

    public float[] getSpotlightRatios() {
        return Pie3DSegment.spotlightRatios;
    }

    public void setSpotlightRatios(float[] fArray) {
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Supplied Ratios must be an array of length 4");
        }
        for (float f : fArray) {
            if (!(f < 0.0f) && !(f > 1.0f)) continue;
            throw new IllegalArgumentException("Supplied ratio must be between 0 and 1");
        }
        Pie3DSegment.spotlightRatios = fArray;
    }

    private float calculateRadius(Graphics graphics, Chart chart, ChartStyle chartStyle) {
        float f;
        float f2;
        Insets insets = chart.getInsets();
        int n = graphics.getFontMetrics().getHeight();
        float f3 = chartStyle.getPieExplosionRatio();
        int n2 = chart.titleHeight();
        int n3 = this.getTickLength();
        int n4 = chart.getWidth() - insets.left - insets.right;
        int n5 = chart.getHeight() - insets.top - insets.bottom - n3 - 2 * n - n2;
        if ((double)n5 < (double)(f2 = (float)n4) * 0.67 + (double)(f2 * this.thicknessRatio) && (f = ((float)n5 - (float)n5 * this.thicknessRatio) / 0.67f) < f2) {
            f2 = f;
        }
        f = chart.isSelectionShowsExplodedSegments() || chartStyle.isPieSegmentsAlwaysExploded() ? 2.0f * (1.0f + f3) : 2.0f;
        float f4 = f2 / f;
        return f4;
    }

    @Override
    public void renderSegments(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, float f, float[] fArray) {
        Object object6;
        Object object2;
        int n;
        Object object3;
        if (chart == null) {
            throw new IllegalArgumentException("chart should not be null!");
        }
        ChartStyle chartStyle = chart.getStyle(chartModel) == null ? new ChartStyle() : chart.getStyle(chartModel);
        HashMap<Object, Float> hashMap = new HashMap<Object, Float>();
        if (chartStyle == null) {
            chartStyle = new ChartStyle(Color.blue);
        }
        float f2 = chartStyle.getPieOffsetAngle();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < fArray.length; ++i) {
            boolean bl;
            Object object4;
            object3 = chartModel.getPoint(i);
            Highlight highlight = null;
            if (object3 instanceof Highlightable) {
                highlight = ((Highlightable)object3).getHighlight();
            }
            Positionable positionable = object3.getX();
            if (highlight == null && positionable instanceof ChartCategory) {
                object4 = (ChartCategory)positionable;
                highlight = ((ChartCategory)object4).getHighlight();
            }
            object4 = chart.getSelectionsForModel(chartModel);
            n = object4.isSelectedIndex(i);
            float f3 = fArray[i];
            ChartStyle chartStyle2 = chart.getStyle(chartModel);
            Object object5 = object2 = chartStyle2 == null ? Color.gray : chartStyle2.getBarPaint();
            if (highlight != null && (chartStyle2 = chart.getHighlightStyle(highlight)) != null) {
                object2 = chartStyle2.getBarPaint();
            }
            boolean bl2 = bl = chart.isRolloverEnabled() && object3.equals(chart.getCurrentChartPoint());
            if (bl) {
                if (object2 instanceof Color) {
                    object2 = ColorFactory.intensify2((Color)object2, 50);
                } else if (object2 instanceof TexturePaint) {
                    object2 = this.modify((TexturePaint)object2);
                }
            }
            graphics2D.setPaint((Paint)object2);
            if (object2 == null) {
                object2 = this.factory.create();
            }
            if (f3 == 360.0f && fArray.length == 1) {
                object6 = new Pie3DSegment((Chartable)object3, f2, f3, (Paint)object2);
                ((Pie3DSegment)object6).setStartAngle(f2);
                ((Pie3DSegment)object6).setExtent(f3);
                ((Pie3DSegment)object6).setIndexInModel(i);
                ((Pie3DSegment)object6).setSelected(n != 0);
                arrayList.add(object6);
            } else if (Pie3DSegment.crosses90(f2, f3) && Pie3DSegment.crosses270(f2, f3)) {
                if (Pie3DSegment.isQuadrant1(f2) || Pie3DSegment.isQuadrant4(f2)) {
                    object6 = new Pie3DSegment((Chartable)object3, f2, 180.0f, (Paint)object2);
                    ((Pie3DSegment)object6).setStartAngle(f2);
                    ((Pie3DSegment)object6).setExtent(f3);
                    ((Pie3DSegment)object6).setSurfaceDisplayed(false);
                    ((Pie3DSegment)object6).setIndexInModel(i);
                    ((Pie3DSegment)object6).setSelected(n != 0);
                    float f4 = f2 + 180.0f;
                    if (f4 >= 360.0f) {
                        f4 -= 360.0f;
                    }
                    Pie3DSegment pie3DSegment = new Pie3DSegment((Chartable)object3, f4, f3 - 180.0f, (Paint)object2);
                    pie3DSegment.setSurfaceDisplayed(true);
                    pie3DSegment.setStartAngle(f2);
                    pie3DSegment.setExtent(f3);
                    pie3DSegment.setIndexInModel(i);
                    pie3DSegment.setSelected(n != 0);
                    arrayList.add(object6);
                    arrayList.add(pie3DSegment);
                    float f5 = f2 + f3 / 2.0f;
                    hashMap.put(object6, Float.valueOf(f5));
                    hashMap.put(pie3DSegment, Float.valueOf(f5));
                } else {
                    object6 = new Pie3DSegment((Chartable)object3, f2 + f3 - 180.0f, 180.0f, (Paint)object2);
                    ((Pie3DSegment)object6).setStartAngle(f2);
                    ((Pie3DSegment)object6).setExtent(f3);
                    ((Pie3DSegment)object6).setSurfaceDisplayed(false);
                    ((Pie3DSegment)object6).setIndexInModel(i);
                    ((Pie3DSegment)object6).setSelected(n != 0);
                    Pie3DSegment pie3DSegment = new Pie3DSegment((Chartable)object3, f2, f3 - 180.0f, (Paint)object2);
                    pie3DSegment.setSurfaceDisplayed(true);
                    pie3DSegment.setStartAngle(f2);
                    pie3DSegment.setExtent(f3);
                    pie3DSegment.setIndexInModel(i);
                    pie3DSegment.setSelected(n != 0);
                    arrayList.add(object6);
                    arrayList.add(pie3DSegment);
                    float f6 = f2 + f3 / 2.0f;
                    hashMap.put(object6, Float.valueOf(f6));
                    hashMap.put(pie3DSegment, Float.valueOf(f6));
                }
            } else {
                object6 = new Pie3DSegment((Chartable)object3, f2, f3, (Paint)object2);
                ((Pie3DSegment)object6).setStartAngle(f2);
                ((Pie3DSegment)object6).setExtent(f3);
                ((Pie3DSegment)object6).setIndexInModel(i);
                ((Pie3DSegment)object6).setSelected(n != 0);
                arrayList.add(object6);
            }
            f2 += f3;
            if (!(f2 >= 360.0f)) continue;
            f2 -= 360.0f;
        }
        Collections.sort(arrayList);
        f = this.calculateRadius(graphics2D, chart, chartStyle);
        float f7 = 2.0f * f;
        object3 = chart.getInsets();
        int n2 = chart.getWidth() - ((Insets)object3).left - ((Insets)object3).right;
        if (f7 > (float)n2) {
            f7 = n2;
        }
        int n3 = (int)f7;
        float f8 = f7 * this.thicknessRatio;
        n = (int)(0.67 * (double)f7);
        int n4 = (int)((double)(this.thicknessRatio * (float)n3) / 2.0);
        int n5 = (int)((double)(this.thicknessRatio * (float)n) / 2.0);
        object2 = new Point2D.Double(point2D.getX(), point2D.getY() - (double)f8 / 2.0);
        for (Object object6 : arrayList) {
            ((Pie3DSegment)object6).setDrop((int)f8);
            Float f9 = (Float)hashMap.get(object6);
            float f10 = f9 == null ? ((Pie3DSegment)object6).getMidAngle() : f9.floatValue();
            int n6 = chartStyle.isPieSegmentsAlwaysExploded() || ((Pie3DSegment)object6).isSelected() && chart.isSelectionShowsExplodedSegments() ? (int)((double)n4 * Math.cos(Pie3DSegment.radians(f10))) : 0;
            int n7 = chartStyle.isPieSegmentsAlwaysExploded() || ((Pie3DSegment)object6).isSelected() && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n5 * Math.sin(Pie3DSegment.radians(f10)))) : 0;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n6, n7);
            graphics2D.transform(affineTransform);
            ((Pie3DSegment)object6).paintSegment(graphics2D, (Point2D)object2, n3, n);
            for (Shape shape : ((Pie3DSegment)object6).getShapes()) {
                PointDescriptor pointDescriptor = new PointDescriptor(((Pie3DSegment)object6).getChartable(), ((Pie3DSegment)object6).getIndexInModel(), chartModel);
                this.recordSegment(affineTransform.createTransformedShape(shape), pointDescriptor);
            }
            graphics2D.translate(-n6, -n7);
        }
        if (this.isAlwaysShowOutlines()) {
            this.renderOutlines2D(false, graphics2D, chart, chartModel, (Point2D)object2, n3, n, fArray, chartStyle);
        }
        this.renderOutlines2D(true, graphics2D, chart, chartModel, (Point2D)object2, n3, n, fArray, chartStyle);
        PieLabelRenderer pieLabelRenderer = this.getPieLabelRenderer();
        if (pieLabelRenderer != null) {
            if (pieLabelRenderer instanceof PieLabelRenderer2D) {
                object6 = (PieLabelRenderer2D)pieLabelRenderer;
                Graphics2D graphics2D2 = (Graphics2D)this.getLabelGraphics();
                object6.renderLabels(graphics2D2 == null ? graphics2D : graphics2D2, chart, chartModel, (Point2D)object2, (double)n3, (double)n, fArray, chartStyle);
            } else {
                throw new IllegalStateException("To use a PieSegmentRenderer2D, you must also use a PieLabelRenderer2D");
            }
        }
    }

    @Override
    public void renderSegments(Graphics graphics, Chart chart, ChartModel chartModel, Point point, int n, int[] nArray) {
        int n2;
        Comparable<Pie3DSegment> comparable;
        Object object;
        Object object2;
        int n3;
        int n4;
        int n5;
        if (chart == null) {
            throw new IllegalArgumentException("chart should not be null!");
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        ChartStyle chartStyle = chart.getStyle(chartModel) == null ? new ChartStyle() : chart.getStyle(chartModel);
        HashMap<Comparable<Pie3DSegment>, Integer> hashMap = new HashMap<Comparable<Pie3DSegment>, Integer>();
        if (chartStyle == null) {
            chartStyle = new ChartStyle(Color.blue);
        }
        float f = chartStyle.getPieOffsetAngle();
        ArrayList<Comparable<Pie3DSegment>> arrayList = new ArrayList<Comparable<Pie3DSegment>>();
        for (n5 = 0; n5 < nArray.length; ++n5) {
            boolean bl;
            Chartable chartable = chartModel.getPoint(n5);
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            n4 = listSelectionModel.isSelectedIndex(n5);
            n3 = nArray[n5];
            ChartStyle chartStyle2 = chart.getStyle(chartModel);
            object2 = chartStyle2 == null ? Color.gray : chartStyle2.getBarPaint();
            object = ((ChartPoint)chartable).getHighlight();
            if (object != null && (chartStyle2 = chart.getHighlightStyle((Highlight)object)) != null) {
                object2 = chartStyle2.getBarPaint();
            }
            boolean bl2 = bl = chart.isRolloverEnabled() && chartable.equals(chart.getCurrentChartPoint());
            if (bl) {
                if (object2 instanceof Color) {
                    object2 = ColorFactory.intensify2((Color)object2, 50);
                } else if (object2 instanceof TexturePaint) {
                    object2 = this.modify((TexturePaint)object2);
                }
            }
            graphics2D.setPaint((Paint)object2);
            if (object2 == null) {
                object2 = this.factory.create();
            }
            if (f == 0.0f && n3 == 360 && nArray.length == 1) {
                comparable = new Pie3DSegment(chartable, f, n3, (Paint)object2);
                ((Pie3DSegment)comparable).setStartAngle(f);
                ((Pie3DSegment)comparable).setExtent(n3);
                ((Pie3DSegment)comparable).setIndexInModel(n5);
                ((Pie3DSegment)comparable).setSelected(n4 != 0);
                arrayList.add(comparable);
            } else if (Pie3DSegment.crosses90(f, n3) && Pie3DSegment.crosses270(f, n3)) {
                comparable = new Pie3DSegment(chartable, f, 90.0f, (Paint)object2);
                ((Pie3DSegment)comparable).setStartAngle(f);
                ((Pie3DSegment)comparable).setExtent(n3);
                ((Pie3DSegment)comparable).setSurfaceDisplayed(false);
                ((Pie3DSegment)comparable).setIndexInModel(n5);
                ((Pie3DSegment)comparable).setSelected(n4 != 0);
                Pie3DSegment pie3DSegment = new Pie3DSegment(chartable, f + 90.0f, n3 - 90, (Paint)object2);
                pie3DSegment.setSurfaceDisplayed(true);
                pie3DSegment.setStartAngle(f);
                pie3DSegment.setExtent(n3);
                pie3DSegment.setIndexInModel(n5);
                pie3DSegment.setSelected(n4 != 0);
                arrayList.add(comparable);
                arrayList.add(pie3DSegment);
                n2 = (int)((double)f + (double)n3 / 2.0);
                hashMap.put(comparable, n2);
                hashMap.put(pie3DSegment, n2);
            } else {
                comparable = new Pie3DSegment(chartable, f, n3, (Paint)object2);
                ((Pie3DSegment)comparable).setStartAngle(f);
                ((Pie3DSegment)comparable).setExtent(n3);
                ((Pie3DSegment)comparable).setIndexInModel(n5);
                ((Pie3DSegment)comparable).setSelected(n4 != 0);
                arrayList.add(comparable);
            }
            f += (float)n3;
        }
        Collections.sort(arrayList);
        n = (int)this.calculateRadius(graphics2D, chart, chartStyle);
        int n6 = n5 = 2 * n;
        int n7 = (int)((float)n5 * this.thicknessRatio);
        n4 = (int)(0.67 * (double)n5);
        n3 = (int)(this.thicknessRatio * (float)n6 / 2.0f);
        int n8 = (int)(this.thicknessRatio * (float)n4 / 2.0f);
        object2 = new Point(point.x, point.y - n7 / 2);
        for (Pie3DSegment pie3DSegment : arrayList) {
            pie3DSegment.setDrop(n7);
            comparable = (Integer)hashMap.get(pie3DSegment);
            float f2 = comparable == null ? pie3DSegment.getMidAngle() : (float)((Integer)comparable).intValue();
            n2 = pie3DSegment.isSelected() && chart.isSelectionShowsExplodedSegments() ? (int)((double)n3 * Math.cos(Pie3DSegment.radians(f2))) : 0;
            int n9 = pie3DSegment.isSelected() && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n8 * Math.sin(Pie3DSegment.radians(f2)))) : 0;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n2, n9);
            graphics2D.transform(affineTransform);
            pie3DSegment.paintSegment(graphics, (Point2D)object2, n6, n4);
            for (Shape shape : pie3DSegment.getShapes()) {
                PointDescriptor pointDescriptor = new PointDescriptor(pie3DSegment.getChartable(), pie3DSegment.getIndexInModel(), chartModel);
                this.recordSegment(affineTransform.createTransformedShape(shape), pointDescriptor);
            }
            graphics.translate(-n2, -n9);
        }
        if (this.isAlwaysShowOutlines()) {
            this.renderOutlines(false, graphics2D, chart, chartModel, (Point)object2, n6, n4, nArray, chartStyle);
        }
        this.renderOutlines(true, graphics2D, chart, chartModel, (Point)object2, n6, n4, nArray, chartStyle);
        object = this.getPieLabelRenderer();
        if (object != null) {
            Graphics2D graphics2D2 = (Graphics2D)this.getLabelGraphics();
            object.renderLabels(graphics2D2 == null ? graphics : graphics2D2, chart, chartModel, (Point)object2, n6, n4, nArray, chartStyle);
        }
    }

    protected void renderOutlines(boolean bl, Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point point, int n, int n2, int[] nArray, ChartStyle chartStyle) {
        int n3 = point.x;
        int n4 = point.y;
        int n5 = n3 - n / 2;
        int n6 = n4 - n2 / 2;
        float f = chartStyle.getPieOffsetAngle();
        for (int i = 0; i < nArray.length; ++i) {
            float f2 = f + (float)nArray[i] / 2.0f;
            int n7 = (int)(0.2 * (double)n / 2.0);
            int n8 = (int)(0.2 * (double)n2 / 2.0);
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl2 = listSelectionModel.isSelectedIndex(i);
            int n9 = bl2 && chart.isSelectionShowsExplodedSegments() ? (int)((double)n7 * Math.cos(Pie3DSegment.radians(f2))) : 0;
            int n10 = bl2 && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n8 * Math.sin(Pie3DSegment.radians(f2)))) : 0;
            graphics2D.translate(n9, n10);
            if (this.isAlwaysShowOutlines() && !bl || bl2 && chart.isSelectionShowsOutline()) {
                Color color = bl2 ? this.getSelectionColor() : this.getOutlineColor();
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(this.getOutlineWidth(), 0, 1));
                graphics2D.drawLine(n3, n4, (int)Math.round((double)n3 + (double)n / 2.0 * Math.cos(Math.toRadians(f))), (int)Math.round((double)n4 - (double)(n2 / 2) * Math.sin(Math.toRadians(f))));
                graphics2D.drawArc(n5, n6, n, n2, (int)f, nArray[i]);
                graphics2D.drawLine(n3, n4, (int)Math.round((double)n3 + (double)n / 2.0 * Math.cos(Math.toRadians(f += (float)nArray[i]))), (int)Math.round((double)n4 - (double)(n2 / 2) * Math.sin(Math.toRadians(f))));
            } else {
                f += (float)nArray[i];
            }
            graphics2D.translate(-n9, -n10);
        }
    }

    protected void renderOutlines2D(boolean bl, Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, int n, int n2, float[] fArray, ChartStyle chartStyle) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = d - (double)n / 2.0;
        double d4 = d2 - (double)n2 / 2.0;
        float f = chartStyle.getPieOffsetAngle();
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = f + fArray[i] / 2.0f;
            int n3 = (int)(this.thicknessRatio * (float)n / 2.0f);
            int n4 = (int)(this.thicknessRatio * (float)n2 / 2.0f);
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl2 = listSelectionModel.isSelectedIndex(i);
            int n5 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? (int)((double)n3 * Math.cos(Pie3DSegment.radians(f2))) : 0;
            int n6 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n4 * Math.sin(Pie3DSegment.radians(f2)))) : 0;
            graphics2D.translate(n5, n6);
            if (this.isAlwaysShowOutlines() && !bl || bl2 && chart.isSelectionShowsOutline()) {
                Color color = bl2 ? this.getSelectionColor() : this.getOutlineColor();
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(this.getOutlineWidth(), 0, 1));
                Line2D.Double double_ = new Line2D.Double(d, d2, d + (double)n / 2.0 * Math.cos(Math.toRadians(f)), d2 - (double)(n2 / 2) * Math.sin(Math.toRadians(f)));
                graphics2D.draw(double_);
                Arc2D.Double double_2 = new Arc2D.Double(d3, d4, n, n2, f, fArray[i], 0);
                graphics2D.draw(double_2);
                Line2D.Double double_3 = new Line2D.Double(d, d2, d + (double)n / 2.0 * Math.cos(Math.toRadians(f += fArray[i])), d2 - (double)(n2 / 2) * Math.sin(Math.toRadians(f)));
                graphics2D.draw(double_3);
            } else {
                f += fArray[i];
            }
            graphics2D.translate(-n5, -n6);
        }
    }
}

