/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.render.AbstractLineRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.style.LineFillExtent;
import com.jidesoft.chart.style.LineStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class DefaultLineRenderer
extends AbstractLineRenderer {
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_USE_DRAW_POLYLINE = "Use DrawPolyline";
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Chart chart;
    private boolean useDrawPolyline = false;

    public DefaultLineRenderer(Chart chart) {
        this.chart = chart;
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.chart;
        this.chart = chart;
        this.support.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public boolean getUseDrawPolyline() {
        return this.useDrawPolyline;
    }

    public void setUseDrawPolyline(boolean bl) {
        boolean bl2 = this.useDrawPolyline;
        this.useDrawPolyline = bl;
        this.support.firePropertyChange(PROPERTY_USE_DRAW_POLYLINE, bl2, bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public Shape renderLine(Graphics graphics, ChartModel chartModel, int[] nArray, int[] nArray2, ChartStyle chartStyle) {
        Object object;
        Object object2;
        if (this.chart == null) {
            throw new IllegalStateException("Chart property has not been set");
        }
        if (graphics == null) {
            return null;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (chartStyle != null) {
            object2 = chartStyle.getLineStyle();
            if (nArray != null && nArray.length > 0 && object2 != null && ((LineStyle)object2).getFill() != null) {
                object = ((LineStyle)object2).getFillOrientation();
                LineFillExtent lineFillExtent = ((LineStyle)object2).getFillExtent();
                GeneralPath generalPath = object == Orientation.vertical || chartModel == null ? this.createVerticalFillShape(this.chart, chartModel, nArray, nArray2, lineFillExtent) : this.createHorizontalFillShape(this.chart, chartModel, nArray, nArray2, lineFillExtent);
                Rectangle rectangle = generalPath.getBounds();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(1.0f));
                Paint paint = this.createLineFillPaint(chartModel, chartStyle, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2D.setPaint(paint);
                graphics2D.fill(generalPath);
                graphics2D.draw(generalPath);
                graphics2D.setStroke(stroke);
            }
        }
        object2 = chartStyle == null ? Color.black : chartStyle.getLineColor();
        graphics2D.setColor((Color)object2);
        object = chartStyle == null ? LineStyle.DEFAULT_STROKE : chartStyle.getLineStroke();
        graphics2D.setStroke((Stroke)object);
        return this.drawPolyline(graphics2D, nArray, nArray2);
    }

    private GeneralPath createVerticalFillShape(Chart chart, ChartModel chartModel, int[] nArray, int[] nArray2, LineFillExtent lineFillExtent) {
        float f = this.calculateYVerticalExtent(chart, chartModel, lineFillExtent);
        GeneralPath generalPath = new GeneralPath();
        if (chartModel != null && chartModel.isCyclical()) {
            generalPath.moveTo(nArray[0], nArray2[0]);
        } else {
            generalPath.moveTo(nArray[0], f);
        }
        for (int i = 0; i < nArray.length; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        if (chartModel != null && chartModel.isCyclical()) {
            generalPath.lineTo(nArray[0], nArray2[0]);
        } else {
            generalPath.lineTo(nArray[nArray.length - 1], f);
            generalPath.lineTo(nArray[0], f);
        }
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath createHorizontalFillShape(Chart chart, ChartModel chartModel, int[] nArray, int[] nArray2, LineFillExtent lineFillExtent) {
        float f = this.calculateXHorizontalExtent(chart, chartModel, lineFillExtent);
        GeneralPath generalPath = new GeneralPath();
        if (chartModel != null && chartModel.isCyclical()) {
            generalPath.moveTo(nArray[0], nArray2[0]);
        } else {
            generalPath.moveTo(f, nArray2[0]);
        }
        for (int i = 0; i < nArray.length; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        if (chartModel != null && chartModel.isCyclical()) {
            generalPath.lineTo(nArray[0], nArray2[0]);
        } else {
            generalPath.lineTo(f, nArray2[nArray.length - 1]);
            generalPath.lineTo(f, nArray2[0]);
        }
        generalPath.closePath();
        return generalPath;
    }

    private Shape drawPolyline(Graphics2D graphics2D, int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return null;
        }
        if (this.useDrawPolyline) {
            graphics2D.drawPolyline(nArray, nArray2, nArray.length);
            return null;
        }
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < nArray.length - 1; ++i) {
            Line2D.Float float_ = new Line2D.Float(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
            graphics2D.draw(float_);
            generalPath.append(float_, false);
        }
        return generalPath;
    }
}

