/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.preference;

import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.prefs.Preferences;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PointSizeChooser
extends JSpinner
implements ChangeListener {
    private static final long serialVersionUID = -3801471552512246890L;
    private int initialValue = 4;
    private int minimum = 1;
    private int maximum = 10;
    private int step = 1;
    private static Preferences preferences;
    private SpinnerModel pointSizeModel;
    private Integer pointSize = 0;

    public PointSizeChooser() {
        this.init();
    }

    public PointSizeChooser(int n, int n2, int n3, int n4) {
        this.initialValue = n;
        this.minimum = n2;
        this.maximum = n3;
        this.step = n4;
        this.init();
    }

    public Integer getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(Integer n) {
        this.pointSize = n;
        this.pointSizeModel.setValue(n);
    }

    protected void init() {
        this.pointSizeModel = new SpinnerNumberModel(this.initialValue, this.minimum, this.maximum, this.step);
        this.setModel(this.pointSizeModel);
        int n = preferences.getInt("point.size", this.initialValue);
        this.pointSizeModel.setValue(n);
        this.pointSizeModel.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Integer n = (Integer)this.pointSizeModel.getValue();
        Integer n2 = this.pointSize;
        this.pointSize = n;
        preferences = Preferences.userNodeForPackage(this.getClass());
        preferences.putInt("point.size", n);
        this.firePropertyChange("PointSize", n2, n);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(PointSizeChooser.class.getName(), 4096);
        }
        preferences = Preferences.userNodeForPackage(PointSizeChooser.class);
    }
}

