/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.preference;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.PointShape;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.chart.render.DefaultPointRenderer;
import com.jidesoft.chart.render.PointRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class PointShapeLabel
extends JComponent
implements ListCellRenderer {
    private static final long serialVersionUID = -4185911997441723232L;
    private PointShape shape = PointShape.CIRCLE;
    private final int size = 15;
    private boolean selected;
    private DefaultChartModel model = new DefaultChartModel();
    private Chart chart = new Chart(this.model);
    private ChartStyle style;
    private PointRenderer pointRenderer = new DefaultPointRenderer();

    public PointShapeLabel() {
        this.init();
    }

    public PointShapeLabel(Color color) {
        this.init();
        this.setForeground(color);
    }

    protected void init() {
        this.setOpaque(true);
        this.setSize(15, 15);
        this.setMinimumSize(new Dimension(15, 15));
        this.setPreferredSize(new Dimension(15, 15));
        this.style = this.createStyle();
    }

    protected ChartStyle createStyle() {
        this.style = new ChartStyle();
        this.style.setPointsVisible(true);
        this.style.setPointShape(this.shape);
        return this.style;
    }

    public PointShape getShape() {
        return this.shape;
    }

    public void setShape(PointShape pointShape) {
        this.shape = pointShape;
        this.style.setPointShape(pointShape);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, 15, 15);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(this.getForeground());
        int n = 11;
        this.style.setPointSize(n);
        this.chart.setStyle(this.model, this.style);
        this.pointRenderer.renderPoint(graphics, this.chart, this.model, null, false, false, false, 7, 7);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        PointShape pointShape = (PointShape)((Object)object);
        this.setShape(pointShape);
        return this;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(PointShapeLabel.class.getName(), 4096);
        }
    }
}

