/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.preference;

import com.jidesoft.chart.PointShape;
import com.jidesoft.chart.preference.PointShapeLabel;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class PointShapeChooser
extends JComboBox {
    private static final long serialVersionUID = 2306175108665840301L;
    private static final Logger logger;
    private static final PointShape DEFAULT_VALUE;
    private PointShape shape = null;
    private static Preferences preferences;
    private DefaultComboBoxModel pointShapeModel = new DefaultComboBoxModel<PointShape>(PointShape.values());

    public PointShapeChooser() {
        this.init();
    }

    protected void init() {
        this.setModel(this.pointShapeModel);
        this.setRenderer(new PointShapeLabel());
        String string = preferences.get("point.shape", DEFAULT_VALUE.toString());
        this.shape = PointShape.valueOf(string);
        this.pointShapeModel.setSelectedItem((Object)this.shape);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PointShape pointShape = (PointShape)((Object)PointShapeChooser.this.getSelectedItem());
                logger.fine("Point Shape is now " + (Object)((Object)pointShape));
                preferences.put("point.shape", pointShape.toString());
                PointShapeChooser.this.firePropertyChange("Point Shape", (Object)PointShapeChooser.this.shape, (Object)pointShape);
                PointShapeChooser.this.shape = pointShape;
            }
        });
    }

    public PointShape getPointShape() {
        return (PointShape)((Object)this.getSelectedItem());
    }

    public void setPointShape(PointShape pointShape) {
        this.setSelectedItem((Object)pointShape);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(PointShapeChooser.class.getName(), 4096);
        }
        logger = Logger.getLogger(PointShapeChooser.class.getName());
        DEFAULT_VALUE = PointShape.CIRCLE;
        preferences = Preferences.userNodeForPackage(PointShapeChooser.class);
    }
}

