/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ChartableTableModel
extends AbstractTableModel
implements AnnotatedChartModel {
    private static final long serialVersionUID = -7961741249513738796L;
    private String name;
    private List<Chartable> _chartables;
    private List<ChartModelListener> listeners = Collections.synchronizedList(new ArrayList());

    public ChartableTableModel(String string, List<Chartable> list) {
        this.name = string;
        this._chartables = list;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Chartable getPoint(int n) {
        return this._chartables.get(n);
    }

    @Override
    public int getPointCount() {
        return this.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        return n == 0 ? "X" : "Y";
    }

    @Override
    public int getRowCount() {
        return this._chartables.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Chartable chartable = this.getPoint(n);
        return n2 == 0 ? chartable.getX() : chartable.getY();
    }

    @Override
    public boolean isCyclical() {
        return false;
    }

    @Override
    public Annotation getAnnotation(int n) {
        return null;
    }

    @Override
    public int getAnnotationCount() {
        return 0;
    }

    @Override
    public boolean isAnnotationsVisible() {
        return true;
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Chartable> iterator() {
        return this._chartables.iterator();
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        if (!this.listeners.contains(chartModelListener)) {
            this.listeners.add(chartModelListener);
        }
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.listeners.remove(chartModelListener);
    }

    public void update() {
        this.fireModelChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModelChanged() {
        List<ChartModelListener> list = this.listeners;
        synchronized (list) {
            for (ChartModelListener chartModelListener : this.listeners) {
                chartModelListener.chartModelChanged();
            }
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(ChartableTableModel.class.getName(), 4096);
        }
    }
}

