/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.chart.util.Nameable;
import com.jidesoft.chart.xml.XmlPositionableAdapter;
import com.jidesoft.range.Positionable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlSeeAlso(value={RealPosition.class})
public class ChartPoint
implements Chartable,
Nameable,
Highlightable {
    private Positionable xPos;
    private Positionable yPos;
    private Highlight highlight = null;
    private String name = null;

    public ChartPoint() {
        this(0.0, 0.0);
    }

    public ChartPoint(double d, double d2) {
        this.xPos = new RealPosition(d);
        this.yPos = new RealPosition(d2);
    }

    public ChartPoint(double d, double d2, Highlight highlight) {
        this.xPos = new RealPosition(d);
        this.yPos = new RealPosition(d2);
        this.setHighlight(highlight);
    }

    public ChartPoint(Positionable positionable, Positionable positionable2) {
        this.xPos = positionable;
        this.yPos = positionable2;
    }

    public ChartPoint(Positionable positionable, double d) {
        this.xPos = positionable;
        this.yPos = new RealPosition(d);
    }

    public ChartPoint(Positionable positionable, double d, Highlight highlight) {
        this.xPos = positionable;
        this.yPos = new RealPosition(d);
        this.setHighlight(highlight);
    }

    public ChartPoint(double d, Positionable positionable, Highlight highlight) {
        this.xPos = new RealPosition(d);
        this.yPos = positionable;
        this.setHighlight(highlight);
    }

    public ChartPoint(double d, Positionable positionable) {
        this.xPos = new RealPosition(d);
        this.yPos = positionable;
    }

    public ChartPoint(Positionable positionable, Positionable positionable2, Highlight highlight) {
        this.xPos = positionable;
        this.yPos = positionable2;
        this.setHighlight(highlight);
    }

    public ChartPoint(ChartPoint chartPoint) {
        this.xPos = chartPoint.getX();
        this.yPos = chartPoint.getY();
        this.setHighlight(chartPoint.getHighlight());
    }

    @Override
    @XmlAttribute
    @XmlJavaTypeAdapter(value=XmlPositionableAdapter.class)
    public Positionable getX() {
        return this.xPos;
    }

    @Override
    @XmlAttribute
    @XmlJavaTypeAdapter(value=XmlPositionableAdapter.class)
    public Positionable getY() {
        return this.yPos;
    }

    public void setX(Positionable positionable) {
        this.xPos = positionable;
    }

    public void setY(Positionable positionable) {
        this.yPos = positionable;
    }

    @Override
    @XmlAttribute
    public Highlight getHighlight() {
        return this.highlight;
    }

    public boolean isHighlight(Highlight highlight) {
        if (highlight == null) {
            return false;
        }
        return highlight.equals(this.highlight);
    }

    @Override
    public void setHighlight(Highlight highlight) {
        this.highlight = highlight;
    }

    @Override
    public int compareTo(Chartable chartable) {
        Positionable positionable = chartable.getX();
        int n = this.xPos == null && positionable == null ? 0 : (this.xPos == null ? -1 : (positionable == null ? 1 : this.xPos.compareTo(chartable.getX())));
        if (n == 0) {
            Positionable positionable2 = chartable.getY();
            int n2 = this.yPos == null && positionable2 == null ? 0 : (this.yPos == null ? -1 : (positionable2 == null ? 1 : this.yPos.compareTo(chartable.getY())));
            return n2;
        }
        return n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.xPos == null ? 0 : this.xPos.hashCode());
        n = 31 * n + (this.yPos == null ? 0 : this.yPos.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChartPoint chartPoint = (ChartPoint)object;
        if (this.xPos == null ? chartPoint.xPos != null : !this.xPos.equals(chartPoint.xPos)) {
            return false;
        }
        return !(this.yPos == null ? chartPoint.yPos != null : !this.yPos.equals(chartPoint.yPos));
    }

    public String toString() {
        String string;
        String string2 = this.name == null ? "" : this.name;
        String string3 = this.xPos == null ? "null" : String.format("%.2f", this.xPos.position());
        String string4 = string = this.yPos == null ? "null" : String.format("%.2f", this.yPos.position());
        if (this.highlight == null) {
            return String.format("#<ChartPoint name='%s' xPos=%s yPos=%s>", string2, string3, string);
        }
        return String.format("#<ChartPoint name='%s' xPos=%s yPos=%s highlight=%s>", string2, string3, string, this.highlight);
    }
}

