/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;

public class SplineEngine {
    public static double splineEval(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d3 - d2;
        double d9 = (d - d2) / d8;
        double d10 = 1.0 - d9;
        return d10 * d10 * (d4 * (2.0 * d9 + 1.0) + d6 * d8 * d9) + d9 * d9 * (d5 * (3.0 - 2.0 * d9) - d7 * d8 * d10);
    }

    public static double[] computeSplineSlopes(int n, double[] dArray, double[] dArray2) {
        int n2;
        if (n <= 0) {
            return new double[0];
        }
        int n3 = n + 1;
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n3];
        double[] dArray7 = new double[n3];
        double[] dArray8 = new double[n3];
        for (n2 = 0; n2 < n; ++n2) {
            dArray3[n2] = dArray[n2 + 1] - dArray[n2];
            dArray4[n2] = 1.0 / dArray3[n2];
            dArray5[n2] = 3.0 * (dArray2[n2 + 1] - dArray2[n2]) * dArray4[n2] * dArray4[n2];
        }
        dArray6[0] = 2.0 * dArray4[0];
        dArray7[0] = dArray5[0];
        for (n2 = 1; n2 <= n; ++n2) {
            double d = dArray4[n2 - 1] / dArray6[n2 - 1];
            dArray6[n2] = (2.0 - d) * dArray4[n2 - 1];
            dArray7[n2] = dArray5[n2 - 1] - d * dArray7[n2 - 1];
            if (n2 >= n) continue;
            int n4 = n2;
            dArray6[n4] = dArray6[n4] + 2.0 * dArray4[n2];
            int n5 = n2;
            dArray7[n5] = dArray7[n5] + dArray5[n2];
        }
        dArray8[n] = dArray7[n] / dArray6[n];
        for (n2 = n - 1; n2 >= 0; --n2) {
            dArray8[n2] = (dArray7[n2] - dArray4[n2] * dArray8[n2 + 1]) / dArray6[n2];
        }
        return dArray8;
    }

    public static double[] lagrange(double[] dArray, double[] dArray2, double[][] dArray3) {
        assert (dArray.length == dArray2.length) : "x and y are parallel arrays and must have the same length!";
        int n = dArray.length;
        double[] dArray4 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i][0] = 1.0;
            double d = dArray2[i];
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                if (j == i) continue;
                dArray3[i][n2 + 1] = dArray3[i][n2];
                for (int k = n2; k > 0; --k) {
                    dArray3[i][k] = dArray3[i][k - 1] - dArray3[i][k] * dArray[j];
                }
                double[] dArray5 = dArray3[i];
                dArray5[0] = dArray5[0] * -dArray[j];
                ++n2;
                d /= dArray[i] - dArray[j];
            }
            n2 = 0;
            while (n2 < n) {
                double[] dArray6 = dArray3[i];
                int n3 = n2++;
                dArray6[n3] = dArray6[n3] * d;
            }
            for (n2 = 0; n2 < n; ++n2) {
                int n4 = n2;
                dArray4[n4] = dArray4[n4] + dArray3[i][n2];
            }
        }
        return dArray4;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(SplineEngine.class.getName(), 4096);
        }
    }
}

