/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.filter;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.util.Filter;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.text.DateFormat;
import java.util.Date;

public class AxisFilter
implements Filter<Chartable> {
    private Double min = Double.MAX_VALUE;
    private Double max = Double.MIN_VALUE;
    private Orientation orientation = Orientation.horizontal;

    public AxisFilter() {
    }

    public AxisFilter(Orientation orientation) {
        this.orientation = orientation;
    }

    public AxisFilter(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public AxisFilter(Orientation orientation, double d, double d2) {
        this.orientation = orientation;
        this.min = d;
        this.max = d2;
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double d) {
        this.min = d;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double d) {
        this.max = d;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public boolean isValueFiltered(Chartable chartable) {
        if (this.orientation == Orientation.horizontal) {
            double d = chartable.getX().position();
            return d >= this.min && d <= this.max;
        }
        double d = chartable.getY().position();
        return d >= this.min && d <= this.max;
    }

    public String toString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Date date = this.min == null ? null : new Date(this.min.longValue());
        Date date2 = this.max == null ? null : new Date(this.max.longValue());
        return String.format("#<AxisFilter from='%s' to='%s'>", date == null ? "" : dateFormat.format(date), date2 == null ? "" : dateFormat.format(date2));
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(AxisFilter.class.getName(), 4096);
        }
    }
}

