/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.event.PointSelectionEvent;
import com.jidesoft.chart.event.RectangleSelectionEvent;
import com.jidesoft.chart.event.ZoomDirection;
import com.jidesoft.chart.event.ZoomListener;
import com.jidesoft.chart.event.ZoomOrientation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;

public class RubberBandZoomer
implements Drawable,
MouseMotionListener,
MouseListener {
    public static final String PROPERTY_OUTLINE_STROKE = "Rubber Band Outline Stroke";
    public static final String PROPERTY_OUTLINE_COLOR = "Rubber Band Outline Color";
    public static final String PROPERTY_FILL = "Rubber Band Fill";
    public static final String PROPERTY_KEEP_RATIO = "Rubber Band Keep Ratio";
    public static final String PROPERTY_ZOOM_ORIENTATION = "Zoom Orientation";
    private Point pressed;
    private boolean rightClick = false;
    private Rectangle dragRectangle;
    private Rectangle lastDraggedArea;
    private List<ZoomListener> listeners = new CopyOnWriteArrayList<ZoomListener>();
    private JComponent component;
    private Stroke stroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
    private Color outlineColor = Color.blue;
    private Paint fill = null;
    private boolean keepWidthHeightRatio = false;
    private ZoomOrientation zoomOrientation = ZoomOrientation.BOTH;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public RubberBandZoomer(JComponent jComponent) {
        this.component = jComponent;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this.listeners.add(zoomListener);
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        this.listeners.remove(zoomListener);
    }

    public void setOutlineStroke(Stroke stroke) {
        Stroke stroke2 = this.stroke;
        this.stroke = stroke;
        this.support.firePropertyChange(PROPERTY_OUTLINE_STROKE, stroke2, stroke);
    }

    public Stroke getOutlineStroke() {
        return this.stroke;
    }

    public void setOutlineColor(Color color) {
        Color color2 = this.outlineColor;
        this.outlineColor = color;
        this.support.firePropertyChange(PROPERTY_OUTLINE_COLOR, color2, this.outlineColor);
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        Paint paint2 = this.fill;
        this.fill = paint;
        this.support.firePropertyChange(PROPERTY_FILL, paint2, paint);
    }

    public boolean isKeepWidthHeightRatio() {
        return this.keepWidthHeightRatio;
    }

    public void setKeepWidthHeightRatio(boolean bl) {
        boolean bl2 = this.keepWidthHeightRatio;
        this.keepWidthHeightRatio = bl;
        this.support.firePropertyChange(PROPERTY_KEEP_RATIO, bl2, bl);
    }

    public ZoomOrientation getZoomOrientation() {
        return this.zoomOrientation;
    }

    public void setZoomOrientation(ZoomOrientation zoomOrientation) {
        ZoomOrientation zoomOrientation2 = this.zoomOrientation;
        this.zoomOrientation = zoomOrientation;
        this.support.firePropertyChange(PROPERTY_ZOOM_ORIENTATION, (Object)zoomOrientation2, (Object)zoomOrientation);
    }

    protected void fireZoomIn(Rectangle rectangle) {
        RectangleSelectionEvent rectangleSelectionEvent = new RectangleSelectionEvent(this, rectangle);
        for (ZoomListener zoomListener : this.listeners) {
            zoomListener.zoomChanged(rectangleSelectionEvent);
        }
    }

    protected void fireZoomOut(Point point) {
        PointSelectionEvent pointSelectionEvent = new PointSelectionEvent(this, point, ZoomDirection.OUT);
        for (ZoomListener zoomListener : this.listeners) {
            zoomListener.zoomChanged(pointSelectionEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.pressed = new Point(n, n2);
        boolean bl = this.rightClick = (mouseEvent.getModifiers() & 4) == 4;
        if (this.rightClick) {
            // empty if block
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastDraggedArea = this.dragRectangle;
        this.dragRectangle = null;
        this.pressed = null;
        if (this.rightClick) {
            this.fireZoomOut(mouseEvent.getPoint());
        } else if (this.lastDraggedArea != null) {
            this.fireZoomIn(this.lastDraggedArea);
            this.component.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.pressed != null) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = Math.min(n, this.pressed.x);
            int n4 = Math.min(n2, this.pressed.y);
            int n5 = Math.max(n, this.pressed.x);
            int n6 = Math.max(n2, this.pressed.y);
            int n7 = n5 - n3;
            int n8 = n6 - n4;
            if (this.component instanceof Chart && this.zoomOrientation != ZoomOrientation.BOTH) {
                Chart chart = (Chart)this.component;
                if (this.zoomOrientation == ZoomOrientation.HORIZONTAL) {
                    n4 = chart.getYEnd();
                    n6 = chart.getYStart();
                    n2 = n4;
                    n8 = n6 - n4;
                    this.dragRectangle = new Rectangle(n < this.pressed.x ? this.pressed.x - n7 : this.pressed.x, n2, n7, n8);
                } else if (this.zoomOrientation == ZoomOrientation.VERTICAL) {
                    n3 = chart.getXStart();
                    n5 = chart.getXEnd();
                    n = n3;
                    n7 = n5 - n3;
                    this.dragRectangle = new Rectangle(n, n2 < this.pressed.y ? this.pressed.y - n8 : this.pressed.y, n7, n8);
                }
            } else {
                if (this.keepWidthHeightRatio) {
                    int n9 = this.component.getWidth();
                    int n10 = this.component.getHeight();
                    if (this.component instanceof Chart) {
                        n9 = ((Chart)this.component).getChartWidth();
                        n10 = ((Chart)this.component).getChartHeight();
                    }
                    double d = (double)n10 / (double)n9;
                    double d2 = d * (double)n7;
                    int n11 = n7;
                    double d3 = (double)n8 / d;
                    int n12 = n8;
                    n7 = (int)(((double)n11 + d3) / 2.0);
                    n8 = (int)((d2 + (double)n12) / 2.0);
                }
                this.dragRectangle = new Rectangle(n < this.pressed.x ? this.pressed.x - n7 : this.pressed.x, n2 < this.pressed.y ? this.pressed.y - n8 : this.pressed.y, n7, n8);
            }
            this.component.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.dragRectangle != null) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.fill != null) {
                graphics2D.setPaint(this.fill);
                graphics2D.fillRect(this.dragRectangle.x, this.dragRectangle.y, this.dragRectangle.width, this.dragRectangle.height);
            }
            if (this.outlineColor != null) {
                graphics2D.setColor(this.outlineColor);
                if (this.stroke != null) {
                    graphics2D.setStroke(this.stroke);
                }
                graphics2D.drawRect(this.dragRectangle.x, this.dragRectangle.y, this.dragRectangle.width, this.dragRectangle.height);
            }
            graphics2D.dispose();
        }
    }
}

