/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.CombinedNumericRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.List;

public class PanIndicator
implements Drawable {
    private Chart chart;
    private Placement placement;
    private Color fill = new Color(100, 100, 100, 150);
    private Color outline = new Color(200, 200, 200, 200);
    private int triangleWidth = 10;
    private int triangleHeight = 40;
    private static final int DISTANCE_FROM_EDGE = 5;

    public PanIndicator(Chart chart, Placement placement) {
        this.chart = chart;
        this.placement = placement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CombinedNumericRange getDataXRange() {
        List<ChartModel> list = this.chart.getModels();
        CombinedNumericRange combinedNumericRange = new CombinedNumericRange();
        List<ChartModel> list2 = list;
        synchronized (list2) {
            for (ChartModel chartModel : this.chart.getModels()) {
                if (chartModel instanceof DefaultChartModel) {
                    combinedNumericRange.add(((DefaultChartModel)chartModel).getXRange());
                    continue;
                }
                combinedNumericRange.add(this.getXRange(chartModel));
            }
        }
        return combinedNumericRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range<Double> getXRange(ChartModel chartModel) {
        Double d = Double.MAX_VALUE;
        Double d2 = Double.MIN_VALUE;
        ChartModel chartModel2 = chartModel;
        synchronized (chartModel2) {
            for (Chartable chartable : chartModel) {
                Positionable positionable = chartable.getX();
                if (positionable == null) continue;
                double d3 = positionable.position();
                if (d3 < d) {
                    d = d3;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
            }
        }
        return new NumericRange(d, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CombinedNumericRange getDataYRange() {
        List<ChartModel> list = this.chart.getModels();
        CombinedNumericRange combinedNumericRange = new CombinedNumericRange();
        List<ChartModel> list2 = list;
        synchronized (list2) {
            for (ChartModel chartModel : this.chart.getModels()) {
                if (chartModel instanceof DefaultChartModel) {
                    combinedNumericRange.add(((DefaultChartModel)chartModel).getYRange());
                    continue;
                }
                combinedNumericRange.add(this.getYRange(chartModel));
            }
        }
        return combinedNumericRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range<Double> getYRange(ChartModel chartModel) {
        Double d = Double.MAX_VALUE;
        Double d2 = Double.MIN_VALUE;
        ChartModel chartModel2 = chartModel;
        synchronized (chartModel2) {
            for (Chartable chartable : chartModel) {
                Positionable positionable = chartable.getY();
                if (positionable == null) continue;
                double d3 = positionable.position();
                if (d3 < d) {
                    d = d3;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
            }
        }
        return new NumericRange(d, d2);
    }

    private void paintShape(Graphics2D graphics2D, Shape shape) {
        graphics2D.setColor(this.fill);
        graphics2D.fill(shape);
        graphics2D.setColor(this.outline);
        graphics2D.draw(shape);
    }

    @Override
    public void draw(Graphics graphics) {
        CombinedNumericRange combinedNumericRange;
        Graphics2D graphics2D = (Graphics2D)graphics;
        CombinedNumericRange combinedNumericRange2 = combinedNumericRange = this.placement == Placement.LEFT || this.placement == Placement.RIGHT ? this.getDataXRange() : this.getDataYRange();
        if (combinedNumericRange.rangeCount() == 0) {
            return;
        }
        Point point = new Point(this.chart.getXStart(), this.chart.getYStart());
        Point point2 = new Point(this.chart.getXEnd(), this.chart.getYEnd());
        Point2D point2D = this.chart.calculateUserPoint(point);
        Point2D point2D2 = this.chart.calculateUserPoint(point2);
        if (this.placement == Placement.LEFT) {
            int n = this.chart.getXStart() + 5;
            int n2 = (point.y + point2.y) / 2;
            if (point2D != null && point2D.getX() > combinedNumericRange.minimum()) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n, n2);
                polygon.addPoint(n + this.triangleWidth, n2 - this.triangleHeight / 2);
                polygon.addPoint(n + this.triangleWidth, n2 + this.triangleHeight / 2);
                this.paintShape(graphics2D, polygon);
            }
        } else if (this.placement == Placement.RIGHT) {
            int n = this.chart.getXEnd() - 5;
            int n3 = (point.y + point2.y) / 2;
            if (point2D2 != null && point2D2.getX() < combinedNumericRange.maximum()) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n, n3);
                polygon.addPoint(n - this.triangleWidth, n3 - this.triangleHeight / 2);
                polygon.addPoint(n - this.triangleWidth, n3 + this.triangleHeight / 2);
                this.paintShape(graphics2D, polygon);
            }
        } else if (this.placement == Placement.TOP) {
            int n = (this.chart.getXEnd() + this.chart.getXStart()) / 2;
            int n4 = this.chart.getYEnd() + 5;
            if (point2D2.getY() < combinedNumericRange.maximum()) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n, n4);
                polygon.addPoint(n - this.triangleHeight / 2, n4 + this.triangleWidth);
                polygon.addPoint(n + this.triangleHeight / 2, n4 + this.triangleWidth);
                this.paintShape(graphics2D, polygon);
            }
        } else {
            int n = (this.chart.getXEnd() + this.chart.getXStart()) / 2;
            int n5 = this.chart.getYStart() - 5;
            if (point2D.getY() > combinedNumericRange.minimum()) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n, n5);
                polygon.addPoint(n - this.triangleHeight / 2, n5 - this.triangleWidth);
                polygon.addPoint(n + this.triangleHeight / 2, n5 - this.triangleWidth);
                this.paintShape(graphics2D, polygon);
            }
        }
    }

    public static enum Placement {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

